/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.SLanguageHierarchy;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.TokenInputUtils;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserManagerImpl
extends ParserManager {
    private Document doc;
    private TokenHierarchy tokenHierarchy;
    private ASTNode ast = null;
    private ParseException exception = null;
    private ParserManager.State state = ParserManager.State.NOT_PARSED;
    private boolean[] cancel = new boolean[]{false};
    private Set<ParserManagerListener> listeners;
    private Map<String, Set<ASTEvaluator>> evaluatorsMap;
    private static RequestProcessor rp = new RequestProcessor("Parser");
    private RequestProcessor.Task parsingTask;

    public ParserManagerImpl(Document document) {
        this.doc = document;
        this.tokenHierarchy = TokenHierarchy.get((Document)document);
        String string = (String)document.getProperty("mimeType");
        if (this.tokenHierarchy == null && string != null) {
            try {
                if (LanguagesManager.getDefault().getLanguage(string).getParser() != null) {
                    document.putProperty(org.netbeans.api.lexer.Language.class, new SLanguageHierarchy(string).language());
                    this.tokenHierarchy = TokenHierarchy.get((Document)document);
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
        }
        if (this.tokenHierarchy != null) {
            new DocListener(this, this.tokenHierarchy);
            if (this.state == ParserManager.State.NOT_PARSED) {
                try {
                    LanguagesManager.getDefault().getLanguage(string);
                    this.startParsing();
                }
                catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public ParserManager.State getState() {
        return this.state;
    }

    @Override
    public ASTNode getAST() throws ParseException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.ast;
    }

    @Override
    public void addListener(ParserManagerListener parserManagerListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ParserManagerListener>();
        }
        this.listeners.add(parserManagerListener);
    }

    @Override
    public void removeListener(ParserManagerListener parserManagerListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(parserManagerListener);
    }

    @Override
    public void addASTEvaluator(ASTEvaluator aSTEvaluator) {
        Set<ASTEvaluator> set;
        if (this.evaluatorsMap == null) {
            this.evaluatorsMap = new HashMap<String, Set<ASTEvaluator>>();
        }
        if ((set = this.evaluatorsMap.get(aSTEvaluator.getFeatureName())) == null) {
            set = new HashSet<ASTEvaluator>();
            this.evaluatorsMap.put(aSTEvaluator.getFeatureName(), set);
        }
        set.add(aSTEvaluator);
    }

    @Override
    public void removeASTEvaluator(ASTEvaluator aSTEvaluator) {
        Set<ASTEvaluator> set;
        if (this.evaluatorsMap != null && (set = this.evaluatorsMap.get(aSTEvaluator.getFeatureName())) != null) {
            set.remove(aSTEvaluator);
        }
    }

    private synchronized void startParsing() {
        this.setChange(ParserManager.State.PARSING, this.ast);
        this.cancel[0] = true;
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        this.parsingTask = rp.post(new Runnable(){

            public void run() {
                ((ParserManagerImpl)ParserManagerImpl.this).cancel[0] = false;
                ParserManagerImpl.this.parseAST();
            }
        }, 1000);
    }

    private void setChange(ParserManager.State state, ASTNode aSTNode) {
        if (state == this.state) {
            return;
        }
        this.state = state;
        this.ast = aSTNode;
        this.exception = null;
        ArrayList<ParserManagerListener> arrayList = this.listeners == null ? null : new ArrayList<ParserManagerListener>(this.listeners);
        HashMap<String, Set<ASTEvaluator>> hashMap = this.evaluatorsMap == null ? null : new HashMap<String, Set<ASTEvaluator>>(this.evaluatorsMap);
        this.fire2(state, arrayList, hashMap, aSTNode);
    }

    public void fire(final ParserManager.State state, final List<ParserManagerListener> list, final Map<String, Set<ASTEvaluator>> map, final ASTNode aSTNode) {
        this.parsingTask = rp.post(new Runnable(){

            public void run() {
                ((ParserManagerImpl)ParserManagerImpl.this).cancel[0] = false;
                ParserManagerImpl.this.fire2(state, list, map, aSTNode);
            }
        });
    }

    private void fire2(ParserManager.State state, List<ParserManagerListener> list, Map<String, Set<ASTEvaluator>> map, ASTNode aSTNode) {
        if (list != null) {
            for (ParserManagerListener iterator : list) {
                iterator.parsed(state, this.ast);
                if (!this.cancel[0]) continue;
                return;
            }
        }
        if (state == ParserManager.State.PARSING) {
            return;
        }
        if (map != null && !map.isEmpty()) {
            Iterator<Object> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                for (ASTEvaluator aSTEvaluator : (Set)iterator.next()) {
                    aSTEvaluator.beforeEvaluation(state, aSTNode);
                    if (!this.cancel[0]) continue;
                    return;
                }
            }
            this.evaluate(state, aSTNode, new ArrayList<ASTItem>(), map);
            if (this.cancel[0]) {
                return;
            }
            iterator = map.values().iterator();
            while (iterator.hasNext()) {
                for (ASTEvaluator aSTEvaluator : (Set)iterator.next()) {
                    aSTEvaluator.afterEvaluation(state, aSTNode);
                    if (!this.cancel[0]) continue;
                    return;
                }
            }
        }
    }

    private void evaluate(ParserManager.State state, ASTItem aSTItem, List<ASTItem> list, Map<String, Set<ASTEvaluator>> map) {
        list.add(aSTItem);
        Language language = (Language)aSTItem.getLanguage();
        if (language != null) {
            language.evaluate(state, list, map);
        }
        Iterator<ASTItem> iterator = aSTItem.getChildren().iterator();
        while (iterator.hasNext()) {
            if (this.cancel[0]) {
                return;
            }
            this.evaluate(state, iterator.next(), list, map);
        }
        list.remove(list.size() - 1);
    }

    private void setChange(ParseException parseException) {
        this.state = ParserManager.State.ERROR;
        this.ast = null;
        this.exception = parseException;
        for (ParserManagerListener parserManagerListener : new ArrayList<ParserManagerListener>(this.listeners)) {
            parserManagerListener.parsed(this.state, this.ast);
            if (!this.cancel[0]) continue;
            return;
        }
        if (this.state == ParserManager.State.PARSING) {
            return;
        }
    }

    private void parseAST() {
        try {
            this.setChange(ParserManager.State.PARSING, this.ast);
            this.ast = this.parse();
            if (this.cancel[0]) {
                return;
            }
            if (this.ast == null) {
                this.setChange(new ParseException("ast is null?!"));
                return;
            }
            this.ast = this.process(this.ast);
            if (this.ast == null) {
                this.setChange(new ParseException("ast is null?!"));
                return;
            }
            this.setChange(ParserManager.State.OK, this.ast);
        }
        catch (ParseException parseException) {
            ParseException parseException2;
            if (parseException.getASTNode() != null) {
                ASTNode aSTNode = this.process(parseException.getASTNode());
                parseException2 = new ParseException(parseException, aSTNode);
            }
            this.setChange(parseException2);
            ErrorManager.getDefault().notify((Throwable)parseException2);
        }
    }

    private ASTNode process(ASTNode aSTNode) {
        try {
            ASTNode aSTNode2;
            String string = (String)this.doc.getProperty("mimeType");
            Language language = this.getLanguage(string);
            Feature feature = language.getFeature("AST");
            if (feature != null && this.ast != null && (aSTNode2 = (ASTNode)feature.getValue("process", SyntaxContext.create(this.doc, ASTPath.create(aSTNode)))) != null) {
                aSTNode = aSTNode2;
            }
            return aSTNode;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return aSTNode;
        }
    }

    private ASTNode parse() throws ParseException {
        String string = (String)this.doc.getProperty("mimeType");
        Language language = this.getLanguage(string);
        LLSyntaxAnalyser lLSyntaxAnalyser = language.getAnalyser();
        TokenInput tokenInput = this.createTokenInput();
        if (this.cancel[0]) {
            return null;
        }
        ASTNode aSTNode = lLSyntaxAnalyser.read(tokenInput, true, this.cancel);
        return aSTNode;
    }

    public TokenInput createTokenInput() {
        final TokenInput[] tokenInputArray = new TokenInput[1];
        this.doc.render(new Runnable(){

            public void run() {
                if (ParserManagerImpl.this.tokenHierarchy == null) {
                    tokenInputArray[0] = TokenInputUtils.create(Collections.emptyList());
                    return;
                }
                TokenSequence tokenSequence = ParserManagerImpl.this.tokenHierarchy.tokenSequence();
                List list = ParserManagerImpl.this.getTokens(tokenSequence);
                if (ParserManagerImpl.this.cancel[0]) {
                    return;
                }
                tokenInputArray[0] = TokenInputUtils.create(list);
            }
        });
        return tokenInputArray[0];
    }

    private List<ASTToken> getTokens(TokenSequence tokenSequence) {
        Language language = null;
        try {
            language = LanguagesManager.getDefault().getLanguage(tokenSequence.language().mimeType());
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        ArrayList<ASTToken> arrayList = new ArrayList<ASTToken>();
        while (tokenSequence.moveNext()) {
            Object object;
            Object object2;
            if (this.cancel[0]) {
                return null;
            }
            Token token = tokenSequence.token();
            int n = token.id().ordinal();
            int n2 = tokenSequence.offset();
            String string = (String)token.getProperty((Object)"type");
            if (string == null || string.equals("E")) {
                object2 = null;
                object = tokenSequence.embedded();
                if (object != null) {
                    object2 = this.getTokens((TokenSequence)object);
                }
                arrayList.add(ASTToken.create((org.netbeans.api.languages.Language)language, n, ((Object)token.text()).toString(), n2, token.length(), (List<? extends ASTItem>)object2));
                continue;
            }
            if (string.equals("S")) {
                object2 = new StringBuilder(token.text());
                object = new ArrayList();
                TokenSequence tokenSequence2 = tokenSequence.embedded();
                while (tokenSequence.moveNext()) {
                    if (this.cancel[0]) {
                        return null;
                    }
                    token = tokenSequence.token();
                    string = (String)token.getProperty((Object)"type");
                    if (string == null) {
                        tokenSequence.movePrevious();
                        break;
                    }
                    if (string.equals("E")) {
                        tokenSequence2 = tokenSequence.embedded();
                        List<ASTToken> list = this.getTokens(tokenSequence2);
                        if (this.cancel[0]) {
                            return null;
                        }
                        object.addAll(list);
                        continue;
                    }
                    if (string.equals("S")) {
                        tokenSequence.movePrevious();
                        break;
                    }
                    if (!string.equals("C")) {
                        throw new IllegalArgumentException();
                    }
                    if (n != token.id().ordinal()) {
                        throw new IllegalArgumentException();
                    }
                    ((StringBuilder)object2).append(token.text());
                }
                int n3 = tokenSequence.offset() + tokenSequence.token().length();
                arrayList.add(ASTToken.create((org.netbeans.api.languages.Language)language, n, ((StringBuilder)object2).toString(), n2, n3 - n2, (List<? extends ASTItem>)object));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return arrayList;
    }

    private Language getLanguage(String string) {
        try {
            return LanguagesManager.getDefault().getLanguage(string);
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            return Language.create(LanguagesManager.normalizeMimeType(string));
        }
    }

    private static class DocListener
    implements TokenHierarchyListener,
    LanguagesManager.LanguagesManagerListener {
        private WeakReference<ParserManagerImpl> pmwr;

        DocListener(ParserManagerImpl parserManagerImpl, TokenHierarchy tokenHierarchy) {
            this.pmwr = new WeakReference<ParserManagerImpl>(parserManagerImpl);
            tokenHierarchy.addTokenHierarchyListener((TokenHierarchyListener)this);
            LanguagesManager.getDefault().addLanguagesManagerListener(this);
        }

        private ParserManagerImpl getPM() {
            ParserManagerImpl parserManagerImpl = (ParserManagerImpl)this.pmwr.get();
            if (parserManagerImpl != null) {
                return parserManagerImpl;
            }
            LanguagesManager.getDefault().removeLanguagesManagerListener(this);
            return null;
        }

        public void languageChanged(String string) {
            ParserManagerImpl parserManagerImpl = this.getPM();
            if (parserManagerImpl == null) {
                return;
            }
            parserManagerImpl.startParsing();
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
            ParserManagerImpl parserManagerImpl = this.getPM();
            if (parserManagerImpl == null) {
                return;
            }
            parserManagerImpl.startParsing();
        }
    }
}

