/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignImage;

public final class ImageExpressionProperty
extends ExpressionProperty {
    private final JRDesignImage image;

    public ImageExpressionProperty(JRDesignImage image, JRDesignDataset dataset) {
        super((Object)image, dataset);
        this.image = image;
        if (ModelUtils.getTopElementGroup((JRDesignElement)image) instanceof JRDesignCellContents) {
            JRDesignCellContents contents = (JRDesignCellContents)ModelUtils.getTopElementGroup((JRDesignElement)image);
            this.setValue("EXPRESSION_CONTEXT", new ExpressionContext(contents.getOrigin().getCrosstab()));
        }
    }

    public String getName() {
        return "expression";
    }

    public String getDisplayName() {
        return "Image Expression";
    }

    public String getShortDescription() {
        return "The image expression.";
    }

    public String getDefaultExpressionClassName() {
        return String.class.getName();
    }

    public JRDesignExpression getExpression() {
        return (JRDesignExpression)this.image.getExpression();
    }

    public void setExpression(JRDesignExpression expression) {
        this.image.setExpression((JRExpression)expression);
    }
}

