/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts.datasets;

import com.jaspersoft.ireport.designer.charts.datasets.ChartDatasetPanel;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.tools.HyperlinkPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;

public class PieDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private JRDesignPieDataset pieDataset = null;
    private JLabel jLabelKeyExpression;
    private JLabel jLabelLabelExpression;
    private JLabel jLabelValueExpression;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ExpressionEditorArea jRTextExpressionKey;
    private ExpressionEditorArea jRTextExpressionLabel;
    private ExpressionEditorArea jRTextExpressionValue;
    private JTabbedPane jTabbedPane1;
    private HyperlinkPanel sectionItemHyperlinkPanel1;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_KEY_EXPRESSION = 1;
    public static final int COMPONENT_VALUE_EXPRESSION = 2;
    public static final int COMPONENT_LABEL_EXPRESSION = 3;
    public static final int COMPONENT_HYPERLINK = 100;

    public PieDatasetPanel() {
        this.initComponents();
        this.jRTextExpressionKey.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionKeyTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionKeyTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionKeyTextChanged();
            }
        });
        this.jRTextExpressionValue.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionValueTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionValueTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionValueTextChanged();
            }
        });
        this.jRTextExpressionLabel.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionLabelTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionLabelTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                PieDatasetPanel.this.jRTextExpressionLabelTextChanged();
            }
        });
    }

    public JRDesignPieDataset getPieDataset() {
        return this.pieDataset;
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.jRTextExpressionKey.setExpressionContext(ec);
        this.jRTextExpressionValue.setExpressionContext(ec);
        this.jRTextExpressionLabel.setExpressionContext(ec);
        this.sectionItemHyperlinkPanel1.setExpressionContext(ec);
    }

    public void setPieDataset(JRDesignPieDataset pieDataset) {
        this.pieDataset = pieDataset;
        this.jRTextExpressionKey.setText(Misc.getExpressionText(pieDataset.getKeyExpression()));
        this.jRTextExpressionValue.setText(Misc.getExpressionText(pieDataset.getValueExpression()));
        this.jRTextExpressionLabel.setText(Misc.getExpressionText(pieDataset.getLabelExpression()));
        if (pieDataset.getSectionHyperlink() == null) {
            JRDesignHyperlink hl = new JRDesignHyperlink();
            hl.setHyperlinkType((byte)1);
            pieDataset.setSectionHyperlink((JRHyperlink)hl);
        }
        this.sectionItemHyperlinkPanel1.setHyperlink(pieDataset.getSectionHyperlink());
    }

    public void jRTextExpressionKeyTextChanged() {
        JRDesignExpression exp = null;
        if (this.jRTextExpressionKey.getText().trim().length() > 0) {
            exp = new JRDesignExpression();
            exp.setValueClassName("java.lang.Object");
            exp.setText(this.jRTextExpressionKey.getText());
        }
        this.pieDataset.setKeyExpression((JRExpression)exp);
    }

    public void jRTextExpressionValueTextChanged() {
        JRDesignExpression exp = null;
        if (this.jRTextExpressionValue.getText().trim().length() > 0) {
            exp = new JRDesignExpression();
            exp.setValueClassName("java.lang.Number");
            exp.setText(this.jRTextExpressionValue.getText());
        }
        this.pieDataset.setValueExpression((JRExpression)exp);
    }

    public void jRTextExpressionLabelTextChanged() {
        JRDesignExpression exp = null;
        if (this.jRTextExpressionLabel.getText().trim().length() > 0) {
            exp = new JRDesignExpression();
            exp.setValueClassName("java.lang.Object");
            exp.setText(this.jRTextExpressionLabel.getText());
        }
        this.pieDataset.setLabelExpression((JRExpression)exp);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabelKeyExpression = new JLabel();
        this.jRTextExpressionKey = new ExpressionEditorArea();
        this.jLabelValueExpression = new JLabel();
        this.jRTextExpressionValue = new ExpressionEditorArea();
        this.jLabelLabelExpression = new JLabel();
        this.jRTextExpressionLabel = new ExpressionEditorArea();
        this.jPanel2 = new JPanel();
        this.sectionItemHyperlinkPanel1 = new HyperlinkPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelKeyExpression.setText(I18n.getString("PieDatasetPanel.Label.KeyExpression"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jLabelKeyExpression, gridBagConstraints);
        this.jRTextExpressionKey.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionKey.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionKey.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionKey, gridBagConstraints);
        this.jLabelValueExpression.setText(I18n.getString("PieDatasetPanel.Label.ValueExpression"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelValueExpression, gridBagConstraints);
        this.jRTextExpressionValue.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionValue.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionValue.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionValue, gridBagConstraints);
        this.jLabelLabelExpression.setText(I18n.getString("PieDatasetPanel.Label.LabelExpression"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelLabelExpression, gridBagConstraints);
        this.jRTextExpressionLabel.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLabel.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLabel.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jRTextExpressionLabel, gridBagConstraints);
        this.jTabbedPane1.addTab(I18n.getString("PieDatasetPanel.Tab.SectionValue"), this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.sectionItemHyperlinkPanel1, gridBagConstraints);
        this.jTabbedPane1.addTab(I18n.getString("PieDatasetPanel.Panel.SectionHyperlink"), this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jTabbedPane1, gridBagConstraints);
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionKey.getExpressionEditorPane());
                break;
            }
            case 2: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionValue.getExpressionEditorPane());
                break;
            }
            case 3: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionLabel.getExpressionEditorPane());
                break;
            }
            case 100: {
                this.jTabbedPane1.setSelectedComponent(this.jPanel2);
                Object[] newInfo = new Object[expressionInfo.length - 1];
                for (int i = 1; i < expressionInfo.length; ++i) {
                    newInfo[i - 1] = expressionInfo[i];
                }
                break;
            }
        }
    }

    public void containerWindowOpened() {
    }
}

