/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.fill.JRFillAreaPlot;
import net.sf.jasperreports.charts.fill.JRFillBar3DPlot;
import net.sf.jasperreports.charts.fill.JRFillBarPlot;
import net.sf.jasperreports.charts.fill.JRFillCategoryDataset;
import net.sf.jasperreports.charts.fill.JRFillChartAxis;
import net.sf.jasperreports.charts.fill.JRFillGanttDataset;
import net.sf.jasperreports.charts.fill.JRFillLinePlot;
import net.sf.jasperreports.charts.fill.JRFillMeterPlot;
import net.sf.jasperreports.charts.fill.JRFillPie3DPlot;
import net.sf.jasperreports.charts.fill.JRFillPieDataset;
import net.sf.jasperreports.charts.fill.JRFillPiePlot;
import net.sf.jasperreports.charts.fill.JRFillThermometerPlot;
import net.sf.jasperreports.charts.fill.JRFillTimePeriodDataset;
import net.sf.jasperreports.charts.fill.JRFillTimeSeriesDataset;
import net.sf.jasperreports.charts.fill.JRFillXyDataset;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.charts.util.PieLabelGenerator;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.fill.JRFillChart;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;

public class DefaultChartTheme
implements ChartTheme {
    protected static final Color TRANSPARENT_PAINT = new Color(0, 0, 0, 0);
    private JRFillChart chart = null;

    protected DefaultChartTheme() {
    }

    protected JRFillChart getChart() {
        return this.chart;
    }

    protected JRChartPlot getPlot() {
        return this.chart.getPlot();
    }

    protected JRFillChartDataset getDataset() {
        return (JRFillChartDataset)this.chart.getDataset();
    }

    protected final Object evaluateExpression(JRExpression expression, byte evaluation) throws JRException {
        return this.chart.evaluateExpression(expression, evaluation);
    }

    public JFreeChart createChart(JRFillChart chart, byte evaluation) throws JRException {
        this.chart = chart;
        JFreeChart jfreeChart = null;
        switch (chart.getChartType()) {
            case 1: {
                jfreeChart = this.createAreaChart(evaluation);
                break;
            }
            case 3: {
                jfreeChart = this.createBarChart(evaluation);
                break;
            }
            case 2: {
                jfreeChart = this.createBar3DChart(evaluation);
                break;
            }
            case 4: {
                jfreeChart = this.createBubbleChart(evaluation);
                break;
            }
            case 5: {
                jfreeChart = this.createCandlestickChart(evaluation);
                break;
            }
            case 6: {
                jfreeChart = this.createHighLowChart(evaluation);
                break;
            }
            case 7: {
                jfreeChart = this.createLineChart(evaluation);
                break;
            }
            case 17: {
                jfreeChart = this.createMeterChart(evaluation);
                break;
            }
            case 19: {
                break;
            }
            case 9: {
                jfreeChart = this.createPieChart(evaluation);
                break;
            }
            case 8: {
                jfreeChart = this.createPie3DChart(evaluation);
                break;
            }
            case 10: {
                jfreeChart = this.createScatterChart(evaluation);
                break;
            }
            case 12: {
                jfreeChart = this.createStackedBarChart(evaluation);
                break;
            }
            case 11: {
                jfreeChart = this.createStackedBar3DChart(evaluation);
                break;
            }
            case 18: {
                jfreeChart = this.createThermometerChart(evaluation);
                break;
            }
            case 16: {
                jfreeChart = this.createTimeSeriesChart(evaluation);
                break;
            }
            case 13: {
                jfreeChart = this.createXyAreaChart(evaluation);
                break;
            }
            case 14: {
                jfreeChart = this.createXYBarChart(evaluation);
                break;
            }
            case 15: {
                jfreeChart = this.createXyLineChart(evaluation);
                break;
            }
            case 20: {
                jfreeChart = this.createStackedAreaChart(evaluation);
                break;
            }
            case 21: {
                jfreeChart = this.createGanttChart(evaluation);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type " + chart.getChartType() + " not supported.");
            }
        }
        return jfreeChart;
    }

    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot, byte evaluation) throws JRException {
        LegendTitle legend;
        String subtitleText;
        if (this.getChart().getMode() == 1) {
            jfreeChart.setBackgroundPaint((Paint)this.getChart().getBackcolor());
        } else {
            jfreeChart.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        }
        RectangleEdge titleEdge = DefaultChartTheme.getEdge(this.getChart().getTitlePosition());
        if (jfreeChart.getTitle() != null) {
            TextTitle title = jfreeChart.getTitle();
            title.setPaint((Paint)this.getChart().getTitleColor());
            title.setFont(new Font(JRFontUtil.getAttributes(this.getChart().getTitleFont())));
            title.setPosition(titleEdge);
        }
        if ((subtitleText = (String)this.evaluateExpression(this.getChart().getSubtitleExpression(), evaluation)) != null) {
            TextTitle subtitle = new TextTitle(subtitleText);
            subtitle.setPaint((Paint)this.getChart().getSubtitleColor());
            subtitle.setFont(new Font(JRFontUtil.getAttributes(this.getChart().getSubtitleFont())));
            subtitle.setPosition(titleEdge);
            jfreeChart.addSubtitle((Title)subtitle);
        }
        if ((legend = jfreeChart.getLegend()) != null) {
            legend.setItemPaint((Paint)this.getChart().getLegendColor());
            if (this.getChart().getOwnLegendBackgroundColor() == null) {
                legend.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
            } else {
                legend.setBackgroundPaint((Paint)this.getChart().getLegendBackgroundColor());
            }
            jfreeChart.getLegend().setItemFont(new Font(JRFontUtil.getAttributes(this.getChart().getLegendFont())));
            jfreeChart.getLegend().setPosition(DefaultChartTheme.getEdge(this.getChart().getLegendPosition()));
        }
        this.configurePlot(jfreeChart.getPlot(), jrPlot);
    }

    protected void configurePlot(Plot p, JRChartPlot jrPlot) {
        SortedSet seriesColors;
        p.setOutlinePaint((Paint)TRANSPARENT_PAINT);
        if (this.getPlot().getOwnBackcolor() == null) {
            p.setBackgroundPaint((Paint)TRANSPARENT_PAINT);
        } else {
            p.setBackgroundPaint((Paint)this.getPlot().getBackcolor());
        }
        p.setBackgroundAlpha(this.getPlot().getBackgroundAlpha());
        p.setForegroundAlpha(this.getPlot().getForegroundAlpha());
        if (p instanceof CategoryPlot) {
            CategoryAxis axis = ((CategoryPlot)p).getDomainAxis();
            double labelRotation = this.getPlot().getLabelRotation();
            if (labelRotation == 90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.DOWN_90);
            } else if (labelRotation == -90.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            } else if (labelRotation < 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)(-labelRotation / 180.0 * Math.PI)));
            } else if (labelRotation > 0.0) {
                axis.setCategoryLabelPositions(CategoryLabelPositions.createDownRotationLabelPositions((double)(labelRotation / 180.0 * Math.PI)));
            }
        }
        if ((seriesColors = this.getPlot().getSeriesColors()) != null) {
            if (seriesColors.size() == 1) {
                Paint[] colors = new Paint[DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length + 1];
                colors[0] = ((JRChartPlot.JRSeriesColor)seriesColors.first()).getColor();
                for (int i = 0; i < DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length; ++i) {
                    colors[i + 1] = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i];
                }
                p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            } else if (seriesColors.size() > 1) {
                Paint[] colors = new Color[seriesColors.size()];
                JRChartPlot.JRSeriesColor[] colorSequence = new JRChartPlot.JRSeriesColor[seriesColors.size()];
                seriesColors.toArray(colorSequence);
                for (int i = 0; i < colorSequence.length; ++i) {
                    colors[i] = colorSequence[i].getColor();
                }
                p.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
            }
        }
    }

    protected void configureAxis(Axis axis, JRFont labelFont, Color labelColor, JRFont tickLabelFont, Color tickLabelColor, String tickLabelMask, Color lineColor) {
        axis.setLabelFont(new Font(JRFontUtil.getAttributes(labelFont)));
        axis.setTickLabelFont(new Font(JRFontUtil.getAttributes(tickLabelFont)));
        if (labelColor != null) {
            axis.setLabelPaint((Paint)labelColor);
        }
        if (tickLabelColor != null) {
            axis.setTickLabelPaint((Paint)tickLabelColor);
        }
        if (lineColor != null) {
            axis.setAxisLinePaint((Paint)lineColor);
            axis.setTickMarkPaint((Paint)lineColor);
        }
        if (tickLabelMask != null) {
            if (axis instanceof NumberAxis) {
                NumberFormat fmt = NumberFormat.getInstance();
                if (fmt instanceof DecimalFormat) {
                    ((DecimalFormat)fmt).applyPattern(tickLabelMask);
                }
                ((NumberAxis)axis).setNumberFormatOverride(fmt);
            } else if (axis instanceof DateAxis) {
                DateFormat fmt = null;
                fmt = tickLabelMask.equals("SHORT") || tickLabelMask.equals("DateFormat.SHORT") ? DateFormat.getDateInstance(3) : (tickLabelMask.equals("MEDIUM") || tickLabelMask.equals("DateFormat.MEDIUM") ? DateFormat.getDateInstance(2) : (tickLabelMask.equals("LONG") || tickLabelMask.equals("DateFormat.LONG") ? DateFormat.getDateInstance(1) : (tickLabelMask.equals("FULL") || tickLabelMask.equals("DateFormat.FULL") ? DateFormat.getDateInstance(0) : new SimpleDateFormat(tickLabelMask))));
                ((DateAxis)axis).setDateFormatOverride(fmt);
            }
        }
    }

    protected JFreeChart createAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        JRFillAreaPlot areaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRFillBar3DPlot bar3DPlot = (JRFillBar3DPlot)this.getPlot();
        BarRenderer3D barRenderer3D = new BarRenderer3D(bar3DPlot.getXOffset(), bar3DPlot.getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)barRenderer3D);
        barRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        barRenderer3D.setItemLabelsVisible(bar3DPlot.isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createBarChart(byte evaluation) throws JRException {
        CategoryDataset categoryDataset = (CategoryDataset)this.getDataset().getDataset();
        JFreeChart jfreeChart = ChartFactory.createBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)categoryDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(barPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(barPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(barPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(barPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(barPlot.isShowLabels());
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createBubbleChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getXAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBubblePlot)this.getPlot()).getYAxisLabelExpression(), evaluation)), (XYZDataset)((XYZDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRBubblePlot bubblePlot = (JRBubblePlot)this.getPlot();
        XYBubbleRenderer bubbleRenderer = new XYBubbleRenderer(bubblePlot.getScaleType());
        xyPlot.setRenderer((XYItemRenderer)bubbleRenderer);
        this.configureAxis((Axis)xyPlot.getDomainAxis(), bubblePlot.getXAxisLabelFont(), bubblePlot.getXAxisLabelColor(), bubblePlot.getXAxisTickLabelFont(), bubblePlot.getXAxisTickLabelColor(), bubblePlot.getXAxisTickLabelMask(), bubblePlot.getXAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), bubblePlot.getYAxisLabelFont(), bubblePlot.getYAxisLabelColor(), bubblePlot.getYAxisTickLabelFont(), bubblePlot.getYAxisTickLabelColor(), bubblePlot.getYAxisTickLabelMask(), bubblePlot.getYAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createCandlestickChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRCandlestickPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (OHLCDataset)((DefaultHighLowDataset)this.getDataset().getDataset()), (boolean)this.getChart().isShowLegend());
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRCandlestickPlot candlestickPlot = (JRCandlestickPlot)this.getPlot();
        CandlestickRenderer candlestickRenderer = (CandlestickRenderer)xyPlot.getRenderer();
        candlestickRenderer.setDrawVolume(candlestickPlot.isShowVolume());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), candlestickPlot.getTimeAxisLabelFont(), candlestickPlot.getTimeAxisLabelColor(), candlestickPlot.getTimeAxisTickLabelFont(), candlestickPlot.getTimeAxisTickLabelColor(), candlestickPlot.getTimeAxisTickLabelMask(), candlestickPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), candlestickPlot.getValueAxisLabelFont(), candlestickPlot.getValueAxisLabelColor(), candlestickPlot.getValueAxisTickLabelFont(), candlestickPlot.getValueAxisTickLabelColor(), candlestickPlot.getValueAxisTickLabelMask(), candlestickPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createHighLowChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createHighLowChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRHighLowPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (OHLCDataset)((DefaultHighLowDataset)this.getDataset().getDataset()), (boolean)this.getChart().isShowLegend());
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRHighLowPlot highLowPlot = (JRHighLowPlot)this.getPlot();
        HighLowRenderer hlRenderer = (HighLowRenderer)xyPlot.getRenderer();
        hlRenderer.setDrawOpenTicks(highLowPlot.isShowOpenTicks());
        hlRenderer.setDrawCloseTicks(highLowPlot.isShowCloseTicks());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), highLowPlot.getTimeAxisLabelFont(), highLowPlot.getTimeAxisLabelColor(), highLowPlot.getTimeAxisTickLabelFont(), highLowPlot.getTimeAxisTickLabelColor(), highLowPlot.getTimeAxisTickLabelMask(), highLowPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), highLowPlot.getValueAxisLabelFont(), highLowPlot.getValueAxisLabelColor(), highLowPlot.getValueAxisTickLabelFont(), highLowPlot.getValueAxisTickLabelColor(), highLowPlot.getValueAxisTickLabelMask(), highLowPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createLineChart(byte evaluation) throws JRException {
        JFreeChart chart = ChartFactory.createLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRLinePlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(chart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        JRFillLinePlot linePlot = (JRFillLinePlot)this.getPlot();
        LineAndShapeRenderer lineRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineRenderer.setShapesVisible(linePlot.isShowShapes());
        lineRenderer.setLinesVisible(linePlot.isShowLines());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor());
        return chart;
    }

    protected JFreeChart createPie3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createPieChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (PieDataset)((PieDataset)this.getDataset().getDataset()), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        piePlot3D.setDepthFactor(((JRFillPie3DPlot)this.getPlot()).getDepthFactor());
        piePlot3D.setCircular(((JRFillPie3DPlot)this.getPlot()).isCircular());
        PieLabelGenerator labelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (labelGenerator != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        } else if (((JRFillPie3DPlot)this.getPlot()).getLabelFormat() != null) {
            piePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRFillPie3DPlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRFillPie3DPlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRFillPie3DPlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot3D.setLabelFont(new Font(JRFontUtil.getAttributes(new JRBaseFont(null, null, this.getChart(), null))));
        piePlot3D.setLabelPaint((Paint)this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createPieChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createPieChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (PieDataset)((PieDataset)this.getDataset().getDataset()), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        piePlot.setCircular(((JRFillPiePlot)this.getPlot()).isCircular());
        PieLabelGenerator labelGenerator = ((JRFillPieDataset)this.getDataset()).getLabelGenerator();
        if (labelGenerator != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)labelGenerator);
        } else if (((JRFillPiePlot)this.getPlot()).getLabelFormat() != null) {
            piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRFillPiePlot)this.getPlot()).getLabelFormat()));
        }
        if (((JRFillPiePlot)this.getPlot()).getLegendLabelFormat() != null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(((JRFillPiePlot)this.getPlot()).getLegendLabelFormat()));
        }
        piePlot.setLabelFont(new Font(JRFontUtil.getAttributes(new JRBaseFont(null, null, this.getChart(), null))));
        piePlot.setLabelPaint((Paint)this.getChart().getForecolor());
        return jfreeChart;
    }

    protected JFreeChart createScatterChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createScatterPlot((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getXAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRScatterPlot)this.getPlot()).getYAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        JRScatterPlot scatterPlot = (JRScatterPlot)this.getPlot();
        plotRenderer.setLinesVisible(scatterPlot.isShowLines());
        plotRenderer.setShapesVisible(scatterPlot.isShowShapes());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), scatterPlot.getXAxisLabelFont(), scatterPlot.getXAxisLabelColor(), scatterPlot.getXAxisTickLabelFont(), scatterPlot.getXAxisTickLabelColor(), scatterPlot.getXAxisTickLabelMask(), scatterPlot.getXAxisLineColor());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), scatterPlot.getYAxisLabelFont(), scatterPlot.getYAxisLabelColor(), scatterPlot.getYAxisTickLabelFont(), scatterPlot.getYAxisTickLabelColor(), scatterPlot.getYAxisTickLabelMask(), scatterPlot.getYAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart3D((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBar3DPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRFillBar3DPlot bar3DPlot = (JRFillBar3DPlot)this.getPlot();
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D(bar3DPlot.getXOffset(), bar3DPlot.getYOffset());
        categoryPlot.setRenderer((CategoryItemRenderer)stackedBarRenderer3D);
        stackedBarRenderer3D.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        stackedBarRenderer3D.setItemLabelsVisible(bar3DPlot.isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), bar3DPlot.getCategoryAxisLabelFont(), bar3DPlot.getCategoryAxisLabelColor(), bar3DPlot.getCategoryAxisTickLabelFont(), bar3DPlot.getCategoryAxisTickLabelColor(), bar3DPlot.getCategoryAxisTickLabelMask(), bar3DPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), bar3DPlot.getValueAxisLabelFont(), bar3DPlot.getValueAxisLabelColor(), bar3DPlot.getValueAxisTickLabelFont(), bar3DPlot.getValueAxisTickLabelColor(), bar3DPlot.getValueAxisTickLabelMask(), bar3DPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createStackedBarChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createStackedBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(barPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(barPlot.isShowTickLabels());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(barPlot.isShowTickMarks());
        ((NumberAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(barPlot.isShowTickLabels());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)((JRFillCategoryDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(((JRFillBarPlot)this.getPlot()).isShowLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createStackedAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createStackedAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (CategoryDataset)((CategoryDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        JRFillAreaPlot areaPlot = (JRFillAreaPlot)this.getPlot();
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)((CategoryPlot)jfreeChart.getPlot()).getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        ((CategoryPlot)jfreeChart.getPlot()).getDomainAxis().setCategoryMargin(0.0);
        return jfreeChart;
    }

    protected JFreeChart createXyAreaChart(byte evaluation) throws JRException {
        JFreeChart jfreeChart = ChartFactory.createXYAreaChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRAreaPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.getDataset().getDataset()), (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        JRAreaPlot areaPlot = (JRAreaPlot)this.getPlot();
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), areaPlot.getCategoryAxisLabelFont(), areaPlot.getCategoryAxisLabelColor(), areaPlot.getCategoryAxisTickLabelFont(), areaPlot.getCategoryAxisTickLabelColor(), areaPlot.getCategoryAxisTickLabelMask(), areaPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), areaPlot.getValueAxisLabelFont(), areaPlot.getValueAxisLabelColor(), areaPlot.getValueAxisTickLabelFont(), areaPlot.getValueAxisTickLabelColor(), areaPlot.getValueAxisTickLabelMask(), areaPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createXYBarChart(byte evaluation) throws JRException {
        IntervalXYDataset tmpDataset = (IntervalXYDataset)this.getDataset().getDataset();
        boolean isDate = true;
        if (this.getDataset().getDatasetType() == 3) {
            isDate = false;
        }
        JFreeChart jfreeChart = ChartFactory.createXYBarChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (boolean)isDate, (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (IntervalXYDataset)tmpDataset, (PlotOrientation)this.getPlot().getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYItemRenderer itemRenderer = xyPlot.getRenderer();
        if (this.getDataset().getDatasetType() == 6) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimeSeriesDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 5) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillTimePeriodDataset)this.getDataset()).getLabelGenerator());
        } else if (this.getDataset().getDatasetType() == 3) {
            itemRenderer.setBaseItemLabelGenerator((XYItemLabelGenerator)((JRFillXyDataset)this.getDataset()).getLabelGenerator());
        }
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        itemRenderer.setBaseItemLabelsVisible(barPlot.isShowLabels());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createXyLineChart(byte evaluation) throws JRException {
        JRLinePlot linePlot = (JRLinePlot)this.getPlot();
        JFreeChart jfreeChart = ChartFactory.createXYLineChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(linePlot.getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(linePlot.getValueAxisLabelExpression(), evaluation)), (XYDataset)((XYDataset)this.getDataset().getDataset()), (PlotOrientation)linePlot.getOrientation(), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        this.configureAxis((Axis)jfreeChart.getXYPlot().getDomainAxis(), linePlot.getCategoryAxisLabelFont(), linePlot.getCategoryAxisLabelColor(), linePlot.getCategoryAxisTickLabelFont(), linePlot.getCategoryAxisTickLabelColor(), linePlot.getCategoryAxisTickLabelMask(), linePlot.getCategoryAxisLineColor());
        this.configureAxis((Axis)jfreeChart.getXYPlot().getRangeAxis(), linePlot.getValueAxisLabelFont(), linePlot.getValueAxisLabelColor(), linePlot.getValueAxisTickLabelFont(), linePlot.getValueAxisTickLabelColor(), linePlot.getValueAxisTickLabelMask(), linePlot.getValueAxisLineColor());
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)jfreeChart.getXYPlot().getRenderer();
        lineRenderer.setShapesVisible(linePlot.isShowShapes());
        lineRenderer.setLinesVisible(linePlot.isShowLines());
        return jfreeChart;
    }

    protected JFreeChart createTimeSeriesChart(byte evaluation) throws JRException {
        String timeAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getTimeAxisLabelExpression(), evaluation);
        String valueAxisLabel = (String)this.evaluateExpression(((JRTimeSeriesPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation);
        JFreeChart jfreeChart = ChartFactory.createTimeSeriesChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)timeAxisLabel, (String)valueAxisLabel, (XYDataset)((TimeSeriesCollection)this.getDataset().getDataset()), (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        JRTimeSeriesPlot timeSeriesPlot = (JRTimeSeriesPlot)this.getPlot();
        XYLineAndShapeRenderer lineRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
        lineRenderer.setLinesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowLines());
        lineRenderer.setShapesVisible(((JRTimeSeriesPlot)this.getPlot()).isShowShapes());
        this.configureAxis((Axis)xyPlot.getDomainAxis(), timeSeriesPlot.getTimeAxisLabelFont(), timeSeriesPlot.getTimeAxisLabelColor(), timeSeriesPlot.getTimeAxisTickLabelFont(), timeSeriesPlot.getTimeAxisTickLabelColor(), timeSeriesPlot.getTimeAxisTickLabelMask(), timeSeriesPlot.getTimeAxisLineColor());
        this.configureAxis((Axis)xyPlot.getRangeAxis(), timeSeriesPlot.getValueAxisLabelFont(), timeSeriesPlot.getValueAxisLabelColor(), timeSeriesPlot.getValueAxisTickLabelFont(), timeSeriesPlot.getValueAxisTickLabelColor(), timeSeriesPlot.getValueAxisTickLabelMask(), timeSeriesPlot.getValueAxisLineColor());
        return jfreeChart;
    }

    protected JFreeChart createGanttChart(byte evaluation) throws JRException {
        GanttCategoryDataset ganttCategoryDataset = (GanttCategoryDataset)this.getDataset().getDataset();
        JFreeChart jfreeChart = ChartFactory.createGanttChart((String)((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getCategoryAxisLabelExpression(), evaluation)), (String)((String)this.evaluateExpression(((JRBarPlot)this.getPlot()).getValueAxisLabelExpression(), evaluation)), (IntervalCategoryDataset)ganttCategoryDataset, (boolean)this.getChart().isShowLegend(), (boolean)true, (boolean)false);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        JRFillBarPlot barPlot = (JRFillBarPlot)this.getPlot();
        categoryPlot.getDomainAxis().setTickMarksVisible(barPlot.isShowTickMarks());
        categoryPlot.getDomainAxis().setTickLabelsVisible(barPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getDomainAxis(), barPlot.getCategoryAxisLabelFont(), barPlot.getCategoryAxisLabelColor(), barPlot.getCategoryAxisTickLabelFont(), barPlot.getCategoryAxisTickLabelColor(), barPlot.getCategoryAxisTickLabelMask(), barPlot.getCategoryAxisLineColor());
        ((DateAxis)categoryPlot.getRangeAxis()).setTickMarksVisible(barPlot.isShowTickMarks());
        ((DateAxis)categoryPlot.getRangeAxis()).setTickLabelsVisible(barPlot.isShowTickLabels());
        this.configureAxis((Axis)categoryPlot.getRangeAxis(), barPlot.getValueAxisLabelFont(), barPlot.getValueAxisLabelColor(), barPlot.getValueAxisTickLabelFont(), barPlot.getValueAxisTickLabelColor(), barPlot.getValueAxisTickLabelMask(), barPlot.getValueAxisLineColor());
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelGenerator(((JRFillGanttDataset)this.getDataset()).getLabelGenerator());
        categoryRenderer.setItemLabelsVisible(barPlot.isShowLabels());
        return jfreeChart;
    }

    protected Range convertRange(JRDataRange dataRange, byte evaluation) throws JRException {
        if (dataRange == null) {
            return null;
        }
        Number low = (Number)this.evaluateExpression(dataRange.getLowExpression(), evaluation);
        Number high = (Number)this.evaluateExpression(dataRange.getHighExpression(), evaluation);
        return new Range(low != null ? low.doubleValue() : 0.0, high != null ? high.doubleValue() : 100.0);
    }

    protected MeterInterval convertInterval(JRMeterInterval interval, byte evaluation) throws JRException {
        String label = interval.getLabel();
        if (label == null) {
            label = "";
        }
        Range range = this.convertRange(interval.getDataRange(), evaluation);
        Color color = interval.getBackgroundColor();
        float[] components = color.getRGBColorComponents(null);
        Color alphaColor = new Color(components[0], components[1], components[2], (float)interval.getAlpha());
        return new MeterInterval(label, range, (Paint)alphaColor, null, (Paint)alphaColor);
    }

    protected JFreeChart createMeterChart(byte evaluation) throws JRException {
        List intervals;
        JRValueDisplay display;
        JRFillMeterPlot jrPlot = (JRFillMeterPlot)this.getPlot();
        MeterPlot chartPlot = new MeterPlot((ValueDataset)this.getDataset().getDataset());
        byte shape = jrPlot.getShape();
        if (shape == 0) {
            chartPlot.setDialShape(DialShape.CHORD);
        } else if (shape == 1) {
            chartPlot.setDialShape(DialShape.CIRCLE);
        } else {
            chartPlot.setDialShape(DialShape.PIE);
        }
        chartPlot.setRange(this.convertRange(jrPlot.getDataRange(), evaluation));
        chartPlot.setMeterAngle(jrPlot.getMeterAngle());
        String units = jrPlot.getUnits();
        if (units != null && units.length() > 0) {
            chartPlot.setUnits(units);
        }
        chartPlot.setTickSize(jrPlot.getTickInterval());
        Color color = jrPlot.getMeterBackgroundColor();
        if (color != null) {
            chartPlot.setDialBackgroundPaint((Paint)color);
        }
        if ((color = jrPlot.getNeedleColor()) != null) {
            chartPlot.setNeedlePaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setTickLabelFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(new Font(JRFontUtil.getAttributes(display.getFont())));
            }
        }
        if ((color = jrPlot.getTickColor()) != null) {
            chartPlot.setTickPaint((Paint)color);
        }
        if ((intervals = jrPlot.getIntervals()) != null) {
            Iterator iter = intervals.iterator();
            while (iter.hasNext()) {
                JRMeterInterval interval = (JRMeterInterval)iter.next();
                chartPlot.addInterval(this.convertInterval(interval, evaluation));
            }
        }
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression(), evaluation), null, (Plot)chartPlot, this.getChart().isShowLegend());
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        return jfreeChart;
    }

    protected JFreeChart createThermometerChart(byte evaluation) throws JRException {
        JRValueDisplay display;
        JRFillThermometerPlot jrPlot = (JRFillThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset().getDataset());
        Range range = this.convertRange(jrPlot.getDataRange(), evaluation);
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setShowValueLines(jrPlot.isShowValueLines());
        chartPlot.setUnits(0);
        Color color = jrPlot.getMercuryColor();
        if (color != null) {
            chartPlot.setMercuryPaint((Paint)color);
        }
        if ((display = jrPlot.getValueDisplay()) != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                chartPlot.setValueFont(new Font(JRFontUtil.getAttributes(display.getFont())));
            }
        }
        switch (jrPlot.getValueLocation()) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange(), evaluation);
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange(), evaluation)) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange(), evaluation)) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart, this.getPlot(), evaluation);
        return jfreeChart;
    }

    protected AxisLocation getChartAxisLocation(JRFillChartAxis chartAxis) {
        return chartAxis.getPosition() == 2 ? AxisLocation.BOTTOM_OR_RIGHT : AxisLocation.TOP_OR_LEFT;
    }

    private static RectangleEdge getEdge(byte position) {
        RectangleEdge edge = RectangleEdge.TOP;
        switch (position) {
            case 1: {
                edge = RectangleEdge.TOP;
                break;
            }
            case 2: {
                edge = RectangleEdge.BOTTOM;
                break;
            }
            case 3: {
                edge = RectangleEdge.LEFT;
                break;
            }
            case 4: {
                edge = RectangleEdge.RIGHT;
            }
        }
        return edge;
    }
}

