/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc;

import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.IterCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.BetterExpCompiler;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Parameter;
import mondrian.olap.Validator;
import mondrian.util.CreationException;
import mondrian.util.ObjectFactory;
import org.eigenbase.util.property.StringProperty;

public interface ExpCompiler {
    public static final ResultStyle[] ANY_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.ANY};
    public static final ResultStyle[] ITERABLE_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.ITERABLE};
    public static final ResultStyle[] MUTABLE_LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.MUTABLE_LIST};
    public static final ResultStyle[] LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.LIST};
    public static final ResultStyle[] ITERABLE_ANY_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.ITERABLE, ResultStyle.ANY};
    public static final ResultStyle[] ITERABLE_LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.ITERABLE, ResultStyle.LIST};
    public static final ResultStyle[] ITERABLE_MUTABLE_LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.ITERABLE, ResultStyle.MUTABLE_LIST};
    public static final ResultStyle[] ITERABLE_LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.ITERABLE, ResultStyle.LIST, ResultStyle.MUTABLE_LIST};
    public static final ResultStyle[] LIST_MUTABLE_LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.LIST, ResultStyle.MUTABLE_LIST};
    public static final ResultStyle[] MUTABLE_LIST_LIST_RESULT_STYLE_ARRAY = new ResultStyle[]{ResultStyle.MUTABLE_LIST, ResultStyle.LIST};

    public Evaluator getEvaluator();

    public Validator getValidator();

    public Calc compile(Exp var1);

    public Calc compile(Exp var1, ResultStyle[] var2);

    public MemberCalc compileMember(Exp var1);

    public LevelCalc compileLevel(Exp var1);

    public DimensionCalc compileDimension(Exp var1);

    public HierarchyCalc compileHierarchy(Exp var1);

    public IntegerCalc compileInteger(Exp var1);

    public StringCalc compileString(Exp var1);

    public ListCalc compileList(Exp var1);

    public ListCalc compileList(Exp var1, boolean var2);

    public IterCalc compileIter(Exp var1);

    public BooleanCalc compileBoolean(Exp var1);

    public DoubleCalc compileDouble(Exp var1);

    public TupleCalc compileTuple(Exp var1);

    public Calc compileScalar(Exp var1, boolean var2);

    public ParameterSlot registerParameter(Parameter var1);

    public ResultStyle[] getAcceptableResultStyles();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends ObjectFactory<ExpCompiler> {
        private static final Factory factory = new Factory();
        private static final Class[] CLASS_ARRAY = new Class[]{Evaluator.class, Validator.class, ResultStyle[].class};
        private static final ThreadLocal<String> ClassName = new ThreadLocal();

        public static ExpCompiler getExpCompiler(Evaluator evaluator, Validator validator) throws CreationException {
            return Factory.getExpCompiler(evaluator, validator, ANY_RESULT_STYLE_ARRAY);
        }

        public static ExpCompiler getExpCompiler(Evaluator evaluator, Validator validator, ResultStyle[] resultStyles) throws CreationException {
            return (ExpCompiler)factory.getObject(CLASS_ARRAY, new Object[]{evaluator, validator, resultStyles});
        }

        public static String getThreadLocalClassName() {
            return ClassName.get();
        }

        public static void setThreadLocalClassName(String className) {
            ClassName.set(className);
        }

        public static void clearThreadLocalClassName() {
            ClassName.set(null);
        }

        private Factory() {
            super(ExpCompiler.class);
        }

        @Override
        protected String getClassName() {
            return Factory.getThreadLocalClassName();
        }

        @Override
        protected StringProperty getStringProperty() {
            return MondrianProperties.instance().ExpCompilerClass;
        }

        @Override
        protected ExpCompiler getDefault(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            Evaluator evaluator = (Evaluator)parameterValues[0];
            Validator validator = (Validator)parameterValues[1];
            ResultStyle[] resultStyles = (ResultStyle[])parameterValues[2];
            return new BetterExpCompiler(evaluator, validator, resultStyles);
        }

        public static Factory getFactory() {
            return factory;
        }

        @Override
        public Object removeContext() {
            return new Context();
        }

        @Override
        public void restoreContext(Object context) {
            if (context instanceof Context) {
                ((Context)context).restore();
            }
        }

        public static class Context
        implements ObjectFactory.Context {
            private final String threadLocalClassName = Factory.getThreadLocalClassName();
            private final String systemPropertyClassName;

            Context() {
                if (this.threadLocalClassName != null) {
                    Factory.clearThreadLocalClassName();
                }
                this.systemPropertyClassName = System.getProperty(ExpCompiler.class.getName());
                if (this.systemPropertyClassName != null) {
                    System.getProperties().remove(ExpCompiler.class.getName());
                }
            }

            private void restore() {
                if (this.threadLocalClassName != null) {
                    Factory.setThreadLocalClassName(this.threadLocalClassName);
                }
                if (this.systemPropertyClassName != null) {
                    System.setProperty(ExpCompiler.class.getName(), this.systemPropertyClassName);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultStyle {
        ANY,
        MUTABLE_LIST,
        LIST,
        ITERABLE,
        VALUE;

    }
}

