/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.export.legacy.BorderOffset;

public class RectangleDrawer
extends ElementDrawer {
    public void draw(Graphics2D grx, JRPrintElement element, int offsetX, int offsetY) {
        JRPrintRectangle rectangle = (JRPrintRectangle)element;
        int width = rectangle.getWidth();
        int height = rectangle.getHeight();
        if (rectangle.getMode() == 1) {
            grx.setColor(rectangle.getBackcolor());
            if (rectangle.getRadius() > 0) {
                grx.fillRoundRect(rectangle.getX() + offsetX, rectangle.getY() + offsetY, width, height, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
            } else {
                grx.fillRect(rectangle.getX() + offsetX, rectangle.getY() + offsetY, width, height);
            }
        }
        grx.setColor(rectangle.getLinePen().getLineColor());
        Stroke stroke = RectangleDrawer.getStroke(rectangle.getLinePen(), 2);
        if (stroke != null && width > 0 && height > 0) {
            grx.setStroke(stroke);
            AffineTransform oldTx = grx.getTransform();
            if (rectangle.getLinePen().getLineStyle() == 3) {
                float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
                if (rectangle.getRadius() > 0) {
                    grx.translate((float)(rectangle.getX() + offsetX) - lineWidth / 3.0f, (float)(rectangle.getY() + offsetY) - lineWidth / 3.0f);
                    grx.scale(((float)width + 2.0f * lineWidth / 3.0f) / (float)width, ((float)height + 2.0f * lineWidth / 3.0f) / (float)height);
                    grx.drawRoundRect(0, 0, width, height, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
                    grx.setTransform(oldTx);
                    grx.translate((float)(rectangle.getX() + offsetX) + lineWidth / 3.0f, (float)(rectangle.getY() + offsetY) + lineWidth / 3.0f);
                    if ((float)width > 2.0f * lineWidth / 3.0f) {
                        grx.scale(((float)width - 2.0f * lineWidth / 3.0f) / (float)width, 1.0);
                    }
                    if ((float)height > 2.0f * lineWidth / 3.0f) {
                        grx.scale(1.0, ((float)height - 2.0f * lineWidth / 3.0f) / (float)height);
                    }
                    grx.drawRoundRect(0, 0, width, height, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
                } else {
                    grx.translate((float)(rectangle.getX() + offsetX) - lineWidth / 3.0f, (float)(rectangle.getY() + offsetY) - lineWidth / 3.0f);
                    grx.scale(((float)width + 2.0f * lineWidth / 3.0f) / (float)width, ((float)height + 2.0f * lineWidth / 3.0f) / (float)height);
                    grx.drawRect(0, 0, width, height);
                    grx.setTransform(oldTx);
                    grx.translate((float)(rectangle.getX() + offsetX) + lineWidth / 3.0f, (float)(rectangle.getY() + offsetY) + lineWidth / 3.0f);
                    if ((float)width > 2.0f * lineWidth / 3.0f) {
                        grx.scale(((float)width - 2.0f * lineWidth / 3.0f) / (float)width, 1.0);
                    }
                    if ((float)height > 2.0f * lineWidth / 3.0f) {
                        grx.scale(1.0, ((float)height - 2.0f * lineWidth / 3.0f) / (float)height);
                    }
                    grx.drawRect(0, 0, width, height);
                }
            } else {
                float lineOffset = BorderOffset.getOffset(rectangle.getLinePen());
                grx.translate((float)(rectangle.getX() + offsetX) + lineOffset, (float)(rectangle.getY() + offsetY) + lineOffset);
                if ((float)width > 2.0f * lineOffset) {
                    grx.scale(((float)width - 2.0f * lineOffset) / (float)width, 1.0);
                }
                if ((float)height > 2.0f * lineOffset) {
                    grx.scale(1.0, ((float)height - 2.0f * lineOffset) / (float)height);
                }
                if (rectangle.getRadius() > 0) {
                    grx.drawRoundRect(0, 0, width, height, 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
                } else {
                    grx.drawRect(0, 0, width, height);
                }
            }
            grx.setTransform(oldTx);
        }
    }
}

