/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

public final class LineContainsRegExp
extends BaseParamFilterReader
implements ChainableReader {
    private static final String REGEXP_KEY = "regexp";
    private Vector regexps = new Vector();
    private String line = null;

    public LineContainsRegExp() {
    }

    public LineContainsRegExp(Reader in) {
        super(in);
    }

    public final int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int ch = -1;
        if (this.line != null) {
            ch = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            this.line = this.readLine();
            if (this.line == null) {
                ch = -1;
            } else {
                int regexpsSize = this.regexps.size();
                int i = 0;
                while (i < regexpsSize) {
                    RegularExpression regexp = (RegularExpression)this.regexps.elementAt(i);
                    Regexp re = regexp.getRegexp(this.getProject());
                    boolean matches = re.matches(this.line);
                    if (!matches) {
                        this.line = null;
                        break;
                    }
                    ++i;
                }
                return this.read();
            }
        }
        return ch;
    }

    public final void addConfiguredRegexp(RegularExpression regExp) {
        this.regexps.addElement(regExp);
    }

    private void setRegexps(Vector regexps) {
        this.regexps = regexps;
    }

    private final Vector getRegexps() {
        return this.regexps;
    }

    public final Reader chain(Reader rdr) {
        LineContainsRegExp newFilter = new LineContainsRegExp(rdr);
        newFilter.setRegexps(this.getRegexps());
        newFilter.setInitialized(true);
        return newFilter;
    }

    private final void initialize() {
        Parameter[] params = this.getParameters();
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                if (REGEXP_KEY.equals(params[i].getType())) {
                    String pattern = params[i].getValue();
                    RegularExpression regexp = new RegularExpression();
                    regexp.setPattern(pattern);
                    this.regexps.addElement(regexp);
                }
                ++i;
            }
        }
    }
}

