/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocallyDownloadedTableModel
extends UnitCategoryTableModel {
    private OperationContainer<InstallSupport> availableNbmsContainer = Containers.forAvailableNbms();
    private OperationContainer<InstallSupport> updateNbmsContainer = Containers.forUpdateNbms();
    private LocalDownloadSupport localDownloadSupport = null;
    List<UpdateUnit> cachedUnits;

    public LocallyDownloadedTableModel(LocalDownloadSupport localDownloadSupport) {
        this.localDownloadSupport = localDownloadSupport;
        this.getLocalDownloadSupport().removeAll(this.getLocalDownloadSupport().getInstalledUpdateUnits());
    }

    @Override
    public final void setUnits(List<UpdateUnit> list) {
        List<UpdateUnit> list2 = this.getLocalDownloadSupport().getUpdateUnits();
        if (this.cachedUnits == null || !list2.containsAll(this.cachedUnits) || !this.cachedUnits.containsAll(list2)) {
            this.setData(this.makeCategories(list2));
            this.cachedUnits = new ArrayList<UpdateUnit>(list2);
        }
    }

    void removeInstalledUnits() {
        this.getLocalDownloadSupport().removeAll(this.getLocalDownloadSupport().getInstalledUpdateUnits());
        this.cachedUnits = null;
        this.setUnits(null);
    }

    private List<UnitCategory> makeCategories(List<UpdateUnit> list) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        arrayList.addAll(Utilities.makeAvailableCategories(list, true));
        arrayList.addAll(Utilities.makeUpdateCategories(list, true));
        return arrayList;
    }

    LocalDownloadSupport getLocalDownloadSupport() {
        return this.localDownloadSupport;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
        if (object == null) {
            return;
        }
        if (!(object instanceof Boolean)) {
            return;
        }
        Unit unit = this.getUnitAtRow(n);
        if (unit != null) {
            assert (object instanceof Boolean) : object + " must be instanceof Boolean.";
            boolean bl = unit.isMarked();
            unit.setMarked(!bl);
            if (unit.isMarked() != bl) {
                this.fireButtonsChange();
            } else assert (false) : unit.getDisplayName();
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        Unit unit = this.getUnitAtRow(n);
        if (unit != null) {
            boolean bl = unit instanceof Unit.Available;
            switch (n2) {
                case 0: {
                    object = unit.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    object = unit.getDisplayName();
                    break;
                }
                case 2: {
                    object = unit.getCategoryName();
                    break;
                }
                case 3: {
                    if (bl) {
                        object = ((Unit.Available)unit).getAvailableVersion();
                        break;
                    }
                    object = ((Unit.Update)unit).getAvailableVersion();
                    break;
                }
                case 4: {
                    object = bl ? ((Unit.Available)unit).getSize() : ((Unit.Update)unit).getSize();
                }
            }
        }
        return object;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 0: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = String.class;
                break;
            }
            case 2: {
                clazz = String.class;
                break;
            }
            case 3: {
                clazz = String.class;
                break;
            }
            case 4: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Install");
            }
            case 1: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Name");
            }
            case 2: {
                return this.getBundle("InstalledTableModel_Columns_Category");
            }
            case 3: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Version");
            }
            case 4: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Size");
            }
        }
        assert (false);
        return super.getColumnName(n);
    }

    @Override
    public int getPreferredWidth(JTableHeader jTableHeader, int n) {
        switch (n) {
            case 1: {
                return super.getMinWidth(jTableHeader, n) * 4;
            }
            case 2: {
                return super.getMinWidth(jTableHeader, n) * 2;
            }
        }
        return super.getMinWidth(jTableHeader, n);
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.LOCAL;
    }

    @Override
    public boolean isSortAllowed(Object object) {
        boolean bl = this.getColumnName(0).equals(object);
        boolean bl2 = this.getColumnName(4).equals(object);
        return !bl && !bl2;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object object, final boolean bl) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit unit, Unit unit2) {
                Unit unit3;
                Unit unit4 = bl ? unit : unit2;
                Unit unit5 = unit3 = bl ? unit2 : unit;
                if (LocallyDownloadedTableModel.this.getColumnName(0).equals(object)) {
                    assert (false) : object.toString();
                } else {
                    if (LocallyDownloadedTableModel.this.getColumnName(1).equals(object)) {
                        return Unit.compareDisplayNames(unit4, unit3);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(2).equals(object)) {
                        return Unit.compareCategories(unit4, unit3);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(3).equals(object)) {
                        return Unit.compareDisplayVersions(unit4, unit3);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(4).equals(object)) assert (false) : object.toString();
                }
                return 0;
            }
        };
    }

    @Override
    public int getDownloadSize() {
        return 0;
    }

    private String getBundle(String string) {
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    @Override
    public String getTabTitle() {
        return NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Local_Title");
    }

    @Override
    public int getTabIndex() {
        return 2;
    }

    @Override
    public boolean canBePrimaryTab() {
        return false;
    }

    @Override
    public boolean needsRestart() {
        return false;
    }

    public class DisplayName {
        public DisplayName(String string) {
        }
    }
}

