/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.macros;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.macros.MacroSavePanel;
import org.netbeans.modules.options.macros.MacrosModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MacroDialogSupport
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(MacroDialogSupport.class.getName());
    private Dialog macroDialog;
    private final MacroSavePanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final String mimeType;
    private final Class kitClass;

    public MacroDialogSupport(String string, Class clazz) {
        this.mimeType = string;
        this.kitClass = clazz;
        this.panel = new MacroSavePanel(string);
        ResourceBundle resourceBundle = NbBundle.getBundle(MacroDialogSupport.class);
        this.okButton = new JButton(resourceBundle.getString("MDS_ok"));
        this.cancelButton = new JButton(resourceBundle.getString("MDS_cancel"));
        this.okButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MDS_ok"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MDS_cancel"));
    }

    public void setBody(String string) {
        this.panel.setMacroBody(string);
    }

    public void showMacroDialog() {
        this.macroDialog = DialogSupport.createDialog((String)NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_title"), (JPanel)this.panel, (boolean)true, (JButton[])new JButton[]{this.okButton, this.cancelButton}, (boolean)false, (int)0, (int)1, (ActionListener)this);
        this.macroDialog.pack();
        this.panel.popupNotify();
        this.macroDialog.requestFocus();
        this.macroDialog.show();
    }

    private void saveMacro(boolean bl) {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object32;
        Set set = EditorSettings.getDefault().getMimeTypes();
        for (Object object32 : set) {
            object2 = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)object32)).lookup(BaseOptions.class);
            if (object2 == null) continue;
            object = object2.getMacroMap();
            cloneable = new HashMap<String, String>((Map<String, String>)object);
            cloneable.put(this.panel.getMacroName(), this.panel.getMacroBody());
            object2.setMacroMap(cloneable);
        }
        String string = "macro-" + this.panel.getMacroName();
        if (bl) {
            int n;
            object32 = EditorSettings.getDefault().getCurrentKeyMapProfile();
            object2 = EditorSettings.getDefault().getKeyBindingSettings(new String[]{this.mimeType});
            object = object2.getKeyBindings((String)object32);
            cloneable = new ArrayList();
            for (n = 0; n < object.size(); ++n) {
                MultiKeyBinding multiKeyBinding = (MultiKeyBinding)object.get(n);
                if (multiKeyBinding.getActionName() == null || !multiKeyBinding.getActionName().equals(string)) continue;
                cloneable.add(multiKeyBinding);
            }
            for (n = 0; n < cloneable.size(); ++n) {
                object.remove(cloneable.get(n));
            }
            object2.setKeyBindings((String)object32, (List)object);
        }
        if ((object32 = this.panel.getKeySequences()).size() > 0) {
            object2 = (ShortcutsFinder)Lookup.getDefault().lookup(ShortcutsFinder.class);
            object2.refreshActions();
            object = object2.findActionForId(string);
            object2.setShortcuts((ShortcutAction)object, (Set)object32);
            object2.apply();
        }
        if ((object2 = MacrosModel.getModel(null)) != null) {
            ((MacrosModel)object2).reset();
        }
    }

    protected int showConfirmDialog(String string) {
        return JOptionPane.showConfirmDialog(this.panel, MessageFormat.format(NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_Overwrite"), this.panel.getMacroName()), NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_Warning"), 1, 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            if (this.panel.getMacroName() == null || this.panel.getMacroName().length() == 0 || this.panel.getMacroName().trim().length() == 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle(MacroDialogSupport.class).getString("MDS_Empty_Name"), 0));
                this.panel.nameField.requestFocusInWindow();
                return;
            }
            Map map = (Map)Settings.getValue((Class)this.kitClass, (String)"macro-map");
            if (!map.containsKey(this.panel.getMacroName())) {
                this.saveMacro(false);
            } else {
                int n = this.showConfirmDialog(this.panel.getMacroName());
                if (n == 2 || n == -1) {
                    return;
                }
                if (n == 0) {
                    this.saveMacro(true);
                }
            }
        }
        this.macroDialog.setVisible(false);
        this.macroDialog.dispose();
    }

    public static final class StopMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/options/macros/stop_macro_recording.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                String string = this.stopRecording(jTextComponent);
                if (string == null) {
                    jTextComponent.getToolkit().beep();
                } else {
                    BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                    String string2 = NbEditorUtilities.getMimeType((JTextComponent)jTextComponent);
                    MacroDialogSupport macroDialogSupport = new MacroDialogSupport(string2, baseKit.getClass());
                    macroDialogSupport.setBody(string);
                    macroDialogSupport.showMacroDialog();
                }
            }
        }

        private String stopRecording(JTextComponent jTextComponent) {
            try {
                Method method = BaseAction.class.getDeclaredMethod("stopRecording", JTextComponent.class);
                method.setAccessible(true);
                return (String)method.invoke((Object)this, jTextComponent);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't call BaseAction.stopRecording", exception);
                return null;
            }
        }
    }

    public static class StartMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/options/macros/start_macro_recording.png");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && !this.startRecording(jTextComponent)) {
                jTextComponent.getToolkit().beep();
            }
        }

        private boolean startRecording(JTextComponent jTextComponent) {
            try {
                Method method = BaseAction.class.getDeclaredMethod("startRecording", JTextComponent.class);
                method.setAccessible(true);
                return (Boolean)method.invoke((Object)this, jTextComponent);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't call BaseAction.startRecording", exception);
                return false;
            }
        }
    }
}

