/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.actions.AlignWithSupport;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAlignWithResizeStrategyProvider
extends AlignWithSupport
implements ResizeStrategy,
ResizeProvider {
    private boolean outerBounds;
    private boolean moveEnabled = false;
    private boolean snapToGrid = false;
    private int gridSize = 13;
    List<ObjectPropertyUndoableEdit> undoEdits = null;

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public boolean isOuterBounds() {
        return this.outerBounds;
    }

    public void setOuterBounds(boolean outerBounds) {
        this.outerBounds = outerBounds;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public ReportAlignWithResizeStrategyProvider(AlignWithWidgetCollector collector, LayerWidget interractionLayer, AlignWithMoveDecorator decorator, boolean outerBounds) {
        super(collector, interractionLayer, decorator);
        this.outerBounds = outerBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle boundsSuggested(Widget widget, Rectangle originalBounds, Rectangle suggestedBounds, ResizeProvider.ControlPoint controlPoint) {
        Insets insets = widget.getBorder().getInsets();
        int minx = insets.left + insets.right;
        int miny = insets.top + insets.bottom;
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        int minElementWidth = widget.getPreferredBounds().width;
        int minElementHeight = widget.getPreferredBounds().height;
        for (Widget w : selectedElements) {
            if (!w.isVisible()) continue;
            Rectangle r = w.getBounds();
            minElementWidth = Math.min(r.width, minElementWidth);
            minElementHeight = Math.min(r.height, minElementHeight);
        }
        minx += widget.getBounds().width - minElementWidth;
        miny += widget.getBounds().height - minElementHeight;
        suggestedBounds = widget.convertLocalToScene(suggestedBounds);
        switch (controlPoint) {
            case BOTTOM_CENTER: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width / 2, suggestedBounds.y + suggestedBounds.height);
                if (!this.outerBounds) {
                    suggestedLocation.y -= insets.bottom;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, false, true, false, false);
                if (!this.outerBounds) {
                    point.y += insets.bottom;
                }
                suggestedBounds.height = Math.max(miny, point.y - suggestedBounds.y);
                break;
            }
            case BOTTOM_LEFT: {
                Point suggestedLocation = new Point(suggestedBounds.x, suggestedBounds.y + suggestedBounds.height);
                if (!this.outerBounds) {
                    suggestedLocation.y -= insets.bottom;
                    suggestedLocation.x += insets.left;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y += insets.bottom;
                    point.x -= insets.left;
                }
                suggestedBounds.height = Math.max(miny, point.y - suggestedBounds.y);
                int tempx = Math.min(point.x, suggestedBounds.x + suggestedBounds.width - minx);
                suggestedBounds.width = suggestedBounds.x + suggestedBounds.width - tempx;
                suggestedBounds.x = tempx;
                break;
            }
            case BOTTOM_RIGHT: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width, suggestedBounds.y + suggestedBounds.height);
                if (!this.outerBounds) {
                    suggestedLocation.y -= insets.bottom;
                    suggestedLocation.x -= insets.right;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y += insets.bottom;
                    point.x += insets.right;
                }
                suggestedBounds.height = Math.max(miny, point.y - suggestedBounds.y);
                suggestedBounds.width = Math.max(minx, point.x - suggestedBounds.x);
                break;
            }
            case CENTER_LEFT: {
                Point suggestedLocation = new Point(suggestedBounds.x, suggestedBounds.y + suggestedBounds.height / 2);
                if (!this.outerBounds) {
                    suggestedLocation.x += insets.left;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, false, false, false);
                if (!this.outerBounds) {
                    point.x -= insets.left;
                }
                int tempx = Math.min(point.x, suggestedBounds.x + suggestedBounds.width - minx);
                suggestedBounds.width = suggestedBounds.x + suggestedBounds.width - tempx;
                suggestedBounds.x = tempx;
                break;
            }
            case CENTER_RIGHT: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width, suggestedBounds.y + suggestedBounds.height / 2);
                if (!this.outerBounds) {
                    suggestedLocation.x -= insets.right;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, false, false, false);
                if (!this.outerBounds) {
                    point.x += insets.right;
                }
                suggestedBounds.width = Math.max(minx, point.x - suggestedBounds.x);
                break;
            }
            case TOP_CENTER: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width / 2, suggestedBounds.y);
                if (!this.outerBounds) {
                    suggestedLocation.y += insets.top;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, false, true, false, false);
                if (!this.outerBounds) {
                    point.y -= insets.top;
                }
                int tempy = Math.min(point.y, suggestedBounds.y + suggestedBounds.height - miny);
                suggestedBounds.height = suggestedBounds.y + suggestedBounds.height - tempy;
                suggestedBounds.y = tempy;
                break;
            }
            case TOP_LEFT: {
                Point suggestedLocation = new Point(suggestedBounds.x, suggestedBounds.y);
                if (!this.outerBounds) {
                    suggestedLocation.y += insets.top;
                    suggestedLocation.x += insets.left;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y -= insets.top;
                    point.x -= insets.left;
                }
                int tempy = Math.min(point.y, suggestedBounds.y + suggestedBounds.height - miny);
                suggestedBounds.height = suggestedBounds.y + suggestedBounds.height - tempy;
                suggestedBounds.y = tempy;
                int tempx = Math.min(point.x, suggestedBounds.x + suggestedBounds.width - minx);
                suggestedBounds.width = suggestedBounds.x + suggestedBounds.width - tempx;
                suggestedBounds.x = tempx;
                break;
            }
            case TOP_RIGHT: {
                Point suggestedLocation = new Point(suggestedBounds.x + suggestedBounds.width, suggestedBounds.y);
                if (!this.outerBounds) {
                    suggestedLocation.y += insets.top;
                    suggestedLocation.x -= insets.right;
                }
                Point point = this.isSnapToGrid() ? super.snapToGrid(suggestedLocation, this.getGridSize()) : super.locationSuggested(widget, new Rectangle(suggestedLocation), suggestedLocation, true, true, false, false);
                if (!this.outerBounds) {
                    point.y -= insets.top;
                    point.x += insets.right;
                }
                int tempy = Math.min(point.y, suggestedBounds.y + suggestedBounds.height - miny);
                suggestedBounds.height = suggestedBounds.y + suggestedBounds.height - tempy;
                suggestedBounds.y = tempy;
                suggestedBounds.width = Math.max(minx, point.x - suggestedBounds.x);
            }
        }
        suggestedBounds = widget.convertSceneToLocal(suggestedBounds);
        Rectangle wbounds = widget.getBounds();
        Rectangle delta = new Rectangle(suggestedBounds.x - wbounds.x, suggestedBounds.y - wbounds.y, suggestedBounds.width - wbounds.width, suggestedBounds.height - wbounds.height);
        ArrayList<Widget> changedWidgets = new ArrayList<Widget>();
        for (Widget w : selectedElements) {
            JRDesignElementWidget dew;
            if (!w.isVisible() || changedWidgets.contains(dew = ((SelectionWidget)w).getRealWidget())) continue;
            Rectangle r = w.getPreferredBounds();
            r.x += delta.x;
            r.y += delta.y;
            r.width += delta.width;
            r.height += delta.height;
            w.setPreferredBounds(r);
            r = dew.getPreferredBounds();
            r.x += delta.x;
            r.y += delta.y;
            r.width += delta.width;
            r.height += delta.height;
            dew.setPreferredBounds(r);
            Point loc = dew.getPreferredLocation();
            loc.x += r.x;
            loc.y += r.y;
            loc = dew.convertLocalToModelLocation(loc);
            boolean b = dew.setChanging(true);
            try {
                dew.getElement().setX(loc.x);
                dew.getElement().setY(loc.y);
                dew.getElement().setWidth(r.width);
                dew.getElement().setHeight(r.height);
            }
            finally {
                dew.setChanging(b);
            }
            if (dew.getElement() instanceof JRDesignFrame) {
                this.updateChildren((JRDesignFrame)dew.getElement(), (AbstractReportObjectScene)dew.getScene(), changedWidgets);
            }
            changedWidgets.add(dew);
        }
        return suggestedBounds;
    }

    public void resizingStarted(Widget widget) {
        this.undoEdits = new ArrayList<ObjectPropertyUndoableEdit>();
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        for (Widget w : selectedElements) {
            if (!w.isVisible()) continue;
            JRDesignElementWidget dew = ((SelectionWidget)w).getRealWidget();
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), "X", Integer.TYPE, new Integer(dew.getElement().getX()), new Integer(dew.getElement().getX())));
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), "Y", Integer.TYPE, new Integer(dew.getElement().getY()), new Integer(dew.getElement().getY())));
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), I18n.getString("Global.Property.Width"), Integer.TYPE, new Integer(dew.getElement().getWidth()), new Integer(dew.getElement().getWidth())));
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), I18n.getString("Global.Property.Height"), Integer.TYPE, new Integer(dew.getElement().getHeight()), new Integer(dew.getElement().getHeight())));
        }
        this.show();
    }

    private ObjectPropertyUndoableEdit findEdit(Object obj, String property) {
        for (ObjectPropertyUndoableEdit edit : this.undoEdits) {
            if (edit.getObject() != obj || !edit.getProperty().equals(property)) continue;
            return edit;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizingFinished(Widget widget) {
        this.hide();
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        ArrayList<Widget> changedWidgets = new ArrayList<Widget>();
        for (Widget w : selectedElements) {
            JRDesignElementWidget dew;
            if (!w.isVisible() || changedWidgets.contains(dew = ((SelectionWidget)w).getRealWidget())) continue;
            Insets insets = w.getBorder().getInsets();
            Point loc = w.getPreferredLocation();
            Rectangle bounds = w.getPreferredBounds();
            loc.x += bounds.x + insets.left;
            loc.y += bounds.y + insets.top;
            bounds.x = -insets.left;
            bounds.y = -insets.right;
            w.setPreferredBounds(bounds);
            w.setPreferredLocation(loc);
            loc = dew.convertLocalToModelLocation(loc);
            boolean b = dew.setChanging(true);
            try {
                dew.getElement().setX(loc.x);
                dew.getElement().setY(loc.y);
                dew.getElement().setWidth(bounds.width - insets.left - insets.right);
                dew.getElement().setHeight(bounds.height - insets.top - insets.bottom);
                this.findEdit(dew.getElement(), "X").setNewValue(dew.getElement().getX());
                this.findEdit(dew.getElement(), "Y").setNewValue(dew.getElement().getY());
                this.findEdit(dew.getElement(), I18n.getString("Global.Property.Width")).setNewValue(dew.getElement().getWidth());
                this.findEdit(dew.getElement(), I18n.getString("Global.Property.Height")).setNewValue(dew.getElement().getHeight());
            }
            finally {
                dew.setChanging(b);
            }
            dew.updateBounds();
            if (dew.getElement() instanceof JRDesignFrame) {
                this.updateChildren((JRDesignFrame)dew.getElement(), (AbstractReportObjectScene)dew.getScene(), changedWidgets);
            }
            changedWidgets.add(dew);
        }
        for (int i = 0; i < this.undoEdits.size(); ++i) {
            ObjectPropertyUndoableEdit edit = this.undoEdits.get(i);
            if (edit.getNewValue() == null && edit.getOldValue() == null) {
                this.undoEdits.remove(edit);
                continue;
            }
            if (edit.getNewValue() == null || edit.getOldValue() == null || !edit.getNewValue().equals(edit.getOldValue())) continue;
            this.undoEdits.remove(edit);
        }
        if (this.undoEdits.size() > 0) {
            AggregatedUndoableEdit masterEdit = new AggregatedUndoableEdit("Resize");
            for (int i = 0; i < this.undoEdits.size(); ++i) {
                ObjectPropertyUndoableEdit edit = this.undoEdits.get(i);
                masterEdit.concatenate(edit);
            }
            IReportManager.getInstance().addUndoableEdit(masterEdit);
        }
    }

    private void updateChildren(JRDesignFrame parent, AbstractReportObjectScene scene, ArrayList<Widget> changedWidgets) {
        JRElement[] elements = parent.getElements();
        for (int i = 0; i < elements.length; ++i) {
            JRDesignElementWidget w = (JRDesignElementWidget)scene.findWidget(elements[i]);
            if (changedWidgets.contains(w)) continue;
            w.updateBounds();
            w.getSelectionWidget().updateBounds();
            if (elements[i] instanceof JRDesignFrame) {
                this.updateChildren((JRDesignFrame)elements[i], scene, changedWidgets);
            }
            changedWidgets.add(w);
        }
    }
}

