/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openide.loaders.DataObject;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompoundSearchInfo
implements SearchInfo {
    private final SearchInfo[] elements;

    CompoundSearchInfo(SearchInfo ... searchInfoArray) {
        if (searchInfoArray == null) {
            throw new IllegalArgumentException();
        }
        this.elements = searchInfoArray.length != 0 ? searchInfoArray : null;
    }

    @Override
    public boolean canSearch() {
        if (this.elements != null) {
            for (SearchInfo searchInfo : this.elements) {
                if (!searchInfo.canSearch()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<DataObject> objectsToSearch() {
        if (this.elements == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<SearchInfo> arrayList = new ArrayList<SearchInfo>(this.elements.length);
        for (SearchInfo searchInfo : this.elements) {
            if (!searchInfo.canSearch()) continue;
            arrayList.add(searchInfo);
        }
        return new CompoundSearchIterator(arrayList.toArray(new SearchInfo[arrayList.size()]));
    }
}

