/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgAcceptAllStringNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgDimensionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgEnumNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgHierarchyNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgLevelNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgLogicalNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgMemberNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgNumericNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgStringNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTArgTupleNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxfunctions.MdxArrayFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxDimensionFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxHierarchyFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxLevelFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxLogicalFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxMakeTupleFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxMemberFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxNumericFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxOperatorFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxSetFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxStringFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxTupleFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MdxFunctionTree
extends JPanel
implements LanguageChangedListener {
    final JTree tree;
    private JComponent parent;
    private TreePath popUpSource;
    private boolean categorized;
    DefaultMutableTreeNode nonMdxFunctions;
    DefaultMutableTreeNode arrayFunctions;
    DefaultMutableTreeNode stringFunctions;
    DefaultMutableTreeNode dimensionHierarchyAndLevelFunctions;
    DefaultMutableTreeNode dimensionFunctions;
    DefaultMutableTreeNode hierarchyFunctions;
    DefaultMutableTreeNode levelFunctions;
    DefaultMutableTreeNode logicalFunctions;
    DefaultMutableTreeNode tupleFunctions;
    DefaultMutableTreeNode setFunctions;
    DefaultMutableTreeNode otherFunctions;
    DefaultMutableTreeNode numericFunctions;
    DefaultMutableTreeNode memberFunctions;
    DefaultMutableTreeNode allFunctions;
    DefaultMutableTreeNode top = new DefaultMutableTreeNode("");

    public MdxFunctionTree(JComponent _parent) {
        this();
        this.parent = _parent;
    }

    public MdxFunctionTree() {
        this.tree = new JTree(this.top){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintWhiteBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.buildFunctionList(this.top);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(200, 600));
        treeView.setMaximumSize(new Dimension(800, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)treeView, "Center");
        this.tree.setCellRenderer(new MdxFunctionTreeRenderer());
        this.tree.addMouseListener(new PopupListener());
        I18n.addOnLanguageChangedListener(this);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.buildFunctionList(this.top);
        this.tree.updateUI();
        this.tree.repaint();
    }

    public JTree getTree() {
        return this.tree;
    }

    private void buildFunctionList(DefaultMutableTreeNode top) {
        this.nonMdxFunctions = new DefaultMutableTreeNode("Non MDX Functions");
        MdxFunction f = new MdxMakeTupleFunction("make tuple", I18n.getString("nonMDXFunction.makeTuple"), "(\u00abMember\u00bb[, \u00abMember\u00bb...])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(false, "\u00abMember\u00bb", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("*", I18n.getString("nonMDXFunction.multiplyOpr"), "(\u00abNumeric Expression1\u00bb * \u00abNumeric Expression2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00abNumExp1\u00bb"), new MBTArgNumericNode(false, "\u00abNumExp2\u00bb", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("/", I18n.getString("nonMDXFunction.divideOpr"), "(\u00abNumeric Expression1\u00bb / \u00abNumeric Expression2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00abNumExp1\u00bb"), new MBTArgNumericNode(false, "\u00abNumExp2\u00bb", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("+", I18n.getString("nonMDXFunction.addOpr"), "(\u00abNumeric Expression1\u00bb + \u00abNumeric Expression2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00abNumExp1\u00bb"), new MBTArgNumericNode(false, "\u00abNumExp2\u00bb", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxOperatorFunction("-", I18n.getString("nonMDXFunction.subtractOpr"), "(\u00abNumeric Expression1\u00bb + \u00abNumeric Expression2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode(true, "\u00abNumExp1\u00bb"), new MBTArgNumericNode(false, "\u00abNumExp2\u00bb", true, false)};
            }
        };
        this.nonMdxFunctions.add(new DefaultMutableTreeNode(f));
        this.arrayFunctions = new DefaultMutableTreeNode("Array Functions");
        f = new MdxArrayFunction("SetToArray", I18n.getString("arrayFunction.setToArray"), "SetToArray(\u00abSet\u00bb[, \u00abSet\u00bb...][, \u00abNumeric Expression\u00bb]"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode(false, "\u00abSet1\u00bb", true, false), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.arrayFunctions.add(new DefaultMutableTreeNode(f));
        this.stringFunctions = new DefaultMutableTreeNode("String Functions");
        f = new MdxStringFunction("CalculationPassValue", I18n.getString("stringFunction.calcPassValue"), "CalculationPassValue(\u00abString Expression\u00bb, \u00abPass Value\u00bb[, \u00abAccess Flag\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abString Expression\u00bb"), new MBTArgNumericNode("\u00abPass Value\u00bb"), new MBTArgEnumNode(false, "\u00abAccess Flag\u00bb", new String[]{"ABSOLUTE", "RELATIVE"}, false, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("CoalesceEmpty", I18n.getString("stringFunction.coalescesEmpty"), "CoalesceEmpty(\u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]...)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", true, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Generate", I18n.getString("stringFunction.generate"), "Generate(\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Generate", I18n.getString("stringFunction.generate"), "Generate(\u00abSet\u00bb, \u00abString Expression\u00bb[, \u00abDelimiter\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgStringNode("\u00abString Expression\u00bb"), new MBTArgStringNode(false, "\u00abDelimiter\u00bb", false, true)};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("IIf", I18n.getString("stringFunction.iif"), "IIf(\u00abLogical Expression\u00bb, \u00abNumeric or String Expression1\u00bb, \u00abNumeric or String Expression2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLogicalNode("\u00abLogical Expression\u00bb"), new MBTArgStringNode("\u00abNumeric or String Expression1\u00bb"), new MBTArgStringNode("\u00abNumeric or String Expression1\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("LookupCube", I18n.getString("stringFunction.lookUpCube"), "LookupCube(\u00abCube String\u00bb, \u00abNumeric or String Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abCube String\u00bb"), new MBTArgStringNode("\u00abNumeric or String Expression1\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("MemberToStr", I18n.getString("stringFunction.memberToStr"), "MemberToStr(\u00abMember\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Name", I18n.getString("stringFunction.name"), "\u00abDimension|Level|Member|Hierarchy\u00bb.Name"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(true, "\u00abDimension|Level|Member|Hierarchy\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("Properties", I18n.getString("stringFunction.properties"), "\u00abMember\u00bb.Properties(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb"), new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("SetToStr", I18n.getString("stringFunction.setToStr"), "SetToStr(\u00abSet\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("TupleToStr", I18n.getString("stringFunction.tupleToStr"), "TupleToStr(\u00abTuple\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode("\u00abSet\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("UniqueName", I18n.getString("stringFunction.uniqueName"), "\u00abDimension/Level/Member/Hierarchy\u00bb.UniqueName"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00abDimension/Level/Member/Hierarchy\u00bb")};
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxStringFunction("UserName", I18n.getString("stringFunction.userName"), "UserName"){

            public MBTNode[] getFunctionArguments() {
                return null;
            }
        };
        this.stringFunctions.add(new DefaultMutableTreeNode(f));
        this.dimensionHierarchyAndLevelFunctions = new DefaultMutableTreeNode("Dimension, Hierarchy, and Level Functions ");
        this.dimensionFunctions = new DefaultMutableTreeNode("Dimension Functions");
        f = new MdxDimensionFunction("Dimension", I18n.getString("dimensionFunction.dimension"), "\u00abMember|Level|Hierarchy\u00bb.Dimension"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00abMember|Level|Hierarchy\u00bb")};
            }
        };
        this.dimensionFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxDimensionFunction("Dimensions", I18n.getString("dimensionFunction.dimensions"), "Dimensions(\u00abNumeric/String Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abNumeric or String Expression1\u00bb")};
            }
        };
        this.dimensionFunctions.add(new DefaultMutableTreeNode(f));
        this.hierarchyFunctions = new DefaultMutableTreeNode("Hierarchy Functions");
        f = new MdxHierarchyFunction("Hierarchy", I18n.getString("hierarchyFunction.hierarchy"), "\u00abMember|Level\u00bb.Hierarchy"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00abMember|Level\u00bb")};
            }
        };
        this.hierarchyFunctions.add(new DefaultMutableTreeNode(f));
        this.levelFunctions = new DefaultMutableTreeNode("Level Functions");
        f = new MdxLevelFunction("Level", I18n.getString("levelFunction.level"), "\u00abMember\u00bb.Level"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abLevel\u00bb")};
            }
        };
        this.levelFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLevelFunction("Levels", I18n.getString("levelFunction.numeric"), "\u00abDimension\u00bb.Levels(\u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgDimensionNode(true, "\u00abDimension\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.levelFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLevelFunction("Levels", I18n.getString("levelFunction.string"), "Levels(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.levelFunctions.add(new DefaultMutableTreeNode(f));
        this.dimensionHierarchyAndLevelFunctions.add(this.dimensionFunctions);
        this.dimensionHierarchyAndLevelFunctions.add(this.hierarchyFunctions);
        this.dimensionHierarchyAndLevelFunctions.add(this.levelFunctions);
        this.logicalFunctions = new DefaultMutableTreeNode("Logical Functions");
        f = new MdxLogicalFunction("Is (TO BE DONE!!!!)", I18n.getString("logicalFunction.compare"), "\u00abObject 1\u00bb IS \u00abObject 2\u00bb"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(true, "\u00abObject 1\u00bb"), new MBTArgAcceptAllStringNode("\u00abObject 2\u00bb")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsAncestor", I18n.getString("logicalFunction.isAncestor"), "IsAncestor(\u00abMember1\u00bb,\u00abMember2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "Member1\u00bb"), new MBTArgMemberNode("\u00abMember2\u00bb")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsEmpty", I18n.getString("logicalFunction.isEmpty"), "IsEmpty(\u00abValue Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode("\u00abValue Expression\u00bb")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsGeneration", I18n.getString("logicalFunction.isGeneration"), "IsGeneration(\u00abMember\u00bb,\u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsLeaf", I18n.getString("logicalFunction.isLeaf"), "IsLeaf(\u00abMember\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxLogicalFunction("IsSibling", I18n.getString("logicalFunction.isSibling"), "IsSibling(\u00abMember1\u00bb,\u00abMember2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember1\u00bb"), new MBTArgMemberNode("\u00abMember2\u00bb")};
            }
        };
        this.logicalFunctions.add(new DefaultMutableTreeNode(f));
        this.tupleFunctions = new DefaultMutableTreeNode("Tuple Functions");
        f = new MdxTupleFunction("Current", I18n.getString("tupleFunction.current"), "\u00abSet\u00bb.Current"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode(true, "\u00abSet\u00bb")};
            }
        };
        this.tupleFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxTupleFunction("Item", I18n.getString("tupleFunction.item"), "\u00abSet\u00bb.Item(\u00abString Expression\u00bb[, \u00abString Expression\u00bb...] | \u00abIndex\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode(true, "\u00abSet\u00bb"), new MBTArgStringNode(false, "\u00abString Expression\u00bb", true, false)};
            }
        };
        this.tupleFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxTupleFunction("StrToTuple", I18n.getString("tupleFunction.strToTuple"), "StrToTuple(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.tupleFunctions.add(new DefaultMutableTreeNode(f));
        this.memberFunctions = new DefaultMutableTreeNode("Member Functions");
        f = new MdxMemberFunction("Ancestor", I18n.getString("memberFunction.ancestor"), "Ancestor(\u00abMember\u00bb, \u00abLevel\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgLevelNode("\u00abLevel\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Ancestor", I18n.getString("memberFunction.ancestor2"), "Ancestor(\u00abMember\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("ClosingPeriod", I18n.getString("memberFunction.closingPeriod"), "ClosingPeriod([\u00abLevel\u00bb[, \u00abMember\u00bb]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode("\u00abLevel\u00bb"), new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Cousin", I18n.getString("memberFunction.cousin"), "Cousin(\u00abMember1\u00bb, \u00abMember2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember1\u00bb"), new MBTArgMemberNode("\u00abMember2\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("CurrentMember", I18n.getString("memberFunction.currentMember"), "\u00abDimension\u00bb.CurrentMember"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgDimensionNode(true, "\u00abDimension\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("DataMember", I18n.getString("memberFunction.dataMember"), "\u00abMember\u00bb.DataMember"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("DefaultMember", I18n.getString("memberFunction.defaultMember"), "\u00abDimension\u00bb.DefaultMember"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgDimensionNode(true, "\u00abDimension\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("FirstChild", I18n.getString("memberFunction.firstChild"), "\u00abMember\u00bb.FirstChild"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("FirstSibling", I18n.getString("memberFunction.firstSibling"), "\u00abMember\u00bb.FirstSibling"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Item", I18n.getString("memberFunction.item"), "\u00abTuple\u00bb.Item(\u00abIndex\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode(true, "\u00abTuple\u00bb"), new MBTArgNumericNode("\u00abIndex\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Lag", I18n.getString("memberFunction.lag"), "\u00abMember\u00bb.Lag(\u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("LastChild", I18n.getString("memberFunction.lastChild"), "\u00abMember\u00bb.LastChild"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("LastSibling", I18n.getString("memberFunction.lastSibling"), "\u00abMember\u00bb.LastSibling"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Lead", I18n.getString("memberFunction.lead"), "\u00abMember\u00bb.Lead(\u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("LinkMember", I18n.getString("memberFunction.linkMember"), "LinkMember(\u00abMember\u00bb, \u00abHierarchy\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgHierarchyNode("\u00abHierarchy\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Members", I18n.getString("memberFunction.members"), "\u00abDimension|Hierarchy|Level|String Expression\u00bb.Members"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00abDimension|Hierarchy|Level|String Expression\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("NextMember", I18n.getString("memberFunction.nextMember"), "\u00abMember\u00bb.NextMember"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("OpeningPeriod", I18n.getString("memberFunction.openingPeriod"), "OpeningPeriod([\u00abLevel\u00bb[, \u00abMember\u00bb]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true), new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("ParallelPeriod", I18n.getString("memberFunction.parallelPeriod"), "ParallelPeriod([\u00abLevel\u00bb[, \u00abNumeric Expression\u00bb[, \u00abMember\u00bb]]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true), new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("Parent", I18n.getString("memberFunction.parent"), "\u00abMember\u00bb.Parent"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("PrevMember", I18n.getString("memberFunction.prevMember"), "\u00abMember\u00bb.PrevMember"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("StrToMember", I18n.getString("memberFunction.strToMember"), "StrToMember(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxMemberFunction("ValidMeasure", I18n.getString("memberFunction.validMeasure"), "ValidMeasure(\u00abTuple\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode("\u00abTuple\u00bb")};
            }
        };
        this.memberFunctions.add(new DefaultMutableTreeNode(f));
        this.numericFunctions = new DefaultMutableTreeNode("Numeric Functions");
        f = new MdxNumericFunction("Aggregate", I18n.getString("numericFunction.aggregate"), "Aggregate(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Avg", I18n.getString("numericFunction.avg"), "Avg(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CalculationCurrentPass()", I18n.getString("numericFunction.calcPass"), "CalculationCurrentPass()"){

            public MBTNode[] getFunctionArguments() {
                return null;
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CalculationPassValue", I18n.getString("numericFunction.clacPassValue"), "CalculationPassValue(\u00abNumeric Expression\u00bb, \u00abPass Value\u00bb[, \u00abAccess Flag\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode("\u00abPass Value\u00bb"), new MBTArgEnumNode(false, "\u00abAccess Flag\u00bb", new String[]{"ABSOLUTE", "RELATIVE"}, false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CoalesceEmpty", I18n.getString("numericFunction.coalesceEmpty"), "CoalesceEmpty(\u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb]...)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", true, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Correlation", I18n.getString("numericFunction.correlation"), "Correlation(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Dimensions.Count", I18n.getString("numericFunction.dimensionCount"), "Dimensions.Count"){

            public MBTNode[] getFunctionArguments() {
                return null;
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Levels.Count", I18n.getString("numericFunction.levelCount"), "\u00abDimension\u00bb|\u00abHierarchy\u00bb.Levels.Count"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00abDimension|Hierarchy\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Count", I18n.getString("numericFunction.count"), "Count(\u00abSet\u00bb[, ExcludeEmpty | IncludeEmpty])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgEnumNode(false, "ExcludeEmpty | IncludeEmpty", new String[]{"ExcludeEmpty", "IncludeEmpty"}, false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Covariance", I18n.getString("numericFunction.covariance"), "Covariance(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("CovarianceN", I18n.getString("numericFunction.covarianceN"), "CovarianceN(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("DistinctCount", I18n.getString("numericFunction.distinctCount"), "DistinctCount(\u00abSet\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("IIf", I18n.getString("numericFunction.iif"), "IIf(\u00abLogical Expression\u00bb, \u00abNumeric or String Expression1\u00bb, \u00abNumeric or String Expression2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLogicalNode("\u00abLogical Expression\u00bb"), new MBTArgStringNode("\u00abNumeric or String Expression1\u00bb"), new MBTArgStringNode("\u00abNumeric or String Expression1\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegIntercept", I18n.getString("numericFunction.lineRegIncercept"), "LinRegIntercept(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegPoint", I18n.getString("numericFunction.lineRegPoint"), "LinRegPoint(\u00abNumeric Expression\u00bb, \u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgStringNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegR2", I18n.getString("numericFunction.lineRegR2"), "LinRegR2(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegSlope", I18n.getString("numericFunction.lineRegSlope"), "LinRegSlope(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LinRegVariance", I18n.getString("numericFunction.lineRegVariance"), "LinRegVariance(\u00abSet\u00bb, \u00abNumeric Expression\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("LookupCube", I18n.getString("numericFunction.lookUpCube"), "LookupCube(\u00abCube String\u00bb, \u00abNumeric|String Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abCube String\u00bb"), new MBTArgStringNode("\u00abNumeric|String Expression\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Max", I18n.getString("numericFunction.max"), "Max(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Median", I18n.getString("numericFunction.median"), "Median(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Min", I18n.getString("numericFunction.min"), "Min(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Ordinal", I18n.getString("numericFunction.ordinal"), "\u00abLevel\u00bb.Ordinal"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(true, "\u00abLevel\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Predict", I18n.getString("numericFunction.predict"), "Predict(\u00abMining Model Name\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abMining Model Name\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Rank", I18n.getString("numericFunction.rank"), "Rank(\u00abTuple\u00bb, \u00abSet\u00bb[, \u00abCalc Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgTupleNode("\u00abTuple\u00bb"), new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgAcceptAllStringNode(false, "\u00abCalc Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("RollupChildren", I18n.getString("numericFunction.rollUpChildren"), "RollupChildren(\u00abMember\u00bb, \u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Stddev", I18n.getString("numericFunction.stdDev"), "Stdev(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "Numeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("StddevP", I18n.getString("numericFunction.stdDevP"), "StdevP(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "Numeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Stdev", I18n.getString("numericFunction.stdev"), "Stdev(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "Numeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("StdevP", I18n.getString("numericFunction.stdevP"), "StdevP(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "Numeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("StrToValue", I18n.getString("numericFunction.strToValue"), "StrToValue(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Sum", I18n.getString("numericFunction.sum"), "Sum(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00ab\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Value", I18n.getString("numericFunction.value"), "\u00abMember\u00bb.Value"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Var", I18n.getString("numericFunction.var"), "Var(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("Variance", I18n.getString("numericFunction.variance"), "Variance(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("VarianceP", I18n.getString("numericFunction.varianceP"), "VarP(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxNumericFunction("VarP", I18n.getString("numericFunction.varP"), "VarP(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.numericFunctions.add(new DefaultMutableTreeNode(f));
        this.otherFunctions = new DefaultMutableTreeNode("Other Functions");
        this.setFunctions = new DefaultMutableTreeNode("Set Functions");
        f = new MdxSetFunction("AddCalculatedMembers", I18n.getString("setFunction.addCalcMembers"), "AddCalculatedMembers(\u00abSet\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("AllMembers", I18n.getString("setFunction.allMembers"), "\u00abDimension|Level\u00bb.AllMembers"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode(true, "\u00abDimension|Level\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ancestors", I18n.getString("setFunction.ancestors"), "Ancestors(\u00abMember\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ancestors", I18n.getString("setFunction.ancestors2"), "Ancestors(\u00abMember\u00bb, \u00abLevel\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgLevelNode("\u00abLevel\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ascendants", I18n.getString("setFunction.ascendants"), "Ascendants(\u00abMember\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Axis", I18n.getString("setFunction.axis"), "Axis(\u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("BottomCount", I18n.getString("setFunction.bottomCount"), "BottomCount(\u00abSet\u00bb, \u00abCount\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abCount\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("BottomPercent", I18n.getString("setFunction.bottomPercent"), "BottomPercent(\u00abSet\u00bb, \u00abPercentage\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abPercentage\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("BottomSum", I18n.getString("setFunction.bottomSum"), "BottomSum(\u00abSet\u00bb, \u00abValue\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abValue\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Children", I18n.getString("setFunction.children"), "\u00abMember\u00bb.Children"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Crossjoin", I18n.getString("setFunction.crossJoin"), "Crossjoin(\u00abSet1\u00bb, \u00abSet2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Descendants", I18n.getString("setFunction.decendants"), "Descendants(\u00abMember\u00bb, [\u00abLevel\u00bb[, \u00abDesc_flags\u00bb]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true), new MBTArgEnumNode(false, "\u00abDesc_flags\u00bb", new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Descendants", I18n.getString("setFunction.decendants"), "Descendants(\u00abMember\u00bb, \u00abDistance\u00bb[, \u00abDesc_flags\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode("\u00abMember\u00bb"), new MBTArgNumericNode(false, "\u00abDistance\u00bb", false, true), new MBTArgEnumNode(false, "\u00abDesc_flags\u00bb", new String[]{"SELF", "AFTER", "BEFORE", "BEFORE_AND_AFTER", "SELF_AND_AFTER", "SELF_AND_BEFORE", "SELF_BEFORE_AFTER", "LEAVES"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Distinct", I18n.getString("setFunction.distinct"), "Distinct(\u00abSet\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownLevel", I18n.getString("setFunction.drillDownLevel"), "DrilldownLevel(\u00abSet\u00bb[, {\u00abLevel\u00bb |  \u00abIndex\u00bb}])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgStringNode(false, "\u00abLevel\u00bb |  \u00abIndex\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownLevelBottom", I18n.getString("setFunction.drillDownLevelBottom"), "DrilldownLevelBottom(\u00abSet\u00bb, \u00abCount\u00bb[, [\u00abLevel\u00bb][, \u00abNumeric Expression\u00bb]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abCount\u00bb"), new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownLevelTop", I18n.getString("setFunction.drillDownLevelTop"), "DrilldownLevelTop(\u00abSet\u00bb, \u00abCount\u00bb[, [\u00abLevel\u00bb][, \u00abNumeric Expression\u00bb]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abCount\u00bb"), new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownMember", I18n.getString("setFunction.drillDownMember"), "DrilldownMember(\u00abSet1\u00bb, \u00abSet2\u00bb[, RECURSIVE])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownMemberBottom", I18n.getString("setFunction.drillDownMemberBottom"), "DrilldownMemberBottom(\u00abSet1\u00bb, \u00abSet2\u00bb, \u00abCount\u00bb[, [\u00abNumeric Expression\u00bb][, RECURSIVE]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgNumericNode("\u00abCount\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrilldownMemberTop", I18n.getString("setFunction.drillDownMemberTop"), "DrilldownMemberTop(\u00abSet1\u00bb, \u00abSet2\u00bb, \u00abCount\u00bb[, [\u00abNumeric Expression\u00bb][, RECURSIVE]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgNumericNode("\u00abCount\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrillupLevel", I18n.getString("setFunction.drillUpLevel"), "DrillupLevel(\u00abSet\u00bb[, \u00abLevel\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("DrillupMember", I18n.getString("setFunction.drillupMembers"), "DrillupMember(\u00abSet1\u00bb, \u00abSet2\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Except", I18n.getString("setFunction.except"), "Except(\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Extract", I18n.getString("setFunction.extract"), "Extract(\u00abSet\u00bb, \u00abDimension\u00bb[, \u00abDimension\u00bb...])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgDimensionNode(false, "\u00abDimension\u00bb", true, false)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Filter", I18n.getString("setFunction.filter"), "Filter(\u00abSet\u00bb, \u00abSearch Condition\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgStringNode("\u00abSearch Condition\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Generate", I18n.getString("setFunction.generate"), "Generate(\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Generate", I18n.getString("setFunction.generate"), "Generate(\u00abSet\u00bb, \u00abString Expression\u00bb[, \u00abDelimiter\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgStringNode("\u00abString Expression\u00bb"), new MBTArgStringNode(false, "\u00abDelimiter\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Head", I18n.getString("setFunction.head"), "Head(\u00abSet\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Hierarchize", I18n.getString("setFunction.hierarchize"), "Hierarchize(\u00abSet\u00bb[, POST])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgEnumNode(false, "POST", new String[]{"POST"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Intersect", I18n.getString("setFunction.intersect"), "Intersect(\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("LastPeriods", I18n.getString("setFunction.lastPeriods"), "LastPeriods(\u00abIndex\u00bb[, \u00abMember\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgNumericNode("\u00abIndex\u00bb"), new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Members", I18n.getString("setFunction.members"), "\u00abDimension|Hierarchy|Level\u00bb.Members"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode(true, "\u00abDimension|Hierarchy|Level\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Members", I18n.getString("setFunction.members"), "Members(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgAcceptAllStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Mtd", I18n.getString("setFunction.mtd"), "Mtd([\u00abMember\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("NameToSet", I18n.getString("setFunction.nameToSet"), "NameToSet(\u00abMember Name\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abMember Name\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("NonEmptyCrossjoin", I18n.getString("setFunction.nonEmptyJoins"), "NonEmptyCrossjoin(\u00abSet1\u00bb, \u00abSet2\u00bb[, \u00abSet3\u00bb...][, \u00abCrossjoin Set Count\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgSetNode(false, "\u00abSet2\u00bb", true, true), new MBTArgNumericNode(false, "\u00abCrossjoin Set Count\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Order", I18n.getString("setFunction.order"), "Order(\u00abSet\u00bb, {\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb} [, ASC | DESC | BASC | BDESC])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgStringNode("\u00abString Expression\u00bb | \u00abNumeric Expression\u00bb"), new MBTArgEnumNode(false, "ASC | DESC | BASC | BDESC", new String[]{"ASC", "DESC", "BASC", "BDESC"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("PeriodsToDate", I18n.getString("setFunction.periodsToDate"), "PeriodsToDate([\u00abLevel\u00bb[, \u00abMember\u00bb]])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgLevelNode(false, "\u00abLevel\u00bb", false, true), new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Qtd", I18n.getString("setFunction.qtd"), "Qtd([\u00abMember\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Siblings", I18n.getString("setFunction.siblings"), "\u00abMember\u00bb.Siblings"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(true, "\u00abMember\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("StripCalculatedMembers", I18n.getString("setFunction.stripCalcMembers"), "StripCalculatedMembers(\u00abSet\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("StrToSet", I18n.getString("setFunction.strToSet"), "StrToSet(\u00abString Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgStringNode("\u00abString Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Subset", I18n.getString("setFunction.subset"), "Subset(\u00abSet\u00bb, \u00abStart\u00bb[, \u00abCount\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abStart\u00bb"), new MBTArgNumericNode(false, "\u00abCount\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Tail", I18n.getString("setFunction.tail"), "Tail(\u00abSet\u00bb[, \u00abCount\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode(false, "\u00abCount\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("ToggleDrillState", I18n.getString("setFunction.toggleDrillState"), "ToggleDrillState(\u00abSet1\u00bb, \u00abSet2\u00bb[, RECURSIVE])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "RECURSIVE", new String[]{"RECURSIVE"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("TopCount", I18n.getString("setFunction.topCount"), "TopCount(\u00abSet\u00bb, \u00abCount\u00bb[, \u00abNumeric Expression\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abCount\u00bb"), new MBTArgNumericNode(false, "\u00abNumeric Expression\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("TopPercent", I18n.getString("setFunction.topPercent"), "TopPercent(\u00abSet\u00bb, \u00abPercentage\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abPercentage\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("TopSum", I18n.getString("setFunction.topSum"), "TopSum(\u00abSet\u00bb, \u00abValue\u00bb, \u00abNumeric Expression\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgNumericNode("\u00abValue\u00bb"), new MBTArgNumericNode("\u00abNumeric Expression\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Union", I18n.getString("setFunction.union"), "Union(\u00abSet1\u00bb, \u00abSet2\u00bb[, ALL])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet1\u00bb"), new MBTArgSetNode("\u00abSet2\u00bb"), new MBTArgEnumNode(false, "ALL", new String[]{"ALL"}, false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("VisualTotals", I18n.getString("setFunction.visualTotals"), "VisualTotals(\u00abSet\u00bb, \u00abPattern\u00bb)"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgSetNode("\u00abSet\u00bb"), new MBTArgStringNode("\u00abPattern\u00bb")};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Wtd", I18n.getString("setFunction.wtd"), "Wtd([\u00abMember\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        f = new MdxSetFunction("Ytd", I18n.getString("setFunction.ytd"), "Ytd([\u00abMember\u00bb])"){

            public MBTNode[] getFunctionArguments() {
                return new MBTNode[]{new MBTArgMemberNode(false, "\u00abMember\u00bb", false, true)};
            }
        };
        this.setFunctions.add(new DefaultMutableTreeNode(f));
        this.allFunctions = new DefaultMutableTreeNode("All Functions");
        DefaultMutableTreeNode[] heads = new DefaultMutableTreeNode[]{this.arrayFunctions, this.dimensionFunctions, this.hierarchyFunctions, this.levelFunctions, this.memberFunctions, this.numericFunctions, this.setFunctions, this.stringFunctions, this.tupleFunctions};
        int[] headIndexes = new int[heads.length];
        boolean sortDone = false;
        while (!sortDone) {
            f = null;
            sortDone = true;
            int selected = 0;
            for (int i = 0; i < heads.length; ++i) {
                if (headIndexes[i] >= heads[i].getChildCount()) continue;
                DefaultMutableTreeNode curr = (DefaultMutableTreeNode)heads[i].getChildAt(headIndexes[i]);
                if (f == null) {
                    f = (MdxFunction)curr.getUserObject();
                    selected = i;
                    continue;
                }
                if (((MdxFunction)curr.getUserObject()).getName().compareTo(f.getName()) >= 0) continue;
                f = (MdxFunction)curr.getUserObject();
                selected = i;
            }
            if (f == null) continue;
            sortDone = false;
            this.allFunctions.add(new DefaultMutableTreeNode(f));
            int n = selected;
            headIndexes[n] = headIndexes[n] + 1;
        }
        this.categorized = false;
        this.toggleTree();
    }

    private void toggleTree() {
        this.categorized = !this.categorized;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        root.removeAllChildren();
        if (this.categorized) {
            root.add(this.nonMdxFunctions);
            root.add(this.arrayFunctions);
            root.add(this.dimensionFunctions);
            root.add(this.hierarchyFunctions);
            root.add(this.levelFunctions);
            root.add(this.memberFunctions);
            root.add(this.numericFunctions);
            root.add(this.setFunctions);
            root.add(this.stringFunctions);
            root.add(this.tupleFunctions);
            root.setUserObject("Mdx Functions (categorized)");
        } else {
            root.add(this.nonMdxFunctions);
            root.add(this.allFunctions);
            this.tree.expandPath(new TreePath(this.allFunctions.getPath()));
            root.setUserObject("Mdx Functions (alphabetical)");
        }
        this.tree.updateUI();
        this.tree.repaint();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Testing FunctionTree...");
        MdxFunctionTree dst = new MdxFunctionTree();
        frame.setContentPane(dst);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    private class MdxFunctionTreeRenderer
    extends DefaultTreeCellRenderer {
        public MdxFunctionTreeRenderer() {
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof MdxFunction) {
                MdxFunction curr = (MdxFunction)((DefaultMutableTreeNode)value).getUserObject();
                this.setText(curr.toString());
                this.setIcon(curr.getIcon());
                this.setToolTipText(curr.getToolTip());
            } else {
                String s = ((DefaultMutableTreeNode)value).getUserObject().toString();
                this.setText(s);
                this.setIcon(null);
                this.setToolTipText(s);
            }
            return this;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int selRow = MdxFunctionTree.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = MdxFunctionTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject() instanceof MdxFunction) {
                    MdxFunction mdxf = (MdxFunction)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
                    if (MdxFunctionTree.this.parent != null && MdxFunctionTree.this.parent instanceof MdxEditor) {
                        ((MdxEditor)MdxFunctionTree.this.parent).addTextToCurrentPosition(mdxf.getSyntax());
                    }
                } else if (selRow != -1 && selPath.getLastPathComponent() == MdxFunctionTree.this.tree.getModel().getRoot()) {
                    MdxFunctionTree.this.toggleTree();
                }
            }
        }
    }
}

