/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx;

import com.jaspersoft.ireport.designer.GenericInspectorTopComponent;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.jrctx.JRCTXDataObject;
import com.jaspersoft.ireport.designer.jrctx.JRCTXEditorSupport;
import com.jaspersoft.ireport.designer.jrctx.JRCTXExtensionsRegistryFactory;
import com.jaspersoft.ireport.designer.jrctx.JRCTXPreviewToolbar;
import com.jaspersoft.ireport.designer.jrctx.nodes.ChartThemeNode;
import com.jaspersoft.ireport.designer.undo.UndoRedoManager;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartTheme;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerPanel;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JRCTXVisualView
extends TopComponent
implements DocumentListener,
MultiViewDescription,
MultiViewElement,
Runnable,
ExplorerManager.Provider {
    private ChartThemeSettings template = null;
    private AbstractNode noTemplateNode = null;
    private static String[] chartTypeReportFiles = new String[]{"com/jaspersoft/ireport/designer/jrctx/resources/AreaChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/Bar3DChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/BarChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/BubbleChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/HighLowChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/LineChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/MeterChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/Pie3DChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/PieChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/ScatterChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/StackedAreaChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/StackedBar3DChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/StackedBarChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/TimeSeriesChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/XyAreaChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/XyBarChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/XyBarTimePeriodChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/XyBarTimeSeriesChartReport.jasper", "com/jaspersoft/ireport/designer/jrctx/resources/XyLineChartReport.jasper"};
    private static JasperReport[] chartTypeReports = new JasperReport[chartTypeReportFiles.length];
    private int reportIndex = 0;
    private JRViewerPanel previewPanel = null;
    private JRViewerController viewerContext = new JRViewerController(null, null);
    private JRCTXPreviewToolbar viewerToolbar = new JRCTXPreviewToolbar(this, this.viewerContext);
    private static Boolean groupVisible;
    private transient ExplorerManager explorerManager;
    private JRCTXEditorSupport support;
    private boolean elementInitialized = false;
    private boolean needModelRefresh = true;
    MultiViewElementCallback callback = null;
    InstanceContent ic;
    AbstractLookup abstractLookup;
    private ProxyLookup lookup = null;
    private static JRCTXVisualView instance;
    static final String ICON_PATH = "com/jaspersoft/ireport/designer/resources/jasperreports_jrctx.png";
    private static final String PREFERRED_ID = "JRCTXVisualEditorTopComponent";
    private ChartThemeNode model = null;
    boolean loading = false;
    private UndoRedoManager undoRedoManager = null;

    public JRCTXVisualView(JRCTXEditorSupport ed) {
        this.support = ed;
    }

    public void setReportIndex(int index) {
        this.reportIndex = index;
    }

    public void modelChanged() {
        Mutex.EVENT.readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (JRCTXVisualView.this.getModel() == null) {
                    return;
                }
                JRCTXExtensionsRegistryFactory.setChartThemeSettings(JRCTXVisualView.this.getModel().getTemplate());
                try {
                    JRCTXVisualView.this.viewerContext.loadReport(new ReportConverter((JRReport)chartTypeReports[JRCTXVisualView.this.reportIndex], false, true).getJasperPrint());
                    JRCTXVisualView.this.viewerContext.refreshPage();
                    JRCTXVisualView.this.updateUI();
                }
                finally {
                    JRCTXExtensionsRegistryFactory.setChartThemeSettings(null);
                }
            }
        });
    }

    public int getPersistenceType() {
        return 2;
    }

    public String getDisplayName() {
        return I18n.getString("view.designer");
    }

    public ChartThemeNode getModel() {
        return this.model;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public Image getIcon() {
        Node nd = ((JRCTXDataObject)this.support.getDataObject()).getNodeDelegate();
        return nd.getIcon(1);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public MultiViewElement createElement() {
        if (!this.elementInitialized) {
            this.noTemplateNode = new AbstractNode(Children.LEAF);
            this.noTemplateNode.setDisplayName("Template not available");
            try {
                assert (EventQueue.isDispatchThread());
                this.elementInitialized = true;
                this.ic = new InstanceContent();
                this.explorerManager = new ExplorerManager();
                ActionMap map = this.getActionMap();
                map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
                map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
                map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
                map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
                this.abstractLookup = new AbstractLookup((AbstractLookup.Content)this.ic);
                this.lookup = new ProxyLookup(new Lookup[]{this.abstractLookup, ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map), this.support.getDataObject().getLookup()});
                this.associateLookup((Lookup)this.lookup);
                this.removeAll();
                this.support.openDocument().addDocumentListener(this);
                this.initComponents();
                this.setName(NbBundle.getMessage(JRCTXVisualView.class, (String)"CTL_JRCTXVisualEditorTopComponent"));
                this.setToolTipText(NbBundle.getMessage(JRCTXVisualView.class, (String)"HINT_JRCTXVisualEditorTopComponent"));
                this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
                this.previewPanel = new JRViewerPanel(this.viewerContext);
                this.add((Component)this.previewPanel, "Center");
                this.viewerToolbar.init();
                this.getExplorerManager().setRootContext((Node)this.noTemplateNode);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setNeedModelRefresh(true);
    }

    public synchronized void setNeedModelRefresh(boolean b) {
        this.needModelRefresh = b;
    }

    public boolean isNeedModelRefresh() {
        return this.needModelRefresh;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public JComponent getToolbarRepresentation() {
        return new JRCTXPreviewToolbar(this, this.viewerContext);
    }

    public void componentOpened() {
        this.setNeedModelRefresh(false);
        this.refreshModel();
    }

    public void componentClosed() {
        this.syncSatelliteViews(false);
    }

    public void componentShowing() {
        if (this.isNeedModelRefresh()) {
            this.refreshModel();
        } else {
            this.support.setCurrentModel(this.template);
            this.syncSatelliteViews();
        }
    }

    public JRCTXEditorSupport getEditorSupport() {
        return this.support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModel() {
        try {
            this.model = null;
            RequestProcessor.getDefault().post((Runnable)this);
        }
        finally {
            this.setNeedModelRefresh(false);
        }
    }

    public void updateName() {
        Runnable run = new Runnable(){

            public void run() {
                MultiViewElementCallback c = JRCTXVisualView.this.callback;
                if (c == null) {
                    return;
                }
                TopComponent tc = c.getTopComponent();
                if (tc == null) {
                    return;
                }
                Node nd = ((JRCTXDataObject)JRCTXVisualView.this.support.getDataObject()).getNodeDelegate();
                tc.setName(nd.getName());
                tc.setDisplayName(nd.getDisplayName());
                tc.setHtmlDisplayName(nd.getHtmlDisplayName());
                tc.setToolTipText(nd.getShortDescription());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo getUndoRedo() {
        return this.getUndoRedoManager();
    }

    public Lookup getLookup() {
        return super.getLookup();
    }

    public UndoRedo.Manager getUndoRedoManager() {
        if (this.undoRedoManager == null) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(300);
        }
        return this.undoRedoManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.loading = true;
        try {
            this.support.setCurrentModel(null);
            Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
            this.template = XmlChartTheme.loadSettings((InputStream)this.support.getInputStream());
            if (this.template != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JRCTXVisualView.this.model = new ChartThemeNode(JRCTXVisualView.this.template, JRCTXVisualView.this.support.getSpecialNodeLookup());
                        System.out.println("Model: " + (Object)((Object)JRCTXVisualView.this.model));
                        System.out.flush();
                        JRCTXVisualView.this.getUndoRedoManager().discardAllEdits();
                        JRCTXVisualView.this.explorerManager.setRootContext((Node)JRCTXVisualView.this.model);
                        JRCTXVisualView.this.support.setCurrentModel(JRCTXVisualView.this.template);
                        try {
                            JRCTXVisualView.this.explorerManager.setSelectedNodes(new Node[]{JRCTXVisualView.this.model});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            this.noTemplateNode.setDisplayName("Loading error: " + ex.getMessage());
            this.getExplorerManager().setRootContext((Node)this.noTemplateNode);
            this.model = null;
            ex.printStackTrace();
        }
        finally {
            this.modelChanged();
            this.syncSatelliteViews();
            this.loading = false;
        }
    }

    protected void syncSatelliteViews() {
        this.syncSatelliteViews(true);
    }

    protected void syncSatelliteViews(final boolean b) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                if (b) {
                    GenericInspectorTopComponent.getDefault().setCurrentVisualView(JRCTXVisualView.this);
                } else {
                    GenericInspectorTopComponent.getDefault().closingVisualView(JRCTXVisualView.this);
                }
            }
        });
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
        this.updateName();
    }

    public void requestActive() {
        if (this.callback != null) {
            this.callback.requestActive();
        } else {
            super.requestActive();
        }
    }

    public void componentActivated() {
        this.syncSatelliteViews();
        this.updateGroupVisibility();
    }

    public void componentDeactivated() {
        this.updateGroupVisibility();
    }

    public void componentHidden() {
        this.syncSatelliteViews(false);
    }

    public CloseOperationState canCloseElement() {
        if (this.getEditorSupport().isModified()) {
            return MultiViewFactory.createUnsafeCloseState((String)PREFERRED_ID, null, null);
        }
        return CloseOperationState.STATE_OK;
    }

    private void updateGroupVisibility() {
        WindowManager wm = WindowManager.getDefault();
        TopComponentGroup group = wm.findTopComponentGroup("ireport_jrctx");
        if (group == null) {
            return;
        }
        boolean isVisualViewSelected = false;
        for (Mode mode : wm.getModes()) {
            String id;
            MultiViewPerspective mvp;
            MultiViewHandler mvh;
            TopComponent selected = mode.getSelectedTopComponent();
            if (selected == null || (mvh = MultiViews.findMultiViewHandler((TopComponent)selected)) == null || (mvp = mvh.getSelectedPerspective()) == null || !PREFERRED_ID.equals(id = mvp.preferredID())) continue;
            isVisualViewSelected = true;
            break;
        }
        if (isVisualViewSelected && !Boolean.TRUE.equals(groupVisible)) {
            group.open();
        } else if (!isVisualViewSelected && !Boolean.FALSE.equals(groupVisible)) {
            group.close();
        }
        groupVisible = isVisualViewSelected ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        try {
            for (int i = 0; i < chartTypeReportFiles.length; ++i) {
                JRCTXVisualView.chartTypeReports[i] = (JasperReport)JRLoader.loadObjectFromLocation((String)chartTypeReportFiles[i]);
                chartTypeReports[i].setProperty("net.sf.jasperreports.chart.theme", "ireport.preview.chart.theme");
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
        groupVisible = null;
    }
}

