/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.palette.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.palette.PaletteItemAction;
import com.jaspersoft.ireport.designer.undo.AddElementUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Point;
import java.awt.dnd.DropTargetDropEvent;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.util.Mutex;

public abstract class CreateReportElementsAction
extends PaletteItemAction {
    private static JRDesignFrame findTopMostFrameAt(ReportObjectScene theScene, Point p) {
        LayerWidget layer = theScene.getElementsLayer();
        List widgets = layer.getChildren();
        for (int i = widgets.size() - 1; i >= 0; --i) {
            JRDesignElement de;
            Point p2;
            Widget w = (Widget)widgets.get(i);
            if (!w.isHitAt(p2 = w.convertSceneToLocal(p)) || !(w instanceof JRDesignElementWidget) || !((de = ((JRDesignElementWidget)w).getElement()) instanceof JRDesignFrame)) continue;
            return (JRDesignFrame)de;
        }
        return null;
    }

    public void drop(DropTargetDropEvent dtde) {
        JRDesignElement[] elements = this.createReportElements(this.getJasperDesign());
        if (elements == null || elements.length == 0) {
            return;
        }
        this.dropElementsAt(this.getScene(), this.getJasperDesign(), elements, dtde.getLocation());
    }

    public abstract JRDesignElement[] createReportElements(JasperDesign var1);

    public void adjustElement(JRDesignElement[] elements, int index, Scene theScene, JasperDesign jasperDesign, Object parent, Point dropLocation) {
    }

    public void dropElementsAt(Scene theScene, JasperDesign jasperDesign, JRDesignElement[] elements, Point location) {
        block8: {
            block7: {
                if (!(theScene instanceof ReportObjectScene)) break block7;
                Point p = theScene.convertViewToScene(location);
                JRDesignBand b = ModelUtils.getBandAt(jasperDesign, p);
                int yLocation = ModelUtils.getBandLocation((JRBand)b, jasperDesign);
                Point pLocationInBand = new Point(p.x - jasperDesign.getLeftMargin(), p.y - yLocation);
                if (b == null) break block8;
                JRDesignFrame frame = CreateReportElementsAction.findTopMostFrameAt((ReportObjectScene)theScene, p);
                for (int k = 0; k < elements.length; ++k) {
                    JRDesignElement element = elements[k];
                    if (frame != null) {
                        Point parentLocation = ModelUtils.getParentLocation(jasperDesign, element);
                        element.setX(p.x - parentLocation.x);
                        element.setY(p.y - parentLocation.y);
                        this.adjustElement(elements, k, theScene, jasperDesign, frame, location);
                        frame.addElement((JRElement)element);
                    } else {
                        element.setX(pLocationInBand.x);
                        element.setY(pLocationInBand.y);
                        this.adjustElement(elements, k, theScene, jasperDesign, b, location);
                        b.addElement(element);
                    }
                    AddElementUndoableEdit edit = new AddElementUndoableEdit(element, b);
                    IReportManager.getInstance().addUndoableEdit(edit);
                }
                break block8;
            }
            if (theScene instanceof CrosstabObjectScene) {
                Point p = theScene.convertViewToScene(location);
                for (int k = 0; k < elements.length; ++k) {
                    JRDesignElement element = elements[k];
                    if (element instanceof JRCrosstab || element instanceof JRChart || element instanceof JRBreak || element instanceof JRSubreport) {
                        Runnable r = new Runnable(){

                            public void run() {
                                JOptionPane.showMessageDialog(Misc.getMainFrame(), "You can use this kind of element inside a crosstab.", "Error", 2);
                            }
                        };
                        Mutex.EVENT.readAccess(r);
                        return;
                    }
                    JRDesignCrosstab crosstab = ((CrosstabObjectScene)theScene).getDesignCrosstab();
                    JRDesignCellContents cell = ModelUtils.getCellAt(crosstab, p, true);
                    if (cell == null) continue;
                    Point base = ModelUtils.getCellLocation(crosstab, cell);
                    element.setX(p.x - base.x);
                    element.setY(p.y - base.y);
                    String styleName = "Crosstab Data Text";
                    if (jasperDesign.getStylesMap().containsKey(styleName)) {
                        element.setStyle((JRStyle)jasperDesign.getStylesMap().get(styleName));
                    }
                    this.adjustElement(elements, k, theScene, jasperDesign, cell, location);
                    cell.addElement(element);
                    AddElementUndoableEdit edit = new AddElementUndoableEdit(element, cell);
                    IReportManager.getInstance().addUndoableEdit(edit);
                }
            }
        }
    }
}

