/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.StringListProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.WeakListeners;

public abstract class AbstractStyleProperty
extends StringListProperty
implements PropertyChangeListener {
    private final JasperDesign jasperDesign;

    public AbstractStyleProperty(Object object, JasperDesign jasperDesign) {
        super(object);
        this.jasperDesign = jasperDesign;
        jasperDesign.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jasperDesign.getEventSupport()));
    }

    public String getName() {
        return "parentStyleNameReference";
    }

    public String getDisplayName() {
        return I18n.getString("Global.Property.Style");
    }

    public String getShortDescription() {
        return I18n.getString("Global.Property.Styledetail");
    }

    public List getTagList() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(null, ""));
        List styles = this.jasperDesign.getStylesList();
        for (int i = 0; i < styles.size(); ++i) {
            JRDesignStyle style = (JRDesignStyle)styles.get(i);
            tags.add(new Tag(style, style.getName()));
            style.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)style.getEventSupport()));
        }
        return tags;
    }

    public Object getPropertyValue() {
        if (this.getStyle() == null) {
            return this.getStyleNameReference();
        }
        return this.getStyle();
    }

    public Object getOwnPropertyValue() {
        return this.getPropertyValue();
    }

    public void setPropertyValue(Object value) {
        if (value instanceof JRStyle) {
            this.setStyle((JRStyle)value);
            this.setStyleNameReference(null);
        } else {
            String styleNameReference = (String)value;
            if (styleNameReference != null && styleNameReference.trim().length() == 0) {
                styleNameReference = null;
            }
            this.setStyleNameReference(styleNameReference);
            this.setStyle(null);
        }
    }

    public String getString() {
        return null;
    }

    public String getOwnString() {
        return null;
    }

    public String getDefaultString() {
        return null;
    }

    public void setString(String str) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.editor == null) {
            return;
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("styles") || evt.getPropertyName().equals("name")) {
            this.editor.setTagValues(this.getTagList());
        }
    }

    public abstract String getStyleNameReference();

    public abstract void setStyleNameReference(String var1);

    public abstract JRStyle getStyle();

    public abstract void setStyle(JRStyle var1);
}

