/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellRequest {
    private final RolapStar.Measure measure;
    public final boolean extendedContext;
    public final boolean drillThrough;
    private final List constrainedColumnList = new ArrayList();
    private List<StarColumnPredicate> valueList = new ArrayList<StarColumnPredicate>();
    private RolapStar.Column[] columnsCache = null;
    private final BitKey constrainedColumnsBitKey;
    private boolean unsatisfiable;
    private boolean isDirty = true;

    public CellRequest(RolapStar.Measure measure, boolean extendedContext, boolean drillThrough) {
        this.measure = measure;
        this.extendedContext = extendedContext;
        this.drillThrough = drillThrough;
        this.constrainedColumnList.add(measure.getStar());
        this.constrainedColumnsBitKey = BitKey.Factory.makeBitKey(measure.getStar().getColumnCount());
    }

    public void addConstrainedColumn(RolapStar.Column column, StarColumnPredicate predicate) {
        assert (this.columnsCache == null);
        int bitPosition = column.getBitPosition();
        if (this.constrainedColumnsBitKey.get(bitPosition)) {
            int index = this.constrainedColumnList.indexOf(column);
            Util.assertTrue(index >= 0);
            StarColumnPredicate prevValue = this.valueList.get(--index);
            if (prevValue != null) {
                if (predicate == null) {
                    return;
                }
                if (predicate.equalConstraint(prevValue)) {
                    return;
                }
                predicate = null;
                this.unsatisfiable = true;
            }
            this.valueList.set(index, predicate);
        } else {
            this.constrainedColumnList.add(column);
            this.constrainedColumnsBitKey.set(bitPosition);
            this.valueList.add(predicate);
        }
    }

    public RolapStar.Measure getMeasure() {
        return this.measure;
    }

    public RolapStar.Column[] getConstrainedColumns() {
        if (this.columnsCache == null) {
            this.check();
        }
        return this.columnsCache;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    private void check() {
        if (this.isDirty) {
            int size = this.constrainedColumnList.size();
            this.columnsCache = new RolapStar.Column[size - 1];
            ArrayList<StarColumnPredicate> vl = new ArrayList<StarColumnPredicate>();
            int cnt = 0;
            block0: for (int bitPos : this.constrainedColumnsBitKey) {
                for (int j = 1; j < size; ++j) {
                    RolapStar.Column rc = (RolapStar.Column)this.constrainedColumnList.get(j);
                    if (rc.getBitPosition() != bitPos) continue;
                    int index = this.constrainedColumnList.indexOf(rc) - 1;
                    StarColumnPredicate value = this.valueList.get(index);
                    vl.add(value);
                    this.columnsCache[cnt++] = rc;
                    continue block0;
                }
            }
            this.valueList = vl;
            this.isDirty = false;
        }
    }

    public List<StarColumnPredicate> getValueList() {
        this.check();
        return this.valueList;
    }

    public Object[] getSingleValues() {
        this.check();
        Object[] a = new Object[this.valueList.size()];
        int n = this.valueList.size();
        for (int i = 0; i < n; ++i) {
            ValueColumnPredicate constr = (ValueColumnPredicate)this.valueList.get(i);
            a[i] = constr.getValue();
        }
        return a;
    }

    public boolean isUnsatisfiable() {
        return this.unsatisfiable;
    }
}

