/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class MondrianFoodMartLoader {
    private static final Logger LOGGER = Logger.getLogger(MondrianFoodMartLoader.class);
    private static final String nl = Util.nl;
    final Pattern decimalDataTypeRegex = Pattern.compile("DECIMAL\\((.*),(.*)\\)");
    final DecimalFormat integerFormatter = new DecimalFormat(MondrianFoodMartLoader.decimalFormat(15, 0));
    final String dateFormatString = "yyyy-MM-dd";
    final String oracleDateFormatString = "YYYY-MM-DD";
    final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private String jdbcDrivers;
    private String jdbcURL;
    private String userName;
    private String password;
    private String inputJdbcURL;
    private String inputUserName;
    private String inputPassword;
    private String inputFile;
    private String outputDirectory;
    private boolean tables = false;
    private boolean indexes = false;
    private boolean data = false;
    private boolean jdbcInput = false;
    private boolean jdbcOutput = false;
    private boolean populationQueries = false;
    private boolean generateUniqueConstraints = false;
    private int inputBatchSize = -1;
    private Connection connection;
    private Connection inputConnection;
    private FileWriter fileOutput = null;
    private final Map<String, Column[]> tableMetadataToLoad = new HashMap<String, Column[]>();
    private final Map<String, Column[]> aggregateTableMetadataToLoad = new HashMap<String, Column[]>();
    private final Map<String, List<UniqueConstraint>> tableConstraints = new HashMap<String, List<UniqueConstraint>>();
    private SqlQuery.Dialect dialect;

    public MondrianFoodMartLoader(String[] args) {
        if (args.length == 0) {
            this.usage();
            return;
        }
        StringBuilder errorMessage = new StringBuilder();
        StringBuilder parametersMessage = new StringBuilder();
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)new PatternLayout("%m%n"), "System.out");
        consoleAppender.setThreshold((Priority)Level.ERROR);
        LOGGER.addAppender((Appender)consoleAppender);
        for (String arg : args) {
            if (arg.equals("-verbose")) {
                consoleAppender.setThreshold((Priority)Level.DEBUG);
                if (!LOGGER.isDebugEnabled()) {
                    LOGGER.setLevel(Level.DEBUG);
                }
            } else if (arg.equals("-tables")) {
                this.tables = true;
            } else if (arg.equals("-data")) {
                this.data = true;
            } else if (arg.equals("-indexes")) {
                this.indexes = true;
            } else if (arg.equals("-populationQueries")) {
                this.populationQueries = true;
            } else if (arg.startsWith("-jdbcDrivers=")) {
                this.jdbcDrivers = arg.substring("-jdbcDrivers=".length());
            } else if (arg.startsWith("-outputJdbcURL=")) {
                this.jdbcURL = arg.substring("-outputJdbcURL=".length());
            } else if (arg.startsWith("-outputJdbcUser=")) {
                this.userName = arg.substring("-outputJdbcUser=".length());
            } else if (arg.startsWith("-outputJdbcPassword=")) {
                this.password = arg.substring("-outputJdbcPassword=".length());
            } else if (arg.startsWith("-inputJdbcURL=")) {
                this.inputJdbcURL = arg.substring("-inputJdbcURL=".length());
            } else if (arg.startsWith("-inputJdbcUser=")) {
                this.inputUserName = arg.substring("-inputJdbcUser=".length());
            } else if (arg.startsWith("-inputJdbcPassword=")) {
                this.inputPassword = arg.substring("-inputJdbcPassword=".length());
            } else if (arg.startsWith("-inputFile=")) {
                this.inputFile = arg.substring("-inputFile=".length());
            } else if (arg.startsWith("-outputDirectory=")) {
                this.outputDirectory = arg.substring("-outputDirectory=".length());
            } else if (arg.startsWith("-outputJdbcBatchSize=")) {
                this.inputBatchSize = Integer.parseInt(arg.substring("-outputJdbcBatchSize=".length()));
            } else {
                errorMessage.append("unknown arg: ").append(arg).append(nl);
            }
            if (!LOGGER.isInfoEnabled()) continue;
            parametersMessage.append("\t").append(arg).append(nl);
        }
        if (this.inputJdbcURL != null) {
            this.jdbcInput = true;
            if (this.inputFile != null) {
                errorMessage.append("Specified both an input JDBC connection and an input file");
            }
        }
        if (this.jdbcURL != null && this.outputDirectory == null) {
            this.jdbcOutput = true;
        }
        if (errorMessage.length() > 0) {
            this.usage();
            throw MondrianResource.instance().MissingArg.ex(errorMessage.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Parameters: " + nl + parametersMessage.toString()));
        }
    }

    public void usage() {
        System.out.println("Usage: MondrianFoodMartLoader [-verbose] [-tables] [-data] [-indexes] [-populationQueries]-jdbcDrivers=<jdbcDriver> -outputJdbcURL=<jdbcURL> [-outputJdbcUser=user] [-outputJdbcPassword=password] [-outputJdbcBatchSize=<batch size>] | [-outputDirectory=<directory name>] [   [-inputJdbcURL=<jdbcURL> [-inputJdbcUser=user] [-inputJdbcPassword=password]]   |    [-inputfile=<file name>]]");
        System.out.println("");
        System.out.println("  <jdbcURL>             JDBC connect string for DB.");
        System.out.println("  [user]                JDBC user name for DB.");
        System.out.println("  [password]            JDBC password for user for DB.");
        System.out.println("                        If no source DB parameters are given, assumes data comes from file.");
        System.out.println("  [file name]           File containing test data - INSERT statements in MySQL format.");
        System.out.println("                        If no input file name or input JDBC parameters are given,");
        System.out.println("                        assume insert statements come from demo/FoodMartCreateData.zip file");
        System.out.println("  [outputDirectory]     Where FoodMartCreateTables.sql, FoodMartCreateData.sql");
        System.out.println("                        and FoodMartCreateIndexes.sql will be created.");
        System.out.println("  <batch size>          Size of JDBC batch updates - default to 50 inserts.");
        System.out.println("  <jdbcDrivers>         Comma-separated list of JDBC drivers;");
        System.out.println("                        they must be on the classpath.");
        System.out.println("  -verbose              Verbose mode.");
        System.out.println("  -tables               If specified, drop and create the tables.");
        System.out.println("  -data                 If specified, load the data.");
        System.out.println("  -indexes              If specified, drop and create the tables.");
        System.out.println("  -populationQueries    If specified, run the data loading queries. Runs by default if -data is specified.");
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        LOGGER.warn((Object)("Starting load at: " + new Date()));
        try {
            new MondrianFoodMartLoader(args).load();
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Main error", e);
        }
        LOGGER.warn((Object)("Finished load at: " + new Date()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws Exception {
        RolapUtil.loadDrivers(this.jdbcDrivers);
        this.connection = this.userName == null ? DriverManager.getConnection(this.jdbcURL) : DriverManager.getConnection(this.jdbcURL, this.userName, this.password);
        if (this.jdbcInput) {
            this.inputConnection = this.inputUserName == null ? DriverManager.getConnection(this.inputJdbcURL) : DriverManager.getConnection(this.inputJdbcURL, this.inputUserName, this.inputPassword);
        }
        DatabaseMetaData metaData = this.connection.getMetaData();
        String productName = metaData.getDatabaseProductName();
        String version = metaData.getDatabaseProductVersion();
        LOGGER.info((Object)("Output connection is " + productName + ", " + version));
        this.dialect = SqlQuery.Dialect.create(metaData);
        if (this.inputBatchSize == -1) {
            this.inputBatchSize = this.dialect.isLucidDB() ? 1000 : 50;
        }
        if (this.dialect.isLucidDB()) {
            this.generateUniqueConstraints = true;
        }
        try {
            if (this.generateUniqueConstraints) {
                this.createIndexes(false, false);
            }
            this.createTables();
            if (this.data) {
                if (!this.populationQueries) {
                    if (this.jdbcInput) {
                        this.loadDataFromJdbcInput();
                    } else {
                        this.loadDataFromFile();
                    }
                }
                if (this.indexes) {
                    this.createIndexes(true, false);
                }
                this.loadFromSQLInserts();
            }
            if (this.indexes) {
                this.createIndexes(false, true);
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            if (this.inputConnection != null) {
                this.inputConnection.close();
                this.inputConnection = null;
            }
            if (this.fileOutput != null) {
                this.fileOutput.close();
                this.fileOutput = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataFromFile() throws Exception {
        InputStream is = this.openInputStream();
        if (is == null) {
            throw new Exception("No data file to process");
        }
        try {
            String line;
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader bufferedReader = new BufferedReader(reader);
            Pattern mySQLRegex = Pattern.compile("INSERT INTO `([^ ]+)` \\((.*)\\) VALUES\\((.*)\\);");
            Pattern doubleQuoteRegex = Pattern.compile("INSERT INTO \"([^ ]+)\" \\((.*)\\) VALUES\\((.*)\\);");
            int lineNumber = 0;
            int tableRowCount = 0;
            String prevTable = "";
            String quotedTableName = null;
            String quotedColumnNames = null;
            Column[] orderedColumns = null;
            String[] batch = new String[this.inputBatchSize];
            int batchSize = 0;
            Pattern regex = null;
            String quoteChar = null;
            while ((line = bufferedReader.readLine()) != null) {
                Matcher matcher;
                ++lineNumber;
                if (line.startsWith("#")) continue;
                if (regex == null) {
                    Matcher m1 = mySQLRegex.matcher(line);
                    if (m1.matches()) {
                        regex = mySQLRegex;
                        quoteChar = "`";
                    } else {
                        regex = doubleQuoteRegex;
                        quoteChar = "\"";
                    }
                }
                if (!(matcher = regex.matcher(line)).matches()) {
                    throw MondrianResource.instance().InvalidInsertLine.ex(lineNumber, line);
                }
                String tableName = matcher.group(1);
                String columnNames = matcher.group(2);
                String values = matcher.group(3);
                if (!tableName.equals(prevTable)) {
                    if (!prevTable.equals("")) {
                        LOGGER.info((Object)("Table " + prevTable + ": loaded " + tableRowCount + " rows."));
                    }
                    tableRowCount = 0;
                    this.writeBatch(batch, batchSize);
                    batchSize = 0;
                    prevTable = tableName;
                    quotedTableName = this.quoteId(tableName);
                    quotedColumnNames = columnNames.replaceAll(quoteChar, this.dialect.getQuoteIdentifierString());
                    String[] splitColumnNames = columnNames.replaceAll(quoteChar, "").replaceAll(" ", "").split(",");
                    Column[] columns = this.tableMetadataToLoad.get(tableName);
                    orderedColumns = new Column[columns.length];
                    for (int i = 0; i < splitColumnNames.length; ++i) {
                        Column thisColumn = null;
                        for (int j = 0; j < columns.length && thisColumn == null; ++j) {
                            if (!columns[j].name.equalsIgnoreCase(splitColumnNames[i])) continue;
                            thisColumn = columns[j];
                        }
                        if (thisColumn == null) {
                            throw new Exception("Unknown column in INSERT statement from file: " + splitColumnNames[i]);
                        }
                        orderedColumns[i] = thisColumn;
                    }
                }
                StringBuilder massagedLine = new StringBuilder();
                massagedLine.append("INSERT INTO ").append(quotedTableName).append(" (").append(quotedColumnNames).append(" ) VALUES(").append(this.getMassagedValues(orderedColumns, values)).append(" )");
                line = massagedLine.toString();
                ++tableRowCount;
                batch[batchSize++] = line;
                if (batchSize < this.inputBatchSize) continue;
                this.writeBatch(batch, batchSize);
                batchSize = 0;
            }
            if (!prevTable.equals("")) {
                LOGGER.info((Object)("Table " + prevTable + ": loaded " + tableRowCount + " rows."));
                tableRowCount = 0;
                this.writeBatch(batch, batchSize);
                batchSize = 0;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private String getMassagedValues(Column[] columns, String values) throws Exception {
        StringBuilder buf = new StringBuilder();
        String[] individualValues = new String[columns.length];
        String[] splitValues = values.split(",");
        if (splitValues.length == columns.length) {
            individualValues = splitValues;
        } else {
            int valuesPos = 0;
            boolean inQuote = false;
            for (int i = 0; i < splitValues.length; ++i) {
                if (i == 0) {
                    individualValues[valuesPos] = splitValues[i];
                    inQuote = this.inQuote(splitValues[i], inQuote);
                    continue;
                }
                if (inQuote) {
                    individualValues[valuesPos] = individualValues[valuesPos] + "," + splitValues[i];
                    inQuote = this.inQuote(splitValues[i], inQuote);
                    continue;
                }
                individualValues[++valuesPos] = splitValues[i];
                inQuote = this.inQuote(splitValues[i], inQuote);
            }
            assert (valuesPos + 1 == columns.length);
        }
        for (int i = 0; i < columns.length; ++i) {
            String value;
            if (i > 0) {
                buf.append(",");
            }
            if ((value = individualValues[i]) != null && value.trim().equals("NULL")) {
                value = null;
            }
            buf.append(this.columnValue(value, columns[i]));
        }
        return buf.toString();
    }

    private boolean inQuote(String str, boolean nowInQuote) {
        if (str.indexOf(39) == -1) {
            return nowInQuote;
        }
        int lastPos = 0;
        while (lastPos <= str.length() && str.indexOf(39, lastPos) != -1) {
            int pos = str.indexOf(39, lastPos);
            nowInQuote = !nowInQuote;
            lastPos = pos + 1;
        }
        return nowInQuote;
    }

    private void loadDataFromJdbcInput() throws Exception {
        if (this.outputDirectory != null) {
            this.fileOutput = new FileWriter(new File(this.outputDirectory, "createData.sql"));
        }
        for (Map.Entry<String, Column[]> tableEntry : this.tableMetadataToLoad.entrySet()) {
            int rowsAdded = this.loadTable(tableEntry.getKey(), tableEntry.getValue());
            LOGGER.info((Object)("Table " + tableEntry.getKey() + ": loaded " + rowsAdded + " rows."));
        }
        if (this.outputDirectory != null) {
            this.fileOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSQLInserts() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("insert.sql");
        try {
            String line;
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader bufferedReader = new BufferedReader(reader);
            int lineNumber = 0;
            Util.discard((int)lineNumber);
            StringBuilder buf = new StringBuilder();
            String fromQuoteChar = null;
            String toQuoteChar = this.dialect.isMySQL() ? "`" : (this.dialect.isDB2() ? "" : "\"");
            while ((line = bufferedReader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                if (fromQuoteChar == null) {
                    if (line.indexOf(96) >= 0) {
                        fromQuoteChar = "`";
                    } else if (line.indexOf(34) >= 0) {
                        fromQuoteChar = "\"";
                    }
                }
                if (fromQuoteChar != null && !fromQuoteChar.equals(toQuoteChar)) {
                    line = line.replaceAll(fromQuoteChar, toQuoteChar);
                }
                if (line.charAt(line.length() - 1) == ';') {
                    buf.append(" ").append(line.substring(0, line.length() - 1));
                    this.executeDDL(buf.toString());
                    buf.setLength(0);
                    continue;
                }
                buf.append(" ").append(line.substring(0, line.length()));
            }
            if (buf.length() > 0) {
                this.executeDDL(buf.toString());
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private int loadTable(String name, Column[] columns) throws Exception {
        int rowsAdded = 0;
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.quoteId(this.dialect, column.name));
        }
        buf.append(" from ").append(this.quoteId(this.dialect, name));
        String ddl = buf.toString();
        Statement statement = this.inputConnection.createStatement();
        LOGGER.debug((Object)("Input table SQL: " + ddl));
        ResultSet rs = statement.executeQuery(ddl);
        String[] batch = new String[this.inputBatchSize];
        int batchSize = 0;
        boolean displayedInsert = false;
        while (rs.next()) {
            String insertStatement = this.createInsertStatement(rs, name, columns);
            if (!displayedInsert && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Example Insert statement: " + insertStatement));
                displayedInsert = true;
            }
            batch[batchSize++] = insertStatement;
            if (batchSize < this.inputBatchSize) continue;
            rowsAdded += this.writeBatch(batch, batchSize);
            batchSize = 0;
        }
        if (batchSize > 0) {
            rowsAdded += this.writeBatch(batch, batchSize);
        }
        return rowsAdded;
    }

    private String createInsertStatement(ResultSet rs, String name, Column[] columns) throws Exception {
        Column column;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("INSERT INTO ").append(this.quoteId(name)).append(" ( ");
        for (i = 0; i < columns.length; ++i) {
            column = columns[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.quoteId(column.name));
        }
        buf.append(" ) VALUES(");
        for (i = 0; i < columns.length; ++i) {
            column = columns[i];
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.columnValue(rs, column));
        }
        buf.append(" )");
        return buf.toString();
    }

    private int writeBatch(String[] batch, int batchSize) throws IOException, SQLException {
        if (batchSize == 0) {
            return batchSize;
        }
        if (this.outputDirectory != null) {
            for (int i = 0; i < batchSize; ++i) {
                this.fileOutput.write(batch[i]);
                this.fileOutput.write(";" + nl);
            }
        } else {
            boolean useTxn = this.connection.getMetaData().supportsTransactions();
            if (useTxn) {
                this.connection.setAutoCommit(false);
            }
            if (this.dialect.isLucidDB()) {
                String VALUES_TOKEN = "VALUES";
                StringBuilder sb = new StringBuilder(batch[0]);
                for (int i = 1; i < batchSize; ++i) {
                    sb.append(",\n");
                    int valuesPos = batch[i].indexOf(VALUES_TOKEN);
                    if (valuesPos < 0) {
                        throw new RuntimeException("Malformed INSERT:  " + batch[i]);
                    }
                    sb.append(batch[i].substring(valuesPos += VALUES_TOKEN.length()));
                }
                batch[0] = sb.toString();
                batchSize = 1;
            }
            Statement stmt = this.connection.createStatement();
            if (batchSize == 1) {
                stmt.execute(batch[0]);
            } else {
                int i;
                int[] updateCounts;
                for (int i2 = 0; i2 < batchSize; ++i2) {
                    stmt.addBatch(batch[i2]);
                }
                try {
                    updateCounts = stmt.executeBatch();
                }
                catch (SQLException e) {
                    for (i = 0; i < batchSize; ++i) {
                        LOGGER.error((Object)("Error in SQL batch: " + batch[i]));
                    }
                    throw e;
                }
                int updates = 0;
                for (i = 0; i < updateCounts.length; ++i) {
                    if (updateCounts[i] == 0) {
                        LOGGER.error((Object)("Error in SQL: " + batch[i]));
                    }
                    updates += updateCounts[i];
                }
                if (updates < batchSize) {
                    throw new RuntimeException("Failed to execute batch: " + batchSize + " versus " + updates);
                }
            }
            stmt.close();
            if (useTxn) {
                this.connection.setAutoCommit(true);
            }
        }
        return batchSize;
    }

    private InputStream openInputStream() throws Exception {
        File file;
        String defaultZipFileName = "FoodMartCreateData.zip";
        String defaultDataFileName = "FoodMartCreateData.sql";
        File file2 = file = this.inputFile != null ? new File(this.inputFile) : new File("demo", "FoodMartCreateData.zip");
        if (!file.exists()) {
            LOGGER.error((Object)("No input file: " + file));
            return null;
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            ZipFile zippedData = new ZipFile(file);
            ZipEntry entry = zippedData.getEntry("FoodMartCreateData.sql");
            return zippedData.getInputStream(entry);
        }
        return new FileInputStream(file);
    }

    private void createIndexes(boolean baseTables, boolean summaryTables) throws Exception {
        if (this.outputDirectory != null) {
            this.fileOutput = new FileWriter(new File(this.outputDirectory, "createIndexes.sql"));
        }
        this.createIndex(true, "account", "i_account_id", new String[]{"account_id"}, baseTables, summaryTables);
        this.createIndex(false, "account", "i_account_parent", new String[]{"account_parent"}, baseTables, summaryTables);
        this.createIndex(true, "category", "i_category_id", new String[]{"category_id"}, baseTables, summaryTables);
        this.createIndex(false, "category", "i_category_parent", new String[]{"category_parent"}, baseTables, summaryTables);
        this.createIndex(true, "currency", "i_currency", new String[]{"currency_id", "date"}, baseTables, summaryTables);
        this.createIndex(false, "customer", "i_cust_acct_num", new String[]{"account_num"}, baseTables, summaryTables);
        this.createIndex(false, "customer", "i_customer_fname", new String[]{"fname"}, baseTables, summaryTables);
        this.createIndex(false, "customer", "i_customer_lname", new String[]{"lname"}, baseTables, summaryTables);
        this.createIndex(false, "customer", "i_cust_child_home", new String[]{"num_children_at_home"}, baseTables, summaryTables);
        this.createIndex(true, "customer", "i_customer_id", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "customer", "i_cust_postal_code", new String[]{"postal_code"}, baseTables, summaryTables);
        this.createIndex(false, "customer", "i_cust_region_id", new String[]{"customer_region_id"}, baseTables, summaryTables);
        this.createIndex(true, "department", "i_department_id", new String[]{"department_id"}, baseTables, summaryTables);
        this.createIndex(true, "employee", "i_employee_id", new String[]{"employee_id"}, baseTables, summaryTables);
        this.createIndex(false, "employee", "i_empl_dept_id", new String[]{"department_id"}, baseTables, summaryTables);
        this.createIndex(false, "employee", "i_empl_store_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "employee", "i_empl_super_id", new String[]{"supervisor_id"}, baseTables, summaryTables);
        this.createIndex(true, "employee_closure", "i_empl_closure", new String[]{"supervisor_id", "employee_id"}, baseTables, summaryTables);
        this.createIndex(false, "employee_closure", "i_empl_closure_emp", new String[]{"employee_id"}, baseTables, summaryTables);
        this.createIndex(false, "expense_fact", "i_expense_store_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "expense_fact", "i_expense_acct_id", new String[]{"account_id"}, baseTables, summaryTables);
        this.createIndex(false, "expense_fact", "i_expense_time_id", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1997", "i_inv_97_prod_id", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1997", "i_inv_97_store_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1997", "i_inv_97_time_id", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1997", "i_inv_97_wrhse_id", new String[]{"warehouse_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1998", "i_inv_98_prod_id", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1998", "i_inv_98_store_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1998", "i_inv_98_time_id", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "inventory_fact_1998", "i_inv_98_wrhse_id", new String[]{"warehouse_id"}, baseTables, summaryTables);
        this.createIndex(true, "position", "i_position_id", new String[]{"position_id"}, baseTables, summaryTables);
        this.createIndex(false, "product", "i_prod_brand_name", new String[]{"brand_name"}, baseTables, summaryTables);
        this.createIndex(true, "product", "i_product_id", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "product", "i_prod_class_id", new String[]{"product_class_id"}, baseTables, summaryTables);
        this.createIndex(false, "product", "i_product_name", new String[]{"product_name"}, baseTables, summaryTables);
        this.createIndex(false, "product", "i_product_SKU", new String[]{"SKU"}, baseTables, summaryTables);
        this.createIndex(true, "promotion", "i_promotion_id", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "promotion", "i_promo_dist_id", new String[]{"promotion_district_id"}, baseTables, summaryTables);
        this.createIndex(true, "reserve_employee", "i_rsrv_empl_id", new String[]{"employee_id"}, baseTables, summaryTables);
        this.createIndex(false, "reserve_employee", "i_rsrv_empl_dept", new String[]{"department_id"}, baseTables, summaryTables);
        this.createIndex(false, "reserve_employee", "i_rsrv_empl_store", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "reserve_employee", "i_rsrv_empl_sup", new String[]{"supervisor_id"}, baseTables, summaryTables);
        this.createIndex(false, "salary", "i_salary_pay_date", new String[]{"pay_date"}, baseTables, summaryTables);
        this.createIndex(false, "salary", "i_salary_employee", new String[]{"employee_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1997", "i_sls_97_cust_id", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1997", "i_sls_97_prod_id", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1997", "i_sls_97_promo_id", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1997", "i_sls_97_store_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1997", "i_sls_97_time_id", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_dec_1998", "i_sls_dec98_cust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_dec_1998", "i_sls_dec98_prod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_dec_1998", "i_sls_dec98_promo", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_dec_1998", "i_sls_dec98_store", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_dec_1998", "i_sls_dec98_time", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1998", "i_sls_98_cust_id", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1998", "i_sls_1998_prod_id", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1998", "i_sls_1998_promo", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1998", "i_sls_1998_store", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "sales_fact_1998", "i_sls_1998_time_id", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(true, "store", "i_store_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "store", "i_store_region_id", new String[]{"region_id"}, baseTables, summaryTables);
        this.createIndex(true, "store_ragged", "i_store_raggd_id", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "store_ragged", "i_store_rggd_reg", new String[]{"region_id"}, baseTables, summaryTables);
        this.createIndex(true, "time_by_day", "i_time_id", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(true, "time_by_day", "i_time_day", new String[]{"the_date"}, baseTables, summaryTables);
        this.createIndex(false, "time_by_day", "i_time_year", new String[]{"the_year"}, baseTables, summaryTables);
        this.createIndex(false, "time_by_day", "i_time_quarter", new String[]{"quarter"}, baseTables, summaryTables);
        this.createIndex(false, "time_by_day", "i_time_month", new String[]{"month_of_year"}, baseTables, summaryTables);
        this.createIndex(false, "agg_pl_01_sales_fact_1997", "i_sls97pl01cust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_pl_01_sales_fact_1997", "i_sls97pl01prod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_pl_01_sales_fact_1997", "i_sls97pl01time", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_ll_01_sales_fact_1997", "i_sls97ll01cust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_ll_01_sales_fact_1997", "i_sls97ll01prod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_ll_01_sales_fact_1997", "i_sls97ll01time", new String[]{"time_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_l_05_sales_fact_1997", "i_sls97l05cust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_l_05_sales_fact_1997", "i_sls97l05prod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_l_05_sales_fact_1997", "i_sls97l05promo", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_l_05_sales_fact_1997", "i_sls97l05store", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_14_sales_fact_1997", "i_sls97c14cust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_14_sales_fact_1997", "i_sls97c14prod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_14_sales_fact_1997", "i_sls97c14promo", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_14_sales_fact_1997", "i_sls97c14store", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_lc_100_sales_fact_1997", "i_sls97lc100cust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_lc_100_sales_fact_1997", "i_sls97lc100prod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_special_sales_fact_1997", "i_sls97speccust", new String[]{"customer_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_special_sales_fact_1997", "i_sls97specprod", new String[]{"product_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_special_sales_fact_1997", "i_sls97specpromo", new String[]{"promotion_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_c_special_sales_fact_1997", "i_sls97specstore", new String[]{"store_id"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_gender", new String[]{"gender"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_ms", new String[]{"marital_status"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_pfam", new String[]{"product_family"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_pdept", new String[]{"product_department"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_pcat", new String[]{"product_category"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_tmonth", new String[]{"month_of_year"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_tquarter", new String[]{"quarter"}, baseTables, summaryTables);
        this.createIndex(false, "agg_g_ms_pcat_sales_fact_1997", "i_sls97gmp_tyear", new String[]{"the_year"}, baseTables, summaryTables);
        if (this.outputDirectory != null) {
            this.fileOutput.close();
        }
    }

    private void createIndex(boolean isUnique, String tableName, String indexName, String[] columnNames, boolean baseTables, boolean aggregateTables) {
        if (!baseTables && !aggregateTables) {
            if (!isUnique || !this.generateUniqueConstraints) {
                return;
            }
            List<UniqueConstraint> constraintList = this.tableConstraints.get(tableName);
            if (constraintList == null) {
                constraintList = new ArrayList<UniqueConstraint>();
                this.tableConstraints.put(tableName, constraintList);
            }
            constraintList.add(new UniqueConstraint(indexName, columnNames));
            return;
        }
        if (isUnique && this.generateUniqueConstraints) {
            return;
        }
        try {
            boolean isBase;
            boolean bl = isBase = !this.aggregateTableMetadataToLoad.containsKey(tableName);
            if (this.populationQueries && !isBase) {
                return;
            }
            if (isBase && !baseTables) {
                return;
            }
            if (!isBase && !aggregateTables) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            if (this.jdbcOutput && !this.tables) {
                try {
                    buf.append("DROP INDEX ").append(this.quoteId(indexName));
                    if (this.dialect.isMySQL()) {
                        buf.append(" ON ").append(this.quoteId(tableName));
                    }
                    String deleteDDL = buf.toString();
                    this.executeDDL(deleteDDL);
                }
                catch (Exception e1) {
                    LOGGER.info((Object)("Index Drop failed for " + tableName + ", " + indexName + " : but continue"));
                }
            }
            buf.setLength(0);
            buf.append(isUnique ? "CREATE UNIQUE INDEX " : "CREATE INDEX ").append(this.quoteId(indexName)).append(" ON ").append(this.quoteId(tableName)).append(" (");
            for (int i = 0; i < columnNames.length; ++i) {
                String columnName = columnNames[i];
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.quoteId(columnName));
            }
            buf.append(")");
            String createDDL = buf.toString();
            this.executeDDL(createDDL);
        }
        catch (Exception e) {
            throw MondrianResource.instance().CreateIndexFailed.ex(indexName, tableName, e);
        }
    }

    private void createTables() throws Exception {
        if (this.outputDirectory != null) {
            this.fileOutput = new FileWriter(new File(this.outputDirectory, "createTables.sql"));
        }
        this.createTable("sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("promotion_id", Type.Integer, false), new Column("store_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false)});
        this.createTable("sales_fact_1998", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("promotion_id", Type.Integer, false), new Column("store_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false)});
        this.createTable("sales_fact_dec_1998", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("promotion_id", Type.Integer, false), new Column("store_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false)});
        this.createTable("inventory_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, true), new Column("warehouse_id", Type.Integer, true), new Column("store_id", Type.Integer, true), new Column("units_ordered", Type.Integer, true), new Column("units_shipped", Type.Integer, true), new Column("warehouse_sales", Type.Currency, true), new Column("warehouse_cost", Type.Currency, true), new Column("supply_time", Type.Smallint, true), new Column("store_invoice", Type.Currency, true)});
        this.createTable("inventory_fact_1998", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, true), new Column("warehouse_id", Type.Integer, true), new Column("store_id", Type.Integer, true), new Column("units_ordered", Type.Integer, true), new Column("units_shipped", Type.Integer, true), new Column("warehouse_sales", Type.Currency, true), new Column("warehouse_cost", Type.Currency, true), new Column("supply_time", Type.Smallint, true), new Column("store_invoice", Type.Currency, true)});
        this.createTable("agg_pl_01_sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("store_sales_sum", Type.Currency, false), new Column("store_cost_sum", Type.Currency, false), new Column("unit_sales_sum", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_ll_01_sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("time_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_l_03_sales_fact_1997", new Column[]{new Column("time_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_l_04_sales_fact_1997", new Column[]{new Column("time_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("customer_count", Type.Integer, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_l_05_sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("promotion_id", Type.Integer, false), new Column("store_id", Type.Integer, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_c_10_sales_fact_1997", new Column[]{new Column("month_of_year", Type.Smallint, false), new Column("quarter", Type.Varchar30, false), new Column("the_year", Type.Smallint, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("customer_count", Type.Integer, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_c_14_sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("store_id", Type.Integer, false), new Column("promotion_id", Type.Integer, false), new Column("month_of_year", Type.Smallint, false), new Column("quarter", Type.Varchar30, false), new Column("the_year", Type.Smallint, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_lc_100_sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("quarter", Type.Varchar30, false), new Column("the_year", Type.Smallint, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_c_special_sales_fact_1997", new Column[]{new Column("product_id", Type.Integer, false), new Column("promotion_id", Type.Integer, false), new Column("customer_id", Type.Integer, false), new Column("store_id", Type.Integer, false), new Column("time_month", Type.Smallint, false), new Column("time_quarter", Type.Varchar30, false), new Column("time_year", Type.Smallint, false), new Column("store_sales_sum", Type.Currency, false), new Column("store_cost_sum", Type.Currency, false), new Column("unit_sales_sum", Type.Currency, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("agg_g_ms_pcat_sales_fact_1997", new Column[]{new Column("gender", Type.Varchar30, false), new Column("marital_status", Type.Varchar30, false), new Column("product_family", Type.Varchar30, true), new Column("product_department", Type.Varchar30, true), new Column("product_category", Type.Varchar30, true), new Column("month_of_year", Type.Smallint, false), new Column("quarter", Type.Varchar30, false), new Column("the_year", Type.Smallint, false), new Column("store_sales", Type.Currency, false), new Column("store_cost", Type.Currency, false), new Column("unit_sales", Type.Currency, false), new Column("customer_count", Type.Integer, false), new Column("fact_count", Type.Integer, false)}, false, true);
        this.createTable("currency", new Column[]{new Column("currency_id", Type.Integer, false), new Column("date", Type.Date, false), new Column("currency", Type.Varchar30, false), new Column("conversion_ratio", Type.Currency, false)});
        this.createTable("account", new Column[]{new Column("account_id", Type.Integer, false), new Column("account_parent", Type.Integer, true), new Column("account_description", Type.Varchar30, true), new Column("account_type", Type.Varchar30, false), new Column("account_rollup", Type.Varchar30, false), new Column("Custom_Members", Type.Varchar255, true)});
        this.createTable("category", new Column[]{new Column("category_id", Type.Varchar30, false), new Column("category_parent", Type.Varchar30, true), new Column("category_description", Type.Varchar30, false), new Column("category_rollup", Type.Varchar30, true)});
        this.createTable("customer", new Column[]{new Column("customer_id", Type.Integer, false), new Column("account_num", Type.Bigint, false), new Column("lname", Type.Varchar30, false), new Column("fname", Type.Varchar30, false), new Column("mi", Type.Varchar30, true), new Column("address1", Type.Varchar30, true), new Column("address2", Type.Varchar30, true), new Column("address3", Type.Varchar30, true), new Column("address4", Type.Varchar30, true), new Column("city", Type.Varchar30, true), new Column("state_province", Type.Varchar30, true), new Column("postal_code", Type.Varchar30, false), new Column("country", Type.Varchar30, false), new Column("customer_region_id", Type.Integer, false), new Column("phone1", Type.Varchar30, false), new Column("phone2", Type.Varchar30, false), new Column("birthdate", Type.Date, false), new Column("marital_status", Type.Varchar30, false), new Column("yearly_income", Type.Varchar30, false), new Column("gender", Type.Varchar30, false), new Column("total_children", Type.Smallint, false), new Column("num_children_at_home", Type.Smallint, false), new Column("education", Type.Varchar30, false), new Column("date_accnt_opened", Type.Date, false), new Column("member_card", Type.Varchar30, true), new Column("occupation", Type.Varchar30, true), new Column("houseowner", Type.Varchar30, true), new Column("num_cars_owned", Type.Integer, true), new Column("fullname", Type.Varchar60, false)});
        this.createTable("days", new Column[]{new Column("day", Type.Integer, false), new Column("week_day", Type.Varchar30, false)});
        this.createTable("department", new Column[]{new Column("department_id", Type.Integer, false), new Column("department_description", Type.Varchar30, false)});
        this.createTable("employee", new Column[]{new Column("employee_id", Type.Integer, false), new Column("full_name", Type.Varchar30, false), new Column("first_name", Type.Varchar30, false), new Column("last_name", Type.Varchar30, false), new Column("position_id", Type.Integer, true), new Column("position_title", Type.Varchar30, true), new Column("store_id", Type.Integer, false), new Column("department_id", Type.Integer, false), new Column("birth_date", Type.Date, false), new Column("hire_date", Type.Timestamp, true), new Column("end_date", Type.Timestamp, true), new Column("salary", Type.Currency, false), new Column("supervisor_id", Type.Integer, true), new Column("education_level", Type.Varchar30, false), new Column("marital_status", Type.Varchar30, false), new Column("gender", Type.Varchar30, false), new Column("management_role", Type.Varchar30, true)});
        this.createTable("employee_closure", new Column[]{new Column("employee_id", Type.Integer, false), new Column("supervisor_id", Type.Integer, false), new Column("distance", Type.Integer, true)});
        this.createTable("expense_fact", new Column[]{new Column("store_id", Type.Integer, false), new Column("account_id", Type.Integer, false), new Column("exp_date", Type.Timestamp, false), new Column("time_id", Type.Integer, false), new Column("category_id", Type.Varchar30, false), new Column("currency_id", Type.Integer, false), new Column("amount", Type.Currency, false)});
        this.createTable("position", new Column[]{new Column("position_id", Type.Integer, false), new Column("position_title", Type.Varchar30, false), new Column("pay_type", Type.Varchar30, false), new Column("min_scale", Type.Currency, false), new Column("max_scale", Type.Currency, false), new Column("management_role", Type.Varchar30, false)});
        this.createTable("product", new Column[]{new Column("product_class_id", Type.Integer, false), new Column("product_id", Type.Integer, false), new Column("brand_name", Type.Varchar60, true), new Column("product_name", Type.Varchar60, false), new Column("SKU", Type.Bigint, false), new Column("SRP", Type.Currency, true), new Column("gross_weight", Type.Real, true), new Column("net_weight", Type.Real, true), new Column("recyclable_package", Type.Boolean, true), new Column("low_fat", Type.Boolean, true), new Column("units_per_case", Type.Smallint, true), new Column("cases_per_pallet", Type.Smallint, true), new Column("shelf_width", Type.Real, true), new Column("shelf_height", Type.Real, true), new Column("shelf_depth", Type.Real, true)});
        this.createTable("product_class", new Column[]{new Column("product_class_id", Type.Integer, false), new Column("product_subcategory", Type.Varchar30, true), new Column("product_category", Type.Varchar30, true), new Column("product_department", Type.Varchar30, true), new Column("product_family", Type.Varchar30, true)});
        this.createTable("promotion", new Column[]{new Column("promotion_id", Type.Integer, false), new Column("promotion_district_id", Type.Integer, true), new Column("promotion_name", Type.Varchar30, true), new Column("media_type", Type.Varchar30, true), new Column("cost", Type.Currency, true), new Column("start_date", Type.Timestamp, true), new Column("end_date", Type.Timestamp, true)});
        this.createTable("region", new Column[]{new Column("region_id", Type.Integer, false), new Column("sales_city", Type.Varchar30, true), new Column("sales_state_province", Type.Varchar30, true), new Column("sales_district", Type.Varchar30, true), new Column("sales_region", Type.Varchar30, true), new Column("sales_country", Type.Varchar30, true), new Column("sales_district_id", Type.Integer, true)});
        this.createTable("reserve_employee", new Column[]{new Column("employee_id", Type.Integer, false), new Column("full_name", Type.Varchar30, false), new Column("first_name", Type.Varchar30, false), new Column("last_name", Type.Varchar30, false), new Column("position_id", Type.Integer, true), new Column("position_title", Type.Varchar30, true), new Column("store_id", Type.Integer, false), new Column("department_id", Type.Integer, false), new Column("birth_date", Type.Timestamp, false), new Column("hire_date", Type.Timestamp, true), new Column("end_date", Type.Timestamp, true), new Column("salary", Type.Currency, false), new Column("supervisor_id", Type.Integer, true), new Column("education_level", Type.Varchar30, false), new Column("marital_status", Type.Varchar30, false), new Column("gender", Type.Varchar30, false)});
        this.createTable("salary", new Column[]{new Column("pay_date", Type.Timestamp, false), new Column("employee_id", Type.Integer, false), new Column("department_id", Type.Integer, false), new Column("currency_id", Type.Integer, false), new Column("salary_paid", Type.Currency, false), new Column("overtime_paid", Type.Currency, false), new Column("vacation_accrued", Type.Real, false), new Column("vacation_used", Type.Real, false)});
        this.createTable("store", new Column[]{new Column("store_id", Type.Integer, false), new Column("store_type", Type.Varchar30, true), new Column("region_id", Type.Integer, true), new Column("store_name", Type.Varchar30, true), new Column("store_number", Type.Integer, true), new Column("store_street_address", Type.Varchar30, true), new Column("store_city", Type.Varchar30, true), new Column("store_state", Type.Varchar30, true), new Column("store_postal_code", Type.Varchar30, true), new Column("store_country", Type.Varchar30, true), new Column("store_manager", Type.Varchar30, true), new Column("store_phone", Type.Varchar30, true), new Column("store_fax", Type.Varchar30, true), new Column("first_opened_date", Type.Timestamp, true), new Column("last_remodel_date", Type.Timestamp, true), new Column("store_sqft", Type.Integer, true), new Column("grocery_sqft", Type.Integer, true), new Column("frozen_sqft", Type.Integer, true), new Column("meat_sqft", Type.Integer, true), new Column("coffee_bar", Type.Boolean, true), new Column("video_store", Type.Boolean, true), new Column("salad_bar", Type.Boolean, true), new Column("prepared_food", Type.Boolean, true), new Column("florist", Type.Boolean, true)});
        this.createTable("store_ragged", new Column[]{new Column("store_id", Type.Integer, false), new Column("store_type", Type.Varchar30, true), new Column("region_id", Type.Integer, true), new Column("store_name", Type.Varchar30, true), new Column("store_number", Type.Integer, true), new Column("store_street_address", Type.Varchar30, true), new Column("store_city", Type.Varchar30, true), new Column("store_state", Type.Varchar30, true), new Column("store_postal_code", Type.Varchar30, true), new Column("store_country", Type.Varchar30, true), new Column("store_manager", Type.Varchar30, true), new Column("store_phone", Type.Varchar30, true), new Column("store_fax", Type.Varchar30, true), new Column("first_opened_date", Type.Timestamp, true), new Column("last_remodel_date", Type.Timestamp, true), new Column("store_sqft", Type.Integer, true), new Column("grocery_sqft", Type.Integer, true), new Column("frozen_sqft", Type.Integer, true), new Column("meat_sqft", Type.Integer, true), new Column("coffee_bar", Type.Boolean, true), new Column("video_store", Type.Boolean, true), new Column("salad_bar", Type.Boolean, true), new Column("prepared_food", Type.Boolean, true), new Column("florist", Type.Boolean, true)});
        this.createTable("time_by_day", new Column[]{new Column("time_id", Type.Integer, false), new Column("the_date", Type.Timestamp, true), new Column("the_day", Type.Varchar30, true), new Column("the_month", Type.Varchar30, true), new Column("the_year", Type.Smallint, true), new Column("day_of_month", Type.Smallint, true), new Column("week_of_year", Type.Integer, true), new Column("month_of_year", Type.Smallint, true), new Column("quarter", Type.Varchar30, true), new Column("fiscal_period", Type.Varchar30, true)});
        this.createTable("warehouse", new Column[]{new Column("warehouse_id", Type.Integer, false), new Column("warehouse_class_id", Type.Integer, true), new Column("stores_id", Type.Integer, true), new Column("warehouse_name", Type.Varchar60, true), new Column("wa_address1", Type.Varchar30, true), new Column("wa_address2", Type.Varchar30, true), new Column("wa_address3", Type.Varchar30, true), new Column("wa_address4", Type.Varchar30, true), new Column("warehouse_city", Type.Varchar30, true), new Column("warehouse_state_province", Type.Varchar30, true), new Column("warehouse_postal_code", Type.Varchar30, true), new Column("warehouse_country", Type.Varchar30, true), new Column("warehouse_owner_name", Type.Varchar30, true), new Column("warehouse_phone", Type.Varchar30, true), new Column("warehouse_fax", Type.Varchar30, true)});
        this.createTable("warehouse_class", new Column[]{new Column("warehouse_class_id", Type.Integer, false), new Column("description", Type.Varchar30, true)});
        if (this.outputDirectory != null) {
            this.fileOutput.close();
        }
    }

    private void createTable(String name, Column[] columns) {
        this.createTable(name, columns, true, false);
    }

    private void createTable(String name, Column[] columns, boolean loadData, boolean aggregate) {
        try {
            for (Column column1 : columns) {
                column1.init(this.dialect);
            }
            if (loadData) {
                this.tableMetadataToLoad.put(name, columns);
            }
            if (aggregate) {
                this.aggregateTableMetadataToLoad.put(name, columns);
            }
            if (!this.tables) {
                if (this.data && this.jdbcOutput) {
                    if (this.populationQueries && !aggregate) {
                        return;
                    }
                    try {
                        this.executeDDL("DELETE FROM " + this.quoteId(name));
                    }
                    catch (SQLException e) {
                        throw MondrianResource.instance().CreateTableFailed.ex(name, e);
                    }
                }
                return;
            }
            if (this.populationQueries && !aggregate) {
                return;
            }
            try {
                this.executeDDL("DROP TABLE " + this.quoteId(name));
            }
            catch (Exception e) {
                LOGGER.debug((Object)("Drop of " + name + " failed. Ignored"));
            }
            StringBuilder buf = new StringBuilder();
            buf.append("CREATE TABLE ").append(this.quoteId(name)).append("(");
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(nl);
                buf.append("    ").append(this.quoteId(column.name)).append(" ").append(column.typeName);
                if (column.constraint.equals("")) continue;
                buf.append(" ").append(column.constraint);
            }
            List<UniqueConstraint> uniqueConstraints = this.tableConstraints.get(name);
            if (uniqueConstraints != null) {
                for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
                    buf.append(",");
                    buf.append(nl);
                    buf.append("    ");
                    buf.append("CONSTRAINT ");
                    buf.append(this.quoteId(uniqueConstraint.name));
                    buf.append(" UNIQUE(");
                    String[] columnNames = uniqueConstraint.columnNames;
                    for (int i = 0; i < columnNames.length; ++i) {
                        if (i > 0) {
                            buf.append(",");
                        }
                        buf.append(this.quoteId(columnNames[i]));
                    }
                    buf.append(")");
                }
            }
            buf.append(")");
            String ddl = buf.toString();
            this.executeDDL(ddl);
        }
        catch (Exception e) {
            throw MondrianResource.instance().CreateTableFailed.ex(name, e);
        }
    }

    private void executeDDL(String ddl) throws Exception {
        LOGGER.info((Object)ddl);
        if (this.jdbcOutput) {
            Statement statement = this.connection.createStatement();
            statement.execute(ddl);
        } else {
            this.fileOutput.write(ddl);
            this.fileOutput.write(";" + nl);
        }
    }

    private String quoteId(String name) {
        return this.quoteId(this.dialect, name);
    }

    private String quoteId(SqlQuery.Dialect dialect, String name) {
        return dialect.quoteIdentifier(name);
    }

    private String columnValue(ResultSet rs, Column column) throws Exception {
        Object obj = rs.getObject(column.name);
        String columnType = column.typeName;
        if (obj == null) {
            return "NULL";
        }
        if (columnType.startsWith(Type.Integer.name)) {
            if (obj.getClass() == Double.class) {
                try {
                    Double result = (Double)obj;
                    return this.integerFormatter.format(result);
                }
                catch (ClassCastException cce) {
                    LOGGER.error((Object)("CCE: " + column.name + " to Long from: " + obj.getClass().getName() + " - " + obj.toString()));
                    throw cce;
                }
            }
            try {
                Integer result = (Integer)obj;
                return result.toString();
            }
            catch (ClassCastException cce) {
                LOGGER.error((Object)("CCE: " + column.name + " to Integer from: " + obj.getClass().getName() + " - " + obj.toString()));
                throw cce;
            }
        }
        if (columnType.startsWith(Type.Smallint.name)) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? "1" : "0";
            }
            try {
                Integer result = (Integer)obj;
                return result.toString();
            }
            catch (ClassCastException cce) {
                LOGGER.error((Object)("CCE: " + column.name + " to Integer from: " + obj.getClass().getName() + " - " + obj.toString()));
                throw cce;
            }
        }
        if (columnType.startsWith("BIGINT")) {
            if (obj.getClass() == Double.class) {
                try {
                    Double result = (Double)obj;
                    return this.integerFormatter.format(result);
                }
                catch (ClassCastException cce) {
                    LOGGER.error((Object)("CCE: " + column.name + " to Double from: " + obj.getClass().getName() + " - " + obj.toString()));
                    throw cce;
                }
            }
            try {
                Long result = (Long)obj;
                return result.toString();
            }
            catch (ClassCastException cce) {
                LOGGER.error((Object)("CCE: " + column.name + " to Long from: " + obj.getClass().getName() + " - " + obj.toString()));
                throw cce;
            }
        }
        if (columnType.startsWith("VARCHAR")) {
            return this.embedQuotes((String)obj);
        }
        if (columnType.startsWith("TIMESTAMP")) {
            Timestamp ts = (Timestamp)obj;
            if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                return "TIMESTAMP '" + ts + "'";
            }
            return "'" + ts + "'";
        }
        if (columnType.startsWith("DATE")) {
            Date dt = (Date)obj;
            if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                return "DATE '" + this.dateFormatter.format(dt) + "'";
            }
            return "'" + this.dateFormatter.format(dt) + "'";
        }
        if (columnType.startsWith(Type.Real.name)) {
            Float result = (Float)obj;
            return result.toString();
        }
        if (columnType.startsWith("DECIMAL")) {
            Matcher matcher = this.decimalDataTypeRegex.matcher(columnType);
            if (!matcher.matches()) {
                throw new Exception("Bad DECIMAL column type for " + columnType);
            }
            DecimalFormat formatter = new DecimalFormat(MondrianFoodMartLoader.decimalFormat(matcher.group(1), matcher.group(2)));
            if (obj.getClass() == Double.class) {
                try {
                    Double result = (Double)obj;
                    return formatter.format(result);
                }
                catch (ClassCastException cce) {
                    LOGGER.error((Object)("CCE: " + column.name + " to Double from: " + obj.getClass().getName() + " - " + obj.toString()));
                    throw cce;
                }
            }
            try {
                BigDecimal result = (BigDecimal)obj;
                return formatter.format(result);
            }
            catch (ClassCastException cce) {
                LOGGER.error((Object)("CCE: " + column.name + " to BigDecimal from: " + obj.getClass().getName() + " - " + obj.toString()));
                throw cce;
            }
        }
        if (columnType.startsWith("BOOLEAN") || columnType.startsWith("BIT")) {
            Boolean result = (Boolean)obj;
            return result.toString();
        }
        if (columnType.startsWith("TINYINT(1)")) {
            return (Boolean)obj != false ? "1" : "0";
        }
        throw new Exception("Unknown column type: " + columnType + " for column: " + column.name);
    }

    private String columnValue(String columnValue, Column column) throws Exception {
        String columnType = column.typeName;
        if (columnValue == null) {
            return "NULL";
        }
        if (columnType.startsWith("TIMESTAMP")) {
            if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                return "TIMESTAMP " + columnValue;
            }
        } else if (columnType.startsWith("DATE")) {
            if (this.dialect.isOracle() || this.dialect.isLucidDB()) {
                return "DATE " + columnValue;
            }
        } else if (column.type == Type.Boolean) {
            String trimmedValue = columnValue.trim();
            if (!(this.dialect.isMySQL() || this.dialect.isOracle() || this.dialect.isDB2() || this.dialect.isFirebird() || this.dialect.isMSSQL() || this.dialect.isDerby() || this.dialect.isIngres())) {
                if (trimmedValue.equals("1")) {
                    return "true";
                }
                if (trimmedValue.equals("0")) {
                    return "false";
                }
            } else {
                if (trimmedValue.equals("true")) {
                    return "1";
                }
                if (trimmedValue.equals("false")) {
                    return "0";
                }
            }
        }
        return columnValue;
    }

    private String embedQuotes(String original) {
        if (original == null) {
            return "NULL";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("'");
        for (int i = 0; i < original.length(); ++i) {
            char ch = original.charAt(i);
            buf.append(ch);
            if (ch != '\'') continue;
            buf.append('\'');
        }
        buf.append("'");
        return buf.toString();
    }

    private static String decimalFormat(String lengthStr, String placesStr) {
        int length = Integer.parseInt(lengthStr);
        int places = Integer.parseInt(placesStr);
        return MondrianFoodMartLoader.decimalFormat(length, places);
    }

    private static String decimalFormat(int length, int places) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (length - i == places) {
                buf.append('.');
            }
            if (length - i <= places + 1) {
                buf.append("0");
                continue;
            }
            buf.append("#");
        }
        return buf.toString();
    }

    private static class Type {
        private final String name;
        private static final Type Integer = new Type("INTEGER");
        private static final Type Currency = new Type("DECIMAL(10,4)");
        private static final Type Smallint = new Type("SMALLINT");
        private static final Type Varchar30 = new Type("VARCHAR(30)");
        private static final Type Varchar255 = new Type("VARCHAR(255)");
        private static final Type Varchar60 = new Type("VARCHAR(60)");
        private static final Type Real = new Type("REAL");
        private static final Type Boolean = new Type("BOOLEAN");
        private static final Type Bigint = new Type("BIGINT");
        private static final Type Date = new Type("DATE");
        private static final Type Timestamp = new Type("TIMESTAMP");

        private Type(String name) {
            this.name = name;
        }

        String toPhysical(SqlQuery.Dialect dialect) {
            if (this == Integer || this == Currency || this == Smallint || this == Varchar30 || this == Varchar60 || this == Varchar255 || this == Real) {
                return this.name;
            }
            if (this == Boolean) {
                if (dialect.isPostgres() || dialect.isLucidDB()) {
                    return this.name;
                }
                if (dialect.isMySQL()) {
                    return "TINYINT(1)";
                }
                if (dialect.isMSSQL()) {
                    return "BIT";
                }
                return Type.Smallint.name;
            }
            if (this == Bigint) {
                if (dialect.isOracle() || dialect.isFirebird()) {
                    return "DECIMAL(15,0)";
                }
                return this.name;
            }
            if (this == Date) {
                if (dialect.isMSSQL()) {
                    return "DATETIME";
                }
                if (dialect.isIngres()) {
                    return "INGRESDATE";
                }
                return this.name;
            }
            if (this == Timestamp) {
                if (dialect.isMSSQL() || dialect.isMySQL()) {
                    return "DATETIME";
                }
                if (dialect.isIngres()) {
                    return "INGRESDATE";
                }
                return this.name;
            }
            throw new AssertionError((Object)("unexpected type: " + this.name));
        }
    }

    private static class UniqueConstraint {
        final String name;
        final String[] columnNames;

        public UniqueConstraint(String name, String[] columnNames) {
            this.name = name;
            this.columnNames = columnNames;
        }
    }

    private static class Column {
        private final String name;
        private final Type type;
        private String typeName;
        private final String constraint;

        public Column(String name, Type type, boolean nullsAllowed) {
            this.name = name;
            this.type = type;
            this.constraint = nullsAllowed ? "" : "NOT NULL";
        }

        public void init(SqlQuery.Dialect dialect) {
            this.typeName = this.type.toPhysical(dialect);
        }
    }
}

