/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.StandardDialRange;

public class ScaledDialRange
extends StandardDialRange {
    private static final long serialVersionUID = 10200L;
    private float lineWidth = 2.0f;

    public ScaledDialRange() {
    }

    public ScaledDialRange(double lower, double upper, Paint paint) {
        super(lower, upper, paint);
    }

    public ScaledDialRange(double lower, double upper, Paint paint, float lineWidth) {
        super(lower, upper, paint);
        this.lineWidth = lineWidth;
    }

    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        Rectangle2D arcRectInner = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getInnerRadius(), (double)this.getInnerRadius());
        Rectangle2D arcRectOuter = DialPlot.rectangleByRadius((Rectangle2D)frame, (double)this.getOuterRadius(), (double)this.getOuterRadius());
        DialScale scale = plot.getScale(this.getScaleIndex());
        if (scale == null) {
            throw new RuntimeException("No scale for scaleIndex = " + this.getScaleIndex());
        }
        double angleMin = scale.valueToAngle(this.getLowerBound());
        double angleMax = scale.valueToAngle(this.getUpperBound());
        Arc2D.Double arcInner = new Arc2D.Double(arcRectInner, angleMin, angleMax - angleMin, 0);
        Arc2D.Double arcOuter = new Arc2D.Double(arcRectOuter, angleMax, angleMin - angleMax, 0);
        g2.setPaint(this.getPaint());
        g2.setStroke(new BasicStroke(this.lineWidth));
        g2.draw(arcInner);
        g2.draw(arcOuter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(((Object)((Object)this)).getClass())) {
            return false;
        }
        ScaledDialRange that = (ScaledDialRange)((Object)obj);
        if (this.lineWidth != that.lineWidth) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int temp = Float.floatToIntBits(this.lineWidth);
        return 37 * super.hashCode() + (temp ^ temp >>> 32);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

