/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rex.graphics.mdxeditor.mdxbuilder.CanSaveAndResumeState;
import rex.graphics.mdxeditor.mdxbuilder.HandlesMdxEditorSettings;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class MdxBuilderToolbar
extends JPanel
implements LanguageChangedListener {
    private CanSaveAndResumeState parent;
    private HandlesMdxEditorSettings settingsHandler;
    private JLabel saveQuery;
    private JLabel loadQuery;
    private JLabel undoAction;
    private JLabel redoAction;
    private JLabel newQuery;
    private static int MAX_UNDO_OPERATIONS = 20;
    private Stack undoStack;
    private Stack redoStack;
    private static ImageIcon undoEnabledIcon = S.getAppIcon("undo.gif");
    private static ImageIcon undoDisabledIcon = S.getAppIcon("undo_disabled.gif");
    private static ImageIcon redoEnabledIcon = S.getAppIcon("redo.gif");
    private static ImageIcon redoDisabledIcon = S.getAppIcon("redo_disabled.gif");

    public MdxBuilderToolbar(CanSaveAndResumeState _parent, HandlesMdxEditorSettings _settingsHandler) {
        this.parent = _parent;
        this.settingsHandler = _settingsHandler;
        this.newQuery = new JLabel(S.getAppIcon("new_query.gif"));
        this.newQuery.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.newQuery();
            }
        });
        this.newQuery.setToolTipText(I18n.getString("toolTip.newQuery"));
        this.saveQuery = new JLabel(S.getAppIcon("save_query.gif"));
        this.saveQuery.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.saveQuery();
            }
        });
        this.saveQuery.setToolTipText(I18n.getString("toolTip.saveQuery"));
        this.loadQuery = new JLabel(S.getAppIcon("open_query.gif"));
        this.loadQuery.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.loadQuery();
            }
        });
        this.loadQuery.setToolTipText(I18n.getString("toolTip.loadQuery"));
        this.loadQuery.setOpaque(false);
        this.undoAction = new JLabel(undoDisabledIcon);
        this.undoAction.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.undo();
            }
        });
        this.undoAction.setToolTipText(I18n.getString("toolTip.undoAction"));
        this.undoAction.setOpaque(false);
        this.redoAction = new JLabel(redoDisabledIcon);
        this.redoAction.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxBuilderToolbar.this.redo();
            }
        });
        this.redoAction.setToolTipText(I18n.getString("toolTip.redoAction"));
        this.redoAction.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.newQuery);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.saveQuery);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.loadQuery);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.undoAction);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.redoAction);
        this.setBorder(AppColors.TOOLBAR_BORDER);
        this.setOpaque(false);
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void setUndoEnabled(boolean enabled) {
        this.undoAction.setEnabled(enabled);
        if (enabled) {
            this.undoAction.setIcon(undoEnabledIcon);
        } else {
            this.undoAction.setIcon(undoDisabledIcon);
        }
    }

    public void setRedoEnabled(boolean enabled) {
        this.redoAction.setEnabled(enabled);
        if (enabled) {
            this.redoAction.setIcon(redoEnabledIcon);
        } else {
            this.redoAction.setIcon(redoDisabledIcon);
        }
    }

    public void refreshUndoRedoState() {
        this.setUndoEnabled(this.canUndo());
        this.setRedoEnabled(this.canRedo());
    }

    public void actionToBePerformed() {
        if (this.undoStack.size() == MAX_UNDO_OPERATIONS) {
            this.undoStack.removeElementAt(0);
        }
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        this.redoStack.removeAllElements();
        this.parent.saveState(memStream);
        this.undoStack.push(memStream);
        this.refreshUndoRedoState();
    }

    public void undo() {
        if (this.canUndo()) {
            ByteArrayOutputStream currMemStream = new ByteArrayOutputStream();
            this.parent.saveState(currMemStream);
            this.redoStack.push(currMemStream);
            ByteArrayOutputStream memStream = (ByteArrayOutputStream)this.undoStack.pop();
            this.parent.resumeState(new ByteArrayInputStream(memStream.toByteArray()));
            this.refreshUndoRedoState();
        }
    }

    public void redo() {
        if (this.canRedo()) {
            ByteArrayOutputStream currMemStream = new ByteArrayOutputStream();
            this.parent.saveState(currMemStream);
            this.undoStack.push(currMemStream);
            ByteArrayOutputStream memStream = (ByteArrayOutputStream)this.redoStack.pop();
            this.parent.resumeState(new ByteArrayInputStream(memStream.toByteArray()));
            this.refreshUndoRedoState();
        }
    }

    public boolean canUndo() {
        return !this.undoStack.empty();
    }

    public boolean canRedo() {
        return !this.redoStack.empty();
    }

    protected void newQuery() {
        this.parent.clearState();
    }

    protected void loadQuery() {
        FileInputStream in;
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        if (this.settingsHandler.getDefaultSaveDirectory() != null) {
            chooser.setCurrentDirectory(new File(this.settingsHandler.getDefaultSaveDirectory()));
        }
        if ((returnVal = chooser.showOpenDialog(null)) != 0) {
            return;
        }
        try {
            in = new FileInputStream(chooser.getSelectedFile().getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.errLoadingQuery") + chooser.getSelectedFile().getAbsolutePath(), I18n.getString("msgTitle.loadingQuery"), 0);
            return;
        }
        this.parent.resumeState(in);
    }

    protected void saveQuery() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        if (this.settingsHandler.getDefaultSaveDirectory() != null) {
            chooser.setCurrentDirectory(new File(this.settingsHandler.getDefaultSaveDirectory()));
        }
        if ((returnVal = chooser.showSaveDialog(null)) != 0) {
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(chooser.getSelectedFile().getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.fileNotFound") + chooser.getSelectedFile().getAbsolutePath(), I18n.getString("msgTitle.saveQuery"), 0);
            return;
        }
        this.parent.saveState(out);
        JOptionPane.showMessageDialog(null, I18n.getString("msgText.querySaved"), I18n.getString("msgTitle.saveQuery"), 1);
        this.settingsHandler.setDefaultSaveDirectory(chooser.getSelectedFile().getParentFile().getAbsolutePath());
    }

    public void paintComponent(Graphics g) {
        S.paintBackground(g, this);
        super.paintComponent(g);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.newQuery.setToolTipText(I18n.getString("toolTip.newQuery"));
        this.saveQuery.setToolTipText(I18n.getString("toolTip.saveQuery"));
        this.loadQuery.setToolTipText(I18n.getString("toolTip.loadQuery"));
        this.undoAction.setToolTipText(I18n.getString("toolTip.undoAction"));
        this.redoAction.setToolTipText(I18n.getString("toolTip.redoAction"));
    }
}

