/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GraySeparator.java
 *
 * Created on 22-mar-2009, 3.19.01
 */

package com.jaspersoft.ireport.designer.welcome;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import org.jfree.text.G2TextMeasurer;

/**
 *
 * @author gtoffoli
 */
public class GraySeparator extends javax.swing.JPanel {

    public static final int SEPARATOR_NORTH = 0;
    public static final int SEPARATOR_SOUTH = 1;
    public static final int SEPARATOR_EAST = 2;
    public static final int SEPARATOR_WEST = 3;


    private int separatorType = 0;
    private boolean paintStar = false;

    ImageIcon imageIcon = new ImageIcon(G2TextMeasurer.class.getResource("/com/jaspersoft/ireport/designer/welcome/cross.png"));
    /** Creates new form GraySeparator */
    public GraySeparator() {
        this(0,false);
    }
    
    public GraySeparator(int type) {
        this(type,false);
    }

    public GraySeparator(int type, boolean paintStar) {
        initComponents();
        this.separatorType = type;
        this.paintStar = paintStar;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    @Override
    public void paint(Graphics g) {

        Color origColor = g.getColor();

        g.setColor(Color.WHITE);
        g.fillRect(0,0,getWidth(), getHeight());

        g.setColor(new Color(222,222,222));

        if (getSeparatorType() == SEPARATOR_NORTH)
        {
            int top = 25;
            g.drawLine(13, top, 13, getHeight());

            if (isPaintStar() && imageIcon != null)
            {
                g.drawImage(imageIcon.getImage(), 0, getHeight()-27, this);
            }
        }
        else if (getSeparatorType() == SEPARATOR_SOUTH)
        {
            int bottom = getHeight()-25;
            g.drawLine(13, 0, 13, bottom);

            if (isPaintStar() && imageIcon != null)
            {
                g.drawImage(imageIcon.getImage(), 0, 0, this);
            }
        }
        if (getSeparatorType() == SEPARATOR_WEST)
        {
            int left = 25;
            g.drawLine(left, 13, getWidth(), 13);

            if (isPaintStar() && imageIcon != null)
            {
                g.drawImage(imageIcon.getImage(), getWidth()-27, 0, this);
            }
        }
        else if (getSeparatorType() == SEPARATOR_EAST)
        {
            int right = getWidth()-25;
            g.drawLine(0, 13, right, 13);

            if (isPaintStar() && imageIcon != null)
            {
                g.drawImage(imageIcon.getImage(), 0, 0, this);
            }
        }
    }

    /**
     * @return the separatorType
     */
    public int getSeparatorType() {
        return separatorType;
    }

    /**
     * @param separatorType the separatorType to set
     */
    public void setSeparatorType(int separatorType) {
        this.separatorType = separatorType;
    }

    /**
     * @return the paintStar
     */
    public boolean isPaintStar() {
        return paintStar;
    }

    /**
     * @param paintStar the paintStar to set
     */
    public void setPaintStar(boolean paintStar) {
        this.paintStar = paintStar;
    }




    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
