/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.JRDataSourceProviderConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JasperReport;
import org.openide.util.Mutex;

public class JRDataSourceProviderConnection
extends IReportConnection {
    private JRDataSourceProvider dsp;
    private JRDataSource ds;
    private HashMap properties = new HashMap();

    public JRDataSourceProvider getDataSourceProvider() {
        if (this.dsp == null && this.getProperties().get("JRDataSourceProvider") != null) {
            try {
                String string = (String)this.getProperties().get("JRDataSourceProvider");
                IReportManager.getInstance();
                this.dsp = (JRDataSourceProvider)Class.forName(string, true, IReportManager.getReportClassLoader()).newInstance();
            }
            catch (NoClassDefFoundError ex) {
                this.showErrorMessage("No class definition found error!!\nCheck your classpath!", "Exception");
            }
            catch (ClassNotFoundException ex) {
                this.showErrorMessage("Class not found error!!\nCheck your classpath!", "Exception");
            }
            catch (Exception ex) {
                this.showErrorMessage(I18n.getString("unexpected.datasource.error", (Object)ex.getMessage(), Misc.getLogFile()), "Exception");
            }
        }
        return this.dsp;
    }

    public JRDataSource getJRDataSource() {
        return this.getJRDataSource(null);
    }

    public JRDataSource getJRDataSource(JasperReport jasper) {
        if (this.ds != null) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "This datasource is already in use by another filling process!!", "Error", 0);
            return null;
        }
        try {
            this.ds = this.getDataSourceProvider().create(jasper);
        }
        catch (Exception ex) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("Problems occurred creating the new datasource!!\n{0}", new Object[]{"" + ex.getMessage()}), "Error", 0);
                }
            });
        }
        return this.ds;
    }

    public void disposeDataSource() {
        if (this.dsp != null) {
            try {
                this.dsp.dispose(this.ds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ds = null;
        }
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void loadProperties(HashMap map) {
        this.properties = map;
    }

    public void save(PrintWriter pw) {
        HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\"" + this.getName() + "\" connectionClass=\"" + this.getClass().getName() + "\">");
        for (String key : hm.keySet()) {
            pw.println("\t\t<connectionParameter name=\"" + key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }

    public String getDescription() {
        return "JRDataSourceProvider";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRDataSourceProviderConnectionEditor();
    }

    public void test() throws Exception {
        try {
            String string = (String)this.getProperties().get("JRDataSourceProvider");
            IReportManager.getInstance();
            Class<?> c = Class.forName(string, true, IReportManager.getReportClassLoader());
            if (!JRDataSourceProvider.class.isAssignableFrom(c)) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("\"{0}\" is not a subclass of\nnet.sf.jasperreports.engine.JRDataSourceProvider.", new Object[]{this.getProperties().get("JRDataSourceProvider")}), "Error", 0);
                return;
            }
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
            return;
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            return;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"", "" + ex.getMessage(), "" + this.getProperties().get("JRDataSourceProvider")}), "Exception", 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nGeneral problem:\n {1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            return;
        }
    }
}

