/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data;

import bsh.EvalError;
import bsh.Interpreter;
import com.jaspersoft.ireport.designer.FieldsContainer;
import com.jaspersoft.ireport.designer.FieldsProvider;
import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRCSVDataSourceConnection;
import com.jaspersoft.ireport.designer.connection.JRDataSourceProviderConnection;
import com.jaspersoft.ireport.designer.data.JRFieldTableCellRenderer;
import com.jaspersoft.ireport.designer.data.SortFieldsDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.BeanInspectorPanel;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditor;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.CustomColumnControlButton;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStringUtil;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.icon.ColumnControlIcon;

public class ReportQueryDialog
extends JDialog
implements ClipboardOwner,
FieldsContainer {
    private BeanInspectorPanel bip1 = null;
    private FieldsProvider fieldsProvider = null;
    protected static String[] standard_types = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Boolean", "java.lang.Byte", "java.util.Date", "java.sql.Timestamp", "java.sql.Time", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.io.InputStream", "java.lang.Long", "java.lang.Short", "java.math.BigDecimal"};
    FieldReader readerThread = null;
    public static int num = 1;
    Timer stoppedChanging = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (ReportQueryDialog.this.automaticlyReadFieldsCheckBox.isSelected()) {
                ReportQueryDialog.this.processQueryChanged(ReportQueryDialog.this.jEditorPane1.getText().trim());
            }
        }
    });
    public static int elaborationSequence = 0;
    Map parameterNameToExpressionID = null;
    private JCheckBox automaticlyReadFieldsCheckBox;
    private JButton cancelButton;
    private JLabel columnsErrorMsgLabel;
    private JScrollPane columnsErrorScrollPane;
    private JScrollPane columnsScrollPane;
    private JButton exportQueryButton;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButtonLoadQuery;
    private JButton jButtonOpenDesigner;
    private JButton jButtonReadBeanAttributes3;
    private JButton jButtonSaveQuery;
    private JComboBox jComboBoxQueryType;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JXBusyLabel jLabelStatusSQL;
    private JPanel jPanel1;
    private JPanel jPanel11;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel16;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelQueryArea;
    private JPanel jPanelSQL;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JXTable jTableFields;
    private JTextField jTextFieldBeanClass1;
    private JButton okButton;
    private JButton readFieldsButton;
    private boolean isSettingSQLExpression = false;
    private JRDesignDataset dataset;

    public JLabel getJLabelStatusSQL() {
        return this.jLabelStatusSQL;
    }

    public ReportQueryDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public ReportQueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(800, 550);
        this.setLocationRelativeTo(null);
        this.jTableFields.getColumn(0).setCellRenderer(new JRFieldTableCellRenderer());
        this.stoppedChanging.setRepeats(false);
        this.jEditorPane1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.stoppedChanging.restart();
            }
        });
        this.setColumnsError(I18n.getString("ReportQueryDialog.Message.Error"));
        this.jComboBoxQueryType.addItem(new Tag("sql", "SQL"));
        this.jComboBoxQueryType.addItem(new Tag("hql", "Hibernate Query Language (HQL)"));
        this.jComboBoxQueryType.addItem(new Tag("xPath", "XPath"));
        this.jComboBoxQueryType.addItem(new Tag("ejbql", "EJBQL"));
        this.jComboBoxQueryType.addItem(new Tag("mdx", "MDX"));
        this.jComboBoxQueryType.addItem(new Tag("xmla-mdx", "XMLA-MDX"));
        ArrayList<QueryExecuterDef> queryExecuters = IReportManager.getInstance().getQueryExecuters();
        for (QueryExecuterDef qe : queryExecuters) {
            String s = qe.getLanguage();
            boolean found = false;
            for (int i = 0; i < this.jComboBoxQueryType.getItemCount(); ++i) {
                Tag t = (Tag)this.jComboBoxQueryType.getItemAt(i);
                if (!s.toLowerCase().equals((t.getValue() + "").toLowerCase())) continue;
                found = true;
            }
            if (found) continue;
            this.jComboBoxQueryType.addItem(new Tag(qe, qe.getLanguage()));
        }
        this.okButton.setEnabled(false);
        this.bip1 = new BeanInspectorPanel();
        this.bip1.setComboVisible(false);
        this.bip1.setJTableFields((JTable)this.jTableFields);
        this.bip1.setPathOnDescription(true);
        this.jPanel11.add((Component)this.bip1, "Center");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReportQueryDialog.this.cancelButtonActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.jTableFields.setColumnControl((JComponent)((Object)new CustomColumnControlButton(this.jTableFields, (Icon)new ColumnControlIcon())));
    }

    private void processQueryChanged(String query) {
        if (this.isSettingSQLExpression) {
            return;
        }
        if (this.dataset == null) {
            this.setColumnsError(I18n.getString("ReportQueryDialog.Message.Error"));
            return;
        }
        if (query.length() == 0) {
            this.setColumnsError(I18n.getString("ReportQueryDialog.Message.Error2"));
            return;
        }
        IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
        Object obj = this.jComboBoxQueryType.getSelectedItem();
        String queryLanguage = "sql";
        queryLanguage = obj != null && obj instanceof Tag ? "" + ((Tag)obj).getValue() : "" + obj;
        try {
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.readerThread = new FieldReader(query, conn, queryLanguage);
        this.readerThread.start();
    }

    public void setColumns(List cols) {
        JRField field;
        int i;
        this.columnsErrorMsgLabel.setText("");
        this.jPanel2.remove(this.columnsErrorScrollPane);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel2.revalidate();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        HashMap<String, JRPropertiesMap> fieldProperties = new HashMap<String, JRPropertiesMap>();
        JasperDesign report = IReportManager.getInstance().getActiveReport();
        JRField[] oldFields = report.getFields();
        for (i = 0; i < oldFields.length; ++i) {
            field = oldFields[i];
            if (!field.getPropertiesMap().hasProperties()) continue;
            fieldProperties.put(field.getName(), field.getPropertiesMap().cloneProperties());
        }
        for (i = 0; i < dtm.getRowCount(); ++i) {
            field = (JRField)dtm.getValueAt(i, 0);
            if (!field.getPropertiesMap().hasProperties()) continue;
            fieldProperties.put(field.getName(), field.getPropertiesMap().cloneProperties());
        }
        dtm.getDataVector().clear();
        for (i = 0; i < cols.size(); ++i) {
            Object obj = cols.get(i);
            if (obj instanceof JRDesignField) {
                JRDesignField field2 = (JRDesignField)obj;
                if (fieldProperties.containsKey(field2.getName())) {
                    JRPropertiesMap map = (JRPropertiesMap)fieldProperties.get(field2.getName());
                    String[] names = map.getPropertyNames();
                    for (int k = 0; k < names.length; ++k) {
                        if (field2.getPropertiesMap().containsProperty(names[k])) continue;
                        field2.getPropertiesMap().setProperty(names[k], map.getProperty(names[k]));
                    }
                }
                Vector<Object> row = new Vector<Object>();
                row.add(field2);
                row.add(field2.getValueClassName());
                row.add(field2.getDescription());
                dtm.addRow(row);
                continue;
            }
            Object[] row = (Object[])cols.get(i);
            dtm.addRow(row);
        }
        this.jTableFields.selectAll();
        this.okButton.setEnabled(true);
    }

    public void setColumnsError(String msg) {
        this.columnsErrorMsgLabel.setText(msg);
        this.jPanel2.remove(this.columnsScrollPane);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jPanel2.revalidate();
        this.columnsErrorMsgLabel.repaint();
    }

    private FieldsProvider getFieldsProvider() {
        return this.fieldsProvider;
    }

    private void setFieldsProvider(FieldsProvider fieldsProvider) {
        this.fieldsProvider = fieldsProvider;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelSQL = new JPanel();
        this.jPanel14 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxQueryType = new JComboBox();
        this.jPanel16 = new JPanel();
        this.jButtonLoadQuery = new JButton();
        this.jButtonSaveQuery = new JButton();
        this.jPanelQueryArea = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel7 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.jLabelStatusSQL = new JXBusyLabel();
        this.automaticlyReadFieldsCheckBox = new JCheckBox();
        this.readFieldsButton = new JButton();
        this.jButtonOpenDesigner = new JButton();
        this.exportQueryButton = new JButton();
        this.jPanel8 = new JPanel();
        this.jTextFieldBeanClass1 = new JTextField();
        this.jLabel3 = new JLabel();
        this.jButtonReadBeanAttributes3 = new JButton();
        this.jPanel11 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jButton2 = new JButton();
        this.jPanel15 = new JPanel();
        this.jButton3 = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel9 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.columnsErrorScrollPane = new JScrollPane();
        this.columnsErrorMsgLabel = new JLabel();
        this.columnsScrollPane = new JScrollPane();
        this.jTableFields = new JXTable();
        this.setTitle("Report query");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReportQueryDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ReportQueryDialog.this.formWindowOpened(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setMinimumSize(new Dimension(10, 100));
        this.jPanel1.setPreferredSize(new Dimension(10, 350));
        this.jPanel1.setLayout(new BorderLayout());
        this.jTabbedPane1.setMinimumSize(new Dimension(154, 350));
        this.jTabbedPane1.setPreferredSize(new Dimension(154, 350));
        this.jPanelSQL.setMinimumSize(new Dimension(1, 100));
        this.jPanelSQL.setPreferredSize(new Dimension(1, 350));
        this.jPanelSQL.setLayout(new GridBagLayout());
        this.jPanel14.setLayout(new GridBagLayout());
        this.jLabel1.setText("Query language");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel14.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxQueryType.setEditable(true);
        this.jComboBoxQueryType.setMinimumSize(new Dimension(200, 18));
        this.jComboBoxQueryType.setPreferredSize(new Dimension(200, 22));
        this.jComboBoxQueryType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jComboBoxQueryTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel14.add((Component)this.jComboBoxQueryType, gridBagConstraints);
        this.jPanel16.setLayout(new GridBagLayout());
        this.jButtonLoadQuery.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/folder_database.png")));
        this.jButtonLoadQuery.setText("Load query");
        this.jButtonLoadQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonLoadQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonLoadQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel16.add((Component)this.jButtonLoadQuery, gridBagConstraints);
        this.jButtonSaveQuery.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/database_save.png")));
        this.jButtonSaveQuery.setText("Save query");
        this.jButtonSaveQuery.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonSaveQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonSaveQueryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel16.add((Component)this.jButtonSaveQuery, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel14.add((Component)this.jPanel16, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelSQL.add((Component)this.jPanel14, gridBagConstraints);
        this.jPanelQueryArea.setLayout(new BorderLayout());
        this.jSplitPane2.setBorder(null);
        this.jSplitPane2.setDividerSize(6);
        this.jSplitPane2.setResizeWeight(0.5);
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(661, 340));
        this.jEditorPane1.setBorder(BorderFactory.createEtchedBorder());
        this.jEditorPane1.setFont(new Font("Courier New", 0, 12));
        this.jEditorPane1.setMinimumSize(new Dimension(50, 200));
        this.jEditorPane1.setPreferredSize(new Dimension(661, 340));
        this.jScrollPane1.setViewportView(this.jEditorPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel7.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabelStatusSQL.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.jLabelStatusSQL, gridBagConstraints);
        this.automaticlyReadFieldsCheckBox.setSelected(true);
        this.automaticlyReadFieldsCheckBox.setText("Automatically Retrieve Fields");
        this.automaticlyReadFieldsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.automaticlyReadFieldsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel7.add((Component)this.automaticlyReadFieldsCheckBox, gridBagConstraints);
        this.readFieldsButton.setText("Read Fields");
        this.readFieldsButton.setEnabled(false);
        this.readFieldsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.readFieldsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.readFieldsButton, gridBagConstraints);
        this.jButtonOpenDesigner.setText("Query designer");
        this.jButtonOpenDesigner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonOpenDesignerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.jButtonOpenDesigner, gridBagConstraints);
        this.exportQueryButton.setText("Send to clipboard");
        this.exportQueryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.exportQueryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        this.jPanel7.add((Component)this.exportQueryButton, gridBagConstraints);
        this.jSplitPane2.setLeftComponent(this.jPanel7);
        this.jPanelQueryArea.add((Component)this.jSplitPane2, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.jPanelSQL.add((Component)this.jPanelQueryArea, gridBagConstraints);
        this.jTabbedPane1.addTab("Report query ", this.jPanelSQL);
        this.jPanel8.setMinimumSize(new Dimension(235, 30));
        this.jPanel8.setPreferredSize(new Dimension(215, 30));
        this.jPanel8.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jTextFieldBeanClass1, gridBagConstraints);
        this.jLabel3.setText("Class name");
        this.jLabel3.setVerticalAlignment(3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanel8.add((Component)this.jLabel3, gridBagConstraints);
        this.jButtonReadBeanAttributes3.setText("Read attributes");
        this.jButtonReadBeanAttributes3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonReadBeanAttributes3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanel8.add((Component)this.jButtonReadBeanAttributes3, gridBagConstraints);
        this.jPanel11.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.jPanel8.add((Component)this.jPanel11, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 4));
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel8.add((Component)this.jSeparator1, gridBagConstraints);
        this.jTabbedPane1.addTab("JavaBean Datasource", this.jPanel8);
        this.jButton2.setText("Get fields from datasource");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jButton2);
        this.jTabbedPane1.addTab("DataSource Provider", this.jPanel6);
        this.jButton3.setText("Get fields from datasource");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton2ActionPerformed1(evt);
            }
        });
        this.jPanel15.add(this.jButton3);
        this.jTabbedPane1.addTab("CSV Datasource", this.jPanel15);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(453, 150));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel4.add((Component)this.cancelButton, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel9.setMinimumSize(new Dimension(100, 20));
        this.jPanel9.setLayout(new GridBagLayout());
        this.jButton1.setText("Filter expression...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel9.add((Component)this.jButton1, gridBagConstraints);
        this.jButton4.setText("Sort options...");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButton1ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel9.add((Component)this.jButton4, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel9, "West");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.columnsErrorMsgLabel.setText("jLabel1");
        this.columnsErrorMsgLabel.setVerticalAlignment(1);
        this.columnsErrorMsgLabel.setVerticalTextPosition(1);
        this.columnsErrorScrollPane.setViewportView(this.columnsErrorMsgLabel);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jTableFields.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Field name", "Field type", "Description"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.setColumnControlVisible(true);
        this.jTableFields.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReportQueryDialog.this.jTableFieldsMouseClicked(evt);
            }
        });
        this.jTableFields.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ReportQueryDialog.this.jTableFieldsKeyReleased(evt);
            }
        });
        this.columnsScrollPane.setViewportView((Component)this.jTableFields);
        this.jPanel2.add((Component)this.columnsScrollPane, "West");
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void jTableFieldsMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && this.jTableFields.getSelectedRow() >= 0) {
            JRDesignField jRDesignField = (JRDesignField)this.jTableFields.getValueAt(this.jTableFields.getSelectedRow(), 0);
        }
    }

    private void jTableFieldsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            while (this.jTableFields.getSelectedRow() >= 0) {
                dtm.removeRow(this.jTableFields.getSelectedRow());
            }
        }
    }

    private void jButtonOpenDesignerActionPerformed(ActionEvent evt) {
        if (this.getFieldsProvider() != null && this.getFieldsProvider().hasQueryDesigner()) {
            try {
                String newQuery = this.getFieldsProvider().designQuery(IReportManager.getInstance().getDefaultConnection(), this.jEditorPane1.getText(), this);
                if (newQuery != null && !this.jEditorPane1.getText().equals(newQuery)) {
                    this.jEditorPane1.setText(newQuery);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, ex.getMessage());
            }
        }
    }

    private void jButton1ActionPerformed1(ActionEvent evt) {
        SortFieldsDialog sfd = new SortFieldsDialog((Dialog)this, true);
        sfd.setDataset(this.getDataset());
        sfd.setVisible(true);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.openFilterExpressionDialog(false);
    }

    private void jButtonSaveQueryActionPerformed(ActionEvent evt) {
        Misc.saveSQLQuery(this.jEditorPane1.getText(), this);
    }

    private void jButtonLoadQueryActionPerformed(ActionEvent evt) {
        String query = Misc.loadSQLQuery(this);
        if (query != null) {
            this.jEditorPane1.setText(query);
        }
    }

    private void jComboBoxQueryTypeActionPerformed(ActionEvent evt) {
        boolean autoReadFields = this.automaticlyReadFieldsCheckBox.isSelected();
        this.readFieldsButton.setEnabled(false);
        this.automaticlyReadFieldsCheckBox.setSelected(false);
        this.readFieldsButton.setEnabled(false);
        String language = "sql";
        if (this.jComboBoxQueryType.getSelectedItem() != null && this.jComboBoxQueryType.getSelectedItem() instanceof Tag) {
            language = "" + ((Tag)this.jComboBoxQueryType.getSelectedItem()).getValue();
        } else if (this.jComboBoxQueryType.getSelectedItem() != null) {
            language = "" + this.jComboBoxQueryType.getSelectedItem();
        }
        this.getJLabelStatusSQL().setText(I18n.getString("ReportQueryDialog.Label.StatusSQL2") + language + I18n.getString("ReportQueryDialog.Label.StatusSQL2B"));
        this.setFieldsProvider(null);
        ArrayList<QueryExecuterDef> qexecuters = IReportManager.getInstance().getQueryExecuters();
        for (QueryExecuterDef qed : qexecuters) {
            if (!qed.getLanguage().equals(language) || qed.getFieldsProvider() == null || qed.getFieldsProvider().length() <= 0) continue;
            try {
                JRProperties.setProperty((String)("net.sf.jasperreports.query.executer.factory." + language), (String)qed.getClassName());
                String string = qed.getFieldsProvider();
                IReportManager.getInstance();
                this.setFieldsProvider((FieldsProvider)Class.forName(string, true, IReportManager.getReportClassLoader()).newInstance());
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.getJLabelStatusSQL().setText(I18n.getString("ReportQueryDialog.Label.StatusSQL3") + t.getMessage());
            }
        }
        this.exportQueryButton.setEnabled(language.equals("sql"));
        boolean isSettingSQLExpressionOldValue = this.isSettingSQLExpression;
        this.isSettingSQLExpression = true;
        if (this.getFieldsProvider() == null) {
            this.setSpecialLanguageComponent(null);
            this.readFieldsButton.setEnabled(false);
            this.jButtonOpenDesigner.setEnabled(false);
            this.automaticlyReadFieldsCheckBox.setEnabled(false);
            this.automaticlyReadFieldsCheckBox.setSelected(autoReadFields);
            this.getJLabelStatusSQL().setText(I18n.getString("ReportQueryDialog.Label.StatusSQL4", (Object)language));
        } else {
            this.readFieldsButton.setEnabled(this.getFieldsProvider().supportsGetFieldsOperation());
            this.automaticlyReadFieldsCheckBox.setEnabled(this.getFieldsProvider().supportsAutomaticQueryExecution());
            this.automaticlyReadFieldsCheckBox.setSelected(autoReadFields);
            this.jButtonOpenDesigner.setEnabled(this.getFieldsProvider().hasQueryDesigner());
            if (this.getFieldsProvider().hasEditorComponent()) {
                FieldsProviderEditor fpe = this.getFieldsProvider().getEditorComponent(this);
                if (fpe instanceof Component) {
                    this.setSpecialLanguageComponent((Component)((Object)fpe));
                }
            } else {
                this.setSpecialLanguageComponent(null);
            }
            this.getJLabelStatusSQL().setText(I18n.getString("ReportQueryDialog.Label.StatusSQL5", (Object)language));
        }
        this.isSettingSQLExpression = isSettingSQLExpressionOldValue;
    }

    public void setSpecialLanguageComponent(Component c) {
        if (c == null) {
            if (this.jPanelQueryArea.getComponent(0) != this.jPanel7) {
                this.jPanelQueryArea.removeAll();
                this.jPanelQueryArea.add((Component)this.jPanel7, "Center");
            }
        } else if (this.jPanelQueryArea.getComponent(0) != this.jSplitPane2 || this.jSplitPane2.getRightComponent() != c) {
            this.jPanelQueryArea.removeAll();
            this.jSplitPane2.setLeftComponent(this.jPanel7);
            this.jSplitPane2.setRightComponent(c);
            this.jPanelQueryArea.add((Component)this.jSplitPane2, "Center");
        }
        this.jPanelQueryArea.updateUI();
        this.jEditorPane1.requestFocusInWindow();
        this.jEditorPane1.requestFocus();
    }

    private void jButton2ActionPerformed1(ActionEvent evt) {
        IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
        if (conn == null || !(conn instanceof JRCSVDataSourceConnection)) {
            this.setColumnsError(I18n.getString("ReportQueryDialog.Message.Error4"));
            return;
        }
        JRCSVDataSourceConnection ic = (JRCSVDataSourceConnection)conn;
        try {
            Vector names = ic.getColumnNames();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int nd = 0; nd < names.size(); ++nd) {
                String fieldName = "" + names.elementAt(nd);
                JRDesignField field = new JRDesignField();
                field.setName(fieldName);
                field.setDescription("java.lang.String");
                field.setDescription("");
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getValueClassName());
                row.addElement(field.getDescription());
                dtm.addRow(row);
            }
            this.jTableFields.setRowSelectionInterval(0, names.size() - 1);
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
        if (conn == null || !(conn instanceof JRDataSourceProviderConnection)) {
            this.setColumnsError(I18n.getString("ReportQueryDialog.Message.Error5"));
            return;
        }
        JRDataSourceProviderConnection ic = (JRDataSourceProviderConnection)conn;
        try {
            JasperDesign report = IReportManager.getInstance().getActiveReport();
            JasperReport jr = new JasperReport((JRReport)report, "", null, null, "");
            JRField[] jrfields = ic.getDataSourceProvider().getFields(jr);
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int i = 0; i < jrfields.length; ++i) {
                Vector<Object> row = new Vector<Object>();
                row.addElement(jrfields[i]);
                row.addElement(jrfields[i].getValueClassName());
                row.addElement(jrfields[i].getDescription());
                dtm.addRow(row);
            }
        }
        catch (Exception ex) {
            this.setColumnsError("" + ex.getMessage());
        }
    }

    private void exportQueryButtonActionPerformed(ActionEvent evt) {
        FieldReader fr = new FieldReader(this.jEditorPane1.getText(), null);
        String query = fr.interpretQuery();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection fieldContent = new StringSelection(query);
        clipboard.setContents(fieldContent, this);
    }

    private void jButtonReadBeanAttributes3ActionPerformed(ActionEvent evt) {
        this.bip1.setClassName(this.jTextFieldBeanClass1.getText().trim());
    }

    protected void getFieldsFromClass(Class clazz, String path) throws Exception {
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getDeclaringClass().getName().equals(clazz.getName()) || Modifier.isNative(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") || methods[i].getReturnType().isPrimitive() || methods[i].getReturnType().isArray()) continue;
            String fieldName = methods[i].getName().substring(3);
            for (int f = 0; f < fields.length; ++f) {
                if (!fields[f].getName().equalsIgnoreCase(fieldName)) continue;
                fieldName = fields[f].getName();
                break;
            }
            String returnType = methods[i].getReturnType().getName();
            boolean found = false;
            for (int cc = 0; cc < standard_types.length; ++cc) {
                if (!returnType.equalsIgnoreCase(standard_types[cc])) continue;
                JRDesignField field = new JRDesignField();
                field.setName(fieldName);
                field.setValueClassName(returnType);
                field.setDescription(path + "" + fieldName);
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getValueClassName());
                row.addElement(field.getDescription());
                dtm.addRow(row);
                found = true;
                break;
            }
            if (found) continue;
            JRDesignField field = new JRDesignField();
            field.setName(fieldName);
            field.setValueClassName("java.lang.Object");
            field.setDescription(path + "" + fieldName);
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getValueClassName());
            row.addElement(field.getDescription());
            dtm.addRow(row);
            IReportManager.getInstance();
            Class<?> subClazz = Class.forName(returnType, true, IReportManager.getReportClassLoader());
            this.getFieldsFromClass(subClazz, path + fieldName + ".");
        }
    }

    private void automaticlyReadFieldsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.automaticlyReadFieldsCheckBox.isSelected()) {
            this.readFieldsButton.setEnabled(false);
            if (!this.isSettingSQLExpression) {
                this.processQueryChanged(this.jEditorPane1.getText().trim());
            }
        } else {
            this.readFieldsButton.setEnabled(true);
            this.jLabelStatusSQL.setText(I18n.getString("ReportQueryDialog.Label.StatusSQL6") + I18n.getString("ReportQueryDialog.Label.StatusSQL6B"));
        }
        IReportManager.getPreferences().putBoolean("UseAutoRegiesterFields", this.automaticlyReadFieldsCheckBox.isSelected());
    }

    private void readFieldsButtonActionPerformed(ActionEvent evt) {
        this.processQueryChanged(this.jEditorPane1.getText().trim());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        ++num;
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.stoppedChanging != null) {
                this.stoppedChanging.stop();
            }
            if (this.getDataset() != null) {
                ++num;
                Object obj = this.jComboBoxQueryType.getSelectedItem();
                JRDesignQuery query = new JRDesignQuery();
                if (obj != null && obj instanceof Tag) {
                    query.setLanguage("" + ((Tag)obj).getValue());
                } else {
                    query.setLanguage("" + obj);
                }
                query.setText(this.jEditorPane1.getText());
                this.dataset.setQuery(query);
                IReportManager.getInstance().notifyReportChange();
                if (this.jTableFields.getRowCount() > 0) {
                    this.dataset.getFieldsList().clear();
                    this.dataset.getFieldsMap().clear();
                    for (int i = 0; i < this.jTableFields.getRowCount(); ++i) {
                        JRDesignField field = (JRDesignField)this.jTableFields.getValueAt(i, 0);
                        Iterator iterFields = this.dataset.getFieldsList().iterator();
                        boolean found = false;
                        while (iterFields.hasNext()) {
                            JRDesignField f = (JRDesignField)iterFields.next();
                            if (!f.getName().equalsIgnoreCase(field.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        this.dataset.addField((JRField)field);
                    }
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ReportQueryDialog((Frame)new JFrame(), true).setVisible(true);
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(IReportManager.getReportClassLoader());
        interpreter.eval("import net.sf.jasperreports.engine.*;");
        interpreter.eval("import net.sf.jasperreports.engine.fill.*;");
        interpreter.eval("import java.util.*;");
        interpreter.eval("import java.math.*;");
        interpreter.eval("import java.text.*;");
        interpreter.eval("import java.io.*;");
        interpreter.eval("import java.net.*;");
        interpreter.eval("import java.util.*;");
        interpreter.eval("import net.sf.jasperreports.engine.*;");
        interpreter.eval("import net.sf.jasperreports.engine.data.*;");
        String[] imports = IReportManager.getInstance().getActiveReport().getImports();
        for (int i = 0; imports != null && i < imports.length; ++i) {
            interpreter.eval("import " + imports[i] + ";");
        }
        return interpreter;
    }

    private Class classStringToClass(String classType) {
        Class c = null;
        if (classType.equals("java.lang.String")) {
            c = String.class;
        } else if (classType.equals("java.lang.Integer")) {
            c = Integer.class;
        } else if (classType.equals("java.lang.Boolean")) {
            c = Boolean.class;
        } else if (classType.equals("java.lang.Byte")) {
            c = Byte.class;
        } else if (classType.equals("java.util.Date")) {
            c = Date.class;
        } else if (classType.equals("java.sql.Timestamp")) {
            c = Timestamp.class;
        } else if (classType.equals("java.sql.Time")) {
            c = Time.class;
        } else if (classType.equals("java.lang.Double")) {
            c = Double.class;
        } else if (classType.equals("java.lang.Float")) {
            c = Float.class;
        } else if (classType.equals("java.lang.Long")) {
            c = Long.class;
        } else if (classType.equals("java.lang.Short")) {
            c = Short.class;
        } else if (classType.equals("java.math.BigDecimal")) {
            c = BigDecimal.class;
        }
        return c;
    }

    public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, List parameters) throws EvalError {
        return ReportQueryDialog.recursiveInterpreter(interpreter, expression, parameters, 0);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, List parameters, int recursion_level) throws EvalError {
        return ReportQueryDialog.recursiveInterpreter(interpreter, expression, parameters, 0, null);
    }

    public static Object recursiveInterpreter(Interpreter interpreter, String expression, List parameters, int recursion_level, String this_param_name) throws EvalError {
        ++recursion_level;
        if (expression == null || expression.length() == 0) {
            return null;
        }
        if (recursion_level > 100) {
            return null;
        }
        if (expression != null && expression.trim().length() > 0) {
            while (expression.indexOf("$P{") >= 0) {
                int start_index = expression.indexOf("$P{") + 3;
                String param_name = expression.substring(start_index, expression.indexOf("}", start_index));
                String param_expression = "";
                for (int i = 0; i < parameters.size(); ++i) {
                    JRDesignParameter p = (JRDesignParameter)parameters.get(i);
                    if (!p.getName().equals(param_name)) continue;
                    param_expression = p.getDefaultValueExpression().getText();
                    break;
                }
                String param_name_literal = "param_" + JRStringUtil.getLiteral((String)param_name);
                expression = Misc.string_replace(param_name_literal, "$P{" + param_name + "}", expression);
                if (interpreter.get(param_name_literal) != null) continue;
                Object paramValue = ReportQueryDialog.recursiveInterpreter(interpreter, param_expression, parameters, recursion_level, this_param_name);
                interpreter.set(param_name_literal, paramValue);
            }
            String this_param_name_literal = "param_unknow";
            if (this_param_name != null) {
                this_param_name_literal = "param_" + JRStringUtil.getLiteral((String)this_param_name);
            }
            Object res = interpreter.eval(expression);
            interpreter.set(this_param_name_literal, res);
            return res;
        }
        return null;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataset(JRDesignDataset dataset) {
        this.isSettingSQLExpression = true;
        try {
            this.dataset = dataset;
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            ++num;
            this.jLabelStatusSQL.setText("");
            this.jEditorPane1.setText("");
            try {
                this.automaticlyReadFieldsCheckBox.setSelected(IReportManager.getPreferences().getBoolean("UseAutoRegiesterFields", true));
                this.automaticlyReadFieldsCheckBoxActionPerformed(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (dataset == null) {
                this.jEditorPane1.setText("");
            } else {
                String query = "";
                String language = "sql";
                if (this.dataset.getQuery() != null && this.dataset.getQuery().getText() != null) {
                    query = this.dataset.getQuery().getText();
                    language = this.dataset.getQuery().getLanguage();
                    if (language == null || language.length() == 0) {
                        language = "sql";
                    }
                }
                this.jEditorPane1.setText(query);
                ArrayList<Object[]> columns = new ArrayList<Object[]>();
                for (JRDesignField field : dataset.getFieldsList()) {
                    columns.add(new Object[]{field, field.getValueClassName(), field.getDescription()});
                }
                this.setColumns(columns);
                for (int ix = 0; ix < this.jComboBoxQueryType.getItemCount(); ++ix) {
                    if (this.jComboBoxQueryType.getItemAt(ix) instanceof Tag) continue;
                    this.jComboBoxQueryType.removeItemAt(ix);
                    --ix;
                }
                boolean found = false;
                for (int ix = 0; ix < this.jComboBoxQueryType.getItemCount(); ++ix) {
                    Tag t = (Tag)this.jComboBoxQueryType.getItemAt(ix);
                    String lang = ("" + t.getValue()).toLowerCase();
                    if (!lang.equals(language.toLowerCase())) continue;
                    found = true;
                    this.jComboBoxQueryType.setSelectedIndex(ix);
                    break;
                }
                if (!found) {
                    this.jComboBoxQueryType.setEditable(true);
                    this.jComboBoxQueryType.setSelectedItem(language);
                }
                this.jLabelStatusSQL.setText("");
            }
        }
        finally {
            this.isSettingSQLExpression = false;
        }
    }

    public JEditorPane getQueryEditorPane() {
        return this.jEditorPane1;
    }

    public JTable getFieldsTable() {
        return this.jTableFields;
    }

    public void openFilterExpressionDialog(boolean showAsError) {
        if (this.getDataset() == null) {
            return;
        }
        ExpressionEditor fed = new ExpressionEditor();
        fed.setExpressionContext(new ExpressionContext(this.getDataset()));
        String expText = "";
        if (this.getDataset().getFilterExpression() != null) {
            expText = this.getDataset().getFilterExpression().getText();
        }
        fed.setExpression(expText);
        if (fed.showDialog(this) == 0) {
            if (fed.getExpression().trim().length() == 0) {
                this.getDataset().setFilterExpression(null);
            } else {
                JRDesignExpression exp = new JRDesignExpression();
                exp.setText(fed.getExpression());
                exp.setValueClassName("java.lang.Boolean");
                this.getDataset().setFilterExpression((JRExpression)exp);
            }
        }
    }

    public void addField(JRDesignField field) {
        if (field == null) {
            return;
        }
        if (this.columnsErrorMsgLabel.isVisible()) {
            this.columnsErrorMsgLabel.setText("");
            this.jPanel2.remove(this.columnsErrorScrollPane);
            this.jPanel2.add((Component)this.columnsScrollPane, "Center");
            this.jPanel2.revalidate();
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            JRDesignField tmpField = (JRDesignField)dtm.getValueAt(i, 0);
            if (!tmpField.getName().equals(field.getName())) continue;
            return;
        }
        Vector<Object> row = new Vector<Object>();
        row.addElement(field);
        row.addElement(field.getValueClassName());
        row.addElement(field.getDescription());
        dtm.addRow(row);
        this.jTableFields.addRowSelectionInterval(this.jTableFields.getRowCount() - 1, this.jTableFields.getRowCount() - 1);
        this.jTableFields.updateUI();
    }

    class FieldReader
    extends Thread {
        String src_query;
        String src_query_language = "sql";
        IReportConnection conn;
        int elaborationID = 0;

        public FieldReader(String query, IReportConnection conn) {
            this(query, conn, "sql");
        }

        public FieldReader(String query, IReportConnection conn, String query_language) {
            this.src_query = query;
            this.conn = conn;
            this.src_query_language = query_language;
            this.elaborationID = ++elaborationSequence;
        }

        public void setColumnsFromWorker(final List columns) {
            try {
                Runnable r = new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jEditorPane1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setColumns(columns);
                        }
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(r);
                } else {
                    r.run();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setColumnErrorFromWork(final String error_msg) {
            try {
                Runnable r = new Runnable(){

                    public void run() {
                        String str = ReportQueryDialog.this.jEditorPane1.getText().trim();
                        if (str.compareTo(FieldReader.this.src_query) == 0) {
                            ReportQueryDialog.this.setColumnsError(error_msg);
                            ReportQueryDialog.this.jEditorPane1.requestFocusInWindow();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeAndWait(r);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String interpretQuery() {
            String query = this.src_query;
            try {
                Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                ArrayList queryParams = new ArrayList();
                for (JRDesignParameter parameter : ReportQueryDialog.this.dataset.getParametersList()) {
                    Object defValue;
                    String p1 = "$P{" + parameter.getName() + "}";
                    String p2 = "$P!{" + parameter.getName() + "}";
                    if (parameter.getDefaultValueExpression() != null && !parameter.getDefaultValueExpression().equals("")) {
                        String expText = "";
                        if (parameter.getDefaultValueExpression() != null) {
                            expText = parameter.getDefaultValueExpression().getText();
                        }
                        defValue = ReportQueryDialog.recursiveInterpreter(interpreter, expText, ReportQueryDialog.this.dataset.getParametersList(), 0, parameter.getName());
                    } else {
                        defValue = null;
                    }
                    int ip1 = query.indexOf(p1);
                    while (ip1 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException(I18n.getString("ReportQueryDialog.Message.Exception") + I18n.getString("ReportQueryDialog.Message.ExceptionB") + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip1);
                        String after = query.substring(ip1 + p1.length());
                        if (parameter.getValueClassName().equals("java.lang.String")) {
                            String stt = defValue.toString();
                            stt = Misc.string_replace("''", "'", stt);
                            query = before + "'" + stt + "'" + after;
                        } else {
                            query = before + "" + defValue.toString() + "" + after;
                        }
                        ip1 = query.indexOf(p1);
                    }
                    int ip2 = query.indexOf(p2);
                    while (ip2 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException(I18n.getString("ReportQueryDialog.Message.Exception") + I18n.getString("ReportQueryDialog.Message.ExceptionB") + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip2);
                        String after = query.substring(ip2 + p2.length());
                        query = before + "" + defValue.toString() + "" + after;
                        ip2 = query.indexOf(p2);
                    }
                }
                return query;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage());
                return "";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            FieldsProvider fp;
            int in;
            block15: {
                block14: {
                    ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(true);
                    String error_msg = "";
                    in = ++num;
                    fp = ReportQueryDialog.this.getFieldsProvider();
                    if (fp != null) break block14;
                    if (this.elaborationID != elaborationSequence) return;
                    ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(false);
                    return;
                }
                if (fp.hasEditorComponent()) {
                    FieldsProviderEditor editor = fp.getEditorComponent(ReportQueryDialog.this);
                    editor.queryChanged(this.src_query);
                }
                if (in >= num) break block15;
                if (this.elaborationID != elaborationSequence) return;
                ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(false);
                return;
            }
            try {
                List<JRField> columns;
                block18: {
                    JRField[] jrFields;
                    block17: {
                        HashMap<String, Object> parametersValues;
                        JRDesignDataset ds;
                        block16: {
                            if (!fp.supportsGetFieldsOperation()) return;
                            ds = new JRDesignDataset(ReportQueryDialog.this.getDataset().isMainDataset());
                            ds.getParametersList().addAll(ReportQueryDialog.this.getDataset().getParametersList());
                            ds.getVariablesList().addAll(ReportQueryDialog.this.getDataset().getVariablesList());
                            ds.getFieldsList().addAll(ReportQueryDialog.this.getDataset().getFieldsList());
                            JRDesignQuery query = new JRDesignQuery();
                            query.setLanguage(this.src_query_language);
                            query.setText(this.src_query);
                            ds.setQuery(query);
                            Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                            parametersValues = new HashMap<String, Object>();
                            for (int i = 0; i < ds.getParametersList().size(); ++i) {
                                JRDesignParameter param = (JRDesignParameter)ds.getParametersList().get(i);
                                Object defValue = param.getDefaultValueExpression() != null && !param.getDefaultValueExpression().getText().equals("") ? ReportQueryDialog.recursiveInterpreter(interpreter, param.getDefaultValueExpression().getText(), ReportQueryDialog.this.dataset.getParametersList(), 0, param.getName()) : null;
                                parametersValues.put(param.getName(), defValue);
                            }
                            if (in >= num) break block16;
                            if (this.elaborationID != elaborationSequence) return;
                            ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(false);
                            return;
                        }
                        jrFields = fp.getFields(this.conn, (JRDataset)ds, parametersValues);
                        if (in >= num) break block17;
                        if (this.elaborationID != elaborationSequence) return;
                        ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(false);
                        return;
                    }
                    columns = Arrays.asList(jrFields);
                    if (in >= num) break block18;
                    if (this.elaborationID != elaborationSequence) return;
                    ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(false);
                    return;
                }
                try {
                    this.setColumnsFromWorker(columns);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.setColumnErrorFromWork(I18n.getString("ReportQueryDialog.Message.Error3") + ex.getMessage());
                }
                ReportQueryDialog.this.getJLabelStatusSQL().setText(I18n.getString("ReportQueryDialog.Label.statusSQL"));
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (this.elaborationID == elaborationSequence) {
                    ((JXBusyLabel)ReportQueryDialog.this.getJLabelStatusSQL()).setBusy(false);
                }
            }
        }
    }
}

