/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ElementDecorator;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.borders.SimpleLineBorder;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class JRDesignElementWidget
extends Widget
implements PropertyChangeListener {
    private SelectionWidget selectionWidget = null;
    private ImageIcon crosstabImage = null;
    private ImageIcon subreportImage = null;
    private ImageIcon multiaxisImage = null;
    private boolean changing = false;
    JRDesignElement element = null;

    public JRDesignElement getElement() {
        return this.element;
    }

    public void setElement(JRDesignElement element) {
        this.element = element;
    }

    public JRDesignElementWidget(AbstractReportObjectScene scene, JRDesignElement element) {
        super((Scene)scene);
        this.element = element;
        this.setBorder(new SimpleLineBorder(this));
        this.updateBounds();
        try {
            if (this.crosstabImage == null) {
                this.crosstabImage = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/crosstab-32.png"));
            }
            if (this.subreportImage == null) {
                this.subreportImage = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/subreport-32.png"));
            }
            if (this.multiaxisImage == null) {
                this.multiaxisImage = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/chartaxis-32.png"));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.selectionWidget = new SelectionWidget(scene, this);
        this.notifyStateChanged(null, ObjectState.createNormal());
        this.selectionWidget.addDependency(new Widget.Dependency(){

            public void revalidateDependency() {
            }
        });
        element.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        if (element instanceof JRDesignGraphicElement) {
            JRDesignGraphicElement gele = (JRDesignGraphicElement)element;
            ((JRBasePen)gele.getLinePen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        if (element instanceof JRBoxContainer) {
            JRBoxContainer boxcontainer = (JRBoxContainer)element;
            JRBaseLineBox baseBox = (JRBaseLineBox)boxcontainer.getLineBox();
            baseBox.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getTopPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getBottomPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getLeftPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            ((JRBasePen)baseBox.getRightPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        this.selectionWidget.setVisible(state.isSelected());
        if (state.isSelected()) {
            this.selectionWidget.updateBounds();
        }
    }

    public void updateBounds() {
        JasperDesign jd = ((AbstractReportObjectScene)this.getScene()).getJasperDesign();
        Point location = this.convertModelToLocalLocation(new Point(this.element.getX(), this.element.getY()));
        location.x -= this.getBorder().getInsets().left;
        location.y -= this.getBorder().getInsets().top;
        this.setPreferredLocation(location);
        this.setPreferredBounds(new Rectangle(0, 0, this.element.getWidth() + this.getBorder().getInsets().left + this.getBorder().getInsets().right, this.element.getHeight() + this.getBorder().getInsets().top + this.getBorder().getInsets().bottom));
    }

    public SelectionWidget getSelectionWidget() {
        return this.selectionWidget;
    }

    public void setSelectionWidget(SelectionWidget selectionWidget) {
        this.selectionWidget = selectionWidget;
    }

    public Point convertLocalToModelLocation(Point p) {
        return this.convertLocalToModelLocation(p, true);
    }

    public Point convertLocalToModelLocation(Point p, boolean out) {
        JasperDesign jd = ((AbstractReportObjectScene)this.getScene()).getJasperDesign();
        Point base = ModelUtils.getParentLocation(jd, this.getElement());
        if (out) {
            base.x -= this.getBorder().getInsets().left;
            base.y -= this.getBorder().getInsets().top;
        }
        return new Point(p.x - base.x, p.y - base.y);
    }

    public Point convertModelToLocalLocation(Point p) {
        JasperDesign jd = ((AbstractReportObjectScene)this.getScene()).getJasperDesign();
        Point base = ModelUtils.getParentLocation(jd, this.getElement());
        return new Point(base.x + p.x, base.y + p.y);
    }

    protected final void paintWidget() {
        this.paintWidgetImplementation();
        this.paintWidgetExtra();
    }

    protected void paintWidgetImplementation() {
        super.paintWidget();
        Graphics2D gr = this.getScene().getGraphics();
        Rectangle r = this.getPreferredBounds();
        long t = new Date().getTime();
        AffineTransform af = gr.getTransform();
        AffineTransform new_af = (AffineTransform)af.clone();
        AffineTransform translate = AffineTransform.getTranslateInstance(this.getBorder().getInsets().left + r.x, this.getBorder().getInsets().top + r.y);
        new_af.concatenate(translate);
        gr.setTransform(new_af);
        JasperDesign jd = ((AbstractReportObjectScene)this.getScene()).getJasperDesign();
        JRDesignElement e = this.getElement();
        DrawVisitor dv = ((AbstractReportObjectScene)this.getScene()).getDrawVisitor();
        if (dv == null) {
            return;
        }
        if (e instanceof JRDesignCrosstab) {
            Composite oldComposite = gr.getComposite();
            gr.setComposite(AlphaComposite.getInstance(3, 0.5f));
            try {
                e.visit((JRVisitor)dv);
            }
            catch (Exception ex) {
                // empty catch block
            }
            gr.setComposite(oldComposite);
            Shape oldClip = gr.getClip();
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.element.getWidth(), this.element.getHeight());
            gr.clip(rect);
            gr.drawImage(this.crosstabImage.getImage(), 4, 4, null);
            gr.setClip(oldClip);
        } else if (e instanceof JRDesignSubreport) {
            Composite oldComposite = gr.getComposite();
            gr.fillRect(0, 0, this.element.getWidth(), this.element.getHeight());
            gr.setComposite(oldComposite);
            Shape oldClip = gr.getClip();
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.element.getWidth(), this.element.getHeight());
            gr.clip(rect);
            gr.drawImage(this.subreportImage.getImage(), 4, 4, null);
            gr.setClip(oldClip);
        } else if (e instanceof JRDesignChart && ((JRDesignChart)e).getChartType() == 19) {
            Composite oldComposite = gr.getComposite();
            gr.fillRect(0, 0, this.element.getWidth(), this.element.getHeight());
            gr.setComposite(oldComposite);
            Shape oldClip = gr.getClip();
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, this.element.getWidth(), this.element.getHeight());
            gr.clip(rect);
            gr.drawImage(this.multiaxisImage.getImage(), 4, 4, null);
            gr.setClip(oldClip);
        } else {
            dv.setGraphics2D(gr);
            try {
                e.visit((JRVisitor)dv);
            }
            catch (Exception ex) {
                System.err.println("iReport - Element rendering exception " + this.getElement() + " " + ex.getMessage());
            }
        }
        gr.setTransform(af);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isChanging()) {
            return;
        }
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("height") || propertyName.equals("width") || propertyName.equals("elementGroup") || propertyName.equals("x") || propertyName.equals("y") || propertyName.equals("backcolor") || propertyName.equals("forecolor") || propertyName.equals("parentStyle") || propertyName.equals("parentStyleNameReference") || propertyName.equals("mode") || propertyName.equals("fill") || propertyName.equals("direction") || propertyName.equals("radius") || propertyName.equals("horizontalAlignment") || propertyName.equals("verticalAlignment") || propertyName.equals("scaleImage") || propertyName.equals("fontName") || propertyName.equals("fontSize") || propertyName.equals("bold") || propertyName.equals("italic") || propertyName.equals("isStyledText") || propertyName.equals("underline") || propertyName.equals("strikeThrough") || propertyName.equals("rotation") || propertyName.equals("lineSpacing") || propertyName.equals("text") || propertyName.equals("expression") || propertyName.equals("pen") || propertyName.equals("linebox") || propertyName.equals("lineColor") || propertyName.equals("lineStyle") || propertyName.equals("lineWidth") || propertyName.equals("bottomPadding") || propertyName.equals("bottomPadding") || propertyName.equals("bottomPadding") || propertyName.equals("bottomPadding")) {
            this.updateBounds();
            this.repaint();
            this.getSelectionWidget().updateBounds();
            this.getSelectionWidget().revalidate(true);
            this.getScene().validate();
        }
        if (propertyName.equals("children") && this.getElement() instanceof JRElementGroup) {
            ((AbstractReportObjectScene)this.getScene()).refreshElementGroup((JRElementGroup)this.getElement());
        }
    }

    public synchronized boolean isChanging() {
        return this.changing;
    }

    public synchronized boolean setChanging(boolean changing) {
        boolean b = this.changing;
        this.changing = changing;
        return b;
    }

    private final void paintWidgetExtra() {
        IReportManager.getInstance();
        List<ElementDecorator> decorators = IReportManager.getElementDecorators(this.element);
        for (ElementDecorator decorator : decorators) {
            decorator.paintWidget(this);
        }
    }
}

