
#
# Copyright (C) 2004 Voluna Software. All rights reserved.
# Portions of this file are based on VA Linux's very old NetAttach's RPM spec file
#

%define of_user openfiler
%define of_passwd password
%define of_group openfiler
%define of_uid 94
%define of_gid 94
%define of_home /opt/%{name}

%define of_guest_user ofguest
%define of_guest_passwd password
%define of_guest_group ofguest
%define of_guest_uid 96
%define of_guest_gid 96
%define of_guest_home /mnt/%{name}

%define modified_files /etc/samba/smb.conf /etc/exports

Summary: Openfiler Storage Management Platform
Name: openfiler
Version: 1.1pre6
Release: 1
License: GPL
ExclusiveOS: Linux
Group: Applications/System
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
URL: http://www.openfiler.org/
Requires: httpd >= 2.0.47, samba >= 3.0.0, netatalk >= 1.5.5, sudo >= 1.6, nfs-utils >= 1.0.6, php-openfiler >= 0.1, php-pam-auth >= 4.0
#BuildPrereq: pam-devel >= 0.73, newt-devel, glib2-devel, python, python-devel
Vendor: The Openfiler Project


%description
Openfiler is a powerful, intuitive browser-based network storage management utility.
Openfiler, combined with the underlying Linux-based Operating System, delivers
file-based Network Attached Storage and block-based Storage Area Networking in
a single framework.


%prep
%setup -q


%build
make


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT


%clean
rm -rf $RPM_BUILD_ROOT


%post

# Backup files which may be modified
for i in %{modified_files}
do
	cp -f $i $i.openfiler-orig-backup
done

# Add the admin user account and group to the system
grep "^%{of_group}:" /etc/group &> /dev/null
if [ $? != 0 ]
then
	groupadd -g %{of_gid} %{of_group}
fi
grep "^%{of_user}:" /etc/passwd &> /dev/null
if [ $? != 0 ]
then
	useradd -M -u %{of_uid} -g %{of_gid} -d %{of_home} -s "%{of_home}/bin/ofconfig" -c "Openfiler Administrator" %{of_user}
	echo "%{of_user}:%{of_passwd}" | chpasswd
fi

# Add the guest user account and group to the system
grep "^%{of_guest_group}:" /etc/group &> /dev/null
if [ $? != 0 ]
then
	groupadd -g %{of_guest_gid} %{of_guest_group}
fi
grep "^%{of_guest_user}:" /etc/passwd &> /dev/null
if [ $? != 0 ]
then
	useradd -M -u %{of_guest_uid} -g %{of_guest_gid} -d %{of_guest_home} -s "/sbin/nologin" -c "Openfiler Guest User" %{of_guest_user}
	echo "%{of_guest_user}:%{of_guest_passwd}" | chpasswd
fi

# Set ownership and permissions on various paths
chown -R %{of_user}:%{of_group} %{of_home}
chgrp %{of_group} /etc/shadow
chmod g+r /etc/shadow

# Append OF account to 'ftpusers' to deny ftp connections
if [ -e /etc/ftpusers ]
then
	grep -v "^%{of_user}" /etc/ftpusers > /tmp/ftpusers
	echo "%{of_user}" >> /tmp/ftpusers
	cp -f /tmp/ftpusers /etc/ftpusers
	rm -f /tmp/ftpusers
else
	echo "%{of_user}" >> /etc/ftpusers
fi

# Add admin user to /etc/sudoers for root privs
# Using the mods below is pretty lax on the security side.. consider improving
if [ -e /etc/sudoers ]
then
	grep -v "^%{of_user}" /etc/sudoers > /tmp/sudoers
	echo "%{of_user}	ALL = NOPASSWD: ALL" >> /tmp/sudoers
	cp -f /tmp/sudoers /etc/sudoers
	rm -f /tmp/sudoers
else
	echo "%{of_user}	ALL = NOPASSWD: ALL" >> /etc/sudoers
fi

# Add account's shell to /etc/shells
if [ -e /etc/shells ]
then
	grep -v "%{of_home}/bin/ofconfig" /etc/shells > /tmp/shells
	echo "%{of_home}/bin/ofconfig" >> /tmp/shells
	cp /tmp/shells /etc/shells
	rm /tmp/shells
else
	echo "%{of_home}/bin/ofconfig" >> /etc/shells
fi

# Add openfiler init.d rc script
chkconfig --add %{name}

# Turn off network filesystem services by default
chkconfig smb off
chkconfig nfs off
chkconfig atalk off

# Turn off iptables
chkconfig iptables off

# Turn off nscd as it doesn't work well with Winbind for a start
chkconfig nscd off

# Turn on the port mapper, nfslock, atd and openfiler
chkconfig portmap on
chkconfig nfslock on
chkconfig atd on
chkconfig openfiler on

# Create default smb.conf
grep -i %{name} /etc/samba/smb.conf &> /dev/null
if [ $? != 0 ] || [ ! -e /etc/samba/smb.conf ]
then
    cat > /etc/samba/smb.conf <<EOF
#
# PLEASE DO NOT MODIFY THIS CONFIGURATION FILE!
#   This configuration file was auto-generated
#   by Openfiler. Please do not modify it.
#

# Global settings

workgroup = SOMEGROUP
guest account = nobody
log file = /var/log/samba/%m.log
max log size = 0
security = domain
hosts deny = all
encrypt passwords = yes
smb passwd file = /etc/samba/smbpasswd
unix password sync = yes
passwd program = /usr/bin/passwd %u
passwd chat = *New*password* %n\n *Retype*new*password* %n\n *passwd:*all*authentication*tokens*updated*successfully*
pam password change = yes
obey pam restrictions = yes
socket options = TCP_NODELAY SO_RCVBUF=8192 SO_SNDBUF=8192
load printers = no

EOF
fi

if [ ! -e %{of_home}/etc/networks.xml ]
then
    cat > %{of_home}/etc/networks.xml <<EOF
<?xml version="1.0" ?>
<networks>
</networks>

EOF
fi

if [ ! -e %{of_home}/etc/smb_settings.xml ]
then
    cat > %{of_home}/etc/smb_settings.xml <<EOF
<?xml version="1.0" ?>
<smb>
	<serverstring value="Openfiler NAS" />
	<encryptedpasswords value="on" />
</smb>

EOF
fi

if [ ! -e %{of_home}/etc/volumes.xml ]
then
    cat > %{of_home}/etc/volumes.xml <<EOF
<?xml version="1.0" ?>
<volumes>
</volumes>

EOF
fi

# Blank /etc/exports
echo "" > /etc/exports

# Update NFS exports
exportfs -r

cd %{of_home}/etc/httpd
ln -s /etc/httpd/build
mkdir logs
ln -s /etc/httpd/modules
mkdir run
mkdir -p %{of_home}/var/lock/subsys

%preun

if [ $1 -eq 0 ]
then

	service openfiler stop
	service smb stop
	service nfs stop
	service nfslock stop
	service httpd stop

	rm -rf %{of_home}/var/lock/subsys
	rm -rf %{of_home}/etc/httpd/logs
	rm -rf %{of_home}/etc/httpd/run
	rm -f %{of_home}/etc/httpd/build
	rm -f %{of_home}/etc/httpd/modules

	chkconfig smb off
	chkconfig nfs off
	chkconfig atalk off
	chkconfig portmap off
	chkconfig openfiler off
	
	# Turn off init.d rc script
	chkconfig --del %{name}

	# Remove admin account from ftpusers
	grep -v "^%{of_user}" /etc/ftpusers > /tmp/ftpusers
	cp -f /tmp/ftpusers /etc/ftpusers
	rm -f /tmp/ftpusers

	# Remove of user from /etc/sudoers and cleanup
	grep -v "^%{of_user}" /etc/sudoers > /tmp/sudoers
	cp -f /tmp/sudoers /etc/sudoers
	rm -f /tmp/sudoers
	rm -rf /var/run/sudo/%{of_user}

	# Remove ofconfig from /etc/shells
	grep -v "ofconfig" /etc/shells > /tmp/shells
	cp -f /tmp/shells /etc/shells
	rm -f /tmp/shells
	
	# Restore orig system files
	for i in %{modified_files}
	do
		mv -f $i.openfiler-orig-backup $i
	done
fi

%postun

if [ $1 -eq 0 ]
then

	# Delete admin user and group accounts
	userdel %{of_user}
	userdel %{of_guest_user}
	# groupdel %{of_group} -- should not be necessary -- userdel should get rid of it
	# groupdel %{of_guest_group} -- should not be necessary -- userdel should get rid of it
	
fi

%files
%{of_home}/*
/etc/rc.d/init.d/openfiler

#----------------------------------------------------------------------------

%changelog
* Fri Jan 09 2004 Mukund Sivaraman <muks@xinitsystems.com>
- Adopted for GPL'd Openfiler

