/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.option.PropertyOption;
import org.apache.commons.cli2.util.HelpFormatter;

final class CmdLine {
    private final MainApp app;
    private Map<String, String> properties = new HashMap<String, String>(2);
    private boolean resetOptions;
    private boolean minimize;
    private boolean nosplash;

    CmdLine(MainApp mainApp) {
        this.app = mainApp;
        this.resetOptions = false;
        this.minimize = false;
        this.nosplash = false;
    }

    private void showVersion() {
        System.out.println("FreeRapid 0.83u1");
        System.out.println("Authors (c) 2008/09 Vity");
        this.app.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> processCommandLine(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        String string = Utils.getAppPath();
        File file = new File(string, "startup.properties");
        if (file.exists() && file.isFile() && file.canRead()) {
            object3 = null;
            object2 = new LinkedList();
            try {
                object3 = new Scanner(file);
                while (((Scanner)object3).hasNextLine()) {
                    object = ((Scanner)object3).nextLine().trim();
                    if (((String)object).isEmpty() || ((String)object).startsWith("#")) continue;
                    object2.add(object);
                }
                if (!object2.isEmpty()) {
                    object2.addAll(Arrays.asList(stringArray));
                    stringArray = new String[object2.size()];
                    object2.toArray(stringArray);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (object3 != null) {
                    ((Scanner)object3).close();
                }
            }
        }
        if (stringArray.length == 0) {
            return new LinkedList<String>();
        }
        object3 = new DefaultOptionBuilder();
        object2 = new GroupBuilder();
        object = object3.withShortName("h").withShortName("?").withLongName("help").withDescription("print this message").create();
        DefaultOption defaultOption = object3.withShortName("v").withLongName("version").withDescription("print the version information and exit").create();
        DefaultOption defaultOption2 = object3.withShortName("d").withLongName("debug").withDescription("print debugging information").create();
        DefaultOption defaultOption3 = object3.withShortName("r").withLongName("reset").withDescription("reset user properties to default values").create();
        DefaultOption defaultOption4 = object3.withShortName("m").withLongName("minim").withDescription("minimize main window on start").create();
        DefaultOption defaultOption5 = object3.withShortName("p").withLongName("portable").withDescription("configuration files will be stored in the 'config' folder, all file paths will be saved relatively to FRD folder (if possible) - useful for USB FLASH drives").create();
        DefaultOption defaultOption6 = object3.withShortName("s").withLongName("nosplash").withDescription("splash screen will be hidden as soon as possible").create();
        PropertyOption propertyOption = new PropertyOption();
        Group group = object2.withName("options").withOption((Option)object).withOption((Option)defaultOption).withOption((Option)defaultOption2).withOption((Option)defaultOption3).withOption((Option)propertyOption).withOption((Option)defaultOption4).withOption((Option)defaultOption6).withOption((Option)defaultOption5).create();
        Parser parser = new Parser();
        parser.setGroup(group);
        try {
            CommandLine commandLine = parser.parse(stringArray);
            if (commandLine.hasOption((Option)object)) {
                this.printHelp(group);
            } else if (commandLine.hasOption((Option)defaultOption)) {
                this.showVersion();
            } else if (commandLine.hasOption((Option)defaultOption2)) {
                MainApp.debug = true;
            }
            if (commandLine.hasOption((Option)defaultOption3)) {
                this.resetOptions = true;
            }
            if (commandLine.hasOption((Option)defaultOption4)) {
                this.minimize = true;
            }
            if (commandLine.hasOption((Option)defaultOption6)) {
                this.nosplash = true;
            }
            if (commandLine.hasOption((Option)defaultOption5)) {
                System.getProperties().put("portable", (Object)true);
            }
            Set set = commandLine.getProperties((Option)propertyOption);
            for (String string2 : set) {
                this.properties.put(string2, commandLine.getProperty((Option)propertyOption, string2, ""));
            }
        }
        catch (OptionException optionException) {
            optionException.printStackTrace();
            this.printHelp(group);
            System.exit(-1);
        }
        return new LinkedList<String>();
    }

    private void printHelp(Group group) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.getDisplaySettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        helpFormatter.setGroup(group);
        helpFormatter.setShellCommand("frd");
        helpFormatter.getLineUsageSettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        helpFormatter.setFooter("\nmin. Java version required : 1.6");
        helpFormatter.print();
        this.app.exit();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isResetOptions() {
        return this.resetOptions;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public boolean isNosplash() {
        return this.nosplash;
    }
}

