/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.CmdLine;
import cz.vity.freerapid.core.Lng;
import cz.vity.freerapid.core.OneInstanceClient;
import cz.vity.freerapid.core.UIStringsManager;
import cz.vity.freerapid.core.application.GlobalEDTExceptionHandler;
import cz.vity.freerapid.core.application.ListItemsConvertor;
import cz.vity.freerapid.core.tasks.CheckForNewVersionTask;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.LookAndFeels;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.TrayIconSupport;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.SplashScreen;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ProxySelector;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.appframework.swingx.SingleXFrameApplication;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceConverter;

public class MainApp
extends SingleXFrameApplication {
    private ManagerDirector director;
    static boolean debug = false;
    private TrayIconSupport trayIconSupport = null;
    private AppPrefs appPrefs;
    private boolean minimizeOnStart = false;

    @Override
    protected void initialize(String[] stringArray) {
        Object object;
        Object object2;
        if (this.checkInvalidPath()) {
            return;
        }
        CmdLine cmdLine = new CmdLine(this);
        List<String> list = cmdLine.processCommandLine(stringArray);
        try {
            object2 = SplashScreen.getSplashScreen();
            if (object2 != null && cmdLine.isNosplash()) {
                ((SplashScreen)object2).close();
            }
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        try {
            LogUtils.initLogging(debug ? "logdebug.properties" : "logdefault.properties");
        }
        catch (Exception exception) {
            object = this.getLogger();
            ((Logger)object).log(Level.SEVERE, exception.getMessage());
        }
        this.minimizeOnStart = cmdLine.isMinimize();
        object2 = System.getProperty("java.vm.vendor", "");
        if (((String)object2).toLowerCase(Locale.ENGLISH).contains("gcj")) {
            this.getLogger().log(Level.SEVERE, "Not using Sun Java" + (String)object2);
            this.exitWithErrorMessage(String.format("You are not using Sun Java, but %s. See readme.txt for minimal requirements to run FreeRapid Downloader.", object2), new Object[0]);
        }
        object = cmdLine.getProperties();
        if (Utils.isWindows() && (new File("C:/Program files/Eset").exists() || new File("D:/Program files/Eset").exists()) && !object.containsKey("oneinstance")) {
            this.getLogger().info("Detecting ESET - disabling OneInstance functionality");
            object.put("oneinstance", "false");
        }
        try {
            this.appPrefs = new AppPrefs(this.getContext(), (Map<String, String>)object, cmdLine.isResetOptions());
        }
        catch (IllegalStateException illegalStateException) {
            this.getLogger().log(Level.SEVERE, illegalStateException.getMessage());
            this.exitWithErrorMessage("Fatal Error - not all required libraries are available.\nYou probably didn't extract the zip file properly.\nYou have to have /lib directory with all libraries in the FreeRapid directory.\nExiting.", new Object[0]);
        }
        this.checkBugs();
        System.getProperties().put("arguments", stringArray);
        System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(AppPrefs.getProperty("apple.laf.useScreenMenuBar", true)));
        if (OneInstanceClient.checkInstance(list, this.appPrefs, this.getContext())) {
            this.exit();
            return;
        }
        this.getContext().getResourceMap();
        ResourceConverter.register(new ListItemsConvertor());
        this.getContext().getTaskMonitor().setAutoUpdateForegroundTask(false);
        Lng.loadLangProperties();
        LookAndFeels.getInstance().loadLookAndFeelSettings();
        super.initialize(stringArray);
    }

    private boolean checkInvalidPath() {
        String string = Utils.getAppPath();
        int n = string.indexOf(43);
        if (n == -1) {
            n = string.indexOf("!/");
        }
        if (n == -1) {
            n = string.indexOf("!\\");
        }
        if (n > 0 || string.endsWith("!")) {
            String string2 = String.format("This application cannot be started on the path containing '+' or '!' characters ('%s'...)\nPlease move FRD's folder to another place.\nSorry for inconvenience. Exiting.", string.substring(0, n + 1));
            JOptionPane.showMessageDialog(null, string2, "Error", 0);
            this.getLogger().severe(string2);
            System.exit(-1);
            return true;
        }
        return false;
    }

    private Logger getLogger() {
        return Logger.getLogger(MainApp.class.getName());
    }

    private void checkBugs() {
        String string = System.getProperty("java.version");
        this.getLogger().info("You are running FRD with JVM version = " + System.getProperty("java.version") + " - (min 1.6.0_07 is required)");
        if (string.equals("1.6.0_0") || System.getProperty("java.version").equals("1.6.0-beta")) {
            this.exitWithErrorMessage("errorInvalidJRE", new Object[0]);
        }
    }

    private void exitWithErrorMessage(String string, Object ... objectArray) {
        this.getLogger().severe(string);
        Swinger.showErrorMessage(this.getContext().getResourceMap(), string, objectArray);
        System.exit(-1);
    }

    @Override
    protected void startup() {
        super.startup();
        this.director = new ManagerDirector(this.getContext());
        this.director.initComponents();
        UIStringsManager.load(this.getContext().getResourceManager());
        this.initMainFrame();
        this.addExitListener(new MainAppExitListener());
        JFrame jFrame = this.getMainFrame();
        this.show(jFrame);
        this.getTrayIconSupport().setVisibleByDefault();
        this.setGlobalEDTExceptionHandler();
        if (this.minimizeOnStart) {
            Swinger.minimize(jFrame);
        }
    }

    private void initMainFrame() {
        ProxySelector.setDefault(null);
        JFrame jFrame = this.getMainFrame();
        jFrame.setVisible(false);
        if (AppPrefs.getProperty("decoratedFrames", false)) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            jFrame.setUndecorated(true);
            jFrame.getRootPane().setWindowDecorationStyle(1);
            LookAndFeels.updateWindowUI(jFrame);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
        jFrame.setJMenuBar(this.director.getMenuManager().getMenuBar());
        jFrame.setContentPane(this.director.getComponent());
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        jFrame.getJMenuBar().applyComponentOrientation(componentOrientation);
        jFrame.getContentPane().applyComponentOrientation(componentOrientation);
        jFrame.setMinimumSize(new Dimension(30, 30));
        jFrame.pack();
        if (AppPrefs.getProperty("checkForNewVersionAuto", true) && !debug) {
            this.startCheckNewVersion();
        }
    }

    private void setGlobalEDTExceptionHandler() {
        GlobalEDTExceptionHandler globalEDTExceptionHandler = new GlobalEDTExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(globalEDTExceptionHandler);
        Thread.currentThread().setUncaughtExceptionHandler(globalEDTExceptionHandler);
    }

    public ManagerDirector getManagerDirector() {
        assert (this.director != null);
        return this.director;
    }

    public static void main(String[] stringArray) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "FreeRapid Downloader");
        Application.launch(MainApp.class, stringArray);
    }

    public static ApplicationContext getAContext() {
        return Application.getInstance(MainApp.class).getContext();
    }

    private void startCheckNewVersion() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(30000L);
                    MainApp.this.getContext().getTaskService().execute(new CheckForNewVersionTask(false));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public TrayIconSupport getTrayIconSupport() {
        if (this.trayIconSupport == null) {
            this.trayIconSupport = new TrayIconSupport();
        }
        return this.trayIconSupport;
    }

    public AppPrefs getAppPrefs() {
        return this.appPrefs;
    }

    private class MainAppExitListener
    implements Application.ExitListener {
        private MainAppExitListener() {
        }

        @Override
        public boolean canExit(EventObject eventObject) {
            if (AppPrefs.getProperty("minimizeOnClose", false) && eventObject instanceof WindowEvent) {
                Swinger.minimize(MainApp.this.getMainFrame());
                return false;
            }
            return true;
        }

        @Override
        public void willExit(EventObject eventObject) {
            MainApp.this.appPrefs.store();
        }
    }
}

