/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.xmlimport.XMLBind;
import cz.vity.freerapid.xmlimport.ver1.Plugin;
import cz.vity.freerapid.xmlimport.ver1.Plugins;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.java.plugin.registry.Version;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

public class CheckPluginUpdateTask
extends CoreTask<List<Plugin>, Void> {
    private static final Logger logger = Logger.getLogger(CheckPluginUpdateTask.class.getName());
    private final ManagerDirector director;
    private final boolean quietMode;
    private static final String VERSION__PARAM = "version";
    private static final String PRODUCT_PARAM = "product";
    private static final String APIVERSION_PARAM = "apiversion";
    private static int failed = 0;

    public CheckPluginUpdateTask(ManagerDirector managerDirector, ApplicationContext applicationContext, boolean bl) {
        super(applicationContext.getApplication());
        this.director = managerDirector;
        this.quietMode = bl;
        logger.info("Starting to check for a new plugins version");
        this.setTaskToForeground();
        if (!bl) {
            this.setInputBlocker(new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, Swinger.getActiveFrame(), null));
        } else {
            this.setInputBlocker(null);
        }
    }

    @Override
    protected List<Plugin> doInBackground() throws Exception {
        Object object;
        GetMethod getMethod;
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        if (failed > 6) {
            return arrayList;
        }
        AppPrefs.storeProperty("pluginLastUpdateDateTime", System.currentTimeMillis());
        this.message("updatesPluginCheck", new Object[0]);
        ClientManager clientManager = this.director.getClientManager();
        List<ConnectionSettings> list = clientManager.getEnabledConnections();
        if (list.isEmpty()) {
            throw new NoAvailableConnection(this.getResourceMap().getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient downloadClient = new DownloadClient();
        downloadClient.initClient(list.get(0));
        String string = AppPrefs.getProperty("pluginCheckUrlSelected", "http://wordrider.net/freerapid/pluginsCheck.php");
        if (string.toLowerCase().endsWith(".xml")) {
            getMethod = downloadClient.getGetMethod(string);
        } else {
            object = downloadClient.getPostMethod(string);
            object.addParameter(PRODUCT_PARAM, "FreeRapid");
            object.addParameter(VERSION__PARAM, "0.83u1");
            object.addParameter(APIVERSION_PARAM, "0.83");
            getMethod = object;
        }
        this.message("message.connecting", new Object[0]);
        if (downloadClient.makeRequest((HttpMethod)getMethod, true) != 200) {
            throw new ConnectException(this.getResourceMap().getString("Connection_failed", new Object[0]));
        }
        this.message("message.checkingData", new Object[0]);
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
        object = new XMLBind().loadPluginList(downloadClient.getContentAsString());
        List<Plugin> list2 = ((Plugins)object).getPlugin();
        PluginsManager pluginsManager = this.director.getPluginsManager();
        for (Plugin plugin : list2) {
            String string2 = plugin.getId();
            Version version = Version.parse((String)plugin.getVersion());
            plugin.setVersion(version.toString());
            if (pluginsManager.hasPlugin(string2)) {
                Version version2 = Version.parse((String)pluginsManager.getPluginMetadata(string2).getVersion());
                logger.info("id = " + string2 + "  oldVersion = " + version2 + "  newVersion = " + version);
                if (!version.isGreaterThan(version2)) continue;
                arrayList.add(plugin);
                continue;
            }
            logger.info("found new plugin with id =" + string2);
            arrayList.add(plugin);
        }
        return arrayList;
    }

    @Override
    protected void failed(Throwable throwable) {
        LogUtils.processException(logger, throwable);
        ++failed;
        if (this.quietMode) {
            AppPrefs.storeProperty("pluginLastUpdateDateTime", -1);
            return;
        }
        if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", throwable.getMessage());
        }
    }

    @Override
    protected void succeeded(List<Plugin> list) {
        for (Plugin plugin : list) {
            logger.info("plugin update from server: " + plugin.getId());
        }
    }
}

