/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.core.tasks.exceptions.UpdateFailedException;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

public class DownloadNewPluginsTask
extends DownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadNewPluginsTask.class.getName());
    private final ManagerDirector director;
    private final List<DownloadFile> fileList;
    private ScreenInputBlocker blocker;

    public DownloadNewPluginsTask(ManagerDirector managerDirector, ApplicationContext applicationContext, List<DownloadFile> list) {
        super(applicationContext.getApplication());
        this.director = managerDirector;
        this.fileList = list;
        this.blocker = new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, Swinger.getActiveFrame(), null);
        this.setInputBlocker(this.blocker);
        this.setUseRelativeStoreFileIfPossible(false);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.message("downloadNewPluginsTask", new Object[0]);
        ClientManager clientManager = this.director.getClientManager();
        List<ConnectionSettings> list = clientManager.getEnabledConnections();
        if (list.isEmpty()) {
            throw new NoAvailableConnection(this.getResourceMap().getString("noAvailableConnection", new Object[0]));
        }
        this.client = new DownloadClient();
        this.client.initClient(list.get(0));
        this.initDownloadThread();
        File file = this.director.getPluginsManager().getPluginsDir();
        boolean bl = false;
        for (DownloadFile downloadFile : this.fileList) {
            if (this.isCancelled()) break;
            try {
                this.setDownloadFile(downloadFile);
                this.downloadFile.setSaveToDirectory(file);
                this.processFile(downloadFile);
                bl = true;
            }
            catch (Exception exception) {
                downloadFile.setState(DownloadState.ERROR);
                this.setFileErrorMessage(exception);
                LogUtils.processException(logger, exception);
            }
        }
        if (!bl) {
            throw new UpdateFailedException("UpdateFailed");
        }
        return null;
    }

    private void processFile(DownloadFile downloadFile) throws Exception {
        GetMethod getMethod = this.client.getGetMethod(downloadFile.getFileUrl().toExternalForm());
        InputStream inputStream = this.client.makeRequestForFile((HttpMethod)getMethod);
        if (this.isCancelled()) {
            return;
        }
        if (inputStream != null) {
            this.saveToFile(inputStream);
            this.checkRewrite(downloadFile);
            if (this.isCancelled()) {
                return;
            }
        } else {
            throw new IOException("FileWasNotFoundOnServer");
        }
        downloadFile.setState(DownloadState.COMPLETED);
    }

    @Override
    protected void cancelled() {
        super.cancelled();
        for (DownloadFile downloadFile : this.fileList) {
            if (downloadFile.getState() == DownloadState.COMPLETED) continue;
            downloadFile.setState(DownloadState.CANCELLED);
        }
    }

    private void checkRewrite(DownloadFile downloadFile) throws IOException {
        boolean bl;
        File file;
        File file2 = downloadFile.getOutputFile();
        if (file2.exists()) {
            file2.delete();
        }
        if ((file = downloadFile.getStoreFile()) != null && !(bl = file.renameTo(file2))) {
            throw new IOException("Renaming target file failed " + downloadFile.getStoreFile() + " ->" + file2);
        }
    }

    @Override
    protected int checkExists() throws InvocationTargetException, InterruptedException {
        return -2;
    }

    @Override
    protected boolean useTemporaryFiles() {
        return true;
    }

    @Override
    protected void failed(Throwable throwable) {
        LogUtils.processException(logger, throwable);
        if (this.handleRuntimeException(throwable)) {
            return;
        }
        this.error(throwable);
        if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), throwable);
        }
    }

    @Override
    protected void succeeded(Void void_) {
        this.blocker.unblock();
        int n = Swinger.getChoiceYesNo(this.getResourceMap().getString("installed", new Object[0]));
        if (n == 0) {
            this.director.getMenuManager().getFileActions().restartApplication();
        }
    }
}

