/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

public final class LinksAddedTask
extends CoreTask<Void, Void> {
    private final List<DownloadFile> list;
    private static final String ALL_LINKS_FILENAME = "links.txt";
    private static final Logger logger = Logger.getLogger(LinksAddedTask.class.getName());

    public LinksAddedTask(ApplicationContext applicationContext, List<DownloadFile> list) {
        super(applicationContext.getApplication());
        this.list = list;
        this.message("", new Object[0]);
        this.setUserCanCancel(false);
        this.setDescription("");
        this.setMessage("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        String string = this.getStringRepresentation();
        byte[] byArray = string.getBytes();
        if (byArray.length <= 0) {
            return null;
        }
        OutputStream outputStream = null;
        LocalStorage localStorage = this.getContext().getLocalStorage();
        File file = localStorage.getDirectory();
        if (!file.isDirectory() && !file.mkdirs()) {
            return null;
        }
        File file2 = new File(file, ALL_LINKS_FILENAME);
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file2, true));
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return null;
    }

    public String getStringRepresentation() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new SimpleDateFormat("yyyy-MM-dd HH:mm ").format(Calendar.getInstance().getTime());
        String string2 = Utils.getSystemLineSeparator();
        for (DownloadFile downloadFile : this.list) {
            String string3 = downloadFile.getDescription();
            if (string3 != null && !downloadFile.getDescription().isEmpty()) {
                stringBuilder.append(" [").append(string3).append("]");
            }
            stringBuilder.append(string).append(downloadFile.getFileUrl().toExternalForm());
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

