/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.application.SubmitErrorInfo;
import cz.vity.freerapid.core.tasks.CheckPluginUpdateTask;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import java.net.ConnectException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

public class SubmitErrorInfoTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(SubmitErrorInfoTask.class.getName());
    private final SubmitErrorInfo errorInfo;

    public SubmitErrorInfoTask(SubmitErrorInfo submitErrorInfo) {
        super(Application.getInstance());
        this.errorInfo = submitErrorInfo;
        this.setUserCanCancel(false);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.message("message.connecting", new Object[0]);
        String string = AppPrefs.getProperty("weburlSubmitError", "http://wordrider.net/posterror.php");
        ClientManager clientManager = ((MainApp)this.getApplication()).getManagerDirector().getClientManager();
        List<ConnectionSettings> list = clientManager.getEnabledConnections();
        ResourceMap resourceMap = this.getApplication().getContext().getResourceMap(CheckPluginUpdateTask.class);
        if (list.isEmpty()) {
            throw new NoAvailableConnection(resourceMap.getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient downloadClient = new DownloadClient();
        downloadClient.initClient(list.get(0));
        PostMethod postMethod = downloadClient.getPostMethod(string);
        this.errorInfo.toURLPostData(postMethod);
        logger.info("Connected to the web, Writing params");
        this.message("message.sending", new Object[0]);
        if (downloadClient.makeRequest((HttpMethod)postMethod, true) != 200) {
            throw new ConnectException(resourceMap.getString("Connection_failed", new Object[0]));
        }
        logger.info("disconnecting");
        this.message("message.disconnect", new Object[0]);
        return null;
    }
}

