/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.actions.URLTransferHandler;
import cz.vity.freerapid.gui.content.AverageSpeedCellRenderer;
import cz.vity.freerapid.gui.content.CheckedCellRenderer;
import cz.vity.freerapid.gui.content.ConnectionCellRenderer;
import cz.vity.freerapid.gui.content.CustomTableModel;
import cz.vity.freerapid.gui.content.EstTimeCellRenderer;
import cz.vity.freerapid.gui.content.NameURLCellRenderer;
import cz.vity.freerapid.gui.content.ProgressBarCellRenderer;
import cz.vity.freerapid.gui.content.ProgressCellRenderer;
import cz.vity.freerapid.gui.content.ServiceCellRenderer;
import cz.vity.freerapid.gui.content.SizeCellRenderer;
import cz.vity.freerapid.gui.content.SpeedCellRenderer;
import cz.vity.freerapid.gui.content.comparators.AvgSpeedColumnComparator;
import cz.vity.freerapid.gui.content.comparators.CheckedColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ConnectionColumnComparator;
import cz.vity.freerapid.gui.content.comparators.EstTimeColumnComparator;
import cz.vity.freerapid.gui.content.comparators.NameColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ProgressBarColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ProgressColumnComparator;
import cz.vity.freerapid.gui.content.comparators.ServiceColumnComparator;
import cz.vity.freerapid.gui.content.comparators.SizeColumnComparator;
import cz.vity.freerapid.gui.content.comparators.SpeedColumnComparator;
import cz.vity.freerapid.gui.dialogs.InformationDialog;
import cz.vity.freerapid.gui.dialogs.MultipleSettingsDialog;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.components.FindTableAction;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.OSDesktop;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultRowSorter;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.table.TableColumnExt;

public class ContentPanel
extends JPanel
implements ListSelectionListener,
ListDataListener,
PropertyChangeListener,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ContentPanel.class.getName());
    private static final int COLUMN_CHECKED = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_PROGRESSBAR = 2;
    private static final int COLUMN_PROGRESS = 3;
    private static final int COLUMN_STATE = 4;
    private static final int COLUMN_SIZE = 5;
    private static final int COLUMN_SPEED = 6;
    private static final int COLUMN_AVERAGE_SPEED = 7;
    private static final int COLUMN_SERVICE = 8;
    private static final int COLUMN_PROXY = 9;
    private final ApplicationContext context;
    private final ManagerDirector director;
    private final DataManager manager;
    private boolean cancelActionEnabled = false;
    private static final String CANCEL_ACTION_ENABLED_PROPERTY = "cancelActionEnabled";
    private boolean resumeActionEnabled = false;
    private static final String RESUME_ACTION_ENABLED_PROPERTY = "resumeActionEnabled";
    private boolean removeCompletedActionEnabled = false;
    private static final String REMOVECOMPLETED_ACTION_ENABLED_PROPERTY = "removeCompletedActionEnabled";
    private boolean pauseActionEnabled = false;
    private static final String PAUSE_ACTION_ENABLED_PROPERTY = "pauseActionEnabled";
    private boolean completeWithFilesEnabled = false;
    private static final String COMPLETED_OK_ACTION_ENABLED_PROPERTY = "completeWithFilesEnabled";
    private boolean selectedEnabled = false;
    private static final String SELECTED_ACTION_ENABLED_PROPERTY = "selectedEnabled";
    private boolean nonEmptyEnabled = false;
    private static final String NONEMPTY_ACTION_ENABLED_PROPERTY = "nonEmptyEnabled";
    private boolean validateLinksEnabled = false;
    private static final String VALIDATELINKS_ACTION_ENABLED_PROPERTY = "validateLinksEnabled";
    private boolean removeInvalidLinksActionEnabled = false;
    private static final String REMOVEINVALID_ACTION_ENABLED_PROPERTY = "removeInvalidLinksActionEnabled";
    private JXTable table;
    private static String[] states;
    private static final NumberFormat integerInstance;
    private static final NumberFormat numberFormatInstance;
    private static final String MOVEENABLED_ACTION_ENABLED_PROPERTY = "moveEnabled";
    private boolean moveEnabled = false;

    public ContentPanel(ApplicationContext applicationContext, ManagerDirector managerDirector) {
        this.context = applicationContext;
        this.director = managerDirector;
        this.manager = managerDirector.getDataManager();
        this.setName("contentPanel");
        this.readStates();
        Swinger.initActions(this, applicationContext);
        this.initComponents();
        this.setActions();
        MainApp mainApp = (MainApp)applicationContext.getApplication();
        mainApp.getMainFrame().addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                Swinger.inputFocus((JComponent)ContentPanel.this.table);
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
        this.manager.getDownloadFiles().addListDataListener((ListDataListener)this);
        this.manager.addPropertyChangeListener(this);
    }

    private void readStates() {
        DownloadState[] downloadStateArray = DownloadState.values();
        states = new String[downloadStateArray.length];
        int n = 0;
        for (DownloadState downloadState : downloadStateArray) {
            ContentPanel.states[n++] = this.context.getResourceMap().getString(downloadState.name(), new Object[0]);
        }
    }

    @Action(enabledProperty="completeWithFilesEnabled")
    public void openFileAction() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        for (DownloadFile downloadFile : list) {
            OSDesktop.openFile(downloadFile.getOutputFile());
        }
    }

    private int[] getSelectedRows() {
        return Swinger.getSelectedRows((JTable)this.table);
    }

    @Action(enabledProperty="selectedEnabled")
    public void deleteFileAction() {
        int n;
        boolean bl;
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        String string = this.getFileList(list);
        boolean bl2 = AppPrefs.getProperty("confirmFileDelete", true);
        if (string.isEmpty() || !bl2) {
            bl = false;
            n = 0;
        } else {
            n = Swinger.getChoiceOKCancel("message.areyousuredelete", string);
            bl = true;
        }
        if (n == 0) {
            for (DownloadFile downloadFile : list) {
                File file = downloadFile.getOutputFile();
                if (file != null) {
                    file.delete();
                }
                if ((file = downloadFile.getStoreFile()) == null) continue;
                file.delete();
            }
            this.removeSelected(list, nArray, bl);
            if (nArray.length > 0) {
                Arrays.sort(nArray);
                this.renewSelection(new int[]{nArray[0]});
            } else {
                this.selectFirstIfNoSelection();
            }
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void downloadInformationAction() throws Exception {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        if (list.isEmpty()) {
            return;
        }
        MainApp mainApp = (MainApp)this.context.getApplication();
        JFrame jFrame = mainApp.getMainFrame();
        if (list.size() == 1) {
            InformationDialog informationDialog = new InformationDialog(jFrame, this.director, list.get(0));
            mainApp.show(informationDialog);
        } else {
            MultipleSettingsDialog multipleSettingsDialog = new MultipleSettingsDialog(jFrame, list);
            mainApp.show(multipleSettingsDialog);
        }
    }

    @Action(enabledProperty="selectedEnabled")
    public void openDirectoryAction() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        for (DownloadFile downloadFile : list) {
            OSDesktop.openDirectoryForFile(downloadFile.getOutputFile());
        }
    }

    @Action(enabledProperty="resumeActionEnabled")
    public void resumeAction() {
        if (this.isResumeActionEnabled()) {
            this.manager.resumeSelected(this.getSelectedRows());
        }
    }

    @Action(enabledProperty="pauseActionEnabled")
    public void pauseAction() {
        this.manager.pauseSelected(this.getSelectedRows());
    }

    @Action(enabledProperty="cancelActionEnabled")
    public void cancelAction() {
        boolean bl;
        int n;
        if (!this.isCancelActionEnabled()) {
            return;
        }
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        String string = this.getFileList(list);
        boolean bl2 = AppPrefs.getProperty("confirmFileDelete", true);
        if (bl2 && !string.isEmpty()) {
            n = Swinger.getChoiceYesNoCancel("message.areyousuredelete", string);
            bl = n == 0;
        } else {
            n = 0;
            bl = true;
        }
        if (n == 0 || n == 1) {
            this.manager.cancelSelected(this.getSelectedRows(), bl);
        }
    }

    private String getFileList(List<DownloadFile> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DownloadFile downloadFile : list) {
            if (downloadFile.getOutputFile() == null || downloadFile.getDownloaded() <= 0L || !downloadFile.getOutputFile().exists()) continue;
            stringBuilder.append('\n').append(Utils.shortenFileName(downloadFile.getOutputFile(), 60));
        }
        return stringBuilder.toString();
    }

    @Action(enabledProperty="removeCompletedActionEnabled")
    public void removeCompletedAction() {
        int[] nArray = this.getSelectedRows();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        this.manager.removeCompleted();
        this.renewSelection(nArray);
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void selectFirstIfNoSelection() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ContentPanel.this.getVisibleRowCount() > 0) {
                        ContentPanel.this.table.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            });
        }
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void selectAllAction() {
        this.table.selectAll();
    }

    @Action(enabledProperty="nonEmptyEnabled")
    public void invertSelectionAction() {
        int[] nArray = this.getSelectedRows();
        int n = this.table.getModel().getRowCount();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel.clearSelection();
        if (nArray.length > 1) {
            Arrays.sort(nArray);
        }
        for (int i = 0; i < n; ++i) {
            if (Arrays.binarySearch(nArray, i) >= 0) continue;
            int n2 = Swinger.convertRowIndexToView((JTable)this.table, i);
            listSelectionModel.addSelectionInterval(n2, n2);
        }
        listSelectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(true);
    }

    @Action(enabledProperty="selectedEnabled")
    public void removeSelectedAction() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        this.removeSelected(list, nArray, false);
    }

    @Action(enabledProperty="removeInvalidLinksActionEnabled")
    public void removeInvalidLinksAction() {
        int[] nArray = this.getSelectedRows();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        this.manager.removeInvalidLinks();
        this.renewSelection(nArray);
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void renewSelection(final int[] nArray) {
        this.table.clearSelection();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = ContentPanel.this.getVisibleRowCount();
                if (n <= 0) {
                    return;
                }
                for (int n2 : nArray) {
                    int n3 = Swinger.convertRowIndexToView((JTable)ContentPanel.this.table, n2);
                    if (n3 == -1) continue;
                    if (n3 >= n) {
                        n3 = n - 1;
                    }
                    ContentPanel.this.table.getSelectionModel().addSelectionInterval(n3, n3);
                }
                ContentPanel.this.selectFirstIfNoSelection();
                ContentPanel.this.scrollToVisible(true);
            }
        });
    }

    private void removeSelected(List<DownloadFile> list, int[] nArray, boolean bl) {
        int n;
        final ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        if (!bl && (n = AppPrefs.getProperty("confirmRemove", true)) != 0) {
            int n2;
            boolean bl2 = AppPrefs.getProperty("confirmDownloadingRemove", false);
            boolean bl3 = false;
            if (bl2) {
                for (DownloadFile downloadFile : list) {
                    if (DownloadState.DOWNLOADING != downloadFile.getState()) continue;
                    bl3 = true;
                    break;
                }
            } else {
                bl3 = true;
            }
            if (bl3 && (n2 = Swinger.getChoiceOKCancel("areYouSureYouWantToRemove", new Object[0])) != 0) {
                return;
            }
        }
        this.manager.removeSelected(list);
        listSelectionModel.setValueIsAdjusting(false);
        n = this.getArrayMin(nArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n3 = ContentPanel.this.getVisibleRowCount();
                if (n3 > 0) {
                    int n2 = n3 - 1;
                    if (n < n2 && (n2 = n) == -1) {
                        n2 = n3 - 1;
                    }
                    listSelectionModel.addSelectionInterval(n2, n2);
                    ContentPanel.this.scrollToVisible(true);
                }
            }
        });
    }

    private int getVisibleRowCount() {
        return this.table.getRowSorter().getViewRowCount();
    }

    private int getArrayMin(int[] nArray) {
        int n = Integer.MAX_VALUE;
        for (int n2 : nArray) {
            if (n <= (n2 = Swinger.convertRowIndexToView((JTable)this.table, n2)) || n2 == -1) continue;
            n = n2;
        }
        return n;
    }

    @Action(enabledProperty="validateLinksEnabled")
    public void validateLinksAction() {
        this.manager.validateLinks(this.getSelectedRows());
    }

    @Action(enabledProperty="selectedEnabled")
    public void sortbyNameAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 1) {
            this.table.selectAll();
            nArray = this.getSelectedRows();
        }
        int n = this.manager.sortByName(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        if (n != -1) {
            int n2 = Swinger.convertRowIndexToView((JTable)this.table, n);
            listSelectionModel.setSelectionInterval(n2, n2 + nArray.length - 1);
            this.scrollToVisible(true);
        }
    }

    @Action(enabledProperty="moveEnabled")
    public void topAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveTop(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        listSelectionModel.setSelectionInterval(0, nArray.length - 1);
        this.scrollToVisible(true);
    }

    @Action(enabledProperty="moveEnabled")
    public void upAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveUp(nArray);
        listSelectionModel.clearSelection();
        for (int n : nArray) {
            n = Swinger.convertRowIndexToView((JTable)this.table, n);
            listSelectionModel.addSelectionInterval(n, n);
        }
        listSelectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(true);
    }

    private void scrollToVisible(boolean bl) {
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        if (n > 0) {
            this.table.scrollRowToVisible(bl ? nArray[0] : nArray[n - 1]);
        }
    }

    @Action(enabledProperty="moveEnabled")
    public void downAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveDown(nArray);
        listSelectionModel.clearSelection();
        for (int n : nArray) {
            n = Swinger.convertRowIndexToView((JTable)this.table, n);
            listSelectionModel.addSelectionInterval(n, n);
        }
        listSelectionModel.setValueIsAdjusting(false);
        this.scrollToVisible(false);
    }

    @Action(enabledProperty="moveEnabled")
    public void bottomAction() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        int[] nArray = this.getSelectedRows();
        this.manager.moveBottom(nArray);
        listSelectionModel.setValueIsAdjusting(false);
        int n = this.table.getRowCount();
        listSelectionModel.setSelectionInterval(n - nArray.length, n - 1);
        this.scrollToVisible(false);
    }

    @Action(enabledProperty="selectedEnabled")
    public void openInBrowser() {
        List<DownloadFile> list = this.manager.getSelectionToList(this.getSelectedRows());
        for (DownloadFile downloadFile : list) {
            Browser.openBrowser(downloadFile.getFileUrl().toExternalForm());
        }
    }

    private void setActions() {
        this.initTable();
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent preferenceChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContentPanel.this.updateTableFromPreferences(preferenceChangeEvent);
                    }
                });
            }
        });
        this.updateGridLines();
    }

    private void updateTableFromPreferences(PreferenceChangeEvent preferenceChangeEvent) {
        if ("showHorizontalGridLines".equals(preferenceChangeEvent.getKey()) || "showVerticalGridLines".equals(preferenceChangeEvent.getKey())) {
            this.updateGridLines();
        } else if ("showServicesAsIcons".equals(preferenceChangeEvent.getKey())) {
            this.table.repaint();
            this.table.packAll();
        }
    }

    private void updateGridLines() {
        boolean bl = AppPrefs.getProperty("showHorizontalGridLines", false);
        boolean bl2 = AppPrefs.getProperty("showVerticalGridLines", false);
        this.table.setShowGrid(bl, bl2);
    }

    public void updateFilters() {
        SortController sortController = (SortController)this.table.getRowSorter();
        if (!AppPrefs.getProperty("removeCompleted", true)) {
            sortController.setRowFilter((RowFilter)new StateFilter());
        } else {
            sortController.setRowFilter(null);
        }
    }

    private boolean isCancelledExisting() {
        int[] nArray = this.getSelectedRows();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        for (DownloadFile downloadFile : list) {
            File file = downloadFile.getOutputFile();
            if (file.exists() && file.length() == downloadFile.getFileSize() && downloadFile.getFileSize() > 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isPauseActionEnabled() {
        return this.pauseActionEnabled;
    }

    public void setPauseActionEnabled(boolean bl) {
        boolean bl2 = this.pauseActionEnabled;
        this.pauseActionEnabled = bl;
        this.firePropertyChange(PAUSE_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isValidateLinksEnabled() {
        return this.validateLinksEnabled;
    }

    public void setValidateLinksEnabled(boolean bl) {
        boolean bl2 = this.validateLinksEnabled;
        this.validateLinksEnabled = bl;
        this.firePropertyChange(VALIDATELINKS_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isCancelActionEnabled() {
        return this.cancelActionEnabled;
    }

    public void setCancelActionEnabled(boolean bl) {
        boolean bl2 = this.cancelActionEnabled;
        this.cancelActionEnabled = bl;
        this.firePropertyChange(CANCEL_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isResumeActionEnabled() {
        return this.resumeActionEnabled;
    }

    public void setResumeActionEnabled(boolean bl) {
        boolean bl2 = this.resumeActionEnabled;
        this.resumeActionEnabled = bl;
        this.firePropertyChange(RESUME_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isRemoveCompletedActionEnabled() {
        return this.removeCompletedActionEnabled;
    }

    public void setRemoveCompletedActionEnabled(boolean bl) {
        boolean bl2 = this.removeCompletedActionEnabled;
        this.removeCompletedActionEnabled = bl;
        this.firePropertyChange(REMOVECOMPLETED_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isRemoveInvalidLinksActionEnabled() {
        return this.removeInvalidLinksActionEnabled;
    }

    public void setRemoveInvalidLinksActionEnabled(boolean bl) {
        boolean bl2 = this.removeInvalidLinksActionEnabled;
        this.removeInvalidLinksActionEnabled = bl;
        this.firePropertyChange(REMOVEINVALID_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isCompleteWithFilesEnabled() {
        return this.completeWithFilesEnabled;
    }

    public void setCompletedWithFilesEnabled(boolean bl) {
        boolean bl2 = this.completeWithFilesEnabled;
        this.completeWithFilesEnabled = bl;
        this.firePropertyChange(COMPLETED_OK_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isSelectedEnabled() {
        return this.selectedEnabled;
    }

    public void setSelectedEnabled(boolean bl) {
        boolean bl2 = this.selectedEnabled;
        this.selectedEnabled = bl;
        this.firePropertyChange(SELECTED_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isMoveEnabled() {
        return this.moveEnabled;
    }

    public void setMoveEnabled(boolean bl) {
        boolean bl2 = this.moveEnabled;
        this.moveEnabled = bl;
        this.firePropertyChange(MOVEENABLED_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    public boolean isNonEmptyEnabled() {
        return this.nonEmptyEnabled;
    }

    public void setNonEmptyEnabled(boolean bl) {
        boolean bl2 = this.nonEmptyEnabled;
        this.nonEmptyEnabled = bl;
        this.firePropertyChange(NONEMPTY_ACTION_ENABLED_PROPERTY, bl2, bl);
    }

    private boolean isSorted() {
        List<RowSorter.SortKey> list;
        if (this.table.isSortable() && !(list = this.table.getRowSorter().getSortKeys()).isEmpty()) {
            for (RowSorter.SortKey sortKey : list) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                return true;
            }
        }
        return false;
    }

    private void updateActions() {
        int[] nArray = this.getSelectedRows();
        boolean bl = this.manager.hasDownloadFilesStates(nArray, DownloadsActions.cancelEnabledStates);
        this.setCancelActionEnabled(bl);
        this.setSelectedEnabled(nArray.length > 0);
        this.setMoveEnabled(this.isSelectedEnabled() && !this.isSorted());
        boolean bl2 = this.manager.hasDownloadFilesStates(nArray, DownloadsActions.completedStates);
        if (bl2) {
            boolean bl3 = true;
            List<DownloadFile> list = this.manager.getSelectionToList(nArray);
            for (DownloadFile downloadFile : list) {
                if (downloadFile.getOutputFile().exists()) continue;
                bl3 = false;
                break;
            }
            this.setCompletedWithFilesEnabled(bl3);
            this.setResumeActionEnabled(false);
            this.setPauseActionEnabled(false);
            this.setValidateLinksEnabled(false);
        } else {
            boolean bl4 = this.manager.hasAnyDownloadFilesStates(nArray, DownloadsActions.resumeEnabledStates);
            this.setResumeActionEnabled(bl4);
            boolean bl5 = this.manager.isPausable(nArray);
            this.setPauseActionEnabled(bl5);
            this.setValidateLinksEnabled(this.manager.hasAnyDownloadFilesStates(nArray, DownloadsActions.recheckExistingStates));
            this.setCompletedWithFilesEnabled(false);
        }
        this.setNonEmptyEnabled(this.table.getModel().getRowCount() > 0);
    }

    private void initTable() {
        Object object;
        this.table.setName("mainTable");
        String[] stringArray = (String[])this.context.getResourceMap().getObject("mainTableColumns", String[].class);
        this.table.setModel((TableModel)new CustomTableModel(this.manager.getDownloadFiles(), stringArray));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(false);
        this.table.setColumnControlVisible(true);
        this.table.setColumnSelectionAllowed(false);
        DefaultRowSorter defaultRowSorter = (DefaultRowSorter)this.table.getRowSorter();
        WinampMoveStyle winampMoveStyle = new WinampMoveStyle();
        this.table.addMouseListener((MouseListener)winampMoveStyle);
        this.table.addMouseMotionListener((MouseMotionListener)winampMoveStyle);
        this.table.setSortsOnUpdates(true);
        this.table.setTransferHandler((TransferHandler)new URLTransferHandler(this.director){

            @Override
            protected void doDropAction(final List<URL> list) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Swinger.getAction("addNewLinksAction").actionPerformed(new ActionEvent(list, 0, null));
                    }
                });
            }
        });
        ColorHighlighter colorHighlighter = new ColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component component, ComponentAdapter componentAdapter) {
                return FileState.FILE_NOT_FOUND.equals((Object)((DownloadFile)componentAdapter.getValue(0)).getFileState());
            }
        }, new Color(0xFFD2D2), Color.BLACK);
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.table.createDefaultColumnsFromModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellRenderer(new NameURLCellRenderer(this.director.getFileTypeIconProvider()));
        tableColumn.setWidth(150);
        tableColumn.setMinWidth(50);
        tableColumnModel.getColumn(2).setCellRenderer(new ProgressBarCellRenderer(this.context));
        TableColumn tableColumn2 = tableColumnModel.getColumn(0);
        tableColumn2.setMaxWidth(30);
        tableColumn2.setWidth(30);
        tableColumn2.setCellRenderer(new CheckedCellRenderer(this.context));
        ((TableColumnExt)tableColumnModel.getColumn(0)).setToolTipText(this.context.getResourceMap().getString("checkedColumnTooltip", new Object[0]));
        tableColumnModel.getColumn(3).setCellRenderer(new ProgressCellRenderer());
        tableColumnModel.getColumn(4).setCellRenderer(new EstTimeCellRenderer(this.context));
        tableColumnModel.getColumn(5).setCellRenderer(new SizeCellRenderer(this.context));
        tableColumnModel.getColumn(6).setCellRenderer(new SpeedCellRenderer());
        tableColumnModel.getColumn(7).setCellRenderer(new AverageSpeedCellRenderer());
        tableColumnModel.getColumn(8).setCellRenderer(new ServiceCellRenderer(this.director));
        tableColumnModel.getColumn(9).setCellRenderer(new ConnectionCellRenderer(this.context));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    ContentPanel.this.showPopMenu(mouseEvent);
                } else if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() >= 2) {
                    ContentPanel.this.smartEnterAction();
                }
            }
        });
        boolean bl = AppPrefs.getProperty("tableSortable", false);
        this.table.setSortable(bl);
        if (bl) {
            object = (SortController)this.table.getRowSorter();
            object.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
            ((DefaultRowSorter)object).setMaxSortKeys(1);
            defaultRowSorter.setComparator(1, new NameColumnComparator());
            defaultRowSorter.setComparator(7, new AvgSpeedColumnComparator());
            defaultRowSorter.setComparator(0, new CheckedColumnComparator());
            defaultRowSorter.setComparator(3, new ProgressColumnComparator());
            defaultRowSorter.setComparator(9, new ConnectionColumnComparator());
            defaultRowSorter.setComparator(8, new ServiceColumnComparator());
            defaultRowSorter.setComparator(5, new SizeColumnComparator());
            defaultRowSorter.setComparator(6, new SpeedColumnComparator());
            defaultRowSorter.setComparator(4, new EstTimeColumnComparator());
            defaultRowSorter.setComparator(2, new ProgressBarColumnComparator());
        }
        this.table.setUpdateSelectionOnSort(bl);
        this.table.packAll();
        object = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        ((InputMap)object).put(SwingUtils.getCtrlKeyStroke(67), "copy");
        ((InputMap)object).put(SwingUtils.getCtrlAltKeyStroke(67), "copy");
        actionMap.put("copy", Swinger.getAction("copyContent"));
        if (AppPrefs.getProperty("cancelOnEscape", true)) {
            ((InputMap)object).put(SwingUtils.getKeyStroke(27), "deleteItem");
            actionMap.put("deleteItem", Swinger.getAction("cancelAction"));
        }
        ((InputMap)object).put(SwingUtils.getShiftKeyStroke(127), "deleteFileAction");
        actionMap.put("deleteFileAction", Swinger.getAction("deleteFileAction"));
        ((InputMap)object).put(SwingUtils.getKeyStroke(32), "resumeAction");
        actionMap.put("resumeAction", Swinger.getAction("resumeAction"));
        ((InputMap)object).put(SwingUtils.getKeyStroke(525), "contextMenu");
        actionMap.put("contextMenu", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Point point = new Point();
                Rectangle rectangle = ContentPanel.this.table.getVisibleRect();
                if (Swinger.getSelectedRows((JTable)ContentPanel.this.table).length > 0) {
                    int n = ContentPanel.this.table.getSelectionModel().getLeadSelectionIndex();
                    Rectangle rectangle2 = ContentPanel.this.table.getCellRect(n, 0, true);
                    rectangle2.y += rectangle2.height - 1;
                    point.y = rectangle2.y > rectangle.y && rectangle.y + rectangle.height > rectangle2.y ? rectangle2.y : (rectangle2.y < rectangle.y ? rectangle.y : rectangle.y + rectangle.height);
                    point.x = rectangle2.x;
                } else {
                    point.x = ((ContentPanel)ContentPanel.this).table.getCellRect((int)0, (int)0, (boolean)true).x;
                }
                ContentPanel.this.showPopMenu(new MouseEvent((Component)ContentPanel.this.table, 0, 0L, 0, point.x, point.y, 1, true));
            }
        });
        ((InputMap)object).put(SwingUtils.getKeyStroke(10), "smartEnterAction");
        actionMap.put("smartEnterAction", Swinger.getAction("smartEnterAction"));
        ((InputMap)object).put(SwingUtils.getKeyStroke(36), "selectFirstRow");
        ((InputMap)object).put(SwingUtils.getKeyStroke(35), "selectLastRow");
        ((InputMap)object).put(SwingUtils.getCtrlKeyStroke(36), "selectFirstColumn");
        ((InputMap)object).put(SwingUtils.getCtrlKeyStroke(35), "selectLastColumn");
        ((InputMap)object).put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        ((InputMap)object).put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
        ((InputMap)object).remove(KeyStroke.getKeyStroke("F8"));
        actionMap.remove("find");
        actionMap.remove("focusHeader");
        this.updateFilters();
        this.table.addHighlighter((Highlighter)colorHighlighter);
        new FindTableAction(Swinger.getResourceMap(), 1){

            @Override
            protected Object getObject(int n, int n2) {
                DownloadFile downloadFile = (DownloadFile)ContentPanel.this.table.getModel().getValueAt(n, n2);
                if (downloadFile == null) {
                    logger.warning("Download File is null");
                    return null;
                }
                String string = downloadFile.getFileName();
                String string2 = downloadFile.getFileUrl().toString();
                String string3 = string != null && !string.isEmpty() ? string : string2;
                return string3;
            }
        }.install((JComponent)this.table);
    }

    @Action
    public void smartEnterAction() {
        if (this.isCompleteWithFilesEnabled() || this.isSelectedEnabled() && this.isCancelledExisting()) {
            this.openFileAction();
        } else if (this.isSelectedEnabled()) {
            try {
                this.downloadInformationAction();
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        }
    }

    public void paste() {
        javax.swing.Action action = this.table.getActionMap().get("paste");
        action.actionPerformed(new ActionEvent(this.table, 0, "paste"));
    }

    @Action(enabledProperty="selectedEnabled")
    public void copyContent() {
        List<DownloadFile> list = this.manager.getSelectionToList(this.getSelectedRows());
        StringBuilder stringBuilder = new StringBuilder();
        for (DownloadFile downloadFile : list) {
            stringBuilder.append(downloadFile.toString()).append('\n');
        }
        SwingUtils.copyToClipboard(stringBuilder.toString().trim(), this);
    }

    private void showPopMenu(MouseEvent mouseEvent) {
        Object object;
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n != -1) {
            if (nArray.length <= 0) {
                if (this.getVisibleRowCount() > 0) {
                    listSelectionModel.setSelectionInterval(n, n);
                }
            } else {
                Arrays.sort(nArray);
                if (Arrays.binarySearch(nArray, this.table.convertRowIndexToModel(n)) < 0) {
                    listSelectionModel.setValueIsAdjusting(true);
                    this.table.clearSelection();
                    listSelectionModel.setSelectionInterval(n, n);
                    listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            this.table.clearSelection();
        }
        nArray = this.getSelectedRows();
        JPopupMenu jPopupMenu = new JPopupMenu();
        ApplicationActionMap applicationActionMap = this.context.getActionMap();
        MenuManager menuManager = this.director.getMenuManager();
        JMenu jMenu = menuManager.createMenu("removeMenu", applicationActionMap, "removeCompletedAction", "removeInvalidLinksAction", "removeSelectedAction");
        boolean bl = applicationActionMap.get("removeCompletedAction").isEnabled() || applicationActionMap.get("removeInvalidLinksAction").isEnabled() || applicationActionMap.get("removeSelectedAction").isEnabled();
        jMenu.setEnabled(bl);
        ResourceMap resourceMap = this.context.getResourceMap();
        resourceMap.injectComponent(jMenu);
        JMenu jMenu2 = new JMenu();
        jMenu2.setName("speedLimitMenu");
        resourceMap.injectComponent(jMenu2);
        jPopupMenu.add(applicationActionMap.get("downloadInformationAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("openFileAction"));
        jPopupMenu.add(applicationActionMap.get("deleteFileAction"));
        jPopupMenu.add(applicationActionMap.get("openDirectoryAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("resumeAction"));
        jPopupMenu.add(applicationActionMap.get("pauseAction"));
        jPopupMenu.add(applicationActionMap.get("cancelAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("validateLinksAction"));
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("selectAllAction"));
        jPopupMenu.add(applicationActionMap.get("invertSelectionAction"));
        JMenu jMenu3 = new JMenu();
        jMenu3.setName("forceDownloadMenu");
        resourceMap.injectComponent(jMenu3);
        String[] stringArray = AppPrefs.getProperty("speedLimitSpeeds", "0,,10,15,20,30,40,50,100,150,200,300").split(",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>(stringArray.length);
        for (String string : stringArray) {
            try {
                int n2;
                int n3 = n2 = string.trim().isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(string);
                if (n2 == 0) {
                    n2 = -1;
                }
                if (n2 < -1) continue;
                arrayList.add(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        List<DownloadFile> list = this.manager.getSelectionToList(nArray);
        if (!list.isEmpty() && !arrayList.contains(list.get(0).getSpeedLimit())) {
            arrayList.add(list.get(0).getSpeedLimit());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (n4 == Integer.MAX_VALUE) {
                jMenu2.addSeparator();
                continue;
            }
            String string = n4 == -1 ? resourceMap.getString("unlimitedSpeed", new Object[0]) : resourceMap.getString("limitSpeed", n4);
            object = new JRadioButtonMenuItem(new SpeedLimitAction(string, n4));
            buttonGroup.add((AbstractButton)object);
            ((JComponent)object).setAlignmentX(0.0f);
            jMenu2.add((JMenuItem)object);
            if (list.isEmpty()) continue;
            ((AbstractButton)object).setSelected(list.get(0).getSpeedLimit() == n4);
        }
        boolean bl2 = this.isSelectedEnabled() && this.manager.hasDownloadFilesStates(nArray, DownloadsActions.forceEnabledStates);
        jMenu3.setEnabled(bl2);
        List<ConnectionSettings> list2 = this.director.getClientManager().getAvailableConnections();
        boolean bl3 = false;
        for (ConnectionSettings connectionSettings : list2) {
            ForceDownloadAction forceDownloadAction = new ForceDownloadAction(connectionSettings);
            jMenu3.add(forceDownloadAction);
            forceDownloadAction.setEnabled(bl2);
            if (!connectionSettings.isEnabled()) continue;
            bl3 = true;
        }
        jMenu3.setEnabled(bl2 && bl3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenu3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(applicationActionMap.get("copyContent"));
        jPopupMenu.add(applicationActionMap.get("openInBrowser"));
        object = SwingUtilities.convertMouseEvent((Component)this.table, mouseEvent, this);
        jPopupMenu.show(this, ((MouseEvent)object).getX(), ((MouseEvent)object).getY());
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.table = new JXTable();
        this.setLayout(new BorderLayout());
        jScrollPane.setViewportView((Component)this.table);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentPanel.this.updateActions();
            }
        });
    }

    @Override
    public void intervalAdded(final ListDataEvent listDataEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ContentPanel.this.isInInterval(ContentPanel.this.getSelectedRows(), listDataEvent.getIndex0(), listDataEvent.getIndex1())) {
                    ContentPanel.this.updateActions();
                }
            }
        });
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.intervalAdded(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.intervalAdded(listDataEvent);
    }

    private boolean isInInterval(int[] nArray, int n, int n2) {
        for (int n3 : nArray) {
            if (n < n3 || n3 > n2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("completed".equals(string)) {
            this.setRemoveCompletedActionEnabled((Integer)propertyChangeEvent.getNewValue() > 0);
        } else if ("notFound".equals(string)) {
            this.setRemoveInvalidLinksActionEnabled((Integer)propertyChangeEvent.getNewValue() > 0);
        }
    }

    public void selectAdded(List<DownloadFile> list) {
        assert (!list.isEmpty());
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = this.manager.getDownloadFiles().indexOf((Object)list.get(0));
        int n2 = Swinger.convertRowIndexToView((JTable)this.table, n);
        listSelectionModel.setSelectionInterval(n2, n2 + list.size() - 1);
        this.scrollToVisible(true);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public static int getProgress(DownloadFile downloadFile) {
        long l = downloadFile.getDownloaded();
        long l2 = downloadFile.getFileSize();
        if (l == 0L || l2 == 0L) {
            return 0;
        }
        return (int)((float)l / (float)l2 * 100.0f);
    }

    static int getProgress(int n, int n2) {
        return (int)((float)n2 / (float)n * 100.0f);
    }

    public static String secondsToHMin(long l) {
        long l2 = l / 60L;
        long l3 = l2 / 60L;
        l = l - (l2 -= l3 * 60L) * 60L - l3 * 3600L;
        if (l3 > 0L) {
            return String.format("%02dh:%02dm", l3, l2);
        }
        if (l2 > 0L) {
            return String.format("%02dm:%02ds", l2, l);
        }
        return String.format("%ds", l);
    }

    public static String bytesToAnother(long l) {
        if (l > 0x40000000L) {
            return numberFormatInstance.format((float)l / 1.0737418E9f) + " GB";
        }
        if (l > 0x100000L) {
            return numberFormatInstance.format((float)l / 1048576.0f) + " MB";
        }
        if (l >= 1024L) {
            return numberFormatInstance.format((float)l / 1024.0f) + " kB";
        }
        return String.format("%s B", integerInstance.format(l));
    }

    public static String stateToString(DownloadState downloadState) {
        return states[downloadState.ordinal()];
    }

    private boolean isSelectedRow(int n) {
        int[] nArray;
        for (int n2 : nArray = this.getSelectedRows()) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    static {
        integerInstance = NumberFormat.getIntegerInstance();
        numberFormatInstance = NumberFormat.getInstance();
        numberFormatInstance.setMaximumFractionDigits(2);
        numberFormatInstance.setMinimumFractionDigits(1);
    }

    private class WinampMoveStyle
    extends MouseAdapter {
        private boolean active = false;
        private int rowPosition;

        private WinampMoveStyle() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                if (!ContentPanel.this.table.getRowSorter().getSortKeys().isEmpty()) {
                    return;
                }
                if (AppPrefs.getProperty("dragOnRightMouse", true)) {
                    this.rowPosition = ContentPanel.this.table.rowAtPoint(mouseEvent.getPoint());
                    if (this.rowPosition != -1 && ContentPanel.this.isSelectedRow(this.rowPosition)) {
                        this.active = true;
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) && this.active) {
                ContentPanel.this.table.setCursor(Cursor.getDefaultCursor());
                this.active = false;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.active) {
                return;
            }
            try {
                ContentPanel.this.table.setCursor(DragSource.DefaultMoveDrop);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n = ContentPanel.this.table.rowAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            if (this.rowPosition - n >= 1) {
                for (int i = this.rowPosition - n; i > 0; --i) {
                    ContentPanel.this.upAction();
                }
                this.rowPosition = n;
            } else if (this.rowPosition - n <= -1) {
                for (int i = -1 * (this.rowPosition - n); i > 0; --i) {
                    ContentPanel.this.downAction();
                }
                this.rowPosition = n;
            }
        }
    }

    private class SpeedLimitAction
    extends AbstractAction {
        private final int value;

        public SpeedLimitAction(String string, int n) {
            this.value = n;
            this.putValue("Name", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ContentPanel.this.manager.setSpeedLimit(ContentPanel.this.getSelectedRows(), this.value);
        }
    }

    private class ForceDownloadAction
    extends AbstractAction {
        private final ConnectionSettings settings;

        public ForceDownloadAction(ConnectionSettings connectionSettings) {
            this.settings = connectionSettings;
            this.putValue("Name", connectionSettings.toString());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ContentPanel.this.manager.forceDownload(this.settings, ContentPanel.this.getSelectedRows());
        }
    }

    private static class StateFilter
    extends RowFilter<Object, Object> {
        private StateFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            DownloadFile downloadFile = (DownloadFile)entry.getValue(4);
            return downloadFile != null && downloadFile.getState() != DownloadState.COMPLETED;
        }
    }
}

