/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.awt.Component;
import java.util.concurrent.TimeUnit;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class EstTimeCellRenderer
extends DefaultTableCellRenderer {
    private final String tooltip;
    private final String elapsedTime;

    EstTimeCellRenderer(ApplicationContext applicationContext) {
        ResourceMap resourceMap = applicationContext.getResourceMap();
        this.tooltip = resourceMap.getString("tooltip", new Object[0]);
        this.elapsedTime = resourceMap.getString("elapsedTime", new Object[0]);
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        DownloadTask downloadTask;
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        DownloadFile downloadFile = (DownloadFile)object;
        DownloadState downloadState = downloadFile.getState();
        object = ContentPanel.stateToString(downloadState);
        this.setHorizontalAlignment(0);
        this.setToolTipText(null);
        if (downloadState == DownloadState.DOWNLOADING) {
            long l = downloadFile.getFileSize() - downloadFile.getDownloaded();
            double d = downloadFile.getShortTimeAvgSpeed();
            if (l >= 0L && d > 0.0) {
                object = ContentPanel.secondsToHMin(Math.round((double)l / d));
            }
        } else if (downloadState == DownloadState.WAITING) {
            // empty if block
        }
        if (downloadState == DownloadState.ERROR || downloadState == DownloadState.SLEEPING || downloadState == DownloadState.DISABLED) {
            String string = downloadFile.getErrorMessage();
            if (string != null) {
                if (downloadState == DownloadState.ERROR || downloadState == DownloadState.DISABLED) {
                    object = object + " - " + string.replaceAll("<.*?>", "");
                }
                this.setToolTipText(String.format(this.tooltip, string));
            }
        } else if (DownloadsActions.isProcessState(downloadState) && (downloadTask = downloadFile.getTask()) != null) {
            this.setToolTipText(String.format(this.elapsedTime, ContentPanel.secondsToHMin(downloadTask.getExecutionDuration(TimeUnit.SECONDS))));
        }
        Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.getAccessibleContext().setAccessibleName(jTable.getColumnName(n2) + " " + object);
        this.getAccessibleContext().setAccessibleDescription(jTable.getColumnName(n2) + " " + object);
        return component;
    }
}

