/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

final class ProgressBarCellRenderer
extends JProgressBar
implements TableCellRenderer {
    private static final Color BG_RED = new Color(0xFFD0D0);
    private static final Color BG_ORANGE = new Color(16772560);
    private static final Color BG_GREEN = new Color(13697001);
    private static final Color BG_BLUE = new Color(11987455);
    private String autoReconnectIn;
    private String attemptForDownloading;

    public ProgressBarCellRenderer(ApplicationContext applicationContext) {
        super(0, 100);
        ResourceMap resourceMap = applicationContext.getResourceMap();
        this.autoReconnectIn = resourceMap.getString("autoreconnectIn", new Object[0]);
        this.attemptForDownloading = resourceMap.getString("attemptForDownloading", new Object[0]);
        int n = this.getPreferredSize().height;
        this.setPreferredSize(new Dimension(70, n));
    }

    @Override
    public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        DownloadFile downloadFile;
        DownloadState downloadState;
        if (object == null) {
            object = jTable.getValueAt(n, n2);
        }
        if ((downloadState = (downloadFile = (DownloadFile)object).getState()) == DownloadState.DOWNLOADING || downloadState == DownloadState.GETTING || downloadState == DownloadState.WAITING) {
            this.setBackground(BG_GREEN);
        } else if (downloadState == DownloadState.CANCELLED || downloadState == DownloadState.ERROR || downloadState == DownloadState.DELETED) {
            this.setBackground(BG_RED);
        } else if (downloadState == DownloadState.PAUSED || downloadState == DownloadState.DISABLED) {
            this.setBackground(Color.BLACK);
        } else if (downloadState == DownloadState.QUEUED) {
            this.setBackground(BG_ORANGE);
        } else if (downloadState == DownloadState.SLEEPING) {
            this.setBackground(BG_BLUE);
        } else if (downloadState == DownloadState.COMPLETED) {
            this.setBackground(null);
        } else {
            this.setBackground(Color.BLACK);
        }
        int n3 = downloadFile.getTimeToQueued();
        if ((downloadState == DownloadState.ERROR || downloadState == DownloadState.SLEEPING) && n3 >= 0) {
            int n4 = downloadFile.getTimeToQueuedMax();
            this.setStringPainted(true);
            this.setString(ContentPanel.secondsToHMin(n3));
            this.setValue(ContentPanel.getProgress(n4, n3));
            this.setToolTipText(String.format(this.autoReconnectIn, n3));
        } else {
            int n5 = downloadFile.getSleep();
            if (downloadState == DownloadState.WAITING && n5 >= 0) {
                int n6 = downloadFile.getTimeToQueuedMax();
                this.setStringPainted(true);
                this.setString(ContentPanel.secondsToHMin(n5));
                this.setValue(ContentPanel.getProgress(n6, n5));
                this.setToolTipText(String.format(this.attemptForDownloading, n5));
            } else {
                this.setToolTipText(null);
                int n7 = ContentPanel.getProgress(downloadFile);
                if (AppPrefs.getProperty("showPercentProgress", false)) {
                    this.setStringPainted(true);
                    this.setString(n7 + "%");
                } else {
                    this.setStringPainted(false);
                }
                this.setValue(n7);
            }
        }
        this.getAccessibleContext().setAccessibleName(this.getString());
        return this;
    }
}

