/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.plugins.webclient.hoster.PremiumAccount;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;

public class AccountDialog
extends AppDialog {
    private static final Logger logger = Logger.getLogger(AccountDialog.class.getName());
    private PresentationModel<PremiumAccount> model;
    private PremiumAccount account;
    private JTextField fieldUserName;
    private JPasswordField fieldPassword;
    private JButton btnOK;
    private JButton btnCancel;

    public AccountDialog(Frame frame, String string, PremiumAccount premiumAccount) throws HeadlessException {
        super(frame, true);
        this.setName("AccountDialog");
        this.account = premiumAccount == null ? new PremiumAccount() : premiumAccount;
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        if (string != null) {
            this.setTitle(this.getTitle() + " - " + string);
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnOK;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.btnOK, "okBtnAction");
        this.setAction(this.btnCancel, "cancelBtnAction");
        this.pack();
        AccountDialog.locateOnOpticalScreenCenter(this);
    }

    private void buildModels() {
        this.model = new PresentationModel((Object)this.account);
        Bindings.bind((JTextField)this.fieldUserName, (ValueModel)this.model.getBufferedModel("username"));
        Bindings.bind((JTextField)this.fieldPassword, (ValueModel)this.model.getBufferedModel("password"));
    }

    private void buildGUI() {
    }

    @Action
    public void okBtnAction() {
        if (!this.validated()) {
            return;
        }
        if (this.model != null) {
            this.model.triggerCommit();
        }
        this.setResult(0);
        this.doClose();
    }

    private boolean validated() {
        if (!Utils.hasValue(this.fieldUserName.getText())) {
            Swinger.showErrorMessage(this.getResourceMap(), "message_noUserName", new Object[0]);
            Swinger.inputFocus(this.fieldUserName);
            return false;
        }
        if (this.fieldPassword.getPassword().length == 0) {
            Swinger.showErrorMessage(this.getResourceMap(), "message_noPassword", new Object[0]);
            Swinger.inputFocus(this.fieldPassword);
            return false;
        }
        return true;
    }

    @Action
    public void cancelBtnAction() {
        if (this.model != null) {
            this.model.triggerFlush();
        }
        this.setResult(1);
        this.doClose();
    }

    public PremiumAccount getAccount() {
        return this.account;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.fieldUserName = ComponentFactory.getTextField();
        JLabel jLabel3 = new JLabel();
        this.fieldPassword = ComponentFactory.getPasswordField();
        JPanel jPanel3 = new JPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        jLabel.setName("labelIcon");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setLayout(new BorderLayout());
        jLabel2.setName("labelUserName");
        jLabel2.setLabelFor(this.fieldUserName);
        jLabel3.setName("labelPassword");
        jLabel3.setLabelFor(this.fieldPassword);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec("max(pref;35dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("min(pref;40dlu):grow"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC}), jPanel2);
        panelBuilder.add((Component)jLabel, cellConstraints.xywh(1, 1, 2, 7, CellConstraints.FILL, CellConstraints.CENTER));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.fieldUserName, cellConstraints.xywh(3, 3, 3, 1));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)this.fieldPassword, cellConstraints.xywh(3, 7, 3, 1));
        jPanel.add((Component)jPanel2, "Center");
        jPanel3.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec("55px:grow"), ComponentFactory.BUTTON_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ComponentFactory.BUTTON_COLSPEC}, RowSpec.decodeSpecs((String)"default")), jPanel3);
        panelBuilder.add((Component)this.btnOK, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.btnCancel, cellConstraints.xy(4, 1));
        jPanel.add((Component)jPanel3, "South");
    }
}

