/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.l2fprod.common.swing.JDirectoryChooser;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppFrame;
import cz.vity.freerapid.gui.dialogs.CompoundUndoManager;
import cz.vity.freerapid.gui.dialogs.NewLinksDialog;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.ComponentFactory;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.models.RecentsFilesComboModel;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;

public class InformationDialog
extends AppFrame
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(InformationDialog.class.getName());
    private final ManagerDirector director;
    private final DownloadFile file;
    private PresentationModel<DownloadFile> model;
    private JLabel iconLabel;
    private JLabel pathLabel;
    private JTextField fieldFrom;
    private JTextField fieldSize;
    private JTextArea descriptionArea;
    private JComboBox comboPath;
    private JButton btnSelectPath;
    private JProgressBar progressBar;
    private JLabel remainingLabel;
    private JLabel currentSpeedLabel;
    private JLabel avgSpeedLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel estTimeLabel;

    public InformationDialog(Frame frame, ManagerDirector managerDirector, DownloadFile downloadFile) throws Exception {
        super(frame);
        this.director = managerDirector;
        this.file = downloadFile;
        this.setName("InformationDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.doClose();
            throw exception;
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.okButton;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.cancelButton;
    }

    @Action
    public void cancelBtnAction() {
        this.setResult(1);
        if (this.model != null) {
            this.model.triggerFlush();
        }
        this.doClose();
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.buildModels();
        this.setAction(this.okButton, "okBtnAction");
        this.setAction(this.cancelButton, "cancelBtnAction");
        this.setAction(this.btnSelectPath, "btnSelectPathAction");
        this.updateInit();
    }

    private void buildModels() {
        this.model = new PresentationModel((Object)this.file);
        Bindings.bind((JTextArea)this.descriptionArea, (ValueModel)this.model.getBufferedModel("description"));
        this.file.addPropertyChangeListener(this);
    }

    private void buildGUI() {
        new CompoundUndoManager(this.descriptionArea);
        this.comboPath.setModel(new RecentsFilesComboModel("lastUsedSavedPaths", true));
        this.comboPath.setSelectedItem(FileUtils.getAbsolutFile(this.file.getSaveToDirectory()));
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(1, 16.0f));
        this.progressBar.setStringPainted(true);
        Swinger.inputFocus(this.descriptionArea);
        this.fieldFrom.setOpaque(false);
        this.fieldSize.setOpaque(false);
        this.fieldFrom.setBackground(this.getBackground());
        this.fieldSize.setBackground(this.getBackground());
        this.fieldSize.setEditable(false);
        this.fieldFrom.setEditable(false);
        this.descriptionArea.setFont(this.descriptionArea.getFont().deriveFont(11.0f));
    }

    @Action
    public void okBtnAction() {
        if (!this.validateChanges()) {
            return;
        }
        AppPrefs.storeProperty("lastComboPath", this.comboPath.getSelectedItem().toString());
        File file = new File(this.comboPath.getEditor().getItem().toString());
        this.file.setSaveToDirectory(file);
        this.setResult(0);
        if (this.model != null) {
            this.model.triggerCommit();
        }
        this.doClose();
    }

    @Override
    public void doClose() {
        this.file.removePropertyChangeListener(this);
        super.doClose();
        if (this.model != null) {
            this.model.setBean(null);
        }
        if (this.getModalResult() == 0) {
            this.comboPath.addItem(this.comboPath.getSelectedItem());
        }
    }

    private boolean validateChanges() {
        String string = (String)this.comboPath.getEditor().getItem();
        if (string == null || string.isEmpty()) {
            Swinger.showErrorMessage(this.getResourceMap(), "noDirectoryMessage", new Object[0]);
            this.btnSelectPathAction();
            return false;
        }
        ResourceMap resourceMap = Swinger.getResourceMap(NewLinksDialog.class);
        File file = new File(Utils.isWindows() ? string.trim() : string);
        if (!file.isDirectory()) {
            int n = Swinger.getChoiceYesNo(resourceMap.getString("directoryCreateMessage", new Object[0]));
            if (n == 0) {
                if (!file.mkdirs()) {
                    Swinger.showErrorMessage(resourceMap, "directoryCreatingFailed", file.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
                if (!file.isDirectory()) {
                    Swinger.showErrorMessage(resourceMap, "itsNotDirectory", file.getAbsolutePath());
                    this.btnSelectPathAction();
                    return false;
                }
            } else {
                this.btnSelectPathAction();
                return false;
            }
        }
        return true;
    }

    @Action
    public void btnSelectPathAction() {
        JDirectoryChooser jDirectoryChooser = new JDirectoryChooser(this.comboPath.getEditor().getItem().toString());
        if (jDirectoryChooser.showDialog((Component)this, this.getResourceMap().getString("SelectDirectory", new Object[0])) != 1) {
            this.comboPath.getEditor().setItem(jDirectoryChooser.getSelectedFile().getAbsolutePath());
            Swinger.inputFocus(this.comboPath);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.iconLabel = new JLabel();
        this.pathLabel = new JLabel();
        JLabel jLabel = new JLabel();
        this.fieldFrom = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.fieldSize = new JTextField();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descriptionArea = ComponentFactory.getTextArea();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel4 = new JLabel();
        this.comboPath = new JComboBox();
        this.btnSelectPath = new JButton();
        this.progressBar = new JProgressBar();
        JLabel jLabel5 = new JLabel();
        this.remainingLabel = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.estTimeLabel = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.currentSpeedLabel = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.avgSpeedLabel = new JLabel();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(Borders.DIALOG_BORDER);
        jPanel.setLayout(new BorderLayout());
        this.iconLabel.setName("iconLabel");
        this.pathLabel.setName("pathLabel");
        this.pathLabel.setFont(new Font("Tahoma", 1, 12));
        jLabel.setName("labelFrom");
        this.fieldFrom.setBorder(null);
        this.fieldFrom.setOpaque(false);
        this.fieldFrom.setName("fieldFrom");
        jLabel2.setName("labelSize");
        this.fieldSize.setBorder(null);
        this.fieldSize.setOpaque(false);
        jLabel3.setName("labelDescription");
        jScrollPane.setViewportView(this.descriptionArea);
        jLabel4.setName("saveToLabel");
        jLabel4.setLabelFor(this.comboPath);
        this.comboPath.setEditable(true);
        this.btnSelectPath.setName("btnSelectPath");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")), jPanel3);
        panelBuilder.add((Component)jLabel4, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.comboPath, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.btnSelectPath, cellConstraints.xy(5, 1));
        this.progressBar.setFont(new Font("Tahoma", 1, 16));
        jLabel5.setName("labelRemaining");
        this.remainingLabel.setName("remainingLabel");
        this.remainingLabel.setFont(new Font("Tahoma", 1, 12));
        jLabel6.setName("labelEstimateTime");
        this.estTimeLabel.setName("estTimeLabel");
        this.estTimeLabel.setFont(new Font("Tahoma", 1, 12));
        jLabel7.setName("labelCurrentSpeed");
        this.currentSpeedLabel.setName("currentSpeedLabel");
        this.currentSpeedLabel.setFont(new Font("Tahoma", 1, 12));
        jLabel8.setName("labelAverageSpeed");
        this.avgSpeedLabel.setName("avgSpeedLabel");
        this.avgSpeedLabel.setFont(new Font("Tahoma", 1, 12));
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec((Size)Sizes.dluX((int)54)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec("max(min;70dlu)")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.bounded((Size)Sizes.PREFERRED, (Size)Sizes.dluY((int)40), (Size)Sizes.dluY((int)50)), 1.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, new RowSpec("fill:max(pref;20dlu)"), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}), jPanel2);
        panelBuilder.add((Component)this.iconLabel, cellConstraints.xywh(1, 1, 1, 5));
        panelBuilder.add((Component)this.pathLabel, cellConstraints.xywh(3, 1, 7, 1));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.fieldFrom, cellConstraints.xywh(5, 3, 5, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)this.fieldSize, cellConstraints.xywh(5, 5, 3, 1));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(1, 7));
        panelBuilder.add((Component)jScrollPane, cellConstraints.xywh(1, 9, 9, 1));
        panelBuilder.add((Component)jPanel3, cellConstraints.xywh(1, 11, 9, 1));
        panelBuilder.add((Component)this.progressBar, cellConstraints.xywh(1, 13, 9, 1));
        panelBuilder.add((Component)jLabel5, cellConstraints.xy(1, 15));
        panelBuilder.add((Component)this.remainingLabel, cellConstraints.xywh(3, 15, 3, 1));
        panelBuilder.add((Component)jLabel6, cellConstraints.xy(7, 15));
        panelBuilder.add((Component)this.estTimeLabel, cellConstraints.xy(9, 15));
        panelBuilder.add((Component)jLabel7, cellConstraints.xy(1, 17));
        panelBuilder.add((Component)this.currentSpeedLabel, cellConstraints.xywh(3, 17, 3, 1));
        panelBuilder.add((Component)jLabel8, cellConstraints.xy(7, 17));
        panelBuilder.add((Component)this.avgSpeedLabel, cellConstraints.xy(9, 17));
        jPanel.add((Component)jPanel2, "Center");
        jXButtonPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.okButton.setName("okButton");
        this.cancelButton.setName("cancelButton");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec("max(pref;42dlu)"), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"fill:pref")), (JPanel)jXButtonPanel);
        ((FormLayout)jXButtonPanel.getLayout()).setColumnGroups((int[][])new int[][]{{3, 5}});
        panelBuilder.add((Component)this.okButton, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.cancelButton, cellConstraints.xy(5, 1));
        jPanel.add((Component)jXButtonPanel, "South");
        container.add((Component)jPanel, "Center");
    }

    private void updateInit() {
        this.updateFrom();
        this.updateSize();
        this.updateFileName();
        this.updateState();
    }

    private void updateState() {
        this.updateAvgSpeed();
        this.updateSpeed();
        this.updateDurationTime();
        this.updateEstimateTime();
        this.updateDownloaded();
        this.updateEnabled();
    }

    private void updateEnabled() {
        DownloadState downloadState = this.file.getState();
        javax.swing.Action action = this.getActionMap().get("okBtnAction");
        javax.swing.Action action2 = this.getActionMap().get("btnSelectPathAction");
        boolean bl = downloadState != DownloadState.COMPLETED && downloadState != DownloadState.DELETED;
        action.setEnabled(bl);
        action2.setEnabled(bl);
        this.descriptionArea.setEditable(bl);
        this.comboPath.setEditable(bl);
        this.comboPath.setEnabled(bl);
    }

    private void updateDownloaded() {
        int n = ContentPanel.getProgress(this.file);
        this.progressBar.setString(n + "%");
        this.progressBar.setValue(n);
    }

    private void updateSpeeds() {
        this.updateAvgSpeed();
        this.updateSpeed();
        this.updateEstimateTime();
        this.updateDurationTime();
    }

    private void updateSize() {
        String string;
        long l = this.file.getFileSize();
        if (l >= 0L) {
            string = ContentPanel.bytesToAnother(l);
            if (l >= 1024L) {
                string = string + "  (" + NumberFormat.getIntegerInstance().format(l) + " B)";
            }
        } else {
            string = this.getResourceMap().getString("unknown", new Object[0]);
        }
        this.fieldSize.setText(string);
    }

    private void updateAvgSpeed() {
        DownloadState downloadState = this.file.getState();
        String string = "";
        if (downloadState == DownloadState.DOWNLOADING) {
            string = this.file.getAverageSpeed() >= 0.0f ? ContentPanel.bytesToAnother((long)this.file.getAverageSpeed()) + "/s" : "0 B/s";
        } else if (downloadState == DownloadState.COMPLETED && this.file.getAverageSpeed() > 0.0f) {
            string = ContentPanel.bytesToAnother((long)this.file.getAverageSpeed()) + "/s";
        }
        this.avgSpeedLabel.setText(this.getResourceMap().getString("textBold", string));
    }

    private void updateSpeed() {
        String string = this.file.getState() == DownloadState.DOWNLOADING ? (this.file.getSpeed() >= 0L ? ContentPanel.bytesToAnother(this.file.getSpeed()) + "/s" : "0 B/s") : "";
        this.currentSpeedLabel.setText(this.getResourceMap().getString("textBold", string));
    }

    private void updateDurationTime() {
        String string;
        if (DownloadsActions.isProcessState(this.file.getState())) {
            DownloadTask downloadTask = this.file.getTask();
            string = downloadTask != null ? ContentPanel.secondsToHMin(downloadTask.getExecutionDuration(TimeUnit.SECONDS)) : "";
        } else {
            long l = this.file.getCompleteTaskDuration();
            string = this.file.getState() == DownloadState.COMPLETED && l > 0L ? ContentPanel.secondsToHMin(l) : "";
        }
        this.estTimeLabel.setText(this.getResourceMap().getString("textBold", string));
    }

    private void updateEstimateTime() {
        String string = "";
        DownloadState downloadState = this.file.getState();
        if (downloadState == DownloadState.DOWNLOADING) {
            long l = this.file.getFileSize() - this.file.getDownloaded();
            float f = this.file.getAverageSpeed();
            string = Float.compare(0.0f, f) != 0 ? ContentPanel.secondsToHMin(Math.round((float)l / f)) : this.getResourceMap().getString("estimating", new Object[0]);
        } else if (downloadState == DownloadState.WAITING) {
            string = this.getResourceMap().getString("waiting", ContentPanel.secondsToHMin(this.file.getSleep()));
        }
        this.remainingLabel.setText(this.getResourceMap().getString("textBold", string));
    }

    private void updateFileName() {
        Icon icon = this.director.getFileTypeIconProvider().getIconImageByFileType(this.file.getFileType(), true);
        this.iconLabel.setIcon(icon);
        this.iconLabel.setHorizontalAlignment(0);
        this.pathLabel.setText(this.getResourceMap().getString("textBold", FileUtils.getAbsolutPath(this.file.getOutputFile())));
    }

    private void updateFrom() {
        this.fieldFrom.setText(this.file.getFileUrl().toExternalForm());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("speed".equals(propertyChangeEvent.getPropertyName())) {
            this.updateSpeeds();
        } else if ("averageSpeed".equals(propertyChangeEvent.getPropertyName())) {
            this.updateSpeeds();
        } else if ("state".equals(propertyChangeEvent.getPropertyName())) {
            this.updateState();
        } else if ("fileName".equals(propertyChangeEvent.getPropertyName())) {
            this.updateFileName();
        } else if ("fileSize".equals(propertyChangeEvent.getPropertyName())) {
            this.updateSize();
        } else if ("sleep".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEstimateTime();
            this.updateDurationTime();
        } else if ("downloaded".equals(propertyChangeEvent.getPropertyName())) {
            this.updateDownloaded();
        }
    }
}

