/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.list.ArrayListModel;
import cz.vity.freerapid.model.PluginMetaData;
import cz.vity.freerapid.swing.SwingXUtils;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import org.jdesktop.swingx.hyperlink.LinkModel;

class PluginMetaDataTableModel
extends AbstractTableModel
implements ListDataListener {
    private final ArrayListModel<PluginMetaData> model;
    private final String[] columns;
    static final int COLUMN_ACTIVE = 0;
    static final int COLUMN_UPDATE = 1;
    static final int COLUMN_ID = 2;
    static final int COLUMN_VERSION = 3;
    static final int COLUMN_SERVICES = 4;
    static final int COLUMN_AUTHOR = 5;
    static final int COLUMN_WWW = 6;

    public PluginMetaDataTableModel(ArrayListModel<PluginMetaData> arrayListModel, String[] stringArray) {
        this.model = arrayListModel;
        this.columns = stringArray;
        arrayListModel.addListDataListener((ListDataListener)this);
    }

    @Override
    public int getRowCount() {
        return this.model.getSize();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 || n2 == 1;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0 || n == 1) {
            return Boolean.class;
        }
        if (n == 6) {
            return LinkModel.class;
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PluginMetaData pluginMetaData = (PluginMetaData)this.model.get(n);
        switch (n2) {
            case 0: {
                return pluginMetaData.isEnabled();
            }
            case 1: {
                return pluginMetaData.isUpdatesEnabled();
            }
            case 2: {
                return pluginMetaData.getId();
            }
            case 3: {
                return pluginMetaData.getVersion();
            }
            case 4: {
                return pluginMetaData.getServices();
            }
            case 5: {
                return pluginMetaData.getVendor();
            }
            case 6: {
                return SwingXUtils.createLink(pluginMetaData.getWWW());
            }
        }
        assert (false);
        return pluginMetaData;
    }

    public PluginMetaData getObject(int n) {
        return (PluginMetaData)this.model.get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            ((PluginMetaData)this.model.get(n)).setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
        if (n2 == 1) {
            ((PluginMetaData)this.model.get(n)).setUpdatesEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireTableRowsUpdated(listDataEvent.getIndex0(), listDataEvent.getIndex1());
    }
}

