/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.ssl.EasySSLProtocolSocketFactory;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class ClientManager {
    private static final String SOCKS_PREFIX_REGEXP = "^(\\$SOCKS\\$|SOCKS\\:)";
    private static final Logger logger = Logger.getLogger(ClientManager.class.getName());
    private final List<ConnectionSettings> availableConnections = new ArrayList<ConnectionSettings>(2);
    private Stack<HttpDownloadClient> workingClientsPool = new Stack();
    private static final String PROXY_LIST_DEFAULT_PATH = new File(Utils.getAppPath(), "proxy.list").getAbsolutePath();
    public static final int MAX_DOWNLOADING = 9;
    private ConnectionSettings defaultConnectionSettings = new ConnectionSettings();
    private volatile int popCount;
    private final Object connectionSettingsLock = new Object();
    private final ManagerDirector managerDirector;
    private int rotate = 0;

    public ClientManager(ManagerDirector managerDirector) {
        this.managerDirector = managerDirector;
        this.defaultConnectionSettings.setDefault(true);
        boolean bl = AppPrefs.getProperty("useSystemProxies", false);
        if (!bl) {
            ProxySelector.setDefault(null);
        }
        this.popCount = 0;
        this.initSSL();
        this.updateConnectionSettings();
    }

    private void initSSL() {
        try {
            EasySSLProtocolSocketFactory easySSLProtocolSocketFactory = new EasySSLProtocolSocketFactory();
            Protocol protocol = new Protocol("https", (ProtocolSocketFactory)easySSLProtocolSocketFactory, 443);
            Protocol.registerProtocol((String)"https", (Protocol)protocol);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            logger.warning("SSL initialization failed - some plugins won't work");
        }
    }

    private void updateProxies() {
        String string;
        File file;
        if (AppPrefs.getProperty("useProxyList", true) && (file = new File(string = AppPrefs.getProperty("proxyListPath", PROXY_LIST_DEFAULT_PATH))).exists() && file.isFile() && file.canRead()) {
            try {
                this.readProxyList(file);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        }
    }

    private void updateDefault() {
        if (this.useDefaultConnection()) {
            boolean bl = this.defaultConnectionSettings.isEnabled();
            this.defaultConnectionSettings = new ConnectionSettings();
            this.defaultConnectionSettings.setDefault(true);
            this.initDefaultProxySettings(this.defaultConnectionSettings);
            this.defaultConnectionSettings.setEnabled(bl);
            this.availableConnections.add(this.defaultConnectionSettings);
        }
    }

    private boolean useDefaultConnection() {
        return AppPrefs.getProperty("useDefaultConnection", true);
    }

    private void initDefaultProxySettings(ConnectionSettings connectionSettings) {
        String string = System.getProperty("proxySet", "false");
        logger.info("Proxy set system default connection: " + string);
        if (AppPrefs.getProperty("proxy", Boolean.valueOf(string))) {
            int n;
            String string2 = AppPrefs.getProperty("proxy.url", System.getProperty("proxyHost", "localhost"));
            try {
                n = Integer.valueOf(AppPrefs.getProperty("proxy.port", System.getProperty("proxyPort", "8080")));
            }
            catch (NumberFormatException numberFormatException) {
                n = 8080;
            }
            if (AppPrefs.getProperty("proxy.login", false)) {
                String string3 = AppPrefs.getProperty("proxy.username", "");
                String string4 = Utils.generateXorString(AppPrefs.getProperty("proxy.password", ""));
                connectionSettings.setProxy(string2, n, Proxy.Type.HTTP, string3, string4);
            } else {
                connectionSettings.setProxy(string2, n, Proxy.Type.HTTP);
            }
            boolean bl = AppPrefs.getProperty("defaultConnectionSocks", false);
            if (bl) {
                connectionSettings.setProxyType(Proxy.Type.SOCKS);
            }
            logger.info("Setting proxy configuration ON with configuration: " + connectionSettings.toString());
        } else {
            logger.info("Setting proxy configuration OFF for default connection");
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                ConnectionSettings connectionSettings;
                if ("SOCKS5".equals(this.getRequestingProtocol()) && (connectionSettings = ClientManager.this.findConnectionByParameters(this.getRequestingHost(), this.getRequestingPort(), Proxy.Type.SOCKS)) != null) {
                    String string = connectionSettings.getPassword();
                    char[] cArray = string == null ? null : string.toCharArray();
                    return new PasswordAuthentication(connectionSettings.getUserName(), cArray);
                }
                return null;
            }
        });
    }

    private ConnectionSettings findConnectionByParameters(String string, int n, Proxy.Type type) {
        List<ConnectionSettings> list = this.getAvailableConnections();
        for (ConnectionSettings connectionSettings : list) {
            if (connectionSettings.getProxyPort() != n || connectionSettings.getProxyType() != type || !connectionSettings.getProxyURL().equalsIgnoreCase(string)) continue;
            return connectionSettings;
        }
        return null;
    }

    private void readProxyList(File file) {
        Pattern pattern = Pattern.compile("((\\w*)(:(.*?))?@)?(.*?):(\\d{2,5})");
        Pattern pattern2 = Pattern.compile(SOCKS_PREFIX_REGEXP, 2);
        String[] stringArray = Utils.loadFile(file).split("(\\s)");
        boolean bl = AppPrefs.getProperty("autodetectSOCKSProxy", true);
        for (String string : stringArray) {
            Proxy.Type type;
            if (string.isEmpty()) continue;
            Matcher matcher = pattern2.matcher(string);
            if (matcher.find()) {
                type = Proxy.Type.SOCKS;
                string = string.substring(matcher.group(1).length());
            } else {
                type = Proxy.Type.HTTP;
            }
            Matcher matcher2 = pattern.matcher(string);
            if (matcher2.matches()) {
                String[] stringArray2;
                String string2;
                String[] stringArray3;
                int n = string.lastIndexOf(64);
                ConnectionSettings connectionSettings = new ConnectionSettings();
                if (n >= 0) {
                    stringArray3 = string.substring(0, n);
                    string2 = string.substring(n + 1);
                    n = stringArray3.indexOf(58);
                    stringArray2 = string2.split(":");
                    Integer n2 = Integer.valueOf(stringArray2[1]);
                    if (n2 > 65535) continue;
                    if (bl && n2 >= 1080 && n2 <= 1090) {
                        type = Proxy.Type.SOCKS;
                    }
                    if (n > 0) {
                        connectionSettings.setProxy(stringArray2[0], n2, type, stringArray3.substring(0, n), stringArray3.substring(n + 1));
                    } else {
                        connectionSettings.setProxy(stringArray2[0], n2, type, (String)stringArray3, null);
                    }
                } else {
                    string2 = string;
                    stringArray3 = string2.split(":");
                    stringArray2 = Integer.valueOf(stringArray3[1]);
                    if (stringArray2.intValue() > 65535) continue;
                    if (bl && stringArray2.intValue() >= 1080 && stringArray2.intValue() <= 1090) {
                        type = Proxy.Type.SOCKS;
                    }
                    connectionSettings.setProxy(stringArray3[0], stringArray2.intValue(), type);
                }
                this.availableConnections.add(connectionSettings);
                logger.info("Reading proxy definition " + connectionSettings.toString());
                continue;
            }
            logger.warning("String " + string + " does not match to proxy definition pattern - [username[:password@]]host:port");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getAvailableConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.availableConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getEnabledConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.getEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getRotatedEnabledConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            ArrayList<ConnectionSettings> arrayList = new ArrayList<ConnectionSettings>(this.availableConnections.size());
            for (ConnectionSettings connectionSettings : this.availableConnections) {
                if (!connectionSettings.isEnabled() || connectionSettings.isDefault()) continue;
                arrayList.add(connectionSettings);
            }
            if (arrayList.size() > 1) {
                Collections.rotate(arrayList, this.rotate++);
            }
            if (this.useDefaultConnection() && this.defaultConnectionSettings.isEnabled()) {
                arrayList.add(0, this.defaultConnectionSettings);
            }
            return arrayList;
        }
    }

    private List<ConnectionSettings> getEnabled() {
        LinkedList<ConnectionSettings> linkedList = new LinkedList<ConnectionSettings>();
        for (ConnectionSettings connectionSettings : this.availableConnections) {
            if (!connectionSettings.isEnabled()) continue;
            linkedList.add(connectionSettings);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionEnabled(ConnectionSettings connectionSettings, boolean bl) {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            connectionSettings.setEnabled(bl);
        }
    }

    public synchronized HttpDownloadClient popWorkingClient() {
        if (this.popCount < 9) {
            ++this.popCount;
            if (this.workingClientsPool.isEmpty()) {
                return new DownloadClient();
            }
            return this.workingClientsPool.pop();
        }
        throw new IllegalStateException("Cannot pop more connections");
    }

    public synchronized void pushWorkingClient(HttpDownloadClient httpDownloadClient) {
        --this.popCount;
        this.workingClientsPool.add(httpDownloadClient);
    }

    public void updateDefaultConnection() {
        this.updateConnectionSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionSettings() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            this.availableConnections.clear();
            this.updateDefault();
            this.updateProxies();
        }
        object = this.managerDirector.getMenuManager();
        if (object != null) {
            ((MenuManager)object).updateConnectionSettings(this.getAvailableConnections());
        }
    }

    public void updateProxyConnectionList() {
        this.updateConnectionSettings();
    }
}

