/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.DelayedReadValueModel;
import com.jgoodies.binding.value.ValueModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.managers.FileListMaintainer;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.gui.managers.ProcessManager;
import cz.vity.freerapid.gui.managers.UrlListDataListener;
import cz.vity.freerapid.gui.managers.exceptions.NotSupportedDownloadServiceException;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.interfaces.MaintainQueueSupport;
import cz.vity.freerapid.swing.Swinger;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;

public class DataManager
extends AbstractBean
implements PropertyChangeListener,
ListDataListener,
MaintainQueueSupport {
    private static final Logger logger = Logger.getLogger(DataManager.class.getName());
    private final ArrayListModel<DownloadFile> downloadFiles = new ArrayListModel();
    private ProcessManager processManager;
    private final ManagerDirector director;
    private final ApplicationContext context;
    private final Object lock = new Object();
    private int completed;
    private int notFound;
    private PluginsManager pluginsManager;
    private int dataChanged = 0;
    private FileListMaintainer fileListMaintainer;
    private boolean optimizeSavingList;
    private EventListenerList listenerList = new EventListenerList();

    public DataManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.director = managerDirector;
        this.context = applicationContext;
        this.fileListMaintainer = new FileListMaintainer(applicationContext, managerDirector, this);
        this.pluginsManager = managerDirector.getPluginsManager();
        this.optimizeSavingList = AppPrefs.getProperty("optimizeSavingList", false);
        applicationContext.getApplication().addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject eventObject) {
                if (AppPrefs.getProperty("minimizeOnClose", false) && eventObject instanceof WindowEvent) {
                    return true;
                }
                boolean bl = AppPrefs.getProperty("confirmExit", true);
                if (bl && DataManager.this.isDownloading()) {
                    int n = Swinger.getChoiceOKCancel("downloadInProgress", new Object[0]);
                    return n == 0;
                }
                return true;
            }

            @Override
            public void willExit(EventObject eventObject) {
                DataManager.this.exitDownloading();
                DataManager.this.saveListToBeanImmediately();
            }
        });
        this.updateCompleted();
        this.downloadFiles.addListDataListener((ListDataListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitDownloading() {
        boolean bl = false;
        this.processManager.interrupt();
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile downloadFile : this.downloadFiles) {
                DownloadTask downloadTask = downloadFile.getTask();
                if (downloadTask == null || downloadTask.isTerminated()) continue;
                downloadFile.setState(DownloadState.PAUSED);
                downloadTask.cancel(true);
                bl = true;
                if (AppPrefs.getProperty("downloadOnStart", true)) {
                    downloadFile.setState(DownloadState.QUEUED);
                    continue;
                }
                downloadFile.setState(DownloadState.PAUSED);
            }
        }
        if (bl) {
            try {
                Thread.sleep(700L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void saveListToBeanImmediately() {
        this.fileListMaintainer.saveToFile(this.downloadFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initProcessManager() {
        Object object = this.lock;
        synchronized (object) {
            this.fileListMaintainer.loadListToBean((Collection<DownloadFile>)this.downloadFiles);
        }
        this.processManager = new ProcessManager(this.director, this.context);
        this.processManager.start();
        if (AppPrefs.getProperty("autosaveEnabled", true)) {
            object = new PropertyAdapter((Object)this, "dataChanged", true);
            int n = AppPrefs.getProperty("autosaveTime", 10);
            DelayedReadValueModel delayedReadValueModel = new DelayedReadValueModel((ValueModel)object, n * 1000, false);
            delayedReadValueModel.addValueChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    DataManager.this.fileListMaintainer.saveListToFileOnBackground((Collection<DownloadFile>)DataManager.this.downloadFiles);
                }
            });
        }
        this.addPropertyChangeListener("state", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() == DownloadState.COMPLETED && AppPrefs.getProperty("removeCompletedDownloads", 0) == 1) {
                    DataManager.this.removeCompleted();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(List<DownloadFile> list) {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile downloadFile : list) {
                downloadFile.setState(DownloadState.QUEUED);
            }
        }
        this.processManager.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToList(List<DownloadFile> list) {
        Object object = this.lock;
        synchronized (object) {
            this.addOnList(list);
        }
        this.fireUrlsAdded(list);
    }

    private void addOnList(List<DownloadFile> list) {
        boolean bl = AppPrefs.getProperty("startDownloadFromTheTop", true);
        for (DownloadFile downloadFile : list) {
            try {
                downloadFile.setPluginID(this.pluginsManager.getServiceIDForURL(downloadFile.getFileUrl()));
            }
            catch (NotSupportedDownloadServiceException notSupportedDownloadServiceException) {
                downloadFile.setState(DownloadState.ERROR);
                downloadFile.setErrorMessage(Swinger.getMessageFromException(Swinger.getResourceMap(), notSupportedDownloadServiceException));
            }
            downloadFile.addPropertyChangeListener(this);
            if (bl) {
                this.downloadFiles.add((Object)downloadFile);
                continue;
            }
            this.downloadFiles.add(0, (Object)downloadFile);
        }
    }

    public void addUrlListDataListener(UrlListDataListener urlListDataListener) {
        this.listenerList.add(UrlListDataListener.class, urlListDataListener);
    }

    private void fireUrlsAdded(List<DownloadFile> list) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != UrlListDataListener.class) continue;
            ((UrlListDataListener)objectArray[i + 1]).linksAdded(list);
        }
    }

    public ArrayListModel<DownloadFile> getDownloadFiles() {
        return this.downloadFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadFile> getActualDownloadFiles() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<DownloadFile>((Collection<DownloadFile>)this.downloadFiles));
        }
    }

    private int getIndex(DownloadFile downloadFile) {
        return this.downloadFiles.indexOf((Object)downloadFile);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        final String string = propertyChangeEvent.getPropertyName();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadFile downloadFile = (DownloadFile)propertyChangeEvent.getSource();
                DataManager.this.downloadFiles.fireContentsChanged(DataManager.this.getIndex(downloadFile));
                if ("state".equals(string) || !DataManager.this.optimizeSavingList && "downloaded".equals(string)) {
                    DataManager.this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                    DataManager.this.fireDataChanged();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDownloadFilesStates(int[] nArray, EnumSet<DownloadState> enumSet) {
        Object object = this.lock;
        synchronized (object) {
            if (nArray.length == 0) {
                return false;
            }
            for (int n : nArray) {
                DownloadFile downloadFile = (DownloadFile)this.downloadFiles.get(n);
                DownloadState downloadState = downloadFile.getState();
                if (enumSet.contains((Object)downloadState)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyDownloadFilesStates(int[] nArray, EnumSet<DownloadState> enumSet) {
        Object object = this.lock;
        synchronized (object) {
            if (nArray.length == 0) {
                return false;
            }
            for (int n : nArray) {
                DownloadFile downloadFile = (DownloadFile)this.downloadFiles.get(n);
                DownloadState downloadState = downloadFile.getState();
                if (!enumSet.contains((Object)downloadState)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelected(List<DownloadFile> list) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DownloadFile> arrayList = new ArrayList<DownloadFile>();
            for (DownloadFile downloadFile : list) {
                downloadFile.setState(DownloadState.DELETED);
                arrayList.add(downloadFile);
            }
            for (DownloadFile downloadFile : arrayList) {
                this.downloadFiles.remove((Object)downloadFile);
            }
            for (DownloadFile downloadFile : arrayList) {
                DownloadTask downloadTask = downloadFile.getTask();
                if (downloadTask != null && !downloadTask.isTerminated()) {
                    downloadTask.cancel(true);
                }
                downloadFile.removePropertyChangeListener(this);
            }
        }
        this.processManager.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelected(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadFile> list = this.selectionToList(nArray);
            LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
            for (DownloadFile downloadFile : list) {
                if (!DownloadsActions.resumeEnabledStates.contains((Object)downloadFile.getState())) continue;
                downloadFile.resetErrorAttempts();
                linkedList.add(downloadFile);
            }
            this.addToQueue(linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSelected(int[] nArray, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadFile> list = this.selectionToList(nArray);
            for (DownloadFile downloadFile : list) {
                if (!DownloadsActions.cancelEnabledStates.contains((Object)downloadFile.getState())) continue;
                DownloadTask downloadTask = downloadFile.getTask();
                if (downloadTask != null && !downloadTask.isTerminated()) {
                    downloadTask.cancel(true);
                }
                downloadFile.setState(DownloadState.CANCELLED);
                if (bl && downloadFile.getDownloaded() > 0L) {
                    File file = downloadFile.getStoreFile();
                    if (file != null && file.exists() && !file.delete()) {
                        logger.info("Deleting store file " + file + " failed");
                    }
                    if ((file = downloadFile.getOutputFile()) != null && file.exists() && !file.delete()) {
                        logger.info("Deleting output file " + file + " failed");
                    }
                }
                downloadFile.setDownloaded(0L);
            }
        }
        this.processManager.queueUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DownloadFile> getSelectionToList(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            return this.selectionToList(nArray);
        }
    }

    private List<DownloadFile> selectionToList(int[] nArray) {
        ArrayList<DownloadFile> arrayList = new ArrayList<DownloadFile>();
        for (int n : nArray) {
            arrayList.add((DownloadFile)this.downloadFiles.get(n));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelected(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            List<DownloadFile> list = this.selectionToList(nArray);
            for (DownloadFile downloadFile : list) {
                DownloadState downloadState = downloadFile.getState();
                if (!DownloadsActions.pauseEnabledStates.contains((Object)downloadState) && (downloadState != DownloadState.DOWNLOADING || !downloadFile.isResumeSupported())) continue;
                DownloadTask downloadTask = downloadFile.getTask();
                downloadFile.setState(DownloadState.PAUSED);
                if (downloadTask == null) continue;
                downloadTask.cancel(true);
            }
        }
        this.processManager.queueUpdated();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
        this.fireDataChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
        this.fireDataChanged();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompleted() {
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            int n2 = 0;
            for (DownloadFile downloadFile : this.downloadFiles) {
                if (downloadFile.getState() == DownloadState.COMPLETED) {
                    ++n;
                }
                if (downloadFile.getFileState() != FileState.FILE_NOT_FOUND) continue;
                ++n2;
            }
            this.setCompleted(n);
            this.setNotFound(n2);
        }
    }

    private void setNotFound(int n) {
        int n2 = this.notFound;
        this.notFound = n;
        this.firePropertyChange("notFound", n2, this.notFound);
    }

    public int getCompleted() {
        return this.completed;
    }

    public int getNotFound() {
        return this.notFound;
    }

    public void setCompleted(int n) {
        int n2 = this.completed;
        this.completed = n;
        this.firePropertyChange("completed", n2, this.completed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompleted() {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
            for (DownloadFile downloadFile : this.downloadFiles) {
                if (downloadFile.getState() != DownloadState.COMPLETED) continue;
                linkedList.add(downloadFile);
            }
            this.downloadFiles.removeAll(linkedList);
            for (DownloadFile downloadFile : linkedList) {
                downloadFile.setState(DownloadState.DELETED);
            }
        }
    }

    public Object getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkComplete() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = AppPrefs.getProperty("autoshutdownWithErrors", false);
            for (DownloadFile downloadFile : this.downloadFiles) {
                boolean bl2;
                DownloadState downloadState = downloadFile.getState();
                if (DownloadsActions.isProcessState(downloadState) || downloadState == DownloadState.QUEUED || downloadState == DownloadState.SLEEPING) {
                    return false;
                }
                if (downloadState != DownloadState.ERROR || (bl2 = downloadFile.getErrorAttemptsCount() == 0) || bl) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTop(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            if (nArray.length > 1) {
                Arrays.sort(nArray);
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n == i) continue;
                DownloadFile downloadFile = (DownloadFile)this.downloadFiles.remove(n);
                this.downloadFiles.add(i, (Object)downloadFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveBottom(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            int n = nArray.length;
            if (n > 1) {
                Arrays.sort(nArray);
            }
            int n2 = this.downloadFiles.size() - 1;
            for (int i = n - 1; i >= 0; --i) {
                int n3 = nArray[i];
                int n4 = n2 - (n - 1 - i);
                if (n3 == n4) continue;
                this.downloadFiles.add(n4, this.downloadFiles.remove(n3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveUp(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            if (nArray.length > 1) {
                Arrays.sort(nArray);
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = Math.max(Math.max(0, n - 1), i);
                if (n != n2) {
                    this.downloadFiles.add(n2, this.downloadFiles.remove(n));
                }
                nArray[i] = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDown(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            int n = nArray.length;
            if (n > 1) {
                Arrays.sort(nArray);
            }
            int n2 = this.downloadFiles.size() - 1;
            for (int i = n - 1; i >= 0; --i) {
                int n3;
                int n4 = nArray[i];
                nArray[i] = n3 = Math.min(Math.min(n2, n4 + 1), n2 - (n - 1 - i));
                if (n4 == n3) continue;
                this.downloadFiles.add(n3, this.downloadFiles.remove(n4));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloading() {
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile downloadFile : this.downloadFiles) {
                if (!DownloadsActions.isProcessState(downloadFile.getState())) continue;
                return true;
            }
        }
        return false;
    }

    public int getDownloading() {
        return this.processManager.getDownloading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceDownload(ConnectionSettings connectionSettings, int[] nArray) {
        List<DownloadFile> list;
        Object object = this.lock;
        synchronized (object) {
            list = this.selectionToList(nArray);
        }
        this.processManager.forceDownload(connectionSettings, list);
    }

    public void checkQueue() {
        this.processManager.queueUpdated();
    }

    public int getDataChanged() {
        return this.dataChanged;
    }

    private void fireDataChanged() {
        this.firePropertyChange("dataChanged", this.dataChanged, ++this.dataChanged);
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sortByName(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            if (nArray.length == 1) {
                return -1;
            }
            List<DownloadFile> list = this.selectionToList(nArray);
            DownloadFile[] downloadFileArray = list.toArray(new DownloadFile[list.size()]);
            Arrays.sort(downloadFileArray, new Comparator<DownloadFile>(){

                @Override
                public int compare(DownloadFile downloadFile, DownloadFile downloadFile2) {
                    return downloadFile.getFileName().compareToIgnoreCase(downloadFile2.getFileName());
                }
            });
            if (nArray.length > 1) {
                Arrays.sort(nArray);
            }
            int n = nArray[0];
            int n2 = nArray.length;
            for (int i = n2 - 1; i >= 0; --i) {
                this.downloadFiles.remove(nArray[i]);
            }
            this.downloadFiles.addAll(n, Arrays.asList(downloadFileArray));
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateLinks(int[] nArray) {
        if (nArray.length == 0) {
            return;
        }
        LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile downloadFile : this.selectionToList(nArray)) {
                if (!DownloadsActions.recheckExistingStates.contains((Object)downloadFile.getState())) continue;
                downloadFile.getProperties().put("previousState", (Object)downloadFile.getState());
                downloadFile.setFileState(FileState.NOT_CHECKED);
                downloadFile.setState(DownloadState.QUEUED);
                linkedList.add(downloadFile);
            }
        }
        if (!linkedList.isEmpty()) {
            this.processManager.forceValidateCheck(linkedList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvalidLinks() {
        Object object = this.lock;
        synchronized (object) {
            LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
            for (DownloadFile downloadFile : this.downloadFiles) {
                if (downloadFile.getFileState() != FileState.FILE_NOT_FOUND) continue;
                linkedList.add(downloadFile);
            }
            this.downloadFiles.removeAll(linkedList);
            for (DownloadFile downloadFile : linkedList) {
                downloadFile.setState(DownloadState.DELETED);
            }
        }
    }

    @Override
    public boolean addLinksToQueue(HttpFile httpFile, List<URI> list) {
        LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
        boolean bl = AppPrefs.getProperty("dontAddNotSupportedFromCrypter", true);
        for (URI uRI : list) {
            try {
                URL uRL = uRI.toURL();
                if (bl && !this.pluginsManager.isSupported(uRL)) continue;
                DownloadFile downloadFile = new DownloadFile(uRL, httpFile.getSaveToDirectory(), httpFile.getDescription());
                downloadFile.setPluginID("");
                downloadFile.setState(DownloadState.QUEUED);
                linkedList.add(downloadFile);
            }
            catch (MalformedURLException malformedURLException) {
                logger.warning("File with URI " + uRI.toString() + " cannot be added to queue");
            }
        }
        try {
            this.addToList(linkedList);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpeedLimit(int[] nArray, int n) {
        if (nArray.length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (DownloadFile downloadFile : this.selectionToList(nArray)) {
                downloadFile.setSpeedLimit(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPausable(int[] nArray) {
        Object object = this.lock;
        synchronized (object) {
            if (nArray.length == 0) {
                return false;
            }
            for (int n : nArray) {
                DownloadFile downloadFile = (DownloadFile)this.downloadFiles.get(n);
                DownloadState downloadState = downloadFile.getState();
                if (DownloadsActions.pauseEnabledStates.contains((Object)downloadState)) {
                    return true;
                }
                if (downloadState != DownloadState.DOWNLOADING || !downloadFile.isResumeSupported()) continue;
                return true;
            }
            return false;
        }
    }
}

