/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.list.ArrayListModel;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.actions.DownloadsActions;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.FileState;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;

class FileListMaintainer {
    private final ApplicationContext context;
    private final ManagerDirector director;
    private final DataManager dataManager;
    private final Object saveFileLock = new Object();
    private static final Logger logger = Logger.getLogger(FileListMaintainer.class.getName());
    private static final String FILES_LIST_XML = "filesList.xml";

    public FileListMaintainer(ApplicationContext applicationContext, ManagerDirector managerDirector, DataManager dataManager) {
        this.context = applicationContext;
        this.director = managerDirector;
        this.dataManager = dataManager;
    }

    void loadListToBean(Collection<DownloadFile> collection) {
        LocalStorage localStorage = this.context.getLocalStorage();
        File file = new File(localStorage.getDirectory(), FILES_LIST_XML);
        if (!file.exists()) {
            logger.info("Src list file does not exists from some reason. Trying to renew file from backup");
            try {
                FileUtils.renewBackup(file);
                logger.info("Backup copy was found and copied succesfuly");
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.info("Cannot renew src file, because backup file does not exist");
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
        }
        boolean bl = AppPrefs.getProperty("downloadOnStart", true);
        boolean bl2 = AppPrefs.getProperty("removeCompletedDownloads", 0) == 2;
        boolean bl3 = AppPrefs.getProperty("recheckFilesOnStart", false);
        List<DownloadFile> list = null;
        try {
            list = this.loadListFromFile(file, bl, bl2, bl3);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            logger.info("Trying to renew file from backup");
            try {
                FileUtils.renewBackup(file);
                list = this.loadListFromFile(file, bl, bl2, bl3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.info("Cannot renew src file, because backup file does not exist");
            }
            catch (Exception exception2) {
                LogUtils.processException(logger, exception);
            }
        }
        if (list != null) {
            collection.addAll(list);
        }
    }

    List<DownloadFile> loadListFromFile(File file, boolean bl, boolean bl2, boolean bl3) throws IOException {
        LinkedList<DownloadFile> linkedList = new LinkedList<DownloadFile>();
        Object object = this.context.getLocalStorage().load(file.getName());
        if (!(object instanceof ArrayListModel)) {
            return linkedList;
        }
        for (DownloadFile downloadFile : (ArrayListModel)object) {
            DownloadState downloadState = downloadFile.getState();
            if (downloadState == DownloadState.DELETED || downloadState == DownloadState.COMPLETED && bl2) continue;
            if (downloadState != DownloadState.COMPLETED && bl3) {
                downloadFile.setFileState(FileState.NOT_CHECKED);
            }
            if ((downloadState == DownloadState.ERROR || downloadState == DownloadState.SLEEPING) && bl && downloadFile.getTimeToQueued() > 0) {
                downloadFile.setTimeToQueued(-1);
                downloadFile.setTimeToQueuedMax(-1);
                downloadFile.setState(DownloadState.QUEUED);
            }
            if (DownloadsActions.isProcessState(downloadState)) {
                if (bl) {
                    downloadFile.setState(DownloadState.QUEUED);
                } else {
                    downloadFile.setState(DownloadState.PAUSED);
                }
            }
            if (downloadFile.getDownloaded() <= 0L) {
                downloadFile.setRealDownload(0L);
            } else {
                downloadFile.setDownloaded(downloadFile.getRealDownload());
            }
            downloadFile.resetSpeed();
            downloadFile.setTimeToQueued(-1);
            downloadFile.addPropertyChangeListener(this.dataManager);
            linkedList.add(downloadFile);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToFile(ArrayListModel<DownloadFile> arrayListModel) {
        Object object = this.saveFileLock;
        synchronized (object) {
            logger.info("=====Saving queue into the XML file=====");
            LocalStorage localStorage = this.context.getLocalStorage();
            File file = new File(localStorage.getDirectory(), FILES_LIST_XML);
            try {
                if (AppPrefs.getProperty("makeFileBackups", true)) {
                    FileUtils.makeBackup(file);
                }
                localStorage.save(arrayListModel, FILES_LIST_XML);
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            finally {
                logger.info("=====Finishing saving queue into the XML file=====");
            }
        }
    }

    void saveListToFileOnBackground(final Collection<DownloadFile> collection) {
        logger.info("--------saveListToBeansOnBackground------");
        TaskService taskService = this.director.getTaskServiceManager().getTaskService("workWithFile");
        taskService.execute(new Task(this.context.getApplication()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object doInBackground() throws Exception {
                ArrayListModel arrayListModel;
                Thread.currentThread().setPriority(1);
                Object object = FileListMaintainer.this.dataManager.getLock();
                synchronized (object) {
                    arrayListModel = new ArrayListModel(collection);
                }
                FileListMaintainer.this.saveToFile((ArrayListModel<DownloadFile>)arrayListModel);
                return null;
            }

            @Override
            protected void failed(Throwable throwable) {
                LogUtils.processException(logger, throwable);
            }
        });
    }
}

