/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.BoundedRangeAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ConverterFactory;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.swing.TrayIconSupport;
import cz.vity.freerapid.swing.binding.BindUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXStatusBar;

public class StatusBarManager
implements PropertyChangeListener,
ListDataListener {
    private JXStatusBar statusbar;
    private JLabel infoLabel;
    private final ManagerDirector director;
    private final ApplicationContext context;
    private JProgressBar progress;
    private MainApp app;
    private ResourceMap resourceMap;
    private DataManager dataManager;
    private Image defaultIconImage;
    private Image downloadingIconImage;
    private TrayIconSupport trayIconSupport;
    private PropertyChangeListener taskPCL;
    private Task activeTask = null;
    private JSlider slider;
    private static final int BAR_HEIGHT = 18;

    public StatusBarManager(ManagerDirector managerDirector, ApplicationContext applicationContext) {
        this.director = managerDirector;
        this.context = applicationContext;
        this.resourceMap = applicationContext.getResourceMap();
        this.dataManager = managerDirector.getDataManager();
        this.app = (MainApp)applicationContext.getApplication();
    }

    public JXStatusBar getStatusBar() {
        if (this.statusbar == null) {
            this.statusbar = new JXStatusBar();
            this.trayIconSupport = this.app.getTrayIconSupport();
            this.defaultIconImage = Utils.isWindows() ? this.resourceMap.getImageIcon("trayIconImageWin").getImage() : this.resourceMap.getImageIcon("trayIconImage").getImage();
            this.downloadingIconImage = this.resourceMap.getImageIcon("downloadingIconImage").getImage();
            Action action = this.context.getActionMap().get("showStatusBar");
            ValueModel valueModel = BindUtils.getPrefsValueModel("showStatusbar", true);
            action.putValue("SwingSelectedKey", valueModel.getValue());
            PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.getStatusBar(), (String)"visible");
            JLabel jLabel = new JLabel();
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AppPrefs.negateProperty("clipboardMonitoring", true);
                }
            });
            this.taskPCL = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                        StatusBarManager.this.progress.setIndeterminate(false);
                        StatusBarManager.this.progress.setValue((Integer)propertyChangeEvent.getNewValue());
                    } else if ("message".equals(propertyChangeEvent.getPropertyName())) {
                        StatusBarManager.this.progress.setStringPainted(true);
                        String string = (String)propertyChangeEvent.getNewValue();
                        StatusBarManager.this.progress.setString(string);
                        StatusBarManager.this.progress.setToolTipText(string);
                    }
                }
            };
            jLabel.setName("labelClipboardMonitoring");
            this.resourceMap.injectComponent(jLabel);
            this.statusbar.setName("statusbarPanel");
            this.infoLabel = new JLabel();
            this.progress = new JProgressBar();
            this.infoLabel.setPreferredSize(new Dimension(345, 18));
            jLabel.setPreferredSize(new Dimension(17, 18));
            this.progress.setPreferredSize(new Dimension(this.progress.getPreferredSize().width + 35, 18));
            this.progress.setVisible(false);
            this.director.getMenuManager().getMenuBar().addPropertyChangeListener("selectedText", this);
            this.statusbar.add((Component)this.infoLabel, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            this.initSpeedBar(jPanel, this.resourceMap);
            jPanel.setVisible(false);
            PropertyConnector.connectAndUpdate((ValueModel)BindUtils.getPrefsValueModel("clipboardMonitoring", true), (Object)jLabel, (String)"enabled");
            this.statusbar.add((Component)jLabel, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add((Component)this.progress, (Object)JXStatusBar.Constraint.ResizeBehavior.FIXED);
            this.statusbar.add(Box.createGlue(), (Object)JXStatusBar.Constraint.ResizeBehavior.FILL);
            this.context.getTaskMonitor().addPropertyChangeListener(this);
            this.dataManager.getDownloadFiles().addListDataListener((ListDataListener)this);
            this.dataManager.getProcessManager().addPropertyChangeListener("downloading", this);
            this.director.getSpeedRegulator().addPropertyChangeListener("speed", this);
            this.dataManager.addPropertyChangeListener("completed", this);
            this.dataManager.addPropertyChangeListener("state", this);
            AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(final PreferenceChangeEvent preferenceChangeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StatusBarManager.this.checkPropertyChange(preferenceChangeEvent);
                        }
                    });
                }
            });
            this.updateInfoStatus();
        }
        return this.statusbar;
    }

    private void initSpeedBar(JPanel jPanel, ResourceMap resourceMap) {
        JXCollapsiblePane jXCollapsiblePane = new JXCollapsiblePane();
        jXCollapsiblePane.setDirection(JXCollapsiblePane.Direction.RIGHT);
        jXCollapsiblePane.setBorder(null);
        jXCollapsiblePane.addPropertyChangeListener("animationState", (PropertyChangeListener)this);
        jXCollapsiblePane.setAnimated(true);
        jXCollapsiblePane.setPreferredSize(new Dimension(160, 18));
        jXCollapsiblePane.setBorder(null);
        JLabel jLabel = new JLabel();
        jLabel.setName("labelSpeedBtn");
        resourceMap.injectComponent(jLabel);
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AppPrefs.negateProperty("speedLimitEnabled", false);
            }
        });
        jPanel.add(jLabel);
        jPanel.add((Component)jXCollapsiblePane);
        jLabel.setBackground(null);
        ValueModel valueModel = BindUtils.getPrefsValueModel("speedLimitEnabled", false);
        PropertyConnector.connectAndUpdate((ValueModel)ConverterFactory.createBooleanNegator((ValueModel)valueModel), (Object)jXCollapsiblePane, (String)"collapsed");
        ValueModel valueModel2 = BindUtils.getReadOnlyPrefsValueModel("speedLimit", 250);
        this.slider = new JSlider((BoundedRangeModel)new BoundedRangeAdapter(valueModel2, 0, 0, 250));
        this.slider.setName("speedSlider");
        this.slider.setPreferredSize(new Dimension(100, 18));
        this.slider.setMaximumSize(new Dimension(100, 18));
        this.slider.setSize(45, 12);
        Font font = this.slider.getFont().deriveFont(6.0f);
        this.slider.setFont(font);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.slider.setSnapToTicks(true);
        this.bindSpeedSlider(this.slider);
        JLabel jLabel2 = new JLabel();
        jLabel2.setName("labelSpeed");
        jLabel2.setLabelFor(this.slider);
        Bindings.bind((JLabel)jLabel2, (ValueModel)ConverterFactory.createStringConverter((ValueModel)valueModel2, (Format)NumberFormat.getIntegerInstance()));
        jLabel2.setAlignmentX(1.0f);
        jLabel2.setPreferredSize(new Dimension(32, 18));
        jLabel2.setBackground(Color.green);
        JLabel jLabel3 = new JLabel();
        jLabel3.setLabelFor(this.slider);
        jLabel3.setName("labelSpeedUnit");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)this.slider, (String)"enabled");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)jLabel2, (String)"enabled");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)jLabel3, (String)"enabled");
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)jLabel, (String)"enabled");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.PREF_COLSPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC}), (JPanel)jXCollapsiblePane);
        panelBuilder.add((Component)this.slider, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(3, 1));
    }

    private void checkPropertyChange(PreferenceChangeEvent preferenceChangeEvent) {
        String string = preferenceChangeEvent.getKey();
        if ("showInfoInFrameTitle".equals(string)) {
            this.updateInfoStatus();
        } else if ("animateIcon".equals(string)) {
            if (!AppPrefs.getProperty("animateIcon", true)) {
                this.trayIconSupport.setImage(this.defaultIconImage);
            } else {
                this.updateIconAnimation();
            }
        } else if (!"showMemoryIndicator".equals(string)) {
            if ("speedLimitEnabled".equals(string)) {
                if (Boolean.TRUE.equals(Boolean.valueOf(preferenceChangeEvent.getNewValue()))) {
                    Swinger.inputFocus(this.slider);
                }
            } else if ("globalSpeedMax".equals(string) || "globalSpeedMax".equals(string) || "globalSpeedSliderStep".equals(string)) {
                this.bindSpeedSlider(this.slider);
            }
        }
    }

    private void setStatusBarVisible(boolean bl) {
        this.getStatusBar().setVisible(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("speed".equals(string) || "completed".equals(string)) {
            this.updateInfoStatus();
        } else if ("started".equals(string) || "done".equals(string) || "message".equals(string)) {
            if (!(propertyChangeEvent.getSource() instanceof DownloadTask)) {
                this.updateProgress(propertyChangeEvent);
            }
        } else if ("selectedText".equals(string)) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            if ("cancel".equals(string2)) {
                this.updateInfoStatus();
            } else {
                this.infoLabel.setText(string2);
            }
        } else if ("downloading".equals(string)) {
            if (AppPrefs.getProperty("animateIcon", true)) {
                this.updateIconAnimation();
            }
        } else if ("animationState".equals(string)) {
            this.statusbar.repaint();
        }
    }

    private void updateIconAnimation() {
        int n = this.dataManager.getDownloading();
        if (n == 0) {
            this.trayIconSupport.setImage(this.defaultIconImage);
        } else {
            this.trayIconSupport.setImage(this.downloadingIconImage);
        }
    }

    private void updateProgress(PropertyChangeEvent propertyChangeEvent) {
        Task task = (Task)propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if ("done".equals(string)) {
            this.progress.setVisible(false);
            task.removePropertyChangeListener(this.taskPCL);
            this.activeTask = null;
        } else if ("started".equals(string)) {
            if (this.activeTask != null) {
                task.removePropertyChangeListener(this.taskPCL);
            }
            this.activeTask = task;
            this.progress.setStringPainted(false);
            this.progress.setVisible(true);
            this.progress.setToolTipText(null);
            this.progress.setIndeterminate(!task.isProgressPropertyValid());
            task.addPropertyChangeListener(this.taskPCL);
        }
    }

    private void updateInfoStatus() {
        int n = this.dataManager.getCompleted();
        int n2 = this.dataManager.getDownloadFiles().size();
        long l = this.director.getSpeedRegulator().getSpeed();
        TrayIconSupport trayIconSupport = this.app.getTrayIconSupport();
        boolean bl = AppPrefs.getProperty("showInfoInFrameTitle", false);
        String string = ContentPanel.bytesToAnother(l);
        int n3 = this.dataManager.getDownloading();
        if (bl) {
            String string2 = n3 == 0 ? this.resourceMap.getString("frameTitleInfoNoDownloads", n, n2) : (l == 0L ? this.resourceMap.getString("frameTitleInfo0Speed", n, n2, string) : this.resourceMap.getString("frameTitleInfo", n, n2, string));
            this.app.getMainFrame().setTitle(string2);
        } else {
            this.app.getMainFrame().setTitle(this.resourceMap.getString("Application.title", new Object[0]));
        }
        if (n2 >= 0) {
            trayIconSupport.setToolTip(this.resourceMap.getString("tooltipTrayInfo", n, n2, string));
            this.infoLabel.setText(this.resourceMap.getString("statusBarInfo", n, n2, string));
        } else {
            trayIconSupport.setToolTip(this.resourceMap.getString("Application.title", new Object[0]));
            this.infoLabel.setText(this.resourceMap.getString("statusBarInfoIdle", new Object[0]));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateInfoStatus();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateInfoStatus();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    private void bindSpeedSlider(JSlider jSlider) {
        int n = AppPrefs.getProperty("globalSpeedMin", 50);
        int n2 = AppPrefs.getProperty("globalSpeedMax", 250);
        int n3 = AppPrefs.getProperty("globalSpeedSliderStep", 10);
        jSlider.setMinimum(n);
        jSlider.setMaximum(n2);
        jSlider.setMinorTickSpacing(n3);
    }
}

