/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import cz.vity.freerapid.plugins.exceptions.BuildMethodException;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.plugins.webclient.MethodBuilder;
import cz.vity.freerapid.plugins.webclient.hoster.CaptchaSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.DialogSupport;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpDownloadClient;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFile;
import cz.vity.freerapid.plugins.webclient.interfaces.HttpFileDownloadTask;
import cz.vity.freerapid.plugins.webclient.interfaces.PluginRunner;
import cz.vity.freerapid.plugins.webclient.interfaces.ShareDownloadService;
import cz.vity.freerapid.plugins.webclient.utils.PlugUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public abstract class AbstractRunner
implements PluginRunner {
    private static final Logger logger = Logger.getLogger(AbstractRunner.class.getName());
    protected HttpDownloadClient client;
    private ShareDownloadService pluginService;
    protected HttpFileDownloadTask downloadTask;
    protected HttpFile httpFile;
    protected String fileURL;
    private CaptchaSupport captchaSupport;
    private boolean initialized = false;
    private String referer;
    private String encoding = "UTF-8";

    @Override
    public void init(ShareDownloadService shareDownloadService, HttpFileDownloadTask httpFileDownloadTask) {
        this.pluginService = shareDownloadService;
        this.downloadTask = httpFileDownloadTask;
        this.client = httpFileDownloadTask.getClient();
        this.httpFile = httpFileDownloadTask.getDownloadFile();
        this.fileURL = this.httpFile.getFileUrl().toString();
        this.initialized = true;
    }

    @Override
    public void run() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot run Run method. Runner was not initialized via init method");
        }
        logger.info("Starting download 'run' for file:" + this.fileURL);
    }

    @Override
    public void runCheck() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("Cannot run runCheck method. Runner was not initialized via init method");
        }
        logger.info("Starting download 'runCheck' " + this.fileURL);
    }

    protected CaptchaSupport getCaptchaSupport() {
        if (this.captchaSupport == null) {
            this.captchaSupport = new CaptchaSupport(this.client, this.getDialogSupport());
            return this.captchaSupport;
        }
        return this.captchaSupport;
    }

    protected DialogSupport getDialogSupport() {
        return this.pluginService.getPluginContext().getDialogSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryDownloadAndSaveFile(HttpMethod httpMethod) throws Exception {
        logger.info("Download link URI: " + httpMethod.getURI().toString());
        this.httpFile.setState(DownloadState.GETTING);
        logger.info("Making final request for file");
        try {
            InputStream inputStream = this.client.makeFinalRequestForFile(httpMethod, this.httpFile, true);
            if (inputStream != null) {
                logger.info("Saving to file");
                this.downloadTask.saveToFile(inputStream);
                boolean bl = true;
                return bl;
            }
            logger.info("Saving file failed");
            boolean bl = false;
            return bl;
        }
        finally {
            httpMethod.abort();
            httpMethod.releaseConnection();
        }
    }

    public ShareDownloadService getPluginService() {
        return this.pluginService;
    }

    protected boolean makeRequest(HttpMethod httpMethod) throws IOException {
        this.referer = httpMethod.getURI().toString();
        return this.client.makeRequest(httpMethod, false) == 200;
    }

    protected boolean makeRedirectedRequest(HttpMethod httpMethod) throws IOException {
        this.referer = httpMethod.getURI().toString();
        return this.client.makeRequest(httpMethod, true) == 200;
    }

    protected PostMethod getPostMethod(String string) {
        return this.client.getPostMethod(string);
    }

    protected GetMethod getGetMethod(String string) {
        return this.client.getGetMethod(string);
    }

    protected String getContentAsString() {
        return this.client.getContentAsString();
    }

    protected Matcher getMatcherAgainstContent(String string) {
        return PlugUtils.matcher(string, this.client.getContentAsString());
    }

    protected MethodBuilder getMethodBuilder() throws BuildMethodException {
        return new MethodBuilder(this.client).setBaseURL(this.getBaseURL()).setReferer(this.referer).setEncoding(this.encoding);
    }

    protected MethodBuilder getMethodBuilder(String string) throws BuildMethodException {
        return new MethodBuilder(string, this.client).setBaseURL(this.getBaseURL()).setReferer(this.referer);
    }

    protected void addCookie(Cookie cookie) {
        this.client.getHTTPClient().getState().addCookie(cookie);
    }

    protected String getBaseURL() {
        return null;
    }

    protected void setClientParameter(String string, Object object) {
        this.client.getHTTPClient().getParams().setParameter(string, object);
    }

    protected void setPageEncoding(String string) {
        this.encoding = string;
        this.setClientParameter("pageCharset", string);
        this.client.getHTTPClient().getParams().setHttpElementCharset(string);
    }
}

