/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.color.EyeDropperColorChooserPanel;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.OS;

public class JXColorSelectionButton
extends JButton {
    private BufferedImage colorwell;
    private JDialog dialog = null;
    private JColorChooser chooser = null;

    public JXColorSelectionButton() {
        this(Color.red);
    }

    public JXColorSelectionButton(Color color) {
        this.setBackground(color);
        this.addActionListener(new ActionHandler());
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        try {
            this.colorwell = ImageIO.read(this.getClass().getResourceAsStream("color/colorwell.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addPropertyChangeListener("background", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXColorSelectionButton.this.getChooser().setColor(JXColorSelectionButton.this.getBackground());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        Color color;
        Color color2 = color = this.isEnabled() ? ColorUtil.removeAlpha(this.getBackground()) : UIManagerExt.getSafeColor("Button.disabledForeground", Color.LIGHT_GRAY);
        if (OS.isMacOSX() && this.colorwell != null) {
            Insets insets = new Insets(5, 5, 5, 5);
            ColorUtil.tileStretchPaint(graphics, this, this.colorwell, insets);
            graphics.setColor(color);
            graphics.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
            graphics.setColor(ColorUtil.setBrightness(color, 0.85f));
            graphics.drawRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right - 1, this.getHeight() - insets.top - insets.bottom - 1);
            graphics.drawRect(insets.left + 1, insets.top + 1, this.getWidth() - insets.left - insets.right - 3, this.getHeight() - insets.top - insets.bottom - 3);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(Color.LIGHT_GRAY);
                int n = Math.min(this.getWidth(), this.getHeight());
                int n2 = 3;
                graphics2D.fill(new Ellipse2D.Float(3.0f, 3.0f, n - 6, n - 6));
                graphics2D.setColor(color);
                boolean bl = true;
                graphics2D.fill(new Ellipse2D.Float(4.0f, 4.0f, n - 6 - 2, n - 6 - 2));
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    private void showDialog() {
        final Color color = this.getBackground();
        if (this.dialog == null) {
            this.dialog = JColorChooser.createDialog(this, "Choose a color", true, this.getChooser(), new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JXColorSelectionButton.this.getChooser().getColor();
                    if (color != null) {
                        JXColorSelectionButton.this.setBackground(color);
                    }
                }
            }, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JXColorSelectionButton.this.setBackground(color);
                }
            });
            this.dialog.getContentPane().add(this.getChooser());
            this.getChooser().getSelectionModel().addChangeListener(new ColorChangeListener(this));
        }
        this.dialog.setVisible(true);
    }

    public JColorChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
            this.chooser.addChooserPanel(new EyeDropperColorChooserPanel());
        }
        return this.chooser;
    }

    public void setChooser(JColorChooser jColorChooser) {
        JColorChooser jColorChooser2 = this.getChooser();
        this.chooser = jColorChooser;
        this.firePropertyChange("chooser", jColorChooser2, jColorChooser);
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.colorwell == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.colorwell.getWidth(), this.colorwell.getHeight());
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXColorSelectionButton.this.showDialog();
        }
    }

    private class ColorChangeListener
    implements ChangeListener {
        public JXColorSelectionButton button;

        public ColorChangeListener(JXColorSelectionButton jXColorSelectionButton2) {
            this.button = jXColorSelectionButton2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.button.setBackground(this.button.getChooser().getColor());
        }
    }
}

