/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;

public class JXGlassBox
extends JXPanel {
    private float alphaStart = 0.01f;
    private float alphaEnd = 0.8f;
    private Timer animateTimer;
    private float alphaIncrement = 0.02f;
    private boolean dismissOnClick = false;
    private MouseAdapter dismissListener = null;

    public JXGlassBox() {
        this.setOpaque(false);
        this.setAlpha(this.alphaStart);
        this.setBackground(Color.white);
        this.setDismissOnClick(true);
        this.animateTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXGlassBox.this.setAlpha(Math.min(JXGlassBox.this.alphaEnd, JXGlassBox.this.getAlpha() + JXGlassBox.this.alphaIncrement));
            }
        });
    }

    public JXGlassBox(float f) {
        this();
        this.setAlpha(f);
    }

    public void setAlpha(float f) {
        super.setAlpha(f);
        this.alphaIncrement = (this.alphaEnd - this.alphaStart) / 3.0f;
    }

    public void dismiss() {
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent != null) {
            Container container = jComponent.getTopLevelAncestor();
            jComponent.remove(this);
            container.validate();
            container.repaint();
        }
    }

    public boolean isDismissOnClick() {
        return this.dismissOnClick;
    }

    public void setDismissOnClick(boolean bl) {
        boolean bl2 = this.dismissOnClick;
        this.dismissOnClick = bl;
        this.firePropertyChange("dismissOnClick", bl2, this.isDismissOnClick());
        if (bl && !bl2) {
            if (this.dismissListener == null) {
                this.dismissListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        JXGlassBox.this.dismiss();
                    }
                };
            }
            this.addMouseListener(this.dismissListener);
        } else if (!bl && bl2) {
            this.removeMouseListener(this.dismissListener);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.animateTimer.isRunning() && this.getAlpha() < this.alphaEnd) {
            this.animateTimer.start();
        }
        if (this.animateTimer.isRunning() && this.getAlpha() >= this.alphaEnd) {
            this.animateTimer.stop();
        }
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        this.setAlpha(this.alphaStart);
        super.setVisible(bl);
        this.firePropertyChange("visible", bl2, this.isVisible());
    }

    private Container getTopLevel() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
        }
        return container;
    }

    public void showOnGlassPane(Container container, Component component, int n, int n2, int n3) {
        Rectangle rectangle = SwingUtilities.convertRectangle(component, component.getBounds(), container);
        Dimension dimension = this.getPreferredSize();
        int n4 = n + rectangle.x;
        int n5 = n2 + rectangle.y;
        switch (n3) {
            case 1: {
                n4 += (rectangle.width - dimension.width) / 2;
                n5 -= dimension.height;
                break;
            }
            case 3: {
                n4 += (rectangle.width - dimension.width) / 2;
                n5 += rectangle.height;
                break;
            }
            case 2: {
                n4 -= dimension.width;
                n5 += (rectangle.height - dimension.height) / 2;
                break;
            }
            case 4: {
                n4 += rectangle.width;
                n5 += (rectangle.height - dimension.height) / 2;
                break;
            }
            case 0: {
                n4 += (rectangle.width - dimension.width) / 2;
                n5 += (rectangle.height - dimension.height) / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("inavlid position hint");
            }
        }
        this.showOnGlassPane(container, n4, n5);
    }

    public void showOnGlassPane(Container container, int n, int n2) {
        Dimension dimension = container.getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n3 = Math.min(n, dimension.width - dimension2.width);
        int n4 = Math.min(n2, dimension.height - dimension2.height);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        int n5 = n3 + dimension2.width < dimension.width ? dimension2.width : dimension.width;
        int n6 = n4 + dimension2.height < dimension.height ? dimension2.height : dimension.height;
        container.setLayout(null);
        this.setBounds(n3, n4, n5, n6);
        container.add(this);
        container.setVisible(true);
        Container container2 = this.getTopLevel();
        container2.validate();
        container2.repaint();
    }
}

