/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXColorSelectionButton;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.color.GradientPreviewPanel;
import org.jdesktop.swingx.color.GradientThumbRenderer;
import org.jdesktop.swingx.color.GradientTrackRenderer;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.ThumbListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXGradientChooser
extends JXPanel {
    private JXMultiThumbSlider<Color> slider;
    private JButton deleteThumbButton;
    private JButton addThumbButton;
    private JTextField colorField;
    private JXColorSelectionButton changeColorButton;
    private JSpinner colorLocationSpinner;
    private JSpinner alphaSpinner;
    private JSlider alphaSlider;
    private JComboBox styleCombo;
    private GradientPreviewPanel gradientPreview;
    private JRadioButton noCycleRadio;
    private JRadioButton reflectedRadio;
    private JRadioButton repeatedRadio;
    private JCheckBox reversedCheck;
    private MultipleGradientPaint gradient;
    private boolean thumbsMoving = false;
    private Logger log = Logger.getLogger(JXGradientChooser.class.getName());
    private JPanel topPanel;
    private JPanel previewPanel;

    public JXGradientChooser() {
        this.initComponents2();
    }

    public MultipleGradientPaint getGradient() {
        return this.gradient;
    }

    public void setGradient(MultipleGradientPaint multipleGradientPaint) {
        if (this.gradient == multipleGradientPaint) {
            return;
        }
        float[] fArray = multipleGradientPaint.getFractions();
        Color[] colorArray = multipleGradientPaint.getColors();
        if (!this.thumbsMoving) {
            int n;
            if (this.slider.getModel().getThumbCount() != multipleGradientPaint.getColors().length) {
                while (this.slider.getModel().getThumbCount() > 0) {
                    this.slider.getModel().removeThumb(0);
                }
                for (n = 0; n < fArray.length; ++n) {
                    this.slider.getModel().addThumb(fArray[n], colorArray[n]);
                }
            } else {
                for (n = 0; n < fArray.length; ++n) {
                    this.slider.getModel().getThumbAt(n).setObject(colorArray[n]);
                    this.slider.getModel().getThumbAt(n).setPosition(fArray[n]);
                }
            }
        } else {
            this.log.fine("not updating because it's moving");
        }
        if (multipleGradientPaint instanceof RadialGradientPaint) {
            if (this.styleCombo.getSelectedItem() != GradientStyle.Radial) {
                this.styleCombo.setSelectedItem((Object)GradientStyle.Radial);
            }
        } else if (this.styleCombo.getSelectedItem() != GradientStyle.Linear) {
            this.styleCombo.setSelectedItem((Object)GradientStyle.Linear);
        }
        if (multipleGradientPaint.getCycleMethod() == MultipleGradientPaint.CycleMethod.REFLECT) {
            this.reflectedRadio.setSelected(true);
            this.gradientPreview.setReflected(true);
        }
        if (multipleGradientPaint.getCycleMethod() == MultipleGradientPaint.CycleMethod.REPEAT) {
            this.repeatedRadio.setSelected(true);
            this.gradientPreview.setRepeated(true);
        }
        this.gradientPreview.setGradient(multipleGradientPaint);
        MultipleGradientPaint multipleGradientPaint2 = this.getGradient();
        this.gradient = multipleGradientPaint;
        this.firePropertyChange("gradient", multipleGradientPaint2, this.getGradient());
        this.repaint();
    }

    private void recalcGradientFromStops() {
        this.setGradient(this.gradientPreview.getGradient());
    }

    private void updateFromStop(Thumb<Color> thumb) {
        if (thumb == null) {
            this.updateFromStop(-1, -1.0f, Color.black);
        } else {
            this.updateFromStop(1, thumb.getPosition(), thumb.getObject());
        }
    }

    private void updateFromStop(int n, float f, Color color) {
        this.log.fine("updating: " + n + " " + f + " " + color);
        if (n == -1) {
            this.colorLocationSpinner.setEnabled(false);
            this.alphaSpinner.setEnabled(false);
            this.alphaSlider.setEnabled(false);
            this.colorField.setEnabled(false);
            this.changeColorButton.setEnabled(false);
            this.changeColorButton.setBackground(Color.black);
            this.deleteThumbButton.setEnabled(false);
        } else {
            this.colorLocationSpinner.setEnabled(true);
            this.alphaSpinner.setEnabled(true);
            this.alphaSlider.setEnabled(true);
            this.colorField.setEnabled(true);
            this.changeColorButton.setEnabled(true);
            this.colorLocationSpinner.setValue((int)(100.0f * f));
            this.colorField.setText(Integer.toHexString(color.getRGB()).substring(2));
            this.alphaSpinner.setValue(color.getAlpha() * 100 / 255);
            this.alphaSlider.setValue(color.getAlpha() * 100 / 255);
            this.changeColorButton.setBackground(color);
            this.deleteThumbButton.setEnabled(true);
        }
        this.updateDeleteButtons();
        this.recalcGradientFromStops();
    }

    private void updateDeleteButtons() {
        if (this.slider.getModel().getThumbCount() <= 2) {
            this.deleteThumbButton.setEnabled(false);
        }
    }

    private void updateGradientProperty() {
        this.firePropertyChange("gradient", null, this.getGradient());
        this.gradientPreview.repaint();
    }

    private void initComponents() {
        this.slider = new JXMultiThumbSlider();
        this.gradientPreview = new GradientPreviewPanel();
        this.gradientPreview.setMultiThumbModel(this.slider.getModel());
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel();
        this.topPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this.colorField = new JTextField();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.colorLocationSpinner = new JSpinner();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.alphaSpinner = new JSpinner();
        this.changeColorButton = new JXColorSelectionButton();
        this.alphaSlider = new JSlider();
        JPanel jPanel3 = new JPanel();
        this.addThumbButton = new JButton();
        this.deleteThumbButton = new JButton();
        this.previewPanel = new JPanel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel7 = new JLabel();
        this.styleCombo = new JComboBox();
        JLabel jLabel8 = new JLabel();
        this.noCycleRadio = new JRadioButton();
        this.reflectedRadio = new JRadioButton();
        this.repeatedRadio = new JRadioButton();
        this.reversedCheck = new JCheckBox();
        jPanel.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.setBorder(BorderFactory.createTitledBorder("Gradient"));
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setText("Color:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        jLabel2.setText("#");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.colorField.setColumns(6);
        this.colorField.setEnabled(false);
        this.colorField.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.colorField, gridBagConstraints);
        jLabel3.setText("Location:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        this.colorLocationSpinner.setEnabled(false);
        this.colorLocationSpinner.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.colorLocationSpinner, gridBagConstraints);
        jLabel5.setText("Opacity:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("%");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        this.alphaSpinner.setEnabled(false);
        this.alphaSpinner.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.alphaSpinner, gridBagConstraints);
        this.changeColorButton.setText("00");
        this.changeColorButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel2.add((Component)this.changeColorButton, gridBagConstraints);
        this.alphaSlider.setEnabled(false);
        this.alphaSlider.setPreferredSize(new Dimension(20, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.alphaSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.topPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.topPanel.add(this.slider, gridBagConstraints);
        jPanel3.setLayout(new GridLayout(1, 0, 2, 0));
        this.addThumbButton.setText("Add");
        jPanel3.add(this.addThumbButton);
        this.deleteThumbButton.setText("Delete");
        jPanel3.add(this.deleteThumbButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.topPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.topPanel, gridBagConstraints);
        this.previewPanel.setLayout(new GridBagLayout());
        this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        jPanel4.setLayout(new GridBagLayout());
        jLabel7.setText("Style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)jLabel7, gridBagConstraints);
        this.styleCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Linear", "Radial"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)this.styleCombo, gridBagConstraints);
        jLabel8.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)jLabel8, gridBagConstraints);
        buttonGroup.add(this.noCycleRadio);
        this.noCycleRadio.setSelected(true);
        this.noCycleRadio.setText("None");
        this.noCycleRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noCycleRadio.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)this.noCycleRadio, gridBagConstraints);
        buttonGroup.add(this.reflectedRadio);
        this.reflectedRadio.setText("Reflect");
        this.reflectedRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reflectedRadio.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)this.reflectedRadio, gridBagConstraints);
        buttonGroup.add(this.repeatedRadio);
        this.repeatedRadio.setText("Repeat");
        this.repeatedRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.repeatedRadio.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)this.repeatedRadio, gridBagConstraints);
        this.reversedCheck.setText("Reverse");
        this.reversedCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reversedCheck.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        jPanel4.add((Component)this.reversedCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.previewPanel.add((Component)jPanel4, gridBagConstraints);
        this.gradientPreview.setBorder(BorderFactory.createEtchedBorder());
        this.gradientPreview.setPreferredSize(new Dimension(130, 130));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        this.previewPanel.add((Component)this.gradientPreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.previewPanel, gridBagConstraints);
    }

    private void initComponents2() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.previewPanel, "Center");
        AddThumbAction addThumbAction = new AddThumbAction();
        DeleteThumbAction deleteThumbAction = new DeleteThumbAction();
        deleteThumbAction.setEnabled(false);
        ActionMap actionMap = this.getActionMap();
        actionMap.put("add-thumb", addThumbAction);
        actionMap.put("delete-thumb", deleteThumbAction);
        this.addThumbButton.setAction(addThumbAction);
        this.deleteThumbButton.setAction(deleteThumbAction);
        this.changeColorButton.addPropertyChangeListener("background", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXGradientChooser.this.selectColorForThumb();
                JXGradientChooser.this.updateGradientProperty();
            }
        });
        this.colorLocationSpinner.addChangeListener(new ChangeLocationListener());
        ChangeAlphaListener changeAlphaListener = new ChangeAlphaListener();
        this.alphaSpinner.addChangeListener(changeAlphaListener);
        this.alphaSlider.addChangeListener(changeAlphaListener);
        RepaintOnEventListener repaintOnEventListener = new RepaintOnEventListener();
        this.styleCombo.addItemListener(repaintOnEventListener);
        this.styleCombo.setModel(new DefaultComboBoxModel<GradientStyle>(GradientStyle.values()));
        this.noCycleRadio.addActionListener(repaintOnEventListener);
        this.reflectedRadio.addActionListener(repaintOnEventListener);
        this.repeatedRadio.addActionListener(repaintOnEventListener);
        this.reversedCheck.addActionListener(repaintOnEventListener);
        this.gradientPreview.picker = this;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(100, 0, 100, 1);
        this.alphaSpinner.setModel(spinnerNumberModel);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(100, 0, 100, 1);
        this.colorLocationSpinner.setModel(spinnerNumberModel2);
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(100, 35));
        this.slider.getModel().setMinimumValue(0.0f);
        this.slider.getModel().setMaximumValue(1.0f);
        this.slider.getModel().addThumb(0.0f, Color.black);
        this.slider.getModel().addThumb(0.5f, Color.red);
        this.slider.getModel().addThumb(1.0f, Color.white);
        this.slider.setThumbRenderer(new GradientThumbRenderer());
        this.slider.setTrackRenderer(new GradientTrackRenderer());
        this.slider.addMultiThumbListener(new StopListener());
        this.gradientPreview.addPropertyChangeListener("gradient", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXGradientChooser.this.recalcGradientFromStops();
            }
        });
        this.recalcGradientFromStops();
    }

    private void selectColorForThumb() {
        int n = this.slider.getSelectedIndex();
        if (n >= 0) {
            Color color = this.changeColorButton.getBackground();
            this.slider.getModel().getThumbAt(n).setObject(color);
            this.updateFromStop(n, this.slider.getModel().getThumbAt(n).getPosition(), color);
        }
    }

    public static MultipleGradientPaint showDialog(Component component, String string, MultipleGradientPaint multipleGradientPaint) {
        Component component2 = SwingUtilities.getRoot(component);
        final JDialog jDialog = new JDialog((JFrame)component2, string, true);
        JXGradientChooser jXGradientChooser = new JXGradientChooser();
        if (multipleGradientPaint != null) {
            jXGradientChooser.setGradient(multipleGradientPaint);
        }
        jDialog.add(jXGradientChooser);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("Ok");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jButton2.setDefaultCapable(true);
        GridLayout gridLayout = new GridLayout();
        gridLayout.setHgap(2);
        jPanel.setLayout(gridLayout);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jDialog.add((Component)jPanel2, "South");
        jDialog.getRootPane().setDefaultButton(jButton2);
        jDialog.pack();
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        return jXGradientChooser.getGradient();
    }

    public static String toString(MultipleGradientPaint multipleGradientPaint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(multipleGradientPaint.getClass().getName());
        Color[] colorArray = multipleGradientPaint.getColors();
        float[] fArray = multipleGradientPaint.getFractions();
        stringBuffer.append("[");
        for (int i = 0; i < colorArray.length; ++i) {
            stringBuffer.append("#").append(Integer.toHexString(colorArray[i].getRGB()));
            stringBuffer.append(":");
            stringBuffer.append(fArray[i]);
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private final class RepaintOnEventListener
    implements ActionListener,
    ItemListener {
        private RepaintOnEventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXGradientChooser.this.gradientPreview.setReflected(JXGradientChooser.this.reflectedRadio.isSelected());
            JXGradientChooser.this.gradientPreview.setReversed(JXGradientChooser.this.reversedCheck.isSelected());
            JXGradientChooser.this.gradientPreview.setRepeated(JXGradientChooser.this.repeatedRadio.isSelected());
            JXGradientChooser.this.recalcGradientFromStops();
            JXGradientChooser.this.gradientPreview.repaint();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (JXGradientChooser.this.styleCombo.getSelectedItem() == GradientStyle.Radial) {
                JXGradientChooser.this.gradientPreview.setRadial(true);
            } else {
                JXGradientChooser.this.gradientPreview.setRadial(false);
            }
            JXGradientChooser.this.recalcGradientFromStops();
        }
    }

    private class StopListener
    implements ThumbListener {
        public void thumbMoved(int n, float f) {
            JXGradientChooser.this.log.fine("moved: " + n + " " + f);
            Color color = (Color)JXGradientChooser.this.slider.getModel().getThumbAt(n).getObject();
            JXGradientChooser.this.thumbsMoving = true;
            JXGradientChooser.this.updateFromStop(n, f, color);
            JXGradientChooser.this.updateDeleteButtons();
            JXGradientChooser.this.thumbsMoving = false;
        }

        public void thumbSelected(int n) {
            if (n == -1) {
                JXGradientChooser.this.updateFromStop(-1, -1.0f, Color.black);
                return;
            }
            JXGradientChooser.this.thumbsMoving = true;
            float f = JXGradientChooser.this.slider.getModel().getThumbAt(n).getPosition();
            Color color = (Color)JXGradientChooser.this.slider.getModel().getThumbAt(n).getObject();
            JXGradientChooser.this.log.fine("selected = " + n + " " + f + " " + color);
            JXGradientChooser.this.updateFromStop(n, f, color);
            JXGradientChooser.this.updateDeleteButtons();
            JXGradientChooser.this.slider.repaint();
            JXGradientChooser.this.thumbsMoving = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                JXGradientChooser.this.selectColorForThumb();
            }
        }
    }

    private final class DeleteThumbAction
    extends AbstractActionExt {
        public DeleteThumbAction() {
            super("Delete");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = JXGradientChooser.this.slider.getSelectedIndex();
            if (n >= 0) {
                JXGradientChooser.this.slider.getModel().removeThumb(n);
                JXGradientChooser.this.updateFromStop(-1, -1.0f, null);
            }
        }
    }

    private final class AddThumbAction
    extends AbstractActionExt {
        public AddThumbAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            float f = 0.2f;
            Color color = Color.black;
            int n = JXGradientChooser.this.slider.getModel().addThumb(f, color);
            JXGradientChooser.this.log.fine("new number = " + n);
        }
    }

    private final class ChangeAlphaListener
    implements ChangeListener {
        private ChangeAlphaListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (JXGradientChooser.this.slider.getSelectedIndex() >= 0 && !JXGradientChooser.this.thumbsMoving) {
                Thumb<Color> thumb = JXGradientChooser.this.slider.getModel().getThumbAt(JXGradientChooser.this.slider.getSelectedIndex());
                int n = changeEvent.getSource() == JXGradientChooser.this.alphaSpinner ? ((Integer)JXGradientChooser.this.alphaSpinner.getValue()).intValue() : JXGradientChooser.this.alphaSlider.getValue();
                Color color = (Color)thumb.getObject();
                color = ColorUtil.setAlpha(color, n * 255 / 100);
                thumb.setObject(color);
                if (changeEvent.getSource() == JXGradientChooser.this.alphaSpinner) {
                    JXGradientChooser.this.alphaSlider.setValue(n);
                } else {
                    JXGradientChooser.this.alphaSpinner.setValue(n);
                }
                JXGradientChooser.this.recalcGradientFromStops();
            }
        }
    }

    private final class ChangeLocationListener
    implements ChangeListener {
        private ChangeLocationListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (JXGradientChooser.this.slider.getSelectedIndex() >= 0) {
                Thumb thumb = JXGradientChooser.this.slider.getModel().getThumbAt(JXGradientChooser.this.slider.getSelectedIndex());
                thumb.setPosition((float)((Integer)JXGradientChooser.this.colorLocationSpinner.getValue()).intValue() / 100.0f);
                JXGradientChooser.this.updateFromStop(thumb);
                JXGradientChooser.this.updateGradientProperty();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GradientStyle {
        Linear,
        Radial;

    }
}

