/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.error.ErrorListener;
import org.jdesktop.swingx.error.ErrorSupport;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class JXImageView
extends JXPanel {
    private Logger log = Logger.getLogger(JXImageView.class.getName());
    private Image image;
    private URL imageURL;
    private ErrorSupport errorSupport = new ErrorSupport(this);
    private Point2D imageLocation;
    private Paint checkerPaint;
    private double scale = 1.0;
    private boolean editable = true;
    private MoveHandler moveHandler = new MoveHandler(this);
    private boolean dragEnabled = false;
    private String exportName = "UntitledImage";
    private String exportFormat = "png";

    public JXImageView() {
        this.checkerPaint = ColorUtil.getCheckerPaint(Color.white, new Color(250, 250, 250), 50);
        this.setEditable(true);
    }

    public Point2D getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(Point2D point2D) {
        Point2D point2D2 = this.getImageLocation();
        this.imageLocation = point2D;
        this.firePropertyChange("imageLocation", point2D2, this.getImageLocation());
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image image2 = this.getImage();
        this.image = image;
        this.setImageLocation(null);
        this.setScale(1.0);
        this.firePropertyChange("image", image2, image);
        this.repaint();
    }

    public void setImage(URL uRL) throws IOException {
        this.setImageURL(uRL);
    }

    public void setImage(File file) throws IOException {
        this.setImageURL(file.toURI().toURL());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        double d2 = this.scale;
        this.scale = d;
        this.firePropertyChange("scale", d2, d);
        this.repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.isEditable();
        this.editable = bl;
        if (bl) {
            this.addMouseMotionListener(this.moveHandler);
            this.addMouseListener(this.moveHandler);
            this.setCursor(Cursor.getPredefinedCursor(12));
            try {
                this.setTransferHandler(new DnDHandler());
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                this.fireError(classNotFoundException);
            }
        } else {
            this.removeMouseMotionListener(this.moveHandler);
            this.removeMouseListener(this.moveHandler);
            this.setCursor(Cursor.getDefaultCursor());
            this.setTransferHandler(null);
        }
        this.firePropertyChange("editable", bl2, this.isEditable());
    }

    public void setDragEnabled(boolean bl) {
        boolean bl2 = this.isDragEnabled();
        this.dragEnabled = bl;
        this.firePropertyChange("dragEnabled", bl2, this.isDragEnabled());
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorSupport.addErrorListener(errorListener);
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorSupport.removeErrorListener(errorListener);
    }

    protected void fireError(Throwable throwable) {
        this.errorSupport.fireErrorEvent(throwable);
    }

    private static FileDialog getSafeFileDialog(Component component) {
        Window window = SwingUtilities.windowForComponent(component);
        if (window instanceof Dialog) {
            return new FileDialog((Dialog)window);
        }
        if (window instanceof Frame) {
            return new FileDialog((Frame)window);
        }
        return null;
    }

    @Deprecated
    public Action getOpenAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDialog fileDialog = JXImageView.getSafeFileDialog(JXImageView.this);
                fileDialog.setMode(0);
                fileDialog.setVisible(true);
                if (fileDialog.getFile() != null) {
                    try {
                        JXImageView.this.setImage(new File(fileDialog.getDirectory(), fileDialog.getFile()));
                    }
                    catch (IOException iOException) {
                        JXImageView.this.fireError(iOException);
                    }
                }
            }
        };
        abstractAction.putValue("Name", "Open");
        return abstractAction;
    }

    @Deprecated
    public Action getSaveAction() {
        AbstractAction abstractAction = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = JXImageView.this.getImage();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                try {
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    graphics2D.drawImage(image, 0, 0, null);
                }
                finally {
                    graphics2D.dispose();
                }
                FileDialog fileDialog = new FileDialog((Frame)SwingUtilities.windowForComponent(JXImageView.this));
                fileDialog.setMode(1);
                fileDialog.setVisible(true);
                if (fileDialog.getFile() != null) {
                    try {
                        ImageIO.write((RenderedImage)bufferedImage, "png", new File(fileDialog.getDirectory(), fileDialog.getFile()));
                    }
                    catch (IOException iOException) {
                        JXImageView.this.fireError(iOException);
                    }
                }
            }
        };
        abstractAction.putValue("Name", "Save");
        return abstractAction;
    }

    @Deprecated
    public Action getRotateClockwiseAction() {
        AbstractAction abstractAction = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = JXImageView.this.getImage();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                BufferedImage bufferedImage2 = new BufferedImage(image.getHeight(null), image.getWidth(null), 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                try {
                    graphics2D.drawImage(image, 0, 0, null);
                }
                finally {
                    graphics2D.dispose();
                }
                AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                affineTransform.translate(0.0, -bufferedImage.getHeight());
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
                affineTransformOp.filter(bufferedImage, bufferedImage2);
                JXImageView.this.setImage(bufferedImage2);
            }
        };
        abstractAction.putValue("Name", "Rotate Clockwise");
        return abstractAction;
    }

    @Deprecated
    public Action getRotateCounterClockwiseAction() {
        AbstractAction abstractAction = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                Image image = JXImageView.this.getImage();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                BufferedImage bufferedImage2 = new BufferedImage(image.getHeight(null), image.getWidth(null), 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                try {
                    graphics2D.drawImage(image, 0, 0, null);
                }
                finally {
                    graphics2D.dispose();
                }
                AffineTransform affineTransform = AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0);
                affineTransform.translate(-bufferedImage.getWidth(), 0.0);
                AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
                affineTransformOp.filter(bufferedImage, bufferedImage2);
                JXImageView.this.setImage(bufferedImage2);
            }
        };
        abstractAction.putValue("Name", "Rotate CounterClockwise");
        return abstractAction;
    }

    @Deprecated
    public Action getZoomOutAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXImageView.this.setScale(JXImageView.this.getScale() * 0.5);
            }
        };
        abstractAction.putValue("Name", "Zoom Out");
        return abstractAction;
    }

    @Deprecated
    public Action getZoomInAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXImageView.this.setScale(JXImageView.this.getScale() * 2.0);
            }
        };
        abstractAction.putValue("Name", "Zoom In");
        return abstractAction;
    }

    protected void paintComponent(Graphics graphics) {
        ((Graphics2D)graphics).setPaint(this.checkerPaint);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getImage() != null) {
            Point2D point2D = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
            if (this.getImageLocation() != null) {
                point2D = this.getImageLocation();
            }
            Point2D.Double double_ = new Point2D.Double();
            double d = (double)this.getImage().getWidth(null) * this.getScale();
            double d2 = (double)this.getImage().getHeight(null) * this.getScale();
            ((Point2D)double_).setLocation(point2D.getX() - d / 2.0, point2D.getY() - d2 / 2.0);
            graphics.drawImage(this.getImage(), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), (int)d, (int)d2, null);
        }
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String string) {
        String string2 = this.getExportName();
        this.exportName = string;
        this.firePropertyChange("exportName", string2, this.getExportName());
    }

    public String getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(String string) {
        String string2 = this.getExportFormat();
        this.exportFormat = string;
        this.firePropertyChange("exportFormat", string2, this.getExportFormat());
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(URL uRL) throws IOException {
        URL uRL2 = this.getImageURL();
        this.imageURL = uRL;
        this.firePropertyChange("imageURL", uRL2, this.getImageURL());
        this.setImage(ImageIO.read(this.getImageURL()));
    }

    public String getImageString() {
        if (this.getImageURL() == null) {
            return null;
        }
        return this.getImageURL().toString();
    }

    public void setImageString(String string) throws IOException {
        String string2 = this.getImageString();
        this.setImageURL(new URL(string));
        this.firePropertyChange("imageString", string2, string);
    }

    private class ImageTransferable
    implements Transferable {
        private Image img;
        private List<File> files;
        private String exportName;
        private String exportFormat;

        public ImageTransferable(Image image, String string, String string2) {
            this.img = image;
            this.exportName = string;
            this.exportFormat = string2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.javaFileListFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (dataFlavor == DataFlavor.imageFlavor) {
                return true;
            }
            return dataFlavor == DataFlavor.javaFileListFlavor;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == DataFlavor.imageFlavor) {
                return this.img;
            }
            if (dataFlavor == DataFlavor.javaFileListFlavor) {
                if (this.files == null) {
                    this.files = new ArrayList<File>();
                    File file = File.createTempFile(this.exportName, "." + this.exportFormat);
                    ImageIO.write((RenderedImage)GraphicsUtilities.convertToBufferedImage(this.img), this.exportFormat, file);
                    this.files.add(file);
                }
                return this.files;
            }
            return null;
        }
    }

    private class DnDHandler
    extends TransferHandler {
        DataFlavor urlFlavor = new DataFlavor("application/x-java-url;class=java.net.URL");

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            super.exportAsDrag(jComponent, inputEvent, n);
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i])) {
                    return true;
                }
                if (DataFlavor.imageFlavor.equals(dataFlavorArray[i])) {
                    return true;
                }
                if (!this.urlFlavor.match(dataFlavorArray[i])) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            JXImageView jXImageView = (JXImageView)jComponent;
            return new ImageTransferable(jXImageView.getImage(), jXImageView.getExportName(), jXImageView.getExportFormat());
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
                try {
                    Object object;
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).size() > 0) {
                        File file = (File)object.get(0);
                        JXImageView.this.setImageString(file.toURI().toURL().toString());
                        return true;
                    }
                    object = transferable.getTransferData(this.urlFlavor);
                    if (object instanceof URL) {
                        JXImageView.this.setImageString(((URL)object).toString());
                    }
                    return true;
                }
                catch (Exception exception) {
                    JXImageView.this.log.severe(exception.getMessage());
                    exception.printStackTrace();
                    JXImageView.this.fireError(exception);
                }
            }
            return false;
        }
    }

    private class MoveHandler
    extends MouseInputAdapter {
        private JXImageView panel;
        private Point prev = null;
        private Point start = null;

        public MoveHandler(JXImageView jXImageView2) {
            this.panel = jXImageView2;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.start = this.prev = mouseEvent.getPoint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (JXImageView.this.isDragEnabled() && point.distance(this.start) > 5.0) {
                JXImageView.this.log.fine("starting the drag: ");
                this.panel.getTransferHandler().exportAsDrag((JComponent)mouseEvent.getSource(), mouseEvent, 1);
                return;
            }
            int n = point.x - this.prev.x;
            int n2 = point.y - this.prev.y;
            Point2D point2D = JXImageView.this.getImageLocation();
            if (point2D == null) {
                point2D = JXImageView.this.image != null ? new Point2D.Double(JXImageView.this.getWidth() / 2, JXImageView.this.getHeight() / 2) : new Point2D.Double(0.0, 0.0);
            }
            point2D = new Point2D.Double(point2D.getX() + (double)n, point2D.getY() + (double)n2);
            JXImageView.this.setImageLocation(point2D);
            this.prev = point;
            JXImageView.this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.prev = null;
        }
    }
}

