/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class JXLabel
extends JLabel {
    public static final double NORMAL = 0.0;
    public static final double INVERTED = Math.PI;
    public static final double VERTICAL_LEFT = 4.71238898038469;
    public static final double VERTICAL_RIGHT = 1.5707963267948966;
    private double textRotation = 0.0;
    private boolean painting = false;
    private Painter foregroundPainter;
    private Painter backgroundPainter;
    private boolean multiLine;
    private int pWidth;
    private int pHeight;
    private boolean dontIgnoreRepaint = false;
    private int occupiedWidth;
    private boolean paintBorderInsets = true;
    private int maxLineSpan = -1;
    public boolean painted;
    private TextAlignment textAlignment = TextAlignment.LEFT;

    public JXLabel() {
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon icon) {
        super(icon);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(Icon icon, int n) {
        super(icon, n);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String string) {
        super(string);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String string, Icon icon, int n) {
        super(string, icon, n);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    public JXLabel(String string, int n) {
        super(string, n);
        this.initPainterSupport();
        this.initLineWrapSupport();
    }

    private void initPainterSupport() {
        this.foregroundPainter = new AbstractPainter<JXLabel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doPaint(Graphics2D graphics2D, JXLabel jXLabel, int n, int n2) {
                Insets insets = JXLabel.this.getInsets();
                graphics2D = (Graphics2D)graphics2D.create(-insets.left, -insets.top, n, n2);
                try {
                    jXLabel.paint(graphics2D);
                }
                finally {
                    graphics2D.dispose();
                }
            }

            @Override
            protected boolean shouldUseCache() {
                return false;
            }

            public boolean equals(Object object) {
                return object != null && this.getClass().equals(object.getClass());
            }
        };
    }

    private void initLineWrapSupport() {
        this.addPropertyChangeListener(new MultiLineSupport());
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            public void ancestorResized(HierarchyEvent hierarchyEvent) {
                View view;
                Rectangle rectangle;
                if (hierarchyEvent.getChanged() instanceof JViewport && (rectangle = hierarchyEvent.getChanged().getBounds()).getWidth() < (double)JXLabel.this.getWidth() && (view = JXLabel.this.getWrappingView()) != null) {
                    view.setSize(rectangle.width, rectangle.height);
                }
            }
        });
    }

    public final Painter getForegroundPainter() {
        return this.foregroundPainter;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        View view;
        int n5 = this.getHeight();
        super.reshape(n, n2, n3, n4);
        if (!this.isLineWrap()) {
            return;
        }
        if (n5 == 0) {
            return;
        }
        if (n3 > this.getVisibleRect().width) {
            n3 = this.getVisibleRect().width;
        }
        if ((view = (View)this.getClientProperty("html")) != null && view instanceof Renderer) {
            view.setSize(n3 - this.occupiedWidth, n4);
        }
    }

    public void setForegroundPainter(Painter painter) {
        Painter painter2 = this.getForegroundPainter();
        if (painter == null) {
            this.initPainterSupport();
        } else {
            this.foregroundPainter = painter;
        }
        this.firePropertyChange("foregroundPainter", painter2, this.getForegroundPainter());
        this.repaint();
    }

    public void setBackgroundPainter(Painter painter) {
        Painter painter2 = this.getBackgroundPainter();
        this.backgroundPainter = painter;
        this.firePropertyChange("backgroundPainter", painter2, this.getBackgroundPainter());
        this.repaint();
    }

    public final Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public double getTextRotation() {
        return this.textRotation;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.isPreferredSizeSet()) {
            return dimension;
        }
        if (this.textRotation == 0.0) {
            int n;
            int n2;
            View view = this.getWrappingView();
            if (view == null) {
                if (this.isLineWrap() && !MultiLineSupport.isHTML(this.getText())) {
                    this.getMultiLineSupport();
                    this.putClientProperty("html", MultiLineSupport.createView(this));
                    view = (View)this.getClientProperty("html");
                } else {
                    return dimension;
                }
            }
            Insets insets = this.getInsets();
            int n3 = insets.left + insets.right;
            int n4 = insets.top + insets.bottom;
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            rectangle.height = 0;
            rectangle.width = 0;
            rectangle.y = 0;
            rectangle.x = 0;
            rectangle2.x = n3;
            rectangle2.y = n4;
            rectangle2.height = Short.MAX_VALUE;
            rectangle2.width = Short.MAX_VALUE;
            Rectangle rectangle3 = this.calculateIconRect();
            boolean bl = this.getText() == null || this.getText().equals("");
            int n5 = 0;
            if (bl) {
                rectangle.height = 0;
                rectangle.width = 0;
                n2 = 0;
            } else {
                JPanel jPanel;
                Border border;
                n2 = rectangle3.width == 0 ? 0 : this.getIconTextGap();
                this.occupiedWidth = n3 + rectangle3.width + n2;
                Container container = this.getParent();
                if (container != null && container instanceof JPanel && (border = (jPanel = (JPanel)container).getBorder()) != null) {
                    Insets insets2 = border.getBorderInsets(jPanel);
                    this.occupiedWidth += insets2.left + insets2.right;
                }
                n = this.getHorizontalTextPosition() == 0 ? rectangle2.width : rectangle2.width - (rectangle3.width + n2);
                float f = view.getPreferredSpan(0);
                rectangle.width = Math.min(n, (int)f);
                if (this.maxLineSpan > 0) {
                    rectangle.width = Math.min(rectangle.width, this.maxLineSpan);
                    if (f > (float)this.maxLineSpan) {
                        view.setSize(this.maxLineSpan, rectangle.height);
                    }
                }
                rectangle.height = (int)view.getPreferredSpan(1);
                if (rectangle.height == 0) {
                    rectangle.height = this.getFont().getSize();
                }
            }
            rectangle.y = this.getVerticalTextPosition() == 1 ? (this.getHorizontalTextPosition() != 0 ? 0 : -(rectangle.height + n2)) : (this.getVerticalTextPosition() == 0 ? rectangle3.height / 2 - rectangle.height / 2 : (this.getVerticalTextPosition() != 0 ? rectangle3.height - rectangle.height : rectangle3.height + n2));
            rectangle.x = this.getHorizontalTextPosition() == 2 ? -(rectangle.width + n2) : (this.getHorizontalTextPosition() == 0 ? rectangle3.width / 2 - rectangle.width / 2 : rectangle3.width + n2);
            n = Math.min(rectangle3.x, rectangle.x);
            int n6 = Math.max(rectangle3.x + rectangle3.width, rectangle.x + rectangle.width) - n;
            int n7 = Math.min(rectangle3.y, rectangle.y);
            int n8 = Math.max(rectangle3.y + rectangle3.height, rectangle.y + rectangle.height) - n7;
            int n9 = this.getVerticalAlignment() == 1 ? rectangle2.y - n7 : (this.getVerticalAlignment() == 0 ? rectangle2.y + rectangle2.height / 2 - (n7 + n8 / 2) : rectangle2.y + rectangle2.height - (n7 + n8));
            int n10 = this.getHorizontalAlignment() == 2 ? rectangle2.x - n : (this.getHorizontalAlignment() == 4 ? rectangle2.x + rectangle2.width - (n + n6) : rectangle2.x + rectangle2.width / 2 - (n + n6 / 2));
            rectangle.x += n10;
            rectangle.y += n9;
            rectangle3.x += n10;
            rectangle3.y += n9;
            if (n5 < 0) {
                rectangle.x -= n5;
            }
            int n11 = Math.min(rectangle3.x, rectangle.x);
            int n12 = Math.max(rectangle3.x + rectangle3.width, rectangle.x + rectangle.width);
            int n13 = Math.min(rectangle3.y, rectangle.y);
            int n14 = Math.max(rectangle3.y + rectangle3.height, rectangle.y + rectangle.height);
            Dimension dimension2 = new Dimension(n12 - n11, n14 - n13);
            dimension2.width += n3;
            dimension2.height += n4;
            return dimension2;
        }
        double d = this.getTextRotation();
        dimension.setSize(JXLabel.rotateWidth(dimension, d), JXLabel.rotateHeight(dimension, d));
        return dimension;
    }

    private View getWrappingView() {
        if (super.getTopLevelAncestor() == null) {
            return null;
        }
        View view = (View)this.getClientProperty("html");
        if (!(view instanceof Renderer)) {
            return null;
        }
        return view;
    }

    private Rectangle calculateIconRect() {
        Rectangle rectangle = new Rectangle();
        Icon icon = this.isEnabled() ? this.getIcon() : this.getDisabledIcon();
        rectangle.height = 0;
        rectangle.width = 0;
        rectangle.y = 0;
        rectangle.x = 0;
        if (icon != null) {
            rectangle.width = icon.getIconWidth();
            rectangle.height = icon.getIconHeight();
        } else {
            rectangle.height = 0;
            rectangle.width = 0;
        }
        return rectangle;
    }

    public int getMaxLineSpan() {
        return this.maxLineSpan;
    }

    public void setMaxLineSpan(int n) {
        int n2 = this.getMaxLineSpan();
        this.maxLineSpan = n;
        this.firePropertyChange("maxLineSpan", n2, this.getMaxLineSpan());
    }

    private static int rotateWidth(Dimension dimension, double d) {
        return (int)Math.round((double)dimension.width * Math.abs(Math.cos(d)) + (double)dimension.height * Math.abs(Math.sin(d)));
    }

    private static int rotateHeight(Dimension dimension, double d) {
        return (int)Math.round((double)dimension.width * Math.abs(Math.sin(d)) + (double)dimension.height * Math.abs(Math.cos(d)));
    }

    public void setTextRotation(double d) {
        double d2 = this.getTextRotation();
        this.textRotation = d;
        if (d2 != this.getTextRotation()) {
            this.firePropertyChange("textRotation", d2, this.getTextRotation());
        }
        this.repaint();
    }

    public void setLineWrap(boolean bl) {
        boolean bl2 = this.isLineWrap();
        this.multiLine = bl;
        if (this.isLineWrap() != bl2) {
            this.firePropertyChange("lineWrap", bl2, this.isLineWrap());
            if (this.getForegroundPainter() != null) {
                ((AbstractPainter)this.getForegroundPainter()).setCacheable(!bl);
            }
        }
    }

    public boolean isLineWrap() {
        return this.multiLine;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        TextAlignment textAlignment2 = this.getTextAlignment();
        this.textAlignment = textAlignment;
        this.firePropertyChange("textAlignment", textAlignment2, this.getTextAlignment());
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public boolean isOpaque() {
        return this.painting ? false : super.isOpaque();
    }

    public void setPaintBorderInsets(boolean bl) {
        boolean bl2 = this.isPaintBorderInsets();
        this.paintBorderInsets = bl;
        this.firePropertyChange("paintBorderInsets", bl2, this.isPaintBorderInsets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        this.painted = true;
        if (this.painting || this.backgroundPainter == null && this.foregroundPainter == null) {
            super.paintComponent(graphics);
        } else {
            Object object;
            this.pWidth = this.getWidth();
            this.pHeight = this.getHeight();
            Insets insets = this.getInsets();
            if (this.backgroundPainter != null) {
                object = (Graphics2D)graphics.create();
                try {
                    if (!this.isPaintBorderInsets()) {
                        ((Graphics2D)object).translate(insets.left, insets.top);
                        this.pWidth = this.pWidth - insets.left - insets.right;
                        this.pHeight = this.pHeight - insets.top - insets.bottom;
                    }
                    this.backgroundPainter.paint((Graphics2D)object, this, this.pWidth, this.pHeight);
                }
                finally {
                    ((Graphics)object).dispose();
                }
            }
            if (this.foregroundPainter != null) {
                this.pWidth = this.getWidth() - insets.left - insets.right;
                this.pHeight = this.getHeight() - insets.top - insets.bottom;
                object = this.calculateT();
                double d = Math.sin(this.textRotation) * ((Point2D)object).getY() + Math.cos(this.textRotation) * ((Point2D)object).getX();
                double d2 = Math.sin(this.textRotation) * ((Point2D)object).getX() + Math.cos(this.textRotation) * ((Point2D)object).getY();
                double d3 = ((double)this.getWidth() - d) / 2.0 + Math.sin(this.textRotation) * ((Point2D)object).getY();
                double d4 = ((double)this.getHeight() - d2) / 2.0;
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                if (insets != null) {
                    graphics2D.translate((double)insets.left + d3, (double)insets.top + d4);
                } else {
                    graphics2D.translate(d3, d4);
                }
                graphics2D.rotate(this.textRotation);
                this.painting = true;
                this.foregroundPainter.paint(graphics2D, this, this.pWidth, this.pHeight);
                graphics2D.dispose();
                this.painting = false;
                this.pWidth = 0;
                this.pHeight = 0;
            }
        }
    }

    private Point2D calculateT() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.textRotation > 4.697 && this.textRotation < 4.727 || this.textRotation > 1.555 && this.textRotation < 1.585) {
            int n = this.pHeight;
            this.pHeight = this.pWidth;
            this.pWidth = n;
            d = this.pWidth;
            d2 = this.pHeight;
        } else if (this.textRotation > -0.015 && this.textRotation < 0.015 || this.textRotation > 3.14 && this.textRotation < 3.143) {
            this.pHeight = this.getHeight();
            this.pWidth = this.getWidth();
        } else {
            this.dontIgnoreRepaint = false;
            double d3 = (double)Math.min(this.getHeight(), this.getWidth()) * Math.cos(0.7853981633974483);
            View view = (View)this.getClientProperty("html");
            if (view == null) {
                d2 = this.getFontMetrics(this.getFont()).getHeight();
                double d4 = ((double)this.getWidth() - Math.abs(d2 * Math.sin(this.textRotation))) / Math.abs(Math.cos(this.textRotation));
                double d5 = ((double)this.getHeight() - Math.abs(d2 * Math.cos(this.textRotation))) / Math.abs(Math.sin(this.textRotation));
                d = d4 < 0.0 ? d5 : (d5 > 0.0 ? Math.min(d4, d5) : d4);
            } else {
                float f = view.getPreferredSpan(0);
                float f2 = view.getPreferredSpan(1);
                double d6 = f;
                double d7 = this.textRotation;
                boolean bl = false;
                while (!bl) {
                    while (f2 == view.getPreferredSpan(1)) {
                        view.setSize(f -= 10.0f, f2);
                    }
                    if ((double)f < d3 || (double)f2 > d3) {
                        f = f2 = (float)d3;
                        view.setSize(f, 100000.0f);
                        break;
                    }
                    f2 = view.getPreferredSpan(1);
                    double d8 = ((double)this.getWidth() - Math.abs((double)f2 * Math.sin(d7))) / Math.abs(Math.cos(d7));
                    double d9 = ((double)this.getHeight() - Math.abs((double)f2 * Math.cos(d7))) / Math.abs(Math.sin(d7));
                    d6 = d8 < 0.0 ? d9 : (d9 > 0.0 ? Math.min(d8, d9) : d8);
                    if ((d6 -= 1.0) > (double)f) {
                        view.setSize((float)d6, 10.0f * f2);
                        bl = true;
                        continue;
                    }
                    view.setSize((float)d6, 10.0f * f2);
                    if (view.getPreferredSpan(1) > f2) {
                        view.setSize(f, 10.0f * f2);
                        continue;
                    }
                    f = (float)d6;
                    bl = true;
                }
                d = Math.floor(f);
                d2 = f2;
            }
            this.pWidth = (int)d;
            this.pHeight = (int)d2;
            this.dontIgnoreRepaint = true;
        }
        return new Point2D.Double(d, d2);
    }

    public void repaint() {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint();
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(n, n2, n3, n4);
    }

    public void repaint(long l) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(l);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this.dontIgnoreRepaint) {
            return;
        }
        super.repaint(l, n, n2, n3, n4);
    }

    public int getHeight() {
        int n = super.getHeight();
        if (this.painting) {
            n = this.pHeight;
        }
        return n;
    }

    public int getWidth() {
        int n = super.getWidth();
        if (this.painting) {
            n = this.pWidth;
        }
        return n;
    }

    protected MultiLineSupport getMultiLineSupport() {
        return new MultiLineSupport();
    }

    protected int getOccupiedWidth() {
        return this.occupiedWidth;
    }

    static class Renderer
    extends WrappedPlainView {
        JXLabel host;
        boolean invalidated = false;
        private float width;
        private float height;
        private View view;
        private ViewFactory factory;

        Renderer(JXLabel jXLabel, ViewFactory viewFactory, View view, boolean bl) {
            super(null, bl);
            this.factory = viewFactory;
            this.view = view;
            this.view.setParent(this);
            this.host = jXLabel;
            if (this.host.getVisibleRect().width == 0) {
                this.invalidated = true;
                return;
            }
            int n = this.host.getVisibleRect().width;
            this.setSize(jXLabel.getMaxLineSpan() > -1 ? (float)jXLabel.getMaxLineSpan() : (float)n, this.host.getVisibleRect().height);
        }

        protected void updateLayout(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape) {
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                Container container = this.getContainer();
                if (container != null) {
                    container.repaint();
                }
            }
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            if (this.host != null && this.host.painted) {
                this.host.revalidate();
                this.host.repaint();
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            if (graphics.getClipBounds() == null) {
                graphics.setClip(rectangle);
                this.view.paint(graphics, shape);
                graphics.setClip(null);
            } else {
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Document getDocument() {
            return this.view == null ? null : this.view.getDocument();
        }

        public void setSize(float f, float f2) {
            if (this.host.maxLineSpan > 0) {
                f = Math.min(f, (float)this.host.maxLineSpan);
            }
            if (f == this.width && f2 == this.height) {
                return;
            }
            this.width = (int)f;
            this.height = (int)f2;
            this.view.setSize(f, f2 == 0.0f ? 32767.0f : f2);
            if (this.height == 0.0f) {
                this.height = this.view.getPreferredSpan(1);
            }
        }

        public float getPreferredSpan(int n) {
            if (n == 0) {
                int n2;
                if (this.invalidated && (n2 = this.host.getVisibleRect().width) != 0) {
                    this.invalidated = false;
                    this.setSize(n2 - this.host.getOccupiedWidth(), this.host.getVisibleRect().height);
                }
                return this.width > 0.0f ? this.width : this.view.getPreferredSpan(n);
            }
            return this.view.getPreferredSpan(n);
        }

        public Container getContainer() {
            return this.host;
        }

        public ViewFactory getViewFactory() {
            return this.factory;
        }

        public int getWidth() {
            return (int)this.width;
        }

        public int getHeight() {
            return (int)this.height;
        }
    }

    static class BasicDocument
    extends DefaultStyledDocument {
        BasicDocument(Font font, Color color, TextAlignment textAlignment, float f) {
            this.setFontAndColor(font, color);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setAlignment(simpleAttributeSet, textAlignment.getValue());
            this.getStyle("default").addAttributes(simpleAttributeSet);
            simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setRightIndent(simpleAttributeSet, f);
            this.getStyle("default").addAttributes(simpleAttributeSet);
        }

        private void setFontAndColor(Font font, Color color) {
            SimpleAttributeSet simpleAttributeSet;
            if (color != null) {
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setForeground(simpleAttributeSet, color);
                this.getStyle("default").addAttributes(simpleAttributeSet);
            }
            if (font != null) {
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
                this.getStyle("default").addAttributes(simpleAttributeSet);
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setFontSize(simpleAttributeSet, font.getSize());
                this.getStyle("default").addAttributes(simpleAttributeSet);
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setBold(simpleAttributeSet, font.isBold());
                this.getStyle("default").addAttributes(simpleAttributeSet);
                simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setItalic(simpleAttributeSet, font.isItalic());
                this.getStyle("default").addAttributes(simpleAttributeSet);
            }
            simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setSpaceAbove(simpleAttributeSet, 0.0f);
            this.getStyle("default").addAttributes(simpleAttributeSet);
        }
    }

    private static class BasicViewFactory
    implements ViewFactory {
        private BasicViewFactory() {
        }

        public View create(Element element) {
            String string = element.getName();
            View view = null;
            if (string == null) {
                view = new LabelView(element);
            } else if (string.equals("content")) {
                view = new LabelView(element);
            } else if (string.equals("paragraph")) {
                view = new ParagraphView(element);
            } else if (string.equals("section")) {
                view = new BoxView(element, 1);
            } else if (string.equals("component")) {
                view = new ComponentView(element);
            } else if (string.equals("icon")) {
                view = new IconView(element);
            }
            return view;
        }
    }

    public static class MultiLineSupport
    implements PropertyChangeListener {
        private static ViewFactory basicViewFactory;
        private static BasicEditorKit basicFactory;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JXLabel jXLabel = (JXLabel)propertyChangeEvent.getSource();
            if ("ancestor".equals(string)) {
                jXLabel.dontIgnoreRepaint = true;
            }
            if (jXLabel.isLineWrap()) {
                if ("font".equals(string) || "foreground".equals(string) || "maxLineSpan".equals(string) || "textAlignment".equals(string) || "icon".equals(string) || "iconTextGap".equals(string)) {
                    if (propertyChangeEvent.getOldValue() != null && !MultiLineSupport.isHTML(jXLabel.getText())) {
                        MultiLineSupport.updateRenderer(jXLabel);
                    }
                } else if ("text".equals(string)) {
                    if (MultiLineSupport.isHTML((String)propertyChangeEvent.getOldValue()) && propertyChangeEvent.getNewValue() != null && !MultiLineSupport.isHTML((String)propertyChangeEvent.getNewValue())) {
                        if (jXLabel.getClientProperty("washtml") == null && jXLabel.getClientProperty("html") != null) {
                            jXLabel.putClientProperty("washtml", jXLabel.getClientProperty("html"));
                        }
                        jXLabel.putClientProperty("html", MultiLineSupport.createView(jXLabel));
                    } else if (!MultiLineSupport.isHTML((String)propertyChangeEvent.getOldValue()) && propertyChangeEvent.getNewValue() != null && !MultiLineSupport.isHTML((String)propertyChangeEvent.getNewValue())) {
                        MultiLineSupport.updateRenderer(jXLabel);
                    } else {
                        MultiLineSupport.restoreHtmlRenderer(jXLabel);
                    }
                } else if ("lineWrap".equals(string) && !MultiLineSupport.isHTML(jXLabel.getText())) {
                    jXLabel.putClientProperty("html", MultiLineSupport.createView(jXLabel));
                }
            } else if ("lineWrap".equals(string) && !((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                MultiLineSupport.restoreHtmlRenderer(jXLabel);
            }
        }

        private static void restoreHtmlRenderer(JXLabel jXLabel) {
            Object object = jXLabel.getClientProperty("html");
            if (object == null || object instanceof Renderer) {
                jXLabel.putClientProperty("html", jXLabel.getClientProperty("washtml"));
            }
        }

        private static boolean isHTML(String string) {
            return string != null && string.toLowerCase().startsWith("<html>");
        }

        public static View createView(JXLabel jXLabel) {
            BasicEditorKit basicEditorKit = MultiLineSupport.getFactory();
            float f = 0.0f;
            if (jXLabel.getIcon() != null && jXLabel.getHorizontalTextPosition() != 0) {
                f = jXLabel.getIcon().getIconWidth() + jXLabel.getIconTextGap();
            }
            Document document = basicEditorKit.createDefaultDocument(jXLabel.getFont(), jXLabel.getForeground(), jXLabel.getTextAlignment(), f);
            StringReader stringReader = new StringReader(jXLabel.getText() == null ? "" : jXLabel.getText());
            try {
                basicEditorKit.read(stringReader, document, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ViewFactory viewFactory = basicEditorKit.getViewFactory();
            View view = viewFactory.create(document.getDefaultRootElement());
            Renderer renderer = new Renderer(jXLabel, viewFactory, view, true);
            return renderer;
        }

        public static void updateRenderer(JXLabel jXLabel) {
            View view = null;
            View view2 = (View)jXLabel.getClientProperty("html");
            if (view2 == null || view2 instanceof Renderer) {
                view = MultiLineSupport.createView(jXLabel);
            }
            if (view != view2 && view2 != null) {
                for (int i = 0; i < view2.getViewCount(); ++i) {
                    view2.getView(i).setParent(null);
                }
            }
            jXLabel.putClientProperty("html", view);
        }

        private static BasicEditorKit getFactory() {
            if (basicFactory == null) {
                basicViewFactory = new BasicViewFactory();
                basicFactory = new BasicEditorKit();
            }
            return basicFactory;
        }

        private static class BasicEditorKit
        extends StyledEditorKit {
            private BasicEditorKit() {
            }

            public Document createDefaultDocument(Font font, Color color, TextAlignment textAlignment, float f) {
                BasicDocument basicDocument = new BasicDocument(font, color, textAlignment, f);
                basicDocument.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                return basicDocument;
            }

            public ViewFactory getViewFactory() {
                return basicViewFactory;
            }
        }
    }

    protected static interface IValue {
        public int getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextAlignment implements IValue
    {
        LEFT(0),
        CENTER(1),
        RIGHT(2),
        JUSTIFY(3);

        private int value;

        private TextAlignment(int n2) {
            this.value = n2;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

