/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ListUI;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.XListAddon;
import org.jdesktop.swingx.renderer.AbstractRenderer;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.ListRolloverController;
import org.jdesktop.swingx.rollover.ListRolloverProducer;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.search.ListSearchable;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.sort.SortUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXList
extends JList {
    private static final Logger LOG = Logger.getLogger(JXList.class.getName());
    public static final String uiClassID = "XListUI";
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    protected ComponentAdapter dataAdapter;
    private RolloverProducer rolloverProducer;
    private ListRolloverController<JXList> linkController;
    private DelegatingRenderer delegatingRenderer;
    private boolean filterEnabled;
    private Searchable searchable;
    private Comparator<?> comparator;

    public JXList() {
        this(false);
    }

    public JXList(ListModel listModel) {
        this(listModel, false);
    }

    public JXList(Object[] objectArray) {
        this(objectArray, false);
    }

    public JXList(Vector<?> vector) {
        this(vector, false);
    }

    public JXList(boolean bl) {
        this.init(bl);
    }

    public JXList(ListModel listModel, boolean bl) {
        super(listModel);
        this.init(bl);
    }

    public JXList(Object[] objectArray, boolean bl) {
        super(objectArray);
        if (objectArray == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(bl);
    }

    public JXList(Vector<?> vector, boolean bl) {
        super(vector);
        if (vector == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(bl);
    }

    private void init(boolean bl) {
        this.setFilterEnabled(bl);
        Action action = this.createFindAction();
        this.getActionMap().put("find", action);
        KeyStroke keyStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(keyStroke, "find");
    }

    private Action createFindAction() {
        return new UIAction("find"){

            public void actionPerformed(ActionEvent actionEvent) {
                JXList.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new ListSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.isRolloverEnabled();
        if (bl == bl2) {
            return;
        }
        if (bl) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", bl2, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected ListRolloverController<JXList> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected ListRolloverController<JXList> createLinkController() {
        return new ListRolloverController<JXList>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new ListRolloverProducer();
    }

    public void resetSortOrder() {
        SortController sortController = this.getSortController();
        if (sortController != null) {
            sortController.resetSortOrders();
        }
    }

    public void toggleSortOrder() {
        SortController sortController = this.getSortController();
        if (sortController != null) {
            sortController.toggleSortOrder(0);
        }
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (!SortUtils.isSorted(sortOrder)) {
            this.resetSortOrder();
            return;
        }
        SortController sortController = this.getSortController();
        if (sortController != null) {
            // empty if block
        }
    }

    public SortOrder getSortOrder() {
        SortController sortController = this.getSortController();
        if (sortController == null) {
            return SortOrder.UNSORTED;
        }
        return sortController.getSortOrder(0);
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<?> comparator) {
        Comparator<?> comparator2 = this.getComparator();
        this.comparator = comparator;
        this.updateSortAfterComparatorChange();
        this.firePropertyChange("comparator", comparator2, this.getComparator());
    }

    protected void updateSortAfterComparatorChange() {
        this.setSortOrder(this.getSortOrder());
    }

    protected SortController getSortController() {
        return null;
    }

    public Object getElementAt(int n) {
        return this.getModel().getElementAt(n);
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public int convertIndexToModel(int n) {
        return n;
    }

    public int convertIndexToView(int n) {
        return n;
    }

    public ListModel getWrappedModel() {
        return this.getModel();
    }

    public void setFilterEnabled(boolean bl) {
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    @Override
    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        super.setSelectionModel(listSelectionModel);
    }

    public void setModel(ListModel listModel) {
        super.setModel(listModel);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ListAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int n) {
        ComponentAdapter componentAdapter = this.getComponentAdapter();
        componentAdapter.column = 0;
        componentAdapter.row = n;
        return componentAdapter;
    }

    public void setHighlighters(Highlighter ... highlighterArray) {
        Highlighter[] highlighterArray2 = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighterArray);
        this.firePropertyChange("highlighters", highlighterArray2, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] highlighterArray = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", highlighterArray, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JXList.this.repaint();
            }
        };
    }

    public String getStringAt(int n) {
        ListCellRenderer listCellRenderer = this.getDelegatingRenderer().getDelegateRenderer();
        if (listCellRenderer instanceof StringValue) {
            return ((StringValue)((Object)listCellRenderer)).getString(this.getElementAt(n));
        }
        return StringValues.TO_STRING.getString(this.getElementAt(n));
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected ListCellRenderer createDefaultCellRenderer() {
        return new DefaultListRenderer();
    }

    public ListCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public ListCellRenderer getWrappedCellRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.getDelegatingRenderer().setDelegateRenderer(listCellRenderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    @Override
    public void updateUI() {
        if (this.getUIClassID() == super.getUIClassID()) {
            super.updateUI();
        } else {
            this.setUI((ListUI)LookAndFeelAddons.getUI(this, ListUI.class));
        }
        this.updateRendererUI();
        this.updateHighlighterUI();
    }

    @Override
    public String getUIClassID() {
        return super.getUIClassID();
    }

    private void updateRendererUI() {
        if (this.delegatingRenderer != null) {
            this.delegatingRenderer.updateUI();
        } else {
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)listCellRenderer));
            }
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    static {
        LookAndFeelAddons.contribute(new XListAddon());
    }

    public class DelegatingRenderer
    implements ListCellRenderer,
    RolloverRenderer {
        private ListCellRenderer delegateRenderer;

        public DelegatingRenderer() {
            this(null);
        }

        public DelegatingRenderer(ListCellRenderer listCellRenderer) {
            this.setDelegateRenderer(listCellRenderer);
        }

        public void setDelegateRenderer(ListCellRenderer listCellRenderer) {
            if (listCellRenderer == null) {
                listCellRenderer = JXList.this.createDefaultCellRenderer();
            }
            this.delegateRenderer = listCellRenderer;
        }

        public ListCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public void updateUI() {
            this.updateRendererUI(this.delegateRenderer);
        }

        private void updateRendererUI(ListCellRenderer listCellRenderer) {
            if (listCellRenderer == null) {
                return;
            }
            Component component = null;
            if (listCellRenderer instanceof AbstractRenderer) {
                component = (Component)((AbstractRenderer)((Object)listCellRenderer)).getComponentProvider().getRendererComponent(null);
            } else if (listCellRenderer instanceof Component) {
                component = (Component)((Object)listCellRenderer);
            } else {
                try {
                    component = listCellRenderer.getListCellRendererComponent(JXList.this, null, -1, false, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (component != null) {
                SwingUtilities.updateComponentTreeUI(component);
            }
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = this.delegateRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (JXList.this.compoundHighlighter != null && n >= 0 && n < JXList.this.getElementCount()) {
                component = JXList.this.compoundHighlighter.highlight(component, JXList.this.getComponentAdapter(n));
            }
            return component;
        }

        public boolean isEnabled() {
            return this.delegateRenderer instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegateRenderer)).isEnabled();
        }

        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegateRenderer)).doClick();
            }
        }
    }

    protected static class ListAdapter
    extends ComponentAdapter {
        private final JXList list;

        public ListAdapter(JXList jXList) {
            super(jXList);
            this.list = jXList;
        }

        public JXList getList() {
            return this.list;
        }

        public boolean hasFocus() {
            return this.list.isFocusOwner() && this.row == this.list.getLeadSelectionIndex();
        }

        public int getRowCount() {
            return this.list.getWrappedModel().getSize();
        }

        public Object getValue() {
            return this.list.getElementAt(this.row);
        }

        public Object getValueAt(int n, int n2) {
            return this.list.getWrappedModel().getElementAt(n);
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.list.getElementAt(n);
        }

        public String getFilteredStringAt(int n, int n2) {
            return this.list.getStringAt(n);
        }

        public String getString() {
            return this.list.getStringAt(this.row);
        }

        public String getStringAt(int n, int n2) {
            ListCellRenderer listCellRenderer = this.list.getDelegatingRenderer().getDelegateRenderer();
            if (listCellRenderer instanceof StringValue) {
                return ((StringValue)((Object)listCellRenderer)).getString(this.getValueAt(n, n2));
            }
            return StringValues.TO_STRING.getString(this.getValueAt(n, n2));
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isSelected() {
            return this.list.isSelectedIndex(this.row);
        }
    }
}

