/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.DaySelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.MonthViewAddon;
import org.jdesktop.swingx.plaf.MonthViewUI;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMonthView
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXMonthView.class.getName());
    public static final String COMMIT_KEY = "monthViewCommit";
    public static final String CANCEL_KEY = "monthViewCancel";
    public static final String BOX_PADDING_X = "boxPaddingX";
    public static final String BOX_PADDING_Y = "boxPaddingY";
    public static final String DAYS_OF_THE_WEEK = "daysOfTheWeek";
    public static final String SELECTION_MODEL = "selectionModel";
    public static final String TRAVERSABLE = "traversable";
    public static final String FLAGGED_DATES = "flaggedDates";
    public static final String uiClassID = "MonthViewUI";
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    private Date firstDisplayedDay;
    private Calendar cal;
    private Calendar anchor;
    private Date today;
    private Timer todayTimer;
    private int firstDayOfWeek;
    private DateSelectionModel model;
    private DateSelectionListener modelListener;
    private DaySelectionModel flaggedDates;
    private EventListenerMap listenerMap;
    private boolean traversable;
    private boolean leadingDays;
    private boolean trailingDays;
    private boolean showWeekNumber;
    private boolean componentInputMapEnabled;
    protected Date modifiedStartDate;
    protected Date modifiedEndDate;
    private String[] _daysOfTheWeek;
    protected Insets _monthStringInsets = new Insets(0, 0, 0, 0);
    private int boxPaddingX;
    private int boxPaddingY;
    private int minCalCols = 1;
    private int minCalRows = 1;
    private Color todayBackgroundColor;
    private Color monthStringBackground;
    private Color monthStringForeground;
    private Color daysOfTheWeekForeground;
    private Color selectedBackground;
    private Hashtable<Integer, Color> dayToColorTable = new Hashtable();
    private Color flaggedDayForeground;
    private Color selectedForeground;
    private boolean zoomable;

    public JXMonthView() {
        this(null, null, null);
    }

    public JXMonthView(Locale locale) {
        this(null, null, locale);
    }

    public JXMonthView(Date date) {
        this(date, null, null);
    }

    public JXMonthView(Date date, DateSelectionModel dateSelectionModel) {
        this(date, dateSelectionModel, null);
    }

    public JXMonthView(Date date, DateSelectionModel dateSelectionModel, Locale locale) {
        this.listenerMap = new EventListenerMap();
        this.initModel(dateSelectionModel, locale);
        this.superSetLocale(locale);
        this.setFirstDisplayedDay(date != null ? date : this.getCurrentDate());
        this.updateTodayFromCurrentTime();
        this.updateUI();
        this.setFocusable(true);
        this.todayBackgroundColor = this.getForeground();
    }

    @Override
    public void setLocale(Locale locale) {
        this.model.setLocale(locale);
    }

    private void superSetLocale(Locale locale) {
        if (locale != null) {
            super.setLocale(locale);
            this.repaint();
        }
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            throw new IllegalStateException("must not be called before instantiation is complete");
        }
        Calendar calendar = (Calendar)this.cal.clone();
        calendar.setTime(this.firstDisplayedDay);
        return calendar;
    }

    public TimeZone getTimeZone() {
        return this.cal.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.model.setTimeZone(timeZone);
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int n) {
        this.getSelectionModel().setFirstDayOfWeek(n);
    }

    private void initModel(DateSelectionModel dateSelectionModel, Locale locale) {
        if (locale == null) {
            locale = JComponent.getDefaultLocale();
        }
        if (dateSelectionModel == null) {
            dateSelectionModel = new DaySelectionModel(locale);
        }
        this.model = dateSelectionModel;
        this.flaggedDates = new DaySelectionModel(locale);
        this.flaggedDates.setSelectionMode(DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.installCalendar();
        dateSelectionModel.addDateSelectionListener(this.getDateSelectionListener());
    }

    private DateSelectionListener getDateSelectionListener() {
        if (this.modelListener == null) {
            this.modelListener = new DateSelectionListener(){

                public void valueChanged(DateSelectionEvent dateSelectionEvent) {
                    if (DateSelectionEvent.EventType.CALENDAR_CHANGED.equals((Object)dateSelectionEvent.getEventType())) {
                        JXMonthView.this.updateCalendar();
                    }
                }
            };
        }
        return this.modelListener;
    }

    private void installCalendar() {
        this.cal = this.model.getCalendar();
        this.firstDayOfWeek = this.cal.getFirstDayOfWeek();
        Date date = this.getAnchorDate();
        this.anchor = (Calendar)this.cal.clone();
        if (date != null) {
            this.setFirstDisplayedDay(date);
        }
        this.updateTodayFromCurrentTime();
    }

    protected Date getAnchorDate() {
        return this.anchor != null ? this.anchor.getTime() : null;
    }

    private void updateCalendar() {
        if (!this.getLocale().equals(this.model.getLocale())) {
            this.installCalendar();
            this.superSetLocale(this.model.getLocale());
        } else {
            if (!this.model.getTimeZone().equals(this.getTimeZone())) {
                this.updateTimeZone();
            }
            if (this.cal.getMinimalDaysInFirstWeek() != this.model.getMinimalDaysInFirstWeek()) {
                this.updateMinimalDaysOfFirstWeek();
            }
            if (this.cal.getFirstDayOfWeek() != this.model.getFirstDayOfWeek()) {
                this.updateFirstDayOfWeek();
            }
        }
    }

    private void updateTimeZone() {
        TimeZone timeZone = this.getTimeZone();
        TimeZone timeZone2 = this.model.getTimeZone();
        this.cal.setTimeZone(timeZone2);
        this.anchor.setTimeZone(timeZone2);
        this.setFirstDisplayedDay(this.anchor.getTime());
        this.updateTodayFromCurrentTime();
        this.updateDatesAfterTimeZoneChange(timeZone);
        this.firePropertyChange("timeZone", timeZone, this.getTimeZone());
    }

    protected void updateDatesAfterTimeZoneChange(TimeZone timeZone) {
        SortedSet<Date> sortedSet = this.getFlaggedDates();
        this.flaggedDates.setTimeZone(this.getTimeZone());
        this.firePropertyChange(FLAGGED_DATES, sortedSet, this.getFlaggedDates());
    }

    private void updateFirstDayOfWeek() {
        int n = this.firstDayOfWeek;
        this.firstDayOfWeek = this.getSelectionModel().getFirstDayOfWeek();
        this.cal.setFirstDayOfWeek(this.firstDayOfWeek);
        this.anchor.setFirstDayOfWeek(this.firstDayOfWeek);
        this.firePropertyChange("firstDayOfWeek", n, this.firstDayOfWeek);
    }

    private void updateMinimalDaysOfFirstWeek() {
        this.cal.setMinimalDaysInFirstWeek(this.model.getMinimalDaysInFirstWeek());
        this.anchor.setMinimalDaysInFirstWeek(this.model.getMinimalDaysInFirstWeek());
    }

    public Date getLastDisplayedDay() {
        return this.getUI().getLastDisplayedDay();
    }

    public Date getFirstDisplayedDay() {
        return this.firstDisplayedDay;
    }

    public void setFirstDisplayedDay(Date date) {
        this.anchor.setTime(date);
        Date date2 = this.getFirstDisplayedDay();
        this.cal.setTime(this.anchor.getTime());
        CalendarUtils.startOfMonth(this.cal);
        this.firstDisplayedDay = this.cal.getTime();
        this.firePropertyChange("firstDisplayedDay", date2, this.getFirstDisplayedDay());
    }

    public void ensureDateVisible(Date date) {
        if (date.before(this.firstDisplayedDay)) {
            this.setFirstDisplayedDay(date);
        } else {
            Date date2 = this.getLastDisplayedDay();
            if (date.after(date2)) {
                this.cal.setTime(date);
                int n = this.cal.get(2);
                int n2 = this.cal.get(1);
                this.cal.setTime(date2);
                int n3 = this.cal.get(2);
                int n4 = this.cal.get(1);
                int n5 = n - n3 + (n2 - n4) * 12;
                this.cal.setTime(this.firstDisplayedDay);
                this.cal.add(2, n5);
                this.setFirstDisplayedDay(this.cal.getTime());
            }
        }
    }

    public Date getDayAtLocation(int n, int n2) {
        return this.getUI().getDayAtLocation(n, n2);
    }

    Date getCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    protected void updateTodayFromCurrentTime() {
        this.setToday(this.getCurrentDate());
    }

    protected void incrementToday() {
        this.cal.setTime(this.getToday());
        this.cal.add(5, 1);
        this.setToday(this.cal.getTime());
    }

    protected void setToday(Date date) {
        Date date2 = this.getToday();
        this.today = this.startOfDay(date);
        this.firePropertyChange("today", date2, this.getToday());
    }

    public Date getToday() {
        return this.today != null ? (Date)this.today.clone() : null;
    }

    private Date startOfDay(Date date) {
        return CalendarUtils.startOfDay(this.cal, date);
    }

    @Override
    public MonthViewUI getUI() {
        return (MonthViewUI)this.ui;
    }

    public void setUI(MonthViewUI monthViewUI) {
        super.setUI(monthViewUI);
    }

    @Override
    public void updateUI() {
        this.setUI((MonthViewUI)LookAndFeelAddons.getUI(this, MonthViewUI.class));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public DateSelectionModel getSelectionModel() {
        return this.model;
    }

    public void setSelectionModel(DateSelectionModel dateSelectionModel) {
        Contract.asNotNull(dateSelectionModel, "date selection model must not be null");
        DateSelectionModel dateSelectionModel2 = this.getSelectionModel();
        dateSelectionModel.removeDateSelectionListener(this.getDateSelectionListener());
        this.model = dateSelectionModel;
        this.installCalendar();
        if (!dateSelectionModel.getLocale().equals(this.getLocale())) {
            super.setLocale(dateSelectionModel.getLocale());
        }
        dateSelectionModel.addDateSelectionListener(this.getDateSelectionListener());
        this.firePropertyChange(SELECTION_MODEL, dateSelectionModel2, this.getSelectionModel());
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public SortedSet<Date> getSelection() {
        return this.getSelectionModel().getSelection();
    }

    public void addSelectionInterval(Date date, Date date2) {
        this.getSelectionModel().addSelectionInterval(date, date2);
    }

    public void setSelectionInterval(Date date, Date date2) {
        this.getSelectionModel().setSelectionInterval(date, date2);
    }

    public void removeSelectionInterval(Date date, Date date2) {
        this.getSelectionModel().removeSelectionInterval(date, date2);
    }

    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public Date getFirstSelectionDate() {
        return this.getSelectionModel().getFirstSelectionDate();
    }

    public Date getLastSelectionDate() {
        return this.getSelectionModel().getLastSelectionDate();
    }

    public Date getSelectionDate() {
        return this.getFirstSelectionDate();
    }

    public void setSelectionDate(Date date) {
        if (date == null) {
            this.clearSelection();
        } else {
            this.setSelectionInterval(date, date);
        }
    }

    public boolean isSelected(Date date) {
        return this.getSelectionModel().isSelected(date);
    }

    public void setLowerBound(Date date) {
        this.getSelectionModel().setLowerBound(date);
    }

    public void setUpperBound(Date date) {
        this.getSelectionModel().setUpperBound(date);
    }

    public Date getLowerBound() {
        return this.getSelectionModel().getLowerBound();
    }

    public Date getUpperBound() {
        return this.getSelectionModel().getUpperBound();
    }

    public boolean isUnselectableDate(Date date) {
        return this.getSelectionModel().isUnselectableDate(date);
    }

    public void setUnselectableDates(Date ... dateArray) {
        Contract.asNotNull(dateArray, "unselectable dates must not be null");
        TreeSet<Date> treeSet = new TreeSet<Date>();
        for (Date date : dateArray) {
            treeSet.add(date);
        }
        this.getSelectionModel().setUnselectableDates(treeSet);
        this.repaint();
    }

    public boolean isFlaggedDate(Date date) {
        if (date == null) {
            return false;
        }
        return this.flaggedDates.isSelected(date);
    }

    public void setFlaggedDates(Date ... dateArray) {
        SortedSet<Date> sortedSet = this.getFlaggedDates();
        this.flaggedDates.clearSelection();
        if (dateArray != null) {
            for (Date date : dateArray) {
                this.flaggedDates.addSelectionInterval(date, date);
            }
        }
        this.firePropertyChange(FLAGGED_DATES, sortedSet, this.getFlaggedDates());
    }

    public void addFlaggedDates(Date ... dateArray) {
        SortedSet<Date> sortedSet = this.flaggedDates.getSelection();
        if (dateArray != null) {
            for (Date date : dateArray) {
                this.flaggedDates.addSelectionInterval(date, date);
            }
        }
        this.firePropertyChange(FLAGGED_DATES, sortedSet, this.flaggedDates.getSelection());
    }

    public void removeFlaggedDates(Date ... dateArray) {
        SortedSet<Date> sortedSet = this.flaggedDates.getSelection();
        if (dateArray != null) {
            for (Date date : dateArray) {
                this.flaggedDates.removeSelectionInterval(date, date);
            }
        }
        this.firePropertyChange(FLAGGED_DATES, sortedSet, this.flaggedDates.getSelection());
    }

    public void clearFlaggedDates() {
        SortedSet<Date> sortedSet = this.flaggedDates.getSelection();
        this.flaggedDates.clearSelection();
        this.firePropertyChange(FLAGGED_DATES, sortedSet, this.flaggedDates.getSelection());
    }

    public SortedSet<Date> getFlaggedDates() {
        return this.flaggedDates.getSelection();
    }

    public boolean hasFlaggedDates() {
        return !this.flaggedDates.isSelectionEmpty();
    }

    public void setShowingLeadingDays(boolean bl) {
        boolean bl2 = this.isShowingLeadingDays();
        this.leadingDays = bl;
        this.firePropertyChange("showingLeadingDays", bl2, this.isShowingLeadingDays());
    }

    public boolean isShowingLeadingDays() {
        return this.leadingDays;
    }

    public void setShowingTrailingDays(boolean bl) {
        boolean bl2 = this.isShowingTrailingDays();
        this.trailingDays = bl;
        this.firePropertyChange("showingTrailingDays", bl2, this.isShowingTrailingDays());
    }

    public boolean isShowingTrailingDays() {
        return this.trailingDays;
    }

    public boolean isTraversable() {
        if (this.isZoomable()) {
            return true;
        }
        return this.traversable;
    }

    public void setTraversable(boolean bl) {
        boolean bl2 = this.isTraversable();
        this.traversable = bl;
        this.firePropertyChange(TRAVERSABLE, bl2, this.isTraversable());
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean bl) {
        boolean bl2 = this.isZoomable();
        this.zoomable = bl;
        this.firePropertyChange("zoomable", bl2, this.isZoomable());
    }

    public boolean isShowingWeekNumber() {
        return this.showWeekNumber;
    }

    public void setShowingWeekNumber(boolean bl) {
        boolean bl2 = this.isShowingWeekNumber();
        this.showWeekNumber = bl;
        this.firePropertyChange("showingWeekNumber", bl2, this.isShowingWeekNumber());
    }

    public void setDaysOfTheWeek(String[] stringArray) {
        if (stringArray != null && stringArray.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        String[] stringArray2 = this.getDaysOfTheWeek();
        this._daysOfTheWeek = stringArray;
        this.firePropertyChange(DAYS_OF_THE_WEEK, stringArray2, stringArray);
    }

    public String[] getDaysOfTheWeek() {
        if (this._daysOfTheWeek != null) {
            String[] stringArray = new String[7];
            System.arraycopy(this._daysOfTheWeek, 0, stringArray, 0, 7);
            return stringArray;
        }
        return this.getUI().getDaysOfTheWeek();
    }

    public String getDayOfTheWeek(int n) {
        return this.getDaysOfTheWeek()[n - 1];
    }

    public int getBoxPaddingX() {
        return this.boxPaddingX;
    }

    public void setBoxPaddingX(int n) {
        int n2 = this.getBoxPaddingX();
        this.boxPaddingX = n;
        this.firePropertyChange(BOX_PADDING_X, n2, this.getBoxPaddingX());
    }

    public int getBoxPaddingY() {
        return this.boxPaddingY;
    }

    public void setBoxPaddingY(int n) {
        int n2 = this.getBoxPaddingY();
        this.boxPaddingY = n;
        this.firePropertyChange(BOX_PADDING_Y, n2, this.getBoxPaddingY());
    }

    public Color getSelectionBackground() {
        return this.selectedBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.getSelectionBackground();
        this.selectedBackground = color;
        this.firePropertyChange("selectionBackground", color2, this.getSelectionBackground());
    }

    public Color getSelectionForeground() {
        return this.selectedForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.getSelectionForeground();
        this.selectedForeground = color;
        this.firePropertyChange("selectionForeground", color2, this.getSelectionForeground());
    }

    public Color getTodayBackground() {
        return this.todayBackgroundColor;
    }

    public void setTodayBackground(Color color) {
        Color color2 = this.getTodayBackground();
        this.todayBackgroundColor = color;
        this.firePropertyChange("todayBackground", color2, this.getTodayBackground());
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this.monthStringBackground;
    }

    public void setMonthStringBackground(Color color) {
        Color color2 = this.getMonthStringBackground();
        this.monthStringBackground = color;
        this.firePropertyChange("monthStringBackground", color2, this.getMonthStringBackground());
        this.repaint();
    }

    public Color getMonthStringForeground() {
        return this.monthStringForeground;
    }

    public void setMonthStringForeground(Color color) {
        Color color2 = this.getMonthStringForeground();
        this.monthStringForeground = color;
        this.firePropertyChange("monthStringForeground", color2, this.getMonthStringForeground());
        this.repaint();
    }

    public void setDaysOfTheWeekForeground(Color color) {
        Color color2 = this.getDaysOfTheWeekForeground();
        this.daysOfTheWeekForeground = color;
        this.firePropertyChange("daysOfTheWeekForeground", color2, this.getDaysOfTheWeekForeground());
    }

    public Color getDaysOfTheWeekForeground() {
        return this.daysOfTheWeekForeground;
    }

    public void setDayForeground(int n, Color color) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("dayOfWeek must be in [Calendar.SUNDAY ... Calendar.SATURDAY] but was " + n);
        }
        this.dayToColorTable.put(n, color);
        this.repaint();
    }

    public Color getDayForeground(int n) {
        Color color = this.dayToColorTable.get(n);
        if (color == null) {
            color = this.getForeground();
        }
        return color;
    }

    public Color getPerDayOfWeekForeground(int n) {
        return this.dayToColorTable.get(n);
    }

    public void setFlaggedDayForeground(Color color) {
        Color color2 = this.getFlaggedDayForeground();
        this.flaggedDayForeground = color;
        this.firePropertyChange("flaggedDayForeground", color2, this.getFlaggedDayForeground());
    }

    public Color getFlaggedDayForeground() {
        return this.flaggedDayForeground;
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        Insets insets2 = this.getMonthStringInsets();
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.firePropertyChange("monthStringInsets", insets2, this.getMonthStringInsets());
        this.repaint();
    }

    public int getPreferredColumnCount() {
        return this.minCalCols;
    }

    public void setPreferredColumnCount(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = this.getPreferredColumnCount();
        this.minCalCols = n;
        this.firePropertyChange("preferredColumnCount", n2, this.getPreferredColumnCount());
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRowCount() {
        return this.minCalRows;
    }

    public void setPreferredRowCount(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = this.getPreferredRowCount();
        this.minCalRows = n;
        this.firePropertyChange("preferredRowCount", n2, this.getPreferredRowCount());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeNotify() {
        this.todayTimer.stop();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateTodayFromCurrentTime();
        int n = 86400;
        if (this.todayTimer == null) {
            this.todayTimer = new Timer(n * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JXMonthView.this.incrementToday();
                }
            });
        }
        this.cal.setTime(this.getCurrentDate());
        n = n - this.cal.get(11) * 3600 - this.cal.get(12) * 60 - this.cal.get(13);
        this.todayTimer.setInitialDelay(n * 1000);
        this.todayTimer.start();
    }

    public void commitSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed(COMMIT_KEY);
    }

    public void cancelSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed(CANCEL_KEY);
    }

    public void setComponentInputMapEnabled(boolean bl) {
        boolean bl2 = this.isComponentInputMapEnabled();
        this.componentInputMapEnabled = bl;
        this.firePropertyChange("componentInputMapEnabled", bl2, this.isComponentInputMapEnabled());
    }

    public boolean isComponentInputMapEnabled() {
        return this.componentInputMapEnabled;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerMap.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerMap.remove(ActionListener.class, actionListener);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray;
        List<EventListener> list = this.listenerMap.getListeners(clazz);
        if (!list.isEmpty()) {
            eventListenerArray = (EventListener[])Array.newInstance(clazz, list.size());
            eventListenerArray = list.toArray(eventListenerArray);
        } else {
            eventListenerArray = super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    protected void fireActionPerformed(String string) {
        ActionListener[] actionListenerArray = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent actionEvent = null;
        for (ActionListener actionListener : actionListenerArray) {
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, string);
            }
            actionListener.actionPerformed(actionEvent);
        }
    }

    @Deprecated
    protected void cleanupWeekSelectionDates(Date date, Date date2) {
        int n = 1;
        this.cal.setTime(date);
        while (this.cal.getTimeInMillis() < date2.getTime()) {
            this.cal.add(5, 1);
            ++n;
        }
        if (n > 7) {
            int n2;
            this.cal.setTime(date);
            int n3 = this.cal.get(7);
            int n4 = this.getFirstDayOfWeek();
            int n5 = n3 - n4;
            if (n5 < 0) {
                n5 += 7;
            }
            this.cal.add(5, -n5);
            this.modifiedStartDate = this.cal.getTime();
            this.cal.setTime(date2);
            n3 = this.cal.get(7);
            int n6 = n4 - 1;
            if (n6 == 0) {
                n6 = 7;
            }
            if ((n2 = n6 - n3) < 0) {
                n2 += 7;
            }
            this.cal.add(5, n2);
            this.modifiedEndDate = this.cal.getTime();
        }
    }

    static {
        LookAndFeelAddons.contribute(new MonthViewAddon());
    }
}

