/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXStatusBar;

public class JXRootPane
extends JRootPane {
    protected JXStatusBar statusBar;
    private JToolBar toolBar;
    private JButton cancelButton;

    public JXRootPane() {
        this.installKeyboardActions();
    }

    protected Container createContentPane() {
        JXPanel jXPanel = new JXPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void addImpl(Component component, Object object, int n) {
                Object object2 = this.getTreeLock();
                synchronized (object2) {
                    super.addImpl(component, object, n);
                    JXRootPane.this.registerStatusBar(component);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void remove(int n) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    JXRootPane.this.unregisterStatusBar(this.getComponent(n));
                    super.remove(n);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeAll() {
                Object object = this.getTreeLock();
                synchronized (object) {
                    for (Component component : this.getComponents()) {
                        JXRootPane.this.unregisterStatusBar(component);
                    }
                    super.removeAll();
                }
            }
        };
        jXPanel.setName(this.getName() + ".contentPane");
        jXPanel.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component component, Object object) {
                if (object == null) {
                    object = "Center";
                }
                super.addLayoutComponent(component, object);
            }
        });
        return jXPanel;
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof XRootLayout) {
            if (layoutManager != null && layoutManager == this.getLayout()) {
                ((XRootLayout)layoutManager).setLayoutManager(null);
            }
            super.setLayout(layoutManager);
        } else if (layoutManager instanceof LayoutManager2) {
            ((XRootLayout)this.getLayout()).setLayoutManager((LayoutManager2)layoutManager);
            if (!this.isValid()) {
                this.invalidate();
            }
        }
    }

    protected LayoutManager createRootLayout() {
        return new XRootLayout();
    }

    private void installKeyboardActions() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = JXRootPane.this.getCancelButton();
                if (jButton != null) {
                    jButton.doClick(20);
                }
            }

            public boolean isEnabled() {
                return JXRootPane.this.cancelButton != null && JXRootPane.this.cancelButton.isEnabled();
            }
        };
        this.getActionMap().put("esc-action", abstractAction);
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, "esc-action");
    }

    private void registerStatusBar(Component component) {
        if (this.statusBar == null || component == null) {
            return;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.registerStatusBar(componentArray[i]);
            }
        }
    }

    private void unregisterStatusBar(Component component) {
        if (this.statusBar == null || component == null) {
            return;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.unregisterStatusBar(componentArray[i]);
            }
        }
    }

    public void setStatusBar(JXStatusBar jXStatusBar) {
        JXStatusBar jXStatusBar2 = this.statusBar;
        this.statusBar = jXStatusBar;
        Component[] componentArray = this.getContentPane().getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.unregisterStatusBar(componentArray[i]);
            this.registerStatusBar(componentArray[i]);
        }
        if (jXStatusBar2 != null) {
            this.remove(jXStatusBar2);
        }
        if (jXStatusBar != null) {
            this.add(jXStatusBar);
        }
        this.firePropertyChange("statusBar", jXStatusBar2, this.getStatusBar());
    }

    public JXStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setToolBar(JToolBar jToolBar) {
        JToolBar jToolBar2 = this.getToolBar();
        this.toolBar = jToolBar;
        if (jToolBar2 != null) {
            this.getContentPane().remove(jToolBar2);
        }
        this.getContentPane().add("North", this.toolBar);
        this.getContentPane().validate();
        this.firePropertyChange("toolBar", jToolBar2, this.getToolBar());
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        JMenuBar jMenuBar2 = this.menuBar;
        super.setJMenuBar(jMenuBar);
    }

    public void setCancelButton(JButton jButton) {
        JButton jButton2 = this.cancelButton;
        if (jButton2 != jButton) {
            this.cancelButton = jButton;
            if (jButton2 != null) {
                jButton2.repaint();
            }
            if (jButton != null) {
                jButton.repaint();
            }
        }
        this.firePropertyChange("cancelButton", jButton2, jButton);
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    protected class XRootLayout
    extends JRootPane.RootLayout {
        LayoutManager2 delegate;

        protected XRootLayout() {
            super(JXRootPane.this);
        }

        public void setLayoutManager(LayoutManager2 layoutManager2) {
            this.delegate = layoutManager2;
        }

        private Dimension delegatePreferredLayoutSize(Container container) {
            if (this.delegate == null) {
                return super.preferredLayoutSize(container);
            }
            return this.delegate.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.delegatePreferredLayoutSize(container);
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension dimension2 = JXRootPane.this.statusBar.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        private Dimension delegateMinimumLayoutSize(Container container) {
            if (this.delegate == null) {
                return super.minimumLayoutSize(container);
            }
            return this.delegate.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = this.delegateMinimumLayoutSize(container);
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension dimension2 = JXRootPane.this.statusBar.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        private Dimension delegateMaximumLayoutSize(Container container) {
            if (this.delegate == null) {
                return super.maximumLayoutSize(container);
            }
            return this.delegate.maximumLayoutSize(container);
        }

        public Dimension maximumLayoutSize(Container container) {
            Dimension dimension = this.delegateMaximumLayoutSize(container);
            if (JXRootPane.this.statusBar != null && JXRootPane.this.statusBar.isVisible()) {
                Dimension dimension2 = JXRootPane.this.statusBar.getMaximumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        private void delegateLayoutContainer(Container container) {
            if (this.delegate == null) {
                super.layoutContainer(container);
            } else {
                this.delegate.layoutContainer(container);
            }
        }

        public void layoutContainer(Container container) {
            this.delegateLayoutContainer(container);
            if (JXRootPane.this.statusBar == null || !JXRootPane.this.statusBar.isVisible()) {
                return;
            }
            Rectangle rectangle = container.getBounds();
            Insets insets = JXRootPane.this.getInsets();
            int n = rectangle.width - insets.right - insets.left;
            int n2 = rectangle.height - insets.top - insets.bottom;
            Dimension dimension = JXRootPane.this.statusBar.getPreferredSize();
            JXRootPane.this.statusBar.setBounds(insets.right, rectangle.height - insets.bottom - dimension.height, n, dimension.height);
            if (JXRootPane.this.contentPane != null) {
                Rectangle rectangle2 = JXRootPane.this.contentPane.getBounds();
                JXRootPane.this.contentPane.setBounds(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height - dimension.height);
            }
        }
    }
}

