/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Insets;
import javax.swing.JComponent;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.StatusBarAddon;
import org.jdesktop.swingx.plaf.StatusBarUI;

public class JXStatusBar
extends JComponent {
    public static final String uiClassID = "StatusBarUI";
    private boolean resizeHandleEnabled;

    public JXStatusBar() {
        this.updateUI();
    }

    public void setResizeHandleEnabled(boolean bl) {
        boolean bl2 = this.isResizeHandleEnabled();
        this.resizeHandleEnabled = bl;
        this.firePropertyChange("resizeHandleEnabled", bl2, this.isResizeHandleEnabled());
    }

    public boolean isResizeHandleEnabled() {
        return this.resizeHandleEnabled;
    }

    public StatusBarUI getUI() {
        return (StatusBarUI)this.ui;
    }

    public void setUI(StatusBarUI statusBarUI) {
        super.setUI(statusBarUI);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((StatusBarUI)LookAndFeelAddons.getUI(this, StatusBarUI.class));
    }

    static {
        LookAndFeelAddons.contribute(new StatusBarAddon());
    }

    public static class Constraint {
        private Insets insets;
        private ResizeBehavior resizeBehavior;
        private int fixedWidth = 0;

        public Constraint() {
            this(ResizeBehavior.FIXED, null);
        }

        public Constraint(Insets insets) {
            this(ResizeBehavior.FIXED, insets);
        }

        public Constraint(int n) {
            this(n, null);
        }

        public Constraint(int n, Insets insets) {
            if (n < 0) {
                throw new IllegalArgumentException("fixedWidth must be >= 0");
            }
            this.fixedWidth = n;
            this.insets = insets == null ? new Insets(0, 0, 0, 0) : (Insets)insets.clone();
            this.resizeBehavior = ResizeBehavior.FIXED;
        }

        public Constraint(ResizeBehavior resizeBehavior) {
            this(resizeBehavior, null);
        }

        public Constraint(ResizeBehavior resizeBehavior, Insets insets) {
            this.resizeBehavior = resizeBehavior;
            this.insets = insets == null ? new Insets(0, 0, 0, 0) : (Insets)insets.clone();
        }

        public void setFixedWidth(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("width must be >= 0");
            }
            this.fixedWidth = this.resizeBehavior == ResizeBehavior.FIXED ? n : 0;
        }

        public ResizeBehavior getResizeBehavior() {
            return this.resizeBehavior;
        }

        public Insets getInsets() {
            return (Insets)this.insets.clone();
        }

        public int getFixedWidth() {
            return this.fixedWidth;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ResizeBehavior {
            FILL,
            FIXED;

        }
    }
}

